/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.core.TransactionalMap;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.query.MapQueryEngine;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultUtils;
import com.hazelcast.map.impl.query.Target;
import com.hazelcast.map.impl.tx.TransactionalMapProxySupport;
import com.hazelcast.map.impl.tx.TxnValueWrapper;
import com.hazelcast.map.impl.tx.VersionedValue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TransactionalMapProxy
extends TransactionalMapProxySupport
implements TransactionalMap {
    private final Map<Data, TxnValueWrapper> txMap = new HashMap<Data, TxnValueWrapper>();

    public TransactionalMapProxy(String name, MapService mapService, NodeEngine nodeEngine, Transaction transaction) {
        super(name, mapService, nodeEngine, transaction);
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper valueWrapper = this.txMap.get(keyData);
        if (valueWrapper != null) {
            return valueWrapper.type != TxnValueWrapper.Type.REMOVED;
        }
        return this.containsKeyInternal(keyData);
    }

    @Override
    public int size() {
        this.checkTransactionState();
        int currentSize = this.sizeInternal();
        for (Map.Entry<Data, TxnValueWrapper> entry : this.txMap.entrySet()) {
            VersionedValue versionedValue;
            TxnValueWrapper wrapper = entry.getValue();
            if (wrapper.type == TxnValueWrapper.Type.NEW) {
                ++currentSize;
                continue;
            }
            if (wrapper.type != TxnValueWrapper.Type.REMOVED || (versionedValue = (VersionedValue)this.valueMap.get(entry.getKey())) == null || versionedValue.value == null) continue;
            --currentSize;
        }
        return currentSize;
    }

    @Override
    public boolean isEmpty() {
        this.checkTransactionState();
        return this.size() == 0;
    }

    @Override
    public Object get(Object key) {
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper currentValue = this.txMap.get(keyData);
        if (currentValue != null) {
            return this.checkIfRemoved(currentValue);
        }
        return this.toObjectIfNeeded(this.getInternal(keyData));
    }

    public Object getForUpdate(Object key) {
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper currentValue = this.txMap.get(keyData);
        if (currentValue != null) {
            return this.checkIfRemoved(currentValue);
        }
        return this.toObjectIfNeeded(this.getForUpdateInternal(keyData));
    }

    @Override
    public Object put(Object key, Object value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public Object put(Object key, Object value, long ttl, TimeUnit timeUnit) {
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        Object valueBeforeTxn = this.toObjectIfNeeded(this.putInternal(keyData, this.mapServiceContext.toData(value), ttl, timeUnit));
        TxnValueWrapper currentValue = this.txMap.get(keyData);
        TxnValueWrapper.Type type = valueBeforeTxn == null ? TxnValueWrapper.Type.NEW : TxnValueWrapper.Type.UPDATED;
        TxnValueWrapper wrapper = new TxnValueWrapper(value, type);
        this.txMap.put(keyData, wrapper);
        return currentValue == null ? valueBeforeTxn : this.checkIfRemoved(currentValue);
    }

    @Override
    public void set(Object key, Object value) {
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        Data dataBeforeTxn = this.putInternal(keyData, this.mapServiceContext.toData(value), -1L, TimeUnit.MILLISECONDS);
        TxnValueWrapper.Type type = dataBeforeTxn == null ? TxnValueWrapper.Type.NEW : TxnValueWrapper.Type.UPDATED;
        TxnValueWrapper wrapper = new TxnValueWrapper(value, type);
        this.txMap.put(keyData, wrapper);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        boolean haveTxnPast;
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper wrapper = this.txMap.get(keyData);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (wrapper.type != TxnValueWrapper.Type.REMOVED) {
                return wrapper.value;
            }
            this.putInternal(keyData, this.mapServiceContext.toData(value), -1L, TimeUnit.MILLISECONDS);
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.NEW));
            return null;
        }
        Data oldValue = this.putIfAbsentInternal(keyData, this.mapServiceContext.toData(value));
        if (oldValue == null) {
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.NEW));
        }
        return this.toObjectIfNeeded(oldValue);
    }

    @Override
    public Object replace(Object key, Object value) {
        boolean haveTxnPast;
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper wrapper = this.txMap.get(keyData);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (wrapper.type == TxnValueWrapper.Type.REMOVED) {
                return null;
            }
            this.putInternal(keyData, this.mapServiceContext.toData(value), -1L, TimeUnit.MILLISECONDS);
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED));
            return wrapper.value;
        }
        Data oldValue = this.replaceInternal(keyData, this.mapServiceContext.toData(value));
        if (oldValue != null) {
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED));
        }
        return this.toObjectIfNeeded(oldValue);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        boolean haveTxnPast;
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(oldValue, "oldValue can't be null");
        Preconditions.checkNotNull(newValue, "newValue can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper wrapper = this.txMap.get(keyData);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (!wrapper.value.equals(oldValue)) {
                return false;
            }
            this.putInternal(keyData, this.mapServiceContext.toData(newValue), -1L, TimeUnit.MILLISECONDS);
            this.txMap.put(keyData, new TxnValueWrapper(wrapper.value, TxnValueWrapper.Type.UPDATED));
            return true;
        }
        boolean success = this.replaceIfSameInternal(keyData, this.mapServiceContext.toData(oldValue), this.mapServiceContext.toData(newValue));
        if (success) {
            this.txMap.put(keyData, new TxnValueWrapper(newValue, TxnValueWrapper.Type.UPDATED));
        }
        return success;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper wrapper = this.txMap.get(keyData);
        if (wrapper == null) {
            boolean removed = this.removeIfSameInternal(keyData, value);
            if (removed) {
                this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.REMOVED));
            }
            return removed;
        }
        if (wrapper.type == TxnValueWrapper.Type.REMOVED) {
            return false;
        }
        if (!this.isEquals(wrapper.value, value)) {
            return false;
        }
        this.removeInternal(keyData);
        this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.REMOVED));
        return true;
    }

    @Override
    public Object remove(Object key) {
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        Object valueBeforeTxn = this.toObjectIfNeeded(this.removeInternal(keyData));
        TxnValueWrapper wrapper = null;
        if (valueBeforeTxn != null || this.txMap.containsKey(keyData)) {
            wrapper = this.txMap.put(keyData, new TxnValueWrapper(valueBeforeTxn, TxnValueWrapper.Type.REMOVED));
        }
        return wrapper == null ? valueBeforeTxn : this.checkIfRemoved(wrapper);
    }

    @Override
    public void delete(Object key) {
        this.checkTransactionState();
        Preconditions.checkNotNull(key, "key can't be null");
        Data keyData = this.mapServiceContext.toData(key, this.partitionStrategy);
        Data data = this.removeInternal(keyData);
        if (data != null || this.txMap.containsKey(keyData)) {
            this.txMap.put(keyData, new TxnValueWrapper(this.toObjectIfNeeded(data), TxnValueWrapper.Type.REMOVED));
        }
    }

    public Set<Object> keySet() {
        return this.keySet(TruePredicate.INSTANCE);
    }

    public Set keySet(Predicate predicate) {
        this.checkTransactionState();
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "Paging is not supported for Transactional queries!");
        MapQueryEngine queryEngine = this.mapServiceContext.getMapQueryEngine(this.name);
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        Query query = Query.of().mapName(this.name).predicate(predicate).iterationType(IterationType.KEY).build();
        QueryResult queryResult = (QueryResult)queryEngine.execute(query, Target.ALL_NODES);
        Set result = QueryResultUtils.transformToSet(serializationService, queryResult, predicate, IterationType.KEY, true);
        HashSet keySet = new HashSet(result);
        Extractors extractors = this.mapServiceContext.getExtractors(this.name);
        for (Map.Entry<Data, TxnValueWrapper> entry : this.txMap.entrySet()) {
            Data keyData = entry.getKey();
            if (!TxnValueWrapper.Type.REMOVED.equals((Object)entry.getValue().type)) {
                Object value = entry.getValue().value instanceof Data ? this.toObjectIfNeeded(entry.getValue().value) : entry.getValue().value;
                CachedQueryEntry queryEntry = new CachedQueryEntry((InternalSerializationService)serializationService, keyData, value, extractors);
                if (!predicate.apply(queryEntry)) continue;
                Object keyObject = serializationService.toObject(keyData);
                keySet.add(keyObject);
                continue;
            }
            Object keyObject = serializationService.toObject(keyData);
            keySet.remove(keyObject);
        }
        return keySet;
    }

    public Collection<Object> values() {
        return this.values(TruePredicate.INSTANCE);
    }

    public Collection values(Predicate predicate) {
        this.checkTransactionState();
        Preconditions.checkNotNull(predicate, "Predicate can not be null!");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "Paging is not supported for Transactional queries");
        MapQueryEngine queryEngine = this.mapServiceContext.getMapQueryEngine(this.name);
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        Query query = Query.of().mapName(this.name).predicate(predicate).iterationType(IterationType.ENTRY).build();
        QueryResult queryResylt = (QueryResult)queryEngine.execute(query, Target.ALL_NODES);
        Set result = QueryResultUtils.transformToSet(serializationService, queryResylt, predicate, IterationType.ENTRY, true);
        ArrayList<Object> valueSet = new ArrayList<Object>();
        HashSet<Object> keyWontBeIncluded = new HashSet<Object>();
        Extractors extractors = this.mapServiceContext.getExtractors(this.name);
        for (Map.Entry<Data, TxnValueWrapper> entry : this.txMap.entrySet()) {
            boolean isRemoved = TxnValueWrapper.Type.REMOVED.equals((Object)entry.getValue().type);
            boolean isUpdated = TxnValueWrapper.Type.UPDATED.equals((Object)entry.getValue().type);
            Object keyObject = serializationService.toObject(entry.getKey());
            if (isRemoved) {
                keyWontBeIncluded.add(keyObject);
                continue;
            }
            if (isUpdated) {
                keyWontBeIncluded.add(keyObject);
            }
            Object entryValue = entry.getValue().value;
            CachedQueryEntry queryEntry = new CachedQueryEntry((InternalSerializationService)serializationService, entry.getKey(), entryValue, extractors);
            if (!predicate.apply(queryEntry)) continue;
            valueSet.add(((QueryableEntry)queryEntry).getValue());
        }
        this.removeFromResultSet(result, valueSet, keyWontBeIncluded);
        return valueSet;
    }

    @Override
    public String toString() {
        return "TransactionalMap{name='" + this.name + '\'' + '}';
    }

    private Object checkIfRemoved(TxnValueWrapper wrapper) {
        this.checkTransactionState();
        return wrapper == null || wrapper.type == TxnValueWrapper.Type.REMOVED ? null : wrapper.value;
    }

    private void removeFromResultSet(Set<Map.Entry> queryResultSet, List<Object> valueSet, Set<Object> keyWontBeIncluded) {
        for (Map.Entry entry : queryResultSet) {
            if (keyWontBeIncluded.contains(entry.getKey())) continue;
            valueSet.add(entry.getValue());
        }
    }
}

