/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.networking.SocketWriter;
import com.hazelcast.internal.networking.SocketWriterInitializer;
import com.hazelcast.internal.networking.WriteHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Protocols;
import com.hazelcast.nio.ascii.TextWriteHandler;
import com.hazelcast.nio.tcp.ClientWriteHandler;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.util.StringUtil;
import java.net.SocketException;
import java.nio.ByteBuffer;

public class SocketWriterInitializerImpl
implements SocketWriterInitializer<TcpIpConnection> {
    private final ILogger logger;

    public SocketWriterInitializerImpl(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public void init(TcpIpConnection connection, SocketWriter writer, String protocol) {
        this.logger.fine("Initializing SocketWriter WriteHandler with " + Protocols.toUserFriendlyString(protocol));
        this.initHandler(connection, writer, protocol);
        this.initOutputBuffer(connection, writer, protocol);
    }

    private void initHandler(TcpIpConnection connection, SocketWriter writer, String protocol) {
        WriteHandler<ClientMessage> handler;
        if ("HZC".equals(protocol)) {
            IOService ioService = connection.getConnectionManager().getIoService();
            handler = ioService.createWriteHandler(connection);
        } else {
            handler = "CB2".equals(protocol) ? new ClientWriteHandler() : new TextWriteHandler(connection);
        }
        writer.initWriteHandler(handler);
    }

    private void initOutputBuffer(TcpIpConnection connection, SocketWriter writer, String protocol) {
        IOService ioService = connection.getConnectionManager().getIoService();
        int sizeKb = "HZC".equals(protocol) ? ioService.getSocketSendBufferSize() : ioService.getSocketClientSendBufferSize();
        int size = 1024 * sizeKb;
        ByteBuffer outputBuffer = IOUtil.newByteBuffer(size, ioService.isSocketBufferDirect());
        if ("HZC".equals(protocol)) {
            outputBuffer.put(StringUtil.stringToBytes("HZC"));
        }
        writer.initOutputBuffer(outputBuffer);
        try {
            connection.setSendBufferSize(size);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP send buffer of " + connection + " to " + size + " B.", e);
        }
    }
}

