/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.xa;

import com.highgo.jdbc.core.BaseConnection;
import com.highgo.jdbc.ds.common.BaseDataSource;
import com.highgo.jdbc.xa.PGXAConnection;
import com.highgo.jdbc.xa.PGXADataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGXADataSource
extends BaseDataSource
implements XADataSource {
    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    @Override
    public XAConnection getXAConnection(@Nullable String user, @Nullable String password) throws SQLException {
        Connection con = super.getConnection(user, password);
        return new PGXAConnection((BaseConnection)con);
    }

    @Override
    public String getDescription() {
        return "XA-enabled DataSource from PostgreSQL JDBC Driver /*$mvn.project.property.parsedversion.osgiversion$*/";
    }

    @Override
    protected Reference createReference() {
        return new Reference(this.getClass().getName(), PGXADataSourceFactory.class.getName(), null);
    }
}

