/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import java.text.ParseException;
import java.util.Date;
import shade.okhttp3.Response;

public class LocalTimeUtil {
    private static volatile long timeDiffInMs = 0L;
    private boolean enableAutoRetryForSkewedTime = true;
    private static final ILogger log = LoggerBuilder.getLogger(LocalTimeUtil.class);

    public static void getTimeDiffBetweenServerAndLocal(Response response) {
        String serverTime = LocalTimeUtil.getServerDateFromHeader(response);
        if (serverTime == null) {
            log.error("failed to getTimeDiffBetweenServerAndLocal cause RequestTimeTooSkewed not found in header and response xml is null.");
            return;
        }
        log.info("parsedServerTimeToString:" + serverTime);
        try {
            Date serverTimeDate = ServiceUtils.parseRfc822Date(serverTime);
            long serverTimeDateLong = serverTimeDate.getTime();
            long localTimeDateLong = System.currentTimeMillis();
            LocalTimeUtil.setTimeDiffInMs(serverTimeDateLong - localTimeDateLong);
        }
        catch (ParseException e) {
            log.error("parsedServerTimeToDate Failed:", e);
        }
    }

    public static Date dateWithTimeDiff(Date now) {
        long timeDiff = timeDiffInMs;
        now.setTime(now.getTime() + timeDiff);
        return now;
    }

    public static long currentTimeMillisWithTimeDiff() {
        return System.currentTimeMillis() + timeDiffInMs;
    }

    public static synchronized void setTimeDiffInMs(long timeDiffInMs) {
        LocalTimeUtil.timeDiffInMs = timeDiffInMs;
    }

    public boolean isEnableAutoRetryForSkewedTime() {
        return this.enableAutoRetryForSkewedTime;
    }

    public void setEnableAutoRetryForSkewedTime(boolean enableAutoRetryForSkewedTime) {
        this.enableAutoRetryForSkewedTime = enableAutoRetryForSkewedTime;
    }

    public static boolean isRequestTimeTooSkewed(ServiceException serviceException, Response response) {
        if (serviceException == null || response == null) {
            return false;
        }
        String errorCode = serviceException.getErrorCode();
        if (errorCode != null) {
            return "RequestTimeTooSkewed".equals(errorCode);
        }
        return "RequestTimeTooSkewed".equals(response.header("x-obs-error-code")) || "RequestTimeTooSkewed".equals(response.header("x-amz-error-code"));
    }

    public static String getServerDateFromHeader(Response response) {
        if (response == null) {
            return null;
        }
        return response.header("Date");
    }
}

