/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.property;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.layout.property.UnitValue;
import java.util.ArrayList;
import java.util.List;

public class Transform {
    private List<SingleTransform> multipleTransform;

    public Transform(int length) {
        this.multipleTransform = new ArrayList<SingleTransform>(length);
    }

    public void addSingleTransform(SingleTransform singleTransform) {
        this.multipleTransform.add(singleTransform);
    }

    private List<SingleTransform> getMultipleTransform() {
        return this.multipleTransform;
    }

    public static AffineTransform getAffineTransform(Transform t, float width, float height) {
        List<SingleTransform> multipleTransform = t.getMultipleTransform();
        AffineTransform affineTransform = new AffineTransform();
        for (int k = multipleTransform.size() - 1; k >= 0; --k) {
            int i;
            SingleTransform transform = multipleTransform.get(k);
            float[] floats = new float[6];
            for (i = 0; i < 4; ++i) {
                floats[i] = transform.getFloats()[i];
            }
            for (i = 4; i < 6; ++i) {
                floats[i] = transform.getUnitValues()[i - 4].getUnitType() == 1 ? transform.getUnitValues()[i - 4].getValue() : transform.getUnitValues()[i - 4].getValue() / 100.0f * (i == 4 ? width : height);
            }
            affineTransform.preConcatenate(new AffineTransform(floats));
        }
        return affineTransform;
    }

    public static class SingleTransform {
        private float a;
        private float b;
        private float c;
        private float d;
        private UnitValue tx;
        private UnitValue ty;

        public SingleTransform() {
            this.a = 1.0f;
            this.b = 0.0f;
            this.c = 0.0f;
            this.d = 1.0f;
            this.tx = new UnitValue(1, 0.0f);
            this.ty = new UnitValue(1, 0.0f);
        }

        public SingleTransform(float a, float b, float c, float d, UnitValue tx, UnitValue ty) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.tx = tx;
            this.ty = ty;
        }

        public float[] getFloats() {
            return new float[]{this.a, this.b, this.c, this.d};
        }

        public UnitValue[] getUnitValues() {
            return new UnitValue[]{this.tx, this.ty};
        }
    }
}

