/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.SQLServerDataColumn;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.Util;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import microsoft.sql.DateTimeOffset;

public final class SQLServerDataTable {
    int rowCount = 0;
    int columnCount = 0;
    Map<Integer, SQLServerDataColumn> columnMetadata = new LinkedHashMap<Integer, SQLServerDataColumn>();
    Set<String> columnNames = new HashSet<String>();
    Map<Integer, List<Object>> rows = new HashMap<Integer, List<Object>>();
    private String tvpName = null;

    public synchronized void clear() {
        this.rowCount = 0;
        this.columnCount = 0;
        this.columnMetadata.clear();
        this.columnNames.clear();
        this.rows.clear();
    }

    public synchronized Iterator<Map.Entry<Integer, List<Object>>> getIterator() {
        if (null != this.rows && null != this.rows.entrySet()) {
            return this.rows.entrySet().iterator();
        }
        return null;
    }

    public synchronized void addColumnMetadata(String columnName, int sqlType) throws SQLServerException {
        Util.checkDuplicateColumnName(columnName, this.columnNames);
        this.columnMetadata.put(this.columnCount++, new SQLServerDataColumn(columnName, sqlType));
    }

    public synchronized void addColumnMetadata(SQLServerDataColumn column) throws SQLServerException {
        Util.checkDuplicateColumnName(column.columnName, this.columnNames);
        this.columnMetadata.put(this.columnCount++, column);
    }

    public synchronized void addRow(Object ... values) throws SQLServerException {
        try {
            int columnCount = this.columnMetadata.size();
            if (null != values && values.length > columnCount) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_moreDataInRowThanColumnInTVP"));
                Object[] msgArgs = new Object[]{};
                throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
            }
            Iterator<Map.Entry<Integer, SQLServerDataColumn>> columnsIterator = this.columnMetadata.entrySet().iterator();
            LinkedList<Object> rowValues = new LinkedList<Object>();
            int currentColumn = 0;
            while (columnsIterator.hasNext()) {
                Object val = null;
                if (null != values && currentColumn < values.length && null != values[currentColumn]) {
                    val = values[currentColumn];
                }
                ++currentColumn;
                Map.Entry<Integer, SQLServerDataColumn> pair = columnsIterator.next();
                JDBCType jdbcType = JDBCType.of(pair.getValue().javaSqlType);
                this.internalAddrow(jdbcType, val, rowValues, pair);
            }
            this.rows.put(this.rowCount++, rowValues);
        }
        catch (NumberFormatException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), e);
        }
        catch (ClassCastException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), e);
        }
    }

    private void internalAddrow(JDBCType jdbcType, Object val, List<Object> rowValues, Map.Entry<Integer, SQLServerDataColumn> pair) throws SQLServerException {
        int key = pair.getKey();
        rowValues.add(key, val);
        if (null != val) {
            SQLServerDataColumn currentColumnMetadata = pair.getValue();
            switch (jdbcType) {
                case BIGINT: {
                    rowValues.set(key, val instanceof Long ? val : Long.valueOf(Long.parseLong(val.toString())));
                    break;
                }
                case BIT: {
                    if (val instanceof Boolean) {
                        rowValues.set(key, val);
                        break;
                    }
                    String valString = val.toString();
                    if ("0".equals(valString) || valString.equalsIgnoreCase(Boolean.FALSE.toString())) {
                        rowValues.set(key, Boolean.FALSE);
                        break;
                    }
                    if ("1".equals(valString) || valString.equalsIgnoreCase(Boolean.TRUE.toString())) {
                        rowValues.set(key, Boolean.TRUE);
                        break;
                    }
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_TVPInvalidColumnValue"));
                    Object[] msgArgs = new Object[]{jdbcType};
                    throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
                }
                case INTEGER: {
                    rowValues.set(key, val instanceof Integer ? val : Integer.valueOf(Integer.parseInt(val.toString())));
                    break;
                }
                case SMALLINT: 
                case TINYINT: {
                    rowValues.set(key, val instanceof Short ? val : Short.valueOf(Short.parseShort(val.toString())));
                    break;
                }
                case DECIMAL: 
                case NUMERIC: {
                    int numberOfDigitsIntegerPart;
                    BigDecimal bd = null;
                    boolean isColumnMetadataUpdated = false;
                    bd = new BigDecimal(val.toString());
                    int precision = Util.getValueLengthBaseOnJavaType(bd, JavaType.of(bd), null, null, jdbcType);
                    if (bd.scale() > currentColumnMetadata.scale) {
                        currentColumnMetadata.scale = bd.scale();
                        isColumnMetadataUpdated = true;
                    }
                    if (precision > currentColumnMetadata.precision) {
                        currentColumnMetadata.precision = precision;
                        isColumnMetadataUpdated = true;
                    }
                    if ((numberOfDigitsIntegerPart = precision - bd.scale()) > currentColumnMetadata.numberOfDigitsIntegerPart) {
                        currentColumnMetadata.numberOfDigitsIntegerPart = numberOfDigitsIntegerPart;
                        isColumnMetadataUpdated = true;
                    }
                    if (isColumnMetadataUpdated) {
                        currentColumnMetadata.precision = currentColumnMetadata.scale + currentColumnMetadata.numberOfDigitsIntegerPart;
                        this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                    }
                    rowValues.set(key, bd);
                    break;
                }
                case DOUBLE: {
                    rowValues.set(key, val instanceof Double ? val : Double.valueOf(Double.parseDouble(val.toString())));
                    break;
                }
                case FLOAT: 
                case REAL: {
                    rowValues.set(key, val instanceof Float ? val : Float.valueOf(Float.parseFloat(val.toString())));
                    break;
                }
                case TIMESTAMP_WITH_TIMEZONE: 
                case TIME_WITH_TIMEZONE: 
                case DATE: 
                case TIME: 
                case TIMESTAMP: 
                case DATETIMEOFFSET: 
                case DATETIME: 
                case SMALLDATETIME: {
                    if (val instanceof Date || val instanceof DateTimeOffset || val instanceof OffsetDateTime || val instanceof OffsetTime) {
                        rowValues.set(key, val.toString());
                        break;
                    }
                    rowValues.set(key, val);
                    break;
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: {
                    int nValueLen = ((byte[])val).length;
                    if (nValueLen > currentColumnMetadata.precision) {
                        currentColumnMetadata.precision = nValueLen;
                        this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                    }
                    rowValues.set(key, val);
                    break;
                }
                case CHAR: 
                case VARCHAR: 
                case NCHAR: 
                case NVARCHAR: 
                case LONGVARCHAR: 
                case LONGNVARCHAR: 
                case SQLXML: {
                    int nValueLen;
                    if (val instanceof UUID) {
                        val = val.toString();
                    }
                    if ((nValueLen = 2 * ((String)val).length()) > currentColumnMetadata.precision) {
                        currentColumnMetadata.precision = nValueLen;
                        this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                    }
                    rowValues.set(key, val);
                    break;
                }
                case SQL_VARIANT: {
                    JavaType javaType = JavaType.of(val);
                    JDBCType internalJDBCType = javaType.getJDBCType(SSType.UNKNOWN, jdbcType);
                    this.internalAddrow(internalJDBCType, val, rowValues, pair);
                    break;
                }
                default: {
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_unsupportedDataTypeTVP"));
                    Object[] msgArgs = new Object[]{jdbcType};
                    throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
                }
            }
        } else if (jdbcType == JDBCType.SQL_VARIANT) {
            throw new SQLServerException(SQLServerException.getErrString("R_invalidValueForTVPWithSQLVariant"), null);
        }
    }

    public synchronized Map<Integer, SQLServerDataColumn> getColumnMetadata() {
        return this.columnMetadata;
    }

    public String getTvpName() {
        return this.tvpName;
    }

    public void setTvpName(String tvpName) {
        this.tvpName = tvpName;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.rowCount;
        hash = 31 * hash + this.columnCount;
        hash = 31 * hash + (null != this.columnMetadata ? this.columnMetadata.hashCode() : 0);
        hash = 31 * hash + (null != this.columnNames ? this.columnNames.hashCode() : 0);
        hash = 31 * hash + (null != this.rows ? this.rows.hashCode() : 0);
        hash = 31 * hash + (null != this.tvpName ? this.tvpName.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null != object && object.getClass() == SQLServerDataTable.class) {
            SQLServerDataTable aSQLServerDataTable = (SQLServerDataTable)object;
            if (this.hashCode() == aSQLServerDataTable.hashCode()) {
                boolean equalColumnMetadata = this.columnMetadata.equals(aSQLServerDataTable.columnMetadata);
                boolean equalColumnNames = this.columnNames.equals(aSQLServerDataTable.columnNames);
                boolean equalRowData = this.rows.equals(aSQLServerDataTable.rows);
                return this.rowCount == aSQLServerDataTable.rowCount && this.columnCount == aSQLServerDataTable.columnCount && this.tvpName == aSQLServerDataTable.tvpName && equalColumnMetadata && equalColumnNames && equalRowData;
            }
        }
        return false;
    }
}

