/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.test;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;

public class DirectoryUtils {
    public static void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            DirectoryUtils.deleteDirectoryContents(file);
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    public static void deleteDirectoryContents(File directory) throws IOException {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"Not a directory: %s", (Object[])new Object[]{directory});
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Error listing files for " + directory);
        }
        for (File file : files) {
            DirectoryUtils.deleteRecursively(file);
        }
    }
}

