/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.test;

import com.google.common.collect.ImmutableList;
import com.netflix.curator.test.ByteCodeRewrite;
import com.netflix.curator.test.InstanceSpec;
import com.netflix.curator.test.QuorumConfigBuilder;
import com.netflix.curator.test.TestingZooKeeperServer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import org.apache.zookeeper.ZooKeeper;

public class TestingCluster
implements Closeable {
    private final QuorumConfigBuilder builder;
    private final List<TestingZooKeeperServer> servers;

    public TestingCluster(int instanceQty) {
        this(TestingCluster.makeSpecs(instanceQty));
    }

    public TestingCluster(InstanceSpec ... specs) {
        this((Collection<InstanceSpec>)ImmutableList.copyOf((Object[])specs));
    }

    public TestingCluster(Collection<InstanceSpec> specs) {
        this.builder = new QuorumConfigBuilder(specs);
        ImmutableList.Builder serverBuilder = ImmutableList.builder();
        for (int i = 0; i < specs.size(); ++i) {
            serverBuilder.add((Object)new TestingZooKeeperServer(this.builder, i));
        }
        this.servers = serverBuilder.build();
    }

    public Collection<InstanceSpec> getInstances() {
        return this.builder.getInstanceSpecs();
    }

    public String getConnectString() {
        StringBuilder str = new StringBuilder();
        for (InstanceSpec spec : this.builder.getInstanceSpecs()) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(spec.getConnectString());
        }
        return str.toString();
    }

    public void start() throws Exception {
        for (TestingZooKeeperServer server : this.servers) {
            server.start();
        }
    }

    public void stop() throws IOException {
        for (TestingZooKeeperServer server : this.servers) {
            server.stop();
        }
    }

    @Override
    public void close() throws IOException {
        for (TestingZooKeeperServer server : this.servers) {
            server.close();
        }
    }

    public boolean killServer(InstanceSpec instance) throws Exception {
        for (TestingZooKeeperServer server : this.servers) {
            if (!server.getInstanceSpec().equals(instance)) continue;
            server.kill();
            return true;
        }
        return false;
    }

    public boolean restartServer(InstanceSpec instance) throws Exception {
        for (TestingZooKeeperServer server : this.servers) {
            if (!server.getInstanceSpec().equals(instance)) continue;
            server.restart();
            return true;
        }
        return false;
    }

    public InstanceSpec findConnectionInstance(ZooKeeper client) throws Exception {
        Method m = client.getClass().getDeclaredMethod("testableRemoteSocketAddress", new Class[0]);
        m.setAccessible(true);
        InetSocketAddress address = (InetSocketAddress)m.invoke((Object)client, new Object[0]);
        if (address != null) {
            for (TestingZooKeeperServer server : this.servers) {
                if (server.getInstanceSpec().getPort() != address.getPort()) continue;
                return server.getInstanceSpec();
            }
        }
        return null;
    }

    private static Collection<InstanceSpec> makeSpecs(int instanceQty) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < instanceQty; ++i) {
            builder.add((Object)InstanceSpec.newInstanceSpec());
        }
        return builder.build();
    }

    static {
        ByteCodeRewrite.apply();
    }
}

