/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.test;

import com.netflix.curator.test.DirectoryUtils;
import com.netflix.curator.test.InstanceSpec;
import com.netflix.curator.test.QuorumConfigBuilder;
import com.netflix.curator.test.TestingQuorumPeerMain;
import com.netflix.curator.test.TestingZooKeeperMain;
import com.netflix.curator.test.ZooKeeperMainFace;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingZooKeeperServer
extends QuorumPeerMain
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TestingZooKeeperServer.class);
    private final QuorumConfigBuilder configBuilder;
    private final int thisInstanceIndex;
    private volatile ZooKeeperMainFace main;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);

    public TestingZooKeeperServer(QuorumConfigBuilder configBuilder) {
        this(configBuilder, 0);
    }

    public TestingZooKeeperServer(QuorumConfigBuilder configBuilder, int thisInstanceIndex) {
        this.configBuilder = configBuilder;
        this.thisInstanceIndex = thisInstanceIndex;
        this.main = configBuilder.size() > 1 ? new TestingQuorumPeerMain() : new TestingZooKeeperMain();
    }

    public void kill() {
        this.main.kill();
        this.state.set(State.STOPPED);
    }

    public void restart() throws Exception {
        if (!this.state.compareAndSet(State.STOPPED, State.LATENT)) {
            throw new IllegalStateException("Instance not stopped");
        }
        this.main = this.configBuilder.size() > 1 ? new TestingQuorumPeerMain() : new TestingZooKeeperMain();
        this.start();
    }

    public void stop() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            this.main.close();
        }
    }

    public InstanceSpec getInstanceSpec() {
        return this.configBuilder.getInstanceSpec(this.thisInstanceIndex);
    }

    @Override
    public void close() throws IOException {
        InstanceSpec spec;
        this.stop();
        if (this.state.compareAndSet(State.STOPPED, State.CLOSED) && (spec = this.getInstanceSpec()).deleteDataDirectoryOnClose()) {
            DirectoryUtils.deleteRecursively(spec.getDataDirectory());
        }
    }

    public void start() throws Exception {
        if (!this.state.compareAndSet(State.LATENT, State.STARTED)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    QuorumPeerConfig config = TestingZooKeeperServer.this.configBuilder.buildConfig(TestingZooKeeperServer.this.thisInstanceIndex);
                    TestingZooKeeperServer.this.main.runFromConfig(config);
                }
                catch (Exception e) {
                    logger.error(String.format("From testing server (random state: %s)", String.valueOf(TestingZooKeeperServer.this.configBuilder.isFromRandom())), (Throwable)e);
                }
            }
        }).start();
        this.main.blockUntilStarted();
    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED,
        CLOSED;

    }
}

