/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.layout.BreakAtLineContext;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.LayoutState;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.PageBox;
import java.awt.Dimension;
import java.util.List;
import java.util.TreeSet;

public class BlockBoxing {
    private static final int NO_PAGE_TRIM = -1;

    private BlockBoxing() {
    }

    public static void layoutContent(LayoutContext c, BlockBox block, int contentStart) {
        List<Box> localChildren = block.getChildren();
        int size = localChildren.size();
        int childOffset = block.getHeight() + contentStart;
        LiteRelayoutDataList relayoutDataList = null;
        LayoutContext.BlockBoxingState enterState = c.getBlockBoxingState();
        if (c.isPrint()) {
            relayoutDataList = new LiteRelayoutDataList(size);
        }
        int pageCount = -1;
        BlockBox previousChildBox = null;
        boolean oneChildFailed = false;
        for (int offset = 0; offset < size; ++offset) {
            Dimension relativeOffset;
            BlockBox child = (BlockBox)localChildren.get(offset);
            LayoutState savedChildLayoutState = null;
            boolean rootPageBreakInsideAvoid = false;
            if (c.isPrint()) {
                savedChildLayoutState = c.copyStateForRelayout();
                ((AbstractRelayoutDataList)relayoutDataList).setLayoutState(offset, savedChildLayoutState);
                ((AbstractRelayoutDataList)relayoutDataList).setChildOffset(offset, childOffset);
                pageCount = c.getRootLayer().getPages().size();
                child.setNeedPageClear(false);
                if ((child.getStyle().isAvoidPageBreakInside() || child.getStyle().isKeepWithInline()) && c.getBlockBoxingState() == LayoutContext.BlockBoxingState.NOT_SET) {
                    rootPageBreakInsideAvoid = true;
                }
            }
            if (rootPageBreakInsideAvoid) {
                c.setBlockBoxingState(LayoutContext.BlockBoxingState.ALLOW);
            } else {
                c.setBlockBoxingState(enterState);
            }
            BlockBoxing.layoutBlockChild(c, block, child, false, childOffset, -1, savedChildLayoutState);
            if (c.isPrint()) {
                boolean needPageClear = child.isNeedPageClear();
                if (needPageClear || c.getBlockBoxingState() == LayoutContext.BlockBoxingState.ALLOW) {
                    boolean pageBreak;
                    boolean pageBreakAfterRetry = pageBreak = child.crossesPageBreak(c);
                    boolean tryToAvoidPageBreak = pageBreak && child.getStyle().isAvoidPageBreakInside();
                    boolean keepWithInline = child.isNeedsKeepWithInline(c);
                    if (tryToAvoidPageBreak || needPageClear || keepWithInline) {
                        c.restoreStateForRelayout(savedChildLayoutState);
                        child.reset(c);
                        c.setBlockBoxingState(LayoutContext.BlockBoxingState.DENY);
                        BlockBoxing.layoutBlockChild(c, block, child, true, childOffset, pageCount, savedChildLayoutState);
                        c.setBlockBoxingState(enterState);
                        pageBreakAfterRetry = child.crossesPageBreak(c);
                        if (tryToAvoidPageBreak && pageBreakAfterRetry && !keepWithInline) {
                            c.restoreStateForRelayout(savedChildLayoutState);
                            child.reset(c);
                            c.setBlockBoxingState(LayoutContext.BlockBoxingState.ALLOW);
                            BlockBoxing.layoutBlockChild(c, block, child, false, childOffset, pageCount, savedChildLayoutState);
                        }
                        if (pageBreakAfterRetry) {
                            oneChildFailed = true;
                        }
                    }
                }
                c.getRootLayer().ensureHasPage(c, child);
            }
            if ((childOffset = (relativeOffset = child.getRelativeOffset()) == null ? child.getY() + child.getHeight() : child.getY() - relativeOffset.height + child.getHeight()) > block.getHeight()) {
                block.setHeight(childOffset);
            }
            if (c.isPrint()) {
                Integer newChildOffset;
                if (child.getStyle().isForcePageBreakAfter()) {
                    block.forcePageBreakAfter(c, child.getStyle().getIdent(CSSName.PAGE_BREAK_AFTER));
                    childOffset = block.getHeight();
                }
                if (previousChildBox != null) {
                    ((AbstractRelayoutDataList)relayoutDataList).configureRun(offset, previousChildBox, child);
                }
                if ((newChildOffset = BlockBoxing.processPageBreakAvoidRun(c, block, localChildren, offset, relayoutDataList, child)) != null && (childOffset = newChildOffset.intValue()) > block.getHeight()) {
                    block.setHeight(childOffset);
                }
            }
            previousChildBox = child;
            if (!rootPageBreakInsideAvoid) continue;
            c.setBlockBoxingState(enterState);
        }
        if (oneChildFailed) {
            c.setBlockBoxingState(LayoutContext.BlockBoxingState.DENY);
        }
    }

    private static Integer processPageBreakAvoidRun(LayoutContext c, BlockBox block, List<Box> localChildren, int offset, AbstractRelayoutDataList relayoutDataList, BlockBox childBox) {
        if (offset > 0) {
            int runStart;
            boolean mightNeedRelayout = false;
            int runEnd = -1;
            if (offset == localChildren.size() - 1 && relayoutDataList.isEndsRun(offset)) {
                mightNeedRelayout = true;
                runEnd = offset;
            } else if (offset > 0 && relayoutDataList.isEndsRun(offset - 1)) {
                mightNeedRelayout = true;
                runEnd = offset - 1;
            }
            if (mightNeedRelayout && BlockBoxing.isPageBreakBetweenChildBoxes(relayoutDataList, runStart = relayoutDataList.getRunStart(runEnd), runEnd, c, block)) {
                block.resetChildren(c, runStart, offset);
                int newChildOffset = BlockBoxing.relayoutRun(c, localChildren, block, relayoutDataList, runStart, offset, true);
                if (BlockBoxing.isPageBreakBetweenChildBoxes(relayoutDataList, runStart, runEnd, c, block)) {
                    block.resetChildren(c, runStart, offset);
                    newChildOffset = BlockBoxing.relayoutRun(c, localChildren, block, relayoutDataList, runStart, offset, false);
                }
                return newChildOffset;
            }
        }
        return null;
    }

    private static boolean isPageBreakBetweenChildBoxes(AbstractRelayoutDataList relayoutDataList, int runStart, int runEnd, LayoutContext c, BlockBox block) {
        for (int i = runStart; i < runEnd; ++i) {
            Box prevChild = block.getChild(i);
            Box nextChild = block.getChild(i + 1);
            Box nextLine = BlockBoxing.getFirstLine(nextChild) == null ? nextChild : BlockBoxing.getFirstLine(nextChild);
            int prevChildEnd = prevChild.getAbsY() + prevChild.getHeight();
            int nextLineEnd = nextLine.getAbsY() + nextLine.getHeight();
            if (!c.getRootLayer().crossesPageBreak(c, prevChildEnd, nextLineEnd)) continue;
            return true;
        }
        return false;
    }

    private static LineBox getFirstLine(Box box) {
        Box child = box;
        while (child.getChildCount() > 0) {
            if (child instanceof LineBox) {
                return (LineBox)child;
            }
            child = child.getChild(0);
        }
        return null;
    }

    private static int relayoutRun(LayoutContext c, List<Box> localChildren, BlockBox block, AbstractRelayoutDataList relayoutDataList, int start, int end, boolean onNewPage) {
        int childOffset = relayoutDataList.getChildOffset(start);
        if (onNewPage) {
            Box startBox = localChildren.get(start);
            PageBox startPageBox = c.getRootLayer().getFirstPage((CssContext)c, startBox);
            childOffset += startPageBox.getBottom() - startBox.getAbsY();
        }
        block.setHeight(childOffset);
        for (int i = start; i <= end; ++i) {
            BlockBox child = (BlockBox)localChildren.get(i);
            int pageCount = c.getRootLayer().getPages().size();
            LayoutState restoredChildLayoutState = relayoutDataList.getLayoutState(i);
            c.restoreStateForRelayout(restoredChildLayoutState);
            relayoutDataList.setChildOffset(i, childOffset);
            boolean mayCheckKeepTogether = false;
            if ((child.getStyle().isAvoidPageBreakInside() || child.getStyle().isKeepWithInline()) && c.isMayCheckKeepTogether()) {
                mayCheckKeepTogether = true;
                c.setMayCheckKeepTogether(false);
            }
            BlockBoxing.layoutBlockChild(c, block, child, false, childOffset, -1, restoredChildLayoutState);
            if (mayCheckKeepTogether) {
                c.setMayCheckKeepTogether(true);
                boolean tryToAvoidPageBreak = child.getStyle().isAvoidPageBreakInside() && child.crossesPageBreak(c);
                boolean needPageClear = child.isNeedPageClear();
                boolean keepWithInline = child.isNeedsKeepWithInline(c);
                if (tryToAvoidPageBreak || needPageClear || keepWithInline) {
                    c.restoreStateForRelayout(restoredChildLayoutState);
                    child.reset(c);
                    BlockBoxing.layoutBlockChild(c, block, child, true, childOffset, pageCount, restoredChildLayoutState);
                    if (tryToAvoidPageBreak && child.crossesPageBreak(c) && !keepWithInline) {
                        c.restoreStateForRelayout(restoredChildLayoutState);
                        child.reset(c);
                        BlockBoxing.layoutBlockChild(c, block, child, false, childOffset, pageCount, restoredChildLayoutState);
                    }
                }
            }
            c.getRootLayer().ensureHasPage(c, child);
            Dimension relativeOffset = child.getRelativeOffset();
            childOffset = relativeOffset == null ? child.getY() + child.getHeight() : child.getY() - relativeOffset.height + child.getHeight();
            if (childOffset > block.getHeight()) {
                block.setHeight(childOffset);
            }
            if (!child.getStyle().isForcePageBreakAfter()) continue;
            block.forcePageBreakAfter(c, child.getStyle().getIdent(CSSName.PAGE_BREAK_AFTER));
            childOffset = block.getHeight();
        }
        return childOffset;
    }

    private static void layoutBlockChild(LayoutContext c, BlockBox parent, BlockBox child, boolean needPageClear, int childOffset, int trimmedPageCount, LayoutState layoutState) {
        BlockBoxing.layoutBlockChild0(c, parent, child, needPageClear, childOffset, trimmedPageCount);
        BreakAtLineContext bContext = child.calcBreakAtLineContext(c);
        if (bContext != null) {
            c.setBreakAtLineContext(bContext);
            c.restoreStateForRelayout(layoutState);
            child.reset(c);
            BlockBoxing.layoutBlockChild0(c, parent, child, needPageClear, childOffset, trimmedPageCount);
            c.setBreakAtLineContext(null);
        }
    }

    private static void layoutBlockChild0(LayoutContext c, BlockBox parent, BlockBox child, boolean needPageClear, int childOffset, int trimmedPageCount) {
        child.setNeedPageClear(needPageClear);
        child.initStaticPos(c, parent, childOffset);
        child.initContainingLayer(c);
        child.calcCanvasLocation();
        c.translate(0, childOffset);
        BlockBoxing.repositionBox(c, child, trimmedPageCount);
        child.layout(c);
        c.translate(-child.getX(), -child.getY());
    }

    private static void repositionBox(LayoutContext c, BlockBox child, int trimmedPageCount) {
        boolean moved = false;
        if (child.getStyle().isRelative()) {
            Dimension delta = child.positionRelative(c);
            c.translate(delta.width, delta.height);
            moved = true;
        }
        if (c.isPrint()) {
            boolean pageClear = child.isNeedPageClear() || child.getStyle().isForcePageBreakBefore() || child.isPageBreakNeededBecauseOfMinHeight(c);
            boolean needNewPageContext = child.checkPageContext(c);
            if (needNewPageContext && trimmedPageCount != -1) {
                c.getRootLayer().trimPageCount(trimmedPageCount);
            }
            if (pageClear || needNewPageContext) {
                int delta = child.forcePageBreakBefore(c, child.getStyle().getIdent(CSSName.PAGE_BREAK_BEFORE), needNewPageContext);
                c.translate(0, delta);
                moved = true;
                child.setNeedPageClear(false);
            }
        }
        if (moved) {
            child.calcCanvasLocation();
        }
    }

    public static boolean avoidPageBreakBetween(BlockBox previous, BlockBox current) {
        IdentValue previousAfter = previous.getStyle().getIdent(CSSName.PAGE_BREAK_AFTER);
        IdentValue currentBefore = current.getStyle().getIdent(CSSName.PAGE_BREAK_BEFORE);
        return previousAfter == IdentValue.AVOID && currentBefore == IdentValue.AUTO || previousAfter == IdentValue.AUTO && currentBefore == IdentValue.AVOID || previousAfter == IdentValue.AVOID && currentBefore == IdentValue.AVOID;
    }

    private static class LiteRelayoutDataList
    extends AbstractRelayoutDataList {
        final int[] childOffsets;
        final LayoutState[] layoutStates;
        TreeSet<Integer> runStarts;
        TreeSet<Integer> runEnds;

        LiteRelayoutDataList(int size) {
            this.childOffsets = new int[size];
            this.layoutStates = new LayoutState[size];
        }

        @Override
        int getChildOffset(int boxIndex) {
            return this.childOffsets[boxIndex];
        }

        @Override
        LayoutState getLayoutState(int boxIndex) {
            return this.layoutStates[boxIndex];
        }

        @Override
        void setLayoutState(int boxIndex, LayoutState state) {
            this.layoutStates[boxIndex] = state;
        }

        @Override
        void setChildOffset(int boxIndex, int childOffset) {
            this.childOffsets[boxIndex] = childOffset;
        }

        @Override
        boolean isEndsRun(int boxIndex) {
            return this.runEnds != null && this.runEnds.contains(boxIndex);
        }

        @Override
        int getRunStart(int endRunIndex) {
            return this.runStarts.floor(endRunIndex);
        }

        boolean isInRun(int boxIndex) {
            if (this.runStarts == null) {
                return false;
            }
            Integer lastRunStart = this.runStarts.floor(boxIndex);
            if (lastRunStart != null) {
                Integer lastRunEnd = this.runEnds != null ? this.runEnds.ceiling(lastRunStart) : null;
                return lastRunEnd == null || lastRunEnd >= boxIndex;
            }
            return false;
        }

        void addRunStart(int boxIndex) {
            if (this.runStarts == null) {
                this.runStarts = new TreeSet();
            }
            this.runStarts.add(boxIndex);
        }

        void addRunEnd(int boxIndex) {
            if (this.runEnds == null) {
                this.runEnds = new TreeSet();
            }
            this.runEnds.add(boxIndex);
        }

        @Override
        public void configureRun(int offset, BlockBox previous, BlockBox current) {
            boolean previousInRun = this.isInRun(offset - 1);
            if (BlockBoxing.avoidPageBreakBetween(previous, current)) {
                if (!previousInRun) {
                    this.addRunStart(offset - 1);
                }
                if (offset == this.childOffsets.length - 1) {
                    this.addRunEnd(offset);
                }
            } else if (previousInRun) {
                this.addRunEnd(offset - 1);
            }
        }
    }

    private static abstract class AbstractRelayoutDataList {
        private AbstractRelayoutDataList() {
        }

        abstract int getChildOffset(int var1);

        abstract LayoutState getLayoutState(int var1);

        abstract void setLayoutState(int var1, LayoutState var2);

        abstract void setChildOffset(int var1, int var2);

        abstract int getRunStart(int var1);

        abstract boolean isEndsRun(int var1);

        abstract void configureRun(int var1, BlockBox var2, BlockBox var3);
    }
}

