/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.TableConverter;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.util.HexUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

@ThreadSafe
public abstract class CallableStatementSapDB
extends PreparedStatementSapDB
implements java.sql.CallableStatement {
    public static CallableStatementSapDB getCallableStatementSapDB(java.sql.CallableStatement callableStatement) {
        java.sql.CallableStatement cs = callableStatement;
        while (!(cs instanceof CallableStatementSapDB)) {
            if (cs instanceof CallableStatement) {
                cs = ((CallableStatement)cs).getInner();
                continue;
            }
            return null;
        }
        return (CallableStatementSapDB)cs;
    }

    protected CallableStatementSapDB(Tracer tracer, ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine, StatementSapDB.StatementFlag ... statementFlags) throws SQLException {
        super(tracer, connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean wasNull() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "wasNull") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "wasNull", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._wasNull();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Object getObject(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            AbstractConverter converter;
            Object result;
            if (on) {
                this._tracer.printCall(this, "getObject", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if ((result = this._getObject(converter = this._getParameterConverter(parameterIndex))) instanceof AbstractGetval) {
                    this._addAppLob((AbstractGetval)result);
                }
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized boolean getBoolean(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBoolean") : null;
        try {
            boolean result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBoolean", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getBoolean(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized byte getByte(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getByte") : null;
        try {
            byte result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getByte", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getByte(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            byte by = result;
            return by;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized short getShort(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getShort") : null;
        try {
            short result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getShort", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getShort(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            short s = result;
            return s;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized int getInt(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getInt") : null;
        try {
            int result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getInt", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getInt(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized long getLong(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getLong") : null;
        try {
            long result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getLong", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getLong(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized float getFloat(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getFloat") : null;
        try {
            float result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getFloat", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getFloat(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)Float.valueOf(result)));
            }
            float f = result;
            return f;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized double getDouble(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDouble") : null;
        try {
            double result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDouble", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getDouble(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            double d = result;
            return d;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            BigDecimal result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterIndex, scale);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Date getDate(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            Date result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDate", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Time getTime(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            Time result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTime", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Timestamp getTimestamp(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            Timestamp result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare|lobOutputConverter")
    public synchronized String getString(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getString") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getString", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            PassportListener pl = this._isDeferredPrepare || converter.isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare|lobOutputConverter")
    public synchronized byte[] getBytes(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBytes") : null;
        try {
            byte[] result;
            if (on) {
                this._tracer.printCall(this, "getBytes", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            PassportListener pl = this._isDeferredPrepare || converter.isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)HexUtils.toDisplayHexString(result, 20)));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterIndex);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, scale);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterIndex);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", parameterIndex, map);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getObject( int, Map )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            BigDecimal result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            Date result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDate", parameterIndex, cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            Time result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTime", parameterIndex, cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            Timestamp result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterIndex, cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Clob getClob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getClob") : null;
        try {
            Clob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getClob", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Clob clob = result;
            return clob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Blob getBlob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBlob") : null;
        try {
            Blob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBlob", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getBlob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Blob blob = result;
            return blob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Array getArray(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getArray", parameterIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getArray( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Ref getRef(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", parameterIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getRef( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, typeName);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterIndex);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Object getObject(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            AbstractConverter converter;
            Object result;
            if (on) {
                this._tracer.printCall(this, "getObject", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if ((result = this._getObject(converter = this._getParameterConverter(parameterName))) instanceof AbstractGetval) {
                    this._addAppLob((AbstractGetval)result);
                }
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", parameterName, map);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getObject( int, String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized boolean getBoolean(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBoolean") : null;
        try {
            boolean result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBoolean", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getBoolean(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized byte getByte(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getByte") : null;
        try {
            byte result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getByte", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getByte(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            byte by = result;
            return by;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized short getShort(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getShort") : null;
        try {
            short result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getShort", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getShort(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            short s = result;
            return s;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized int getInt(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getInt") : null;
        try {
            int result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getInt", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getInt(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized long getLong(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getLong") : null;
        try {
            long result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getLong", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getLong(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized float getFloat(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getFloat") : null;
        try {
            float result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getFloat", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getFloat(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)Float.valueOf(result)));
            }
            float f = result;
            return f;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized double getDouble(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDouble") : null;
        try {
            double result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDouble", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getDouble(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            double d = result;
            return d;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized BigDecimal getBigDecimal(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            BigDecimal result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Date getDate(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            Date result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDate", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Date getDate(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            Date result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDate", parameterName, cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Time getTime(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            Time result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTime", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Time getTime(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            Time result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTime", parameterName, cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Timestamp getTimestamp(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            Timestamp result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            Timestamp result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterName, cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare|lobOutputConverter")
    public synchronized String getString(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getString") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getString", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            PassportListener pl = this._isDeferredPrepare || converter.isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare|lobOutputConverter")
    public synchronized byte[] getBytes(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBytes") : null;
        try {
            byte[] result;
            if (on) {
                this._tracer.printCall(this, "getBytes", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            PassportListener pl = this._isDeferredPrepare || converter.isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)HexUtils.toDisplayHexString(result, 20)));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Clob getClob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getClob") : null;
        try {
            Clob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getClob", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Clob clob = result;
            return clob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Blob getBlob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBlob") : null;
        try {
            Blob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBlob", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getBlob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Blob blob = result;
            return blob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Array getArray(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getArray", parameterName);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getArray( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Ref getRef(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", parameterName);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getRef( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized URL getURL(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", parameterIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getURL( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized URL getURL(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", parameterName);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getURL( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setNull(String parameterName, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterName, sqlType);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setNull(this._getParameterConverter(parameterName).getIndex(), sqlType);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterName, sqlType, typeName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setNull(this._getParameterConverter(parameterName).getIndex(), sqlType);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setObject(String parameterName, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, this._obfuscateEncrypted(parameterName, x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setObject(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, this._obfuscateEncrypted(parameterName, x), targetSqlType);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setObject(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, this._obfuscateEncrypted(parameterName, x), targetSqlType, scale);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setObject(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBoolean(String parameterName, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBoolean", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBoolean(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setByte(String parameterName, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setByte", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setByte(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setShort(String parameterName, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setShort", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setShort(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setInt(String parameterName, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setInt", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setInt(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setLong(String parameterName, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setLong", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setLong(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setFloat(String parameterName, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFloat", parameterName, this._obfuscateEncrypted(parameterName, (Object)Float.valueOf(x)));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setFloat(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setDouble(String parameterName, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDouble", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setDouble(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBigDecimal", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBigDecimal(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setDate(String parameterName, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setDate(this._getParameterConverter(parameterName).getIndex(), x, null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setDate(this._getParameterConverter(parameterName).getIndex(), x, cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setTime(String parameterName, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setTime(this._getParameterConverter(parameterName).getIndex(), x, null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setTime(this._getParameterConverter(parameterName).getIndex(), x, cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setTimestamp(this._getParameterConverter(parameterName).getIndex(), x, null);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), cal);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setTimestamp(this._getParameterConverter(parameterName).getIndex(), x, cal);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setString(String parameterName, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setString", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setString(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBytes(String parameterName, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBytes", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBytes(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setAsciiStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBinaryStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setURL(String parameterName, URL x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setURL", parameterName, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("setURL( String, URL )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterName);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, scale);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterName);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterName);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare|lobOutputConverter")
    public synchronized String getNString(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNString") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getNString", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            PassportListener pl = this._isDeferredPrepare || converter.isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare|lobOutputConverter")
    public synchronized String getNString(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNString") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getNString", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            PassportListener pl = this._isDeferredPrepare || converter.isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Reader getCharacterStream(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getCharacterStream") : null;
        try {
            Reader result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Reader getCharacterStream(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getCharacterStream") : null;
        try {
            Reader result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Reader getNCharacterStream(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNCharacterStream") : null;
        try {
            Reader result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = converter.getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized Reader getNCharacterStream(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNCharacterStream") : null;
        try {
            Reader result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = converter.getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized NClob getNClob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNClob") : null;
        try {
            NClob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getNClob", parameterIndex);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterIndex);
                result = (NClob)converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            NClob nClob = result;
            return nClob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized NClob getNClob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNClob") : null;
        try {
            NClob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getNClob", parameterName);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                converter = this._getParameterConverter(parameterName);
                result = (NClob)converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            NClob nClob = result;
            return nClob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized RowId getRowId(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", parameterIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getRowId( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized RowId getRowId(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", parameterName);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getRowId( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized SQLXML getSQLXML(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", parameterIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getSQLXML( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized SQLXML getSQLXML(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", parameterName);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("getSQLXML( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setNString(String parameterName, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNString", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setString(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setAsciiStream(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setAsciiStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setCharacterStream(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setNCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBinaryStream(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBinaryStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setClob(String parameterName, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setClob(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setClob(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setClob(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setClob(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setClob(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setNClob(String parameterName, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setNClob(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setNClob(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setNClob(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setNClob(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setNClob(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBlob(String parameterName, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBlob(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBlob(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBlob(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setBlob(this._getParameterConverter(parameterName).getIndex(), x, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setRowId(String parameterName, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRowId", parameterName, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("setRowId( String, RowId )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSQLXML", parameterName, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw CallableStatementSapDB._getUnsupportedMethodException("setSQLXML( String, SQLXML )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            AbstractConverter converter;
            T result;
            if (on) {
                this._tracer.printCall(this, "getObject", parameterIndex, type);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if ((result = this._getObject(converter = this._getParameterConverter(parameterIndex), type)) instanceof AbstractGetval) {
                    this._addAppLob((AbstractGetval)result);
                }
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            T t = result;
            return t;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            AbstractConverter converter;
            T result;
            if (on) {
                this._tracer.printCall(this, "getObject", parameterName, type);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if ((result = this._getObject(converter = this._getParameterConverter(parameterName), type)) instanceof AbstractGetval) {
                    this._addAppLob((AbstractGetval)result);
                }
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            T t = result;
            return t;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, this._obfuscateEncrypted(parameterName, x), targetSqlType);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setObject(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="deferredPrepare")
    public synchronized void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._isDeferredPrepare ? this._connection.getPassportListener() : null;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, this._obfuscateEncrypted(parameterName, x), targetSqlType, scaleOrLength);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._setObject(this._getParameterConverter(parameterName).getIndex(), x);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterIndex);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, scale);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterIndex);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, typeName);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterIndex);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterName);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, scale);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterName);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, typeName);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._registerOutParameter(parameterName);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    private Object _getObject(AbstractConverter converter) throws SQLException {
        if (this._connection.refCursors() && converter instanceof TableConverter && converter.getParameterMode() == ParameterMode.Out) {
            return this._getResultSet(converter);
        }
        return converter.getObject(this, this._getDataPart(converter.getOutputFieldPos()));
    }

    private <T> T _getObject(AbstractConverter converter, Class<T> type) throws SQLException {
        if (this._connection.refCursors() && converter instanceof TableConverter && converter.getParameterMode() == ParameterMode.Out && type == ResultSet.class) {
            return (T)this._getResultSet(converter);
        }
        return converter.getObject(this, this._getDataPart(converter.getOutputFieldPos()), type);
    }

    private ResultSet _getResultSet(AbstractConverter converter) throws SQLException {
        byte[] cursorID = converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
        return this._getTableOutputParametersMap().get(HexUtils.toHexString(cursorID));
    }

    private void _addAppLob(AbstractGetval appLob) {
        if (this._isClosed()) {
            return;
        }
        if (appLob != null) {
            appLob.addAppLob();
        }
    }
}

