/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class SessionPool {
    private final WeakReference<ConnectionSapDB> _connection;
    private final Tracer _tracer;
    private final Map<SiteTypeVolumeID, Session> _sessions;
    private final AtomicReference<Session> _anchorSession;
    private final AtomicReference<Session> _primarySession;
    private final AtomicReference<SystemInfo> _systemInfo;
    private final AtomicReference<Session> _lastPreparedExecuteSessionForNoneOrPrimarySite;
    private final AtomicInteger _lastAnchorConnectionID;

    public SessionPool(ConnectionSapDB connection) {
        this._connection = new WeakReference<ConnectionSapDB>(connection);
        this._tracer = connection.getTracer();
        this._sessions = new ConcurrentHashMap<SiteTypeVolumeID, Session>();
        this._anchorSession = new AtomicReference();
        this._primarySession = new AtomicReference();
        this._systemInfo = new AtomicReference();
        this._lastPreparedExecuteSessionForNoneOrPrimarySite = new AtomicReference();
        this._lastAnchorConnectionID = new AtomicInteger();
    }

    public Map<SiteTypeVolumeID, Session> getSessions() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public Session getSession(SiteTypeVolumeID siteTypeVolumeID) {
        SystemInfo systemInfo = this._systemInfo.get();
        if (systemInfo == null) {
            return null;
        }
        Session session = this._sessions.get(siteTypeVolumeID);
        if (session == null) {
            int siteCount = systemInfo.getSiteCount();
            int volumeID = siteTypeVolumeID.getVolumeID();
            if (siteCount == 1) {
                for (SiteTypeVolumeID aSiteTypeVolumeID : this._sessions.keySet()) {
                    if (aSiteTypeVolumeID.getVolumeID() != volumeID) continue;
                    return this._sessions.get(aSiteTypeVolumeID);
                }
            }
        }
        return session;
    }

    public SiteTypeVolumeID getSessionSiteTypeVolumeID(Session session) {
        SystemInfo systemInfo = this._systemInfo.get();
        if (systemInfo == null) {
            return null;
        }
        for (Map.Entry<SiteTypeVolumeID, Session> entry : this._sessions.entrySet()) {
            if (entry.getValue() != session) continue;
            return entry.getKey();
        }
        return null;
    }

    public SiteTypeVolumeID getCorrespondingSiteTypeVolumeIDForSiteID(Integer siteID) throws SQLException {
        return this.getCorrespondingSiteTypeVolumeIDForSiteID(siteID, this.getPrimarySession());
    }

    public SiteTypeVolumeID getCorrespondingSiteTypeVolumeIDForSiteID(Integer siteID, Session session) throws SQLException {
        SystemInfo systemInfo = this._systemInfo.get();
        if (systemInfo == null) {
            return null;
        }
        SiteType siteIDType = systemInfo.getSiteType(siteID.byteValue());
        if (siteIDType == SiteType.NONE) {
            throw SQLExceptionSapDB.newInstance("error.force.route.invalidsiteid", siteID.toString());
        }
        return new SiteTypeVolumeID(siteIDType, session.getSiteVolumeID().getVolumeID());
    }

    public Session getAnchorSession() {
        return this._anchorSession.get();
    }

    public Session getPrimarySession() {
        return this._primarySession.get();
    }

    public void setPrimarySession(Session session) {
        Session primarySession = this._primarySession.get();
        if (primarySession == null) {
            this._primarySession.set(session);
            if (this._tracer.on()) {
                this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
            }
        } else if (primarySession != session) {
            this._primarySession.set(session);
            if (!session.isHintRouted()) {
                this.setSendSessionContextFlag();
            }
            if (this._tracer.on()) {
                this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
            }
        }
    }

    public SystemInfo getSystemInfo() {
        return this._systemInfo.get();
    }

    public SystemInfo setSystemInfo(SystemInfo systemInfo) {
        return this._systemInfo.getAndSet(systemInfo);
    }

    public Session getLastPreparedExecuteSessionForNoneOrPrimarySite() {
        return this._lastPreparedExecuteSessionForNoneOrPrimarySite.get();
    }

    public void setLastPreparedExecuteSessionForNoneOrPrimarySite(Session session) {
        this._lastPreparedExecuteSessionForNoneOrPrimarySite.set(session);
    }

    public int getLastAnchorConnectionID() {
        Integer lastAnchorConnectionID = this._lastAnchorConnectionID.get();
        return lastAnchorConnectionID != null ? lastAnchorConnectionID : -1;
    }

    public void addSession(Session session) {
        SystemInfo systemInfo;
        SiteVolumeID siteVolumeID = session.getSiteVolumeID();
        Session primarySession = this._primarySession.get();
        if (!session.isHintRouted()) {
            if (this._anchorSession.compareAndSet(null, session)) {
                this._lastAnchorConnectionID.set(session.getConnectionID());
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Anchor session changed to " + session.getTraceString(true, false));
                }
            }
            if (primarySession == null || !primarySession.isConnected()) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
                }
            } else if (primarySession.getSiteVolumeID().equals(siteVolumeID)) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
                }
            }
        }
        SiteType siteType = (systemInfo = this._systemInfo.get()) != null ? systemInfo.getSiteType(siteVolumeID.getSiteID()) : SiteType.NONE;
        this._sessions.put(new SiteTypeVolumeID(siteType, siteVolumeID.getVolumeID()), session);
    }

    public void setSendSessionContextFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionContextFlag();
        }
    }

    public void setSendSessionVariablesFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionVariablesFlag();
        }
    }

    public void setSendClientInfoFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendClientInfoFlag();
        }
    }

    public void releaseSecondary(Session session) {
        Session anchorSession = this._anchorSession.get();
        if (session == anchorSession) {
            throw new AssertionError((Object)"session must not be the anchor session");
        }
        this._releaseSessions(session, false);
        if (session == this._primarySession.get() && anchorSession != null) {
            this._primarySession.set(anchorSession);
        }
    }

    public void releaseAll() {
        this._releaseSessions(null, false);
        this._sessions.clear();
        this._anchorSession.set(null);
        this._systemInfo.set(null);
        this._lastPreparedExecuteSessionForNoneOrPrimarySite.set(null);
    }

    public void releaseAllHintRouted() {
        this._releaseSessions(null, true);
    }

    protected void _setSessionPublicAddress(Session session, PublicAddress publicAddress) {
        session._address.set(publicAddress);
        for (Map.Entry<SiteTypeVolumeID, Session> entry : this._sessions.entrySet()) {
            SiteTypeVolumeID siteTypeVolumeID = entry.getKey();
            Session aSession = entry.getValue();
            if (aSession != session) continue;
            if (siteTypeVolumeID.getSiteType() == publicAddress.getSiteType()) break;
            this._sessions.remove(siteTypeVolumeID);
            this._sessions.put(new SiteTypeVolumeID(publicAddress.getSiteType(), publicAddress.getSiteVolumeID().getVolumeID()), session);
            break;
        }
    }

    private void _releaseSessions(Session thisSessionOnly, boolean hintRoutedOnly) {
        for (Map.Entry<SiteTypeVolumeID, Session> entry : new HashMap<SiteTypeVolumeID, Session>(this._sessions).entrySet()) {
            SiteTypeVolumeID siteTypeVolumeID = entry.getKey();
            Session session = entry.getValue();
            if (!(session == null || !session.isConnected() || thisSessionOnly != null && session == thisSessionOnly || thisSessionOnly == null && hintRoutedOnly && session.isHintRouted()) && (thisSessionOnly != null || hintRoutedOnly)) continue;
            if (session != null) {
                session.destroy();
            }
            this._sessions.remove(siteTypeVolumeID);
        }
    }

    public Map<SiteTypeVolumeID, Session> getSessionsMap() {
        return this._sessions;
    }

    public int getNumberOfLocations() {
        SystemInfo systemInfo = this._systemInfo.get();
        return systemInfo != null ? systemInfo.getAddressCount() : -1;
    }
}

