/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
class InputStreamFilter
extends InputStream {
    private final InputStream _stream;
    private final long _maxLength;
    private long _readLength;
    private long _markedLength;

    protected InputStreamFilter(InputStream stream, long maxLength) {
        this._stream = stream;
        this._maxLength = maxLength;
    }

    @Override
    public int read() throws IOException {
        return this._maxLength > this._readLength++ ? this._stream.read() : -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this._stream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this._readLength >= this._maxLength) {
            return -1;
        }
        if (this._readLength + (long)len > this._maxLength && (len = (int)(this._maxLength - this._readLength)) <= 0) {
            return 0;
        }
        len = this._stream.read(b, off, len);
        this._readLength += (long)len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        return this._stream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this._stream.available();
    }

    @Override
    public boolean markSupported() {
        return this._stream.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this._stream.mark(readlimit);
        this._markedLength = this._readLength;
    }

    @Override
    public void reset() throws IOException {
        this._stream.reset();
        this._readLength = this._markedLength;
    }

    @Override
    public void close() throws IOException {
        this._stream.close();
    }
}

