/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.exceptions;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.trace.Tracer;

@ThreadSafe
public class RTEException
extends Exception {
    private final Session _session;
    private final RteReturnCode _rteReturnCode;
    private final int _detailErrorCode;

    public static RTEException newInstance(Tracer tracer, Session session, String message, RteReturnCode rteReturnCode) {
        return RTEException._newInstance(tracer, session, message, rteReturnCode, rteReturnCode.getCommunicationErrorCode(), null);
    }

    public static RTEException newInstance(Tracer tracer, Session session, String message, RteReturnCode rteReturnCode, int detailErrorCode) {
        return RTEException._newInstance(tracer, session, message, rteReturnCode, detailErrorCode, null);
    }

    public static RTEException newInstance(Tracer tracer, Session session, String message, RteReturnCode rteReturnCode, Throwable t) {
        return RTEException._newInstance(tracer, session, message, rteReturnCode, rteReturnCode.getCommunicationErrorCode(), t);
    }

    public static RTEException newInstance(Tracer tracer, Session session, String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable t) {
        return RTEException._newInstance(tracer, session, message, rteReturnCode, detailErrorCode, t);
    }

    protected RTEException(Session session, String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable cause) {
        super(message, cause);
        this._session = session;
        this._rteReturnCode = rteReturnCode;
        this._detailErrorCode = detailErrorCode;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this._session == null) {
            return message;
        }
        Address localAddress = this._session.getLocalAddress();
        return message + ": " + (localAddress != null ? localAddress.getTraceString(true) : "(uninitialized)") + " -> " + this._session.getAddress().getTraceString(true) + " ConnectionID:" + this._session.getConnectionID() + " SessionID:" + this._session.getSessionID();
    }

    public RteReturnCode getRTEReturnCode() {
        return this._rteReturnCode;
    }

    public int getDetailErrorCode() {
        return this._detailErrorCode;
    }

    public boolean isTimeoutError() {
        return false;
    }

    public boolean isDecompressError() {
        return false;
    }

    public boolean isInvalidPacketError() {
        return false;
    }

    protected static RTEException _newInstance(Tracer tracer, Session session, String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable t) {
        RTEException e = new RTEException(session, message, rteReturnCode, detailErrorCode, t);
        e._printCurrentStackTrace(tracer);
        return e;
    }

    protected void _printCurrentStackTrace(Tracer tracer) {
        if (tracer.on()) {
            tracer.printCurrentStackTrace("RTEException: " + (Object)((Object)this._rteReturnCode) + "(" + this._rteReturnCode.getValue() + ") " + this._detailErrorCode + " " + this.getMessage(), this);
        }
    }
}

