/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

@Immutable
public enum StatementContextFlag {
    ActiveActive_FallbackRouting(1),
    FullCompileOnPrepare(2);

    private static final StatementContextFlag[] VALUES;
    private final int _value;

    public static Set<StatementContextFlag> decode(int value) {
        EnumSet<StatementContextFlag> statementContextFlags = EnumSet.noneOf(StatementContextFlag.class);
        for (StatementContextFlag statementContextFlag : VALUES) {
            if ((value & statementContextFlag.getValue()) == 0) continue;
            statementContextFlags.add(statementContextFlag);
        }
        return statementContextFlags;
    }

    public static String getDisplayString(int value) {
        Set<StatementContextFlag> statementContextFlags = StatementContextFlag.decode(value);
        return value + (statementContextFlags.isEmpty() ? "(none)" : Arrays.toString(statementContextFlags.toArray()));
    }

    private StatementContextFlag(int value) {
        if (Integer.numberOfTrailingZeros(value) != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    static {
        VALUES = StatementContextFlag.values();
    }
}

