/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;

public class LogMessage {
    final Stream stream;
    final ByteBuffer content;

    public LogMessage(int streamId, ByteBuffer content) {
        this(Stream.of(streamId), content);
    }

    public LogMessage(Stream stream, ByteBuffer content) {
        this.stream = (Stream)((Object)Preconditions.checkNotNull((Object)((Object)stream), (Object)"stream"));
        this.content = (ByteBuffer)Preconditions.checkNotNull((Object)content, (Object)"content");
    }

    public Stream stream() {
        return this.stream;
    }

    public ByteBuffer content() {
        return this.content.asReadOnlyBuffer();
    }

    public static enum Stream {
        STDIN(0),
        STDOUT(1),
        STDERR(2);

        private final int id;

        private Stream(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Stream of(int id) {
            switch (id) {
                case 0: {
                    return STDIN;
                }
                case 1: {
                    return STDOUT;
                }
                case 2: {
                    return STDERR;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

