/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.io.Closer;
import com.squareup.wire.java.Profile;
import com.squareup.wire.java.internal.ProfileFileElement;
import com.squareup.wire.java.internal.ProfileParser;
import com.squareup.wire.java.internal.TypeConfigElement;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaException;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import okio.Okio;
import okio.Source;

public final class ProfileLoader {
    private final FileSystem fileSystem;
    private final String name;
    private Schema schema;

    public ProfileLoader(FileSystem fileSystem, String name) {
        this.fileSystem = fileSystem;
        this.name = name;
    }

    public ProfileLoader(String name) {
        this(FileSystems.getDefault(), name);
    }

    public ProfileLoader schema(Schema schema) {
        Preconditions.checkState((this.schema == null ? 1 : 0) != 0);
        this.schema = schema;
        return this;
    }

    public Profile load() throws IOException {
        LinkedHashSet<Location> protoLocations = new LinkedHashSet<Location>();
        for (ProtoFile protoFile : this.schema.protoFiles()) {
            protoLocations.add(protoFile.location());
        }
        Multimap<Path, String> pathsToAttempt = this.pathsToAttempt(protoLocations);
        ImmutableList<ProfileFileElement> profileFiles = this.loadProfileFiles(pathsToAttempt);
        Profile profile = new Profile(profileFiles);
        this.validate(this.schema, profileFiles);
        return profile;
    }

    private ImmutableList<ProfileFileElement> loadProfileFiles(Multimap<Path, String> pathsToAttempt) throws IOException {
        ImmutableList.Builder result = ImmutableList.builder();
        try (Closer closer = Closer.create();){
            for (Map.Entry entry : pathsToAttempt.asMap().entrySet()) {
                Path base = (Path)entry.getKey();
                if (Files.isRegularFile(base, new LinkOption[0])) {
                    FileSystem sourceFs = FileSystems.newFileSystem(base, this.getClass().getClassLoader());
                    closer.register((Closeable)sourceFs);
                    base = (Path)Iterables.getOnlyElement(sourceFs.getRootDirectories());
                }
                for (String path : (Collection)entry.getValue()) {
                    ProfileFileElement element = this.loadProfileFile(base, path);
                    if (element == null) continue;
                    result.add((Object)element);
                }
            }
        }
        return result.build();
    }

    Multimap<Path, String> pathsToAttempt(Set<Location> protoLocations) {
        SetMultimap result = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        for (Location location : protoLocations) {
            this.pathsToAttempt((Multimap<Path, String>)result, location);
        }
        return result;
    }

    void pathsToAttempt(Multimap<Path, String> sink, Location location) {
        Path base = this.fileSystem.getPath(location.getBase(), new String[0]);
        String path = location.getPath();
        while (!path.isEmpty()) {
            String parent = path.substring(0, path.lastIndexOf(47, path.length() - 2) + 1);
            String profilePath = parent + this.name + ".wire";
            sink.put((Object)base, (Object)profilePath);
            path = parent;
        }
    }

    private ProfileFileElement loadProfileFile(Path base, String path) throws IOException {
        Source source = ProfileLoader.source(base, path);
        if (source == null) {
            return null;
        }
        try {
            Location location = Location.get((String)base.toString(), (String)path);
            String data = Okio.buffer((Source)source).readUtf8();
            ProfileFileElement profileFileElement = new ProfileParser(location, data).read();
            return profileFileElement;
        }
        catch (IOException e) {
            throw new IOException("Failed to load " + source + " from " + base, e);
        }
        finally {
            source.close();
        }
    }

    void validate(Schema schema, ImmutableList<ProfileFileElement> profileFiles) {
        ArrayList<String> errors = new ArrayList<String>();
        for (ProfileFileElement profileFile : profileFiles) {
            for (TypeConfigElement typeConfig : profileFile.getTypeConfigs()) {
                ProtoType type = this.importedType(ProtoType.get((String)typeConfig.getType()));
                if (type == null) continue;
                Type resolvedType = schema.getType(type);
                if (resolvedType == null) {
                    errors.add(String.format("unable to resolve %s (%s)", type, typeConfig.getLocation()));
                    continue;
                }
                String requiredImport = resolvedType.location().getPath();
                if (profileFile.getImports().contains(requiredImport)) continue;
                errors.add(String.format("%s needs to import %s (%s)", typeConfig.getLocation().getPath(), requiredImport, typeConfig.getLocation()));
            }
        }
        if (!errors.isEmpty()) {
            throw new SchemaException(errors);
        }
    }

    @Nullable
    private ProtoType importedType(ProtoType type) {
        if (type.isMap()) {
            type = type.valueType();
        }
        return type.isScalar() ? null : type;
    }

    private static Source source(Path base, String path) throws IOException {
        Path resolvedPath = base.resolve(path);
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            return Okio.source((Path)resolvedPath, (OpenOption[])new OpenOption[0]);
        }
        return null;
    }
}

