/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.StiEncryption;
import com.stimulsoft.base.enums.StiPaperKind;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import com.stimulsoft.report.StiExportManager;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.components.textFormats.StiCustomFormatService;
import com.stimulsoft.report.components.textFormats.StiDateFormatService;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.components.textFormats.StiTimeFormatService;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.enums.StiReportUnitType;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.options.DesignerOptions;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.helper.StiWebResourceHelper;
import com.stimulsoft.web.html.StiHtmlElement;
import com.stimulsoft.webdesigner.StiWebDesigerHandler;
import com.stimulsoft.webdesigner.StiWebDesignerHelper;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.helper.StiAggrigateFunctions;
import com.stimulsoft.webdesigner.helper.StiChartHelper;
import com.stimulsoft.webdesigner.helper.StiCodePageHelper;
import com.stimulsoft.webdesigner.helper.StiCrossTabHelper;
import com.stimulsoft.webdesigner.helper.StiCultureHelper;
import com.stimulsoft.webdesigner.helper.StiDefaultConditions;
import com.stimulsoft.webdesigner.helper.StiDictionaryHelper;
import com.stimulsoft.webdesigner.helper.StiEncodingHelper;
import com.stimulsoft.webdesigner.helper.StiFontNames;
import com.stimulsoft.webdesigner.helper.StiHatchStyles;
import com.stimulsoft.webdesigner.helper.StiIconSetArrays;
import com.stimulsoft.webdesigner.helper.StiPaperSizes;
import com.stimulsoft.webdesigner.helper.StiReportCheckHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiStylesHelper;
import com.stimulsoft.webdesigner.helper.StiSummaryTypes;
import com.stimulsoft.webdesigner.helper.StiTableHelper;
import com.stimulsoft.webdesigner.helper.StiTextFormatHelper;
import com.stimulsoft.webdesigner.helper.StiWebDesignerOptionsHelper;
import com.stimulsoft.webdesigner.helper.StiWizardHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class StiWebDesigner {
    protected static final Logger LOG = Logger.getLogger(StiWebDesigner.class.getName());
    public static final String ACTION_GET_REPORT_TEMPLATE = "ReportTemplate";
    public static final String ACTION_OPEN_REPORT_TEMPLATE = "OpenReportTemplate";
    public static final String ACTION_SAVE_REPORT_TEMPLATE = "SaveReportTemplate";
    public static final String ACTION_SAVE_AS_REPORT_TEMPLATE = "SaveAsReportTemplate";
    public static final String ACTION_GET_NEW_REPORT_DATA = "GetNewReportData";
    public static final String ACTION_DESIGNER_EVENT = "DesignerEvent";
    public static final String ACTION_REFRESH_SESSION = "RefreshSession";
    public static final String ACTION_EXIST_DESIGNER = "ExitDesigner";
    public static final String ACTION_GET_REPORT_SNAPSHOTE = "ReportSnapshot";
    public static final String ACTION_EXPORT_REPORT = "ExportReport";
    private static final String SESSION_ATTRIBUTE_CACHED_REPORT = "webdesigner_cached_report";
    private static final String SESSION_ATTRIBUTE_PARAMETERS = "webdesigner_params";
    private static final String SESSION_ATTRIBUTE_HANDLER = "webdesigner_handler";
    private static final String SESSION_OPTIONS_ID = "sessionOptions";
    private StiWebDesignerOptions options;
    private String id;

    public StiWebDesigner(StiWebDesignerOptions options, URL context, HttpServletRequest request) {
        this.options = options;
        this.id = options.getDesignerID();
        request.getSession().setAttribute(SESSION_OPTIONS_ID, (Object)options);
        String localizationFileName = options.getLocalization();
        if (options.getLocalizationStream() != null) {
            try {
                StiLocalization localization = StiLocalization.load((InputStream)options.getLocalizationStream());
                StiLocalization.setLocalization((StiLocalization)localization);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "", e);
            }
        } else if (StiValidationUtil.isNotNullOrEmpty((String)localizationFileName)) {
            File localizationFile = new File(localizationFileName);
            if (localizationFile.exists()) {
                try {
                    StiLocalization localization = StiLocalization.load((InputStream)new FileInputStream(localizationFile));
                    StiLocalization.setLocalization((StiLocalization)localization);
                }
                catch (FileNotFoundException e) {
                    LOG.log(Level.SEVERE, "", e);
                }
                catch (StiException e) {
                    LOG.log(Level.SEVERE, "", e);
                }
            } else {
                LOG.log(Level.SEVERE, "Unable to load localization file: " + localizationFile.getAbsolutePath());
            }
        }
    }

    private static void setupDesign(StiReport report) {
        if (report != null) {
            report.getInfo().setForceDesigningMode(true);
            report.setIsSerializing(false);
            report.setIsRendered(false);
        }
    }

    public String getDesigner(URL context, StiWebDesigerHandler handler, HttpServletRequest request, Object servletContext) throws ParserConfigurationException, IOException {
        StiReport report = handler.getEditedReport(request);
        StiWebDesigner.setupDesign(report);
        DocumentBuilderFactory docFactory = StiXmlUtil.getBuilderFactory();
        DocumentBuilder docBuilder = null;
        docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        ProcessingInstruction disableEscaping = doc.createProcessingInstruction("javax.xml.transform.disable-output-escaping", "");
        doc.appendChild(disableEscaping);
        Element rootPanel = StiHtmlElement.createPanelHtmlElement((Document)doc);
        doc.appendChild(rootPanel);
        return this.createChildControls(rootPanel, doc, context, report, request, handler, servletContext);
    }

    protected String createChildControls(Element root, Document doc, URL context, StiReport report, HttpServletRequest request, StiWebDesigerHandler handler, Object servletContext) throws IOException {
        this.options.setJsObject("js" + this.id + ".");
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        String reportGuid = StiWebDesigner.getNewGuid();
        String clipboardId = StiWebDesigner.getNewGuid();
        parameters.put("isJava", System.getProperty("java.runtime.version"));
        parameters.put("mobileDesignerId", this.id);
        String url = StiValidationUtil.isNotNullOrEmpty((String)this.options.getController()) ? this.options.getController() : context.toString();
        parameters.put("requestAbsoluteUrl", url + "/" + "stimulsoft_webdesigner_action" + "?a={action}");
        parameters.put("requestUrl", url + "/" + "stimulsoft_webdesigner_action" + "?a={action}");
        parameters.put("actionGetReportSnapshot", ACTION_GET_REPORT_SNAPSHOTE);
        parameters.put("actionGetReportTemplate", ACTION_GET_REPORT_TEMPLATE);
        parameters.put("actionOpenReportTemplate", ACTION_OPEN_REPORT_TEMPLATE);
        parameters.put("actionSaveReportTemplate", ACTION_SAVE_REPORT_TEMPLATE);
        parameters.put("actionGetNewReportData", ACTION_GET_NEW_REPORT_DATA);
        parameters.put("actionExitDesigner", ACTION_EXIST_DESIGNER);
        parameters.put("actionDesignerEvent", ACTION_DESIGNER_EVENT);
        parameters.put("actionSaveAsReportTemplate", ACTION_SAVE_AS_REPORT_TEMPLATE);
        parameters.put("requestHeaderContentType", this.options.getRequestHeaderContentType());
        parameters.put("serverCacheMode", "Page");
        parameters.put("serverTimeout", "00:00:10");
        parameters.put("serverCacheItemPriority", "Default");
        parameters.put("demoVersion", !StiLicenseKeyValidator.isValidOnJavaFramework(null));
        parameters.put("theme", this.options.getTheme().name());
        parameters.put("showAnimation", this.options.isShowAnimation());
        parameters.put("defaultUnit", this.options.getDefaultUnit());
        parameters.put("helpLanguage", this.getCurrentHelpLanguage());
        parameters.put("productVersion", StiAttribute.getVersion());
        parameters.put("defaultUnit", this.options.getDefaultUnit());
        parameters.put("clipboardId", clipboardId);
        parameters.put("undoArrayId", StiWebDesigner.getNewGuid());
        parameters.put("componentCloneId", StiWebDesigner.getNewGuid());
        parameters.put("reportCheckersId", StiWebDesigner.getNewGuid());
        parameters.put("showSaveDialog", this.options.isShowSaveDialog());
        parameters.put("fullScreenMode", StiValidationUtil.isNullOrEmpty((String)this.options.getWidth()) && StiValidationUtil.isNullOrEmpty((String)this.options.getHeight()));
        parameters.put("showTooltips", this.options.isShowTooltips());
        parameters.put("showTooltipsHelp", this.options.isShowTooltipsHelp());
        parameters.put("interfaceType", this.options.getInterfaceType().name());
        parameters.put("cloudMode", false);
        parameters.put("runWizardAfterLoad", StiOptions.Designer.getRunWizardAfterLoad());
        parameters.put("datePickerFirstDayOfWeek", this.options.getDatePickerFirstDayOfWeek().toString());
        parameters.put("saveReportTemplateMode", (Object)this.options.getSaveReportTemplateMode());
        parameters.put("saveReportTemplateAsMode", (Object)this.options.getSaveReportTemplateAsMode());
        parameters.put("loc", new JSONObject(StiLocalization.getLocalization().languageProp).toString());
        parameters.put("paperSizes", StiPaperSizes.getItems());
        parameters.put("hatchStyles", StiHatchStyles.getItems());
        parameters.put("summaryTypes", StiSummaryTypes.getItems());
        parameters.put("aggrigateFunctions", StiAggrigateFunctions.getItems());
        parameters.put("fontNames", StiFontNames.getItems());
        parameters.put("conditions", StiDefaultConditions.getItems());
        parameters.put("iconSetArrays", StiIconSetArrays.getItems());
        parameters.put("images", StiWebResourceHelper.getImages(StiWebDesigner.class, (String)"webdesigner", (String)"webdesigner/Images/Designer/Office2013/", (String)url, (String)this.options.getTheme().name(), (boolean)this.options.isImagesInHTML()));
        parameters.put("styles", StiWebDesignerHelper.getDesignerStyles(url, this.options.getTheme()));
        parameters.put("routes", "{}");
        parameters.put("defaultDesignerOptions", StiWebDesignerOptionsHelper.getDefaultDesignerOptions());
        parameters.put("showPropertiesWhichUsedFromStyles", DesignerOptions.PropertyGrid.isShowPropertiesWhichUsedFromStyles());
        parameters.put("dBaseCodePages", StiCodePageHelper.getDBaseCodePageItems());
        parameters.put("csvCodePages", StiCodePageHelper.getCsvCodePageItems());
        parameters.put("textFormats", StiTextFormatHelper.getTextFormatItems());
        parameters.put("currencySymbols", StiTextFormatHelper.getCurrencySymbols());
        parameters.put("dateFormats", StiTextFormatHelper.getDateAndTimeFormats("date", (StiFormatService)new StiDateFormatService()));
        parameters.put("timeFormats", StiTextFormatHelper.getDateAndTimeFormats("time", (StiFormatService)new StiTimeFormatService()));
        parameters.put("customFormats", StiTextFormatHelper.getDateAndTimeFormats("custom", (StiFormatService)new StiCustomFormatService()));
        parameters.put("cultures", StiCultureHelper.getItems());
        parameters.put("showInsertButton", this.options.isShowInsertButton());
        parameters.put("showLayoutButton", this.options.isShowLayoutButton());
        parameters.put("showPageButton", this.options.isShowPageButton());
        parameters.put("showPreviewButton", this.options.isShowPreviewButton());
        parameters.put("showFileMenu", this.options.isShowFileMenu());
        parameters.put("showSaveButton", this.options.isShowSaveButton());
        parameters.put("showAboutButton", this.options.isShowAboutButton());
        parameters.put("reportGuid", reportGuid);
        parameters.put("showFileMenuNew", this.options.isShowFileMenuNew());
        parameters.put("showFileMenuOpen", this.options.isShowFileMenuOpen());
        parameters.put("showFileMenuSave", this.options.isShowFileMenuSave());
        parameters.put("showFileMenuSaveAs", this.options.isShowFileMenuSaveAs());
        parameters.put("showFileMenuClose", this.options.isShowFileMenuClose());
        parameters.put("showFileMenuExit", this.options.isShowFileMenuExit());
        parameters.put("showFileMenuReportSetup", this.options.isShowFileMenuReportSetup());
        parameters.put("showFileMenuOptions", this.options.isShowFileMenuOptions());
        parameters.put("showFileMenuInfo", this.options.isShowFileMenuInfo());
        Hashtable<String, Boolean> visibilityBands = new Hashtable<String, Boolean>();
        parameters.put("visibilityBands", visibilityBands);
        visibilityBands.put("StiReportTitleBand", this.options.isShowReportTitleBand());
        visibilityBands.put("StiReportSummaryBand", this.options.isShowReportSummaryBand());
        visibilityBands.put("StiPageHeaderBand", this.options.isShowPageHeaderBand());
        visibilityBands.put("StiPageFooterBand", this.options.isShowPageFooterBand());
        visibilityBands.put("StiGroupHeaderBand", this.options.isShowGroupHeaderBand());
        visibilityBands.put("StiGroupFooterBand", this.options.isShowGroupFooterBand());
        visibilityBands.put("StiHeaderBand", this.options.isShowHeaderBand());
        visibilityBands.put("StiFooterBand", this.options.isShowFooterBand());
        visibilityBands.put("StiColumnHeaderBand", this.options.isShowColumnHeaderBand());
        visibilityBands.put("StiColumnFooterBand", this.options.isShowColumnFooterBand());
        visibilityBands.put("StiDataBand", this.options.isShowDataBand());
        visibilityBands.put("StiHierarchicalBand", this.options.isShowHierarchicalBand());
        visibilityBands.put("StiChildBand", this.options.isShowChildBand());
        visibilityBands.put("StiEmptyBand", this.options.isShowEmptyBand());
        visibilityBands.put("StiOverlayBand", this.options.isShowOverlayBand());
        visibilityBands.put("StiTable", this.options.isShowTable());
        Hashtable<String, Boolean> visibilityCrossBands = new Hashtable<String, Boolean>();
        parameters.put("visibilityCrossBands", visibilityCrossBands);
        visibilityCrossBands.put("StiCrossTab", this.options.isShowCrossTab());
        visibilityCrossBands.put("StiCrossGroupHeaderBand", this.options.isShowCrossGroupHeaderBand());
        visibilityCrossBands.put("StiCrossGroupFooterBand", this.options.isShowCrossGroupFooterBand());
        visibilityCrossBands.put("StiCrossHeaderBand", this.options.isShowCrossHeaderBand());
        visibilityCrossBands.put("StiCrossFooterBand", this.options.isShowCrossFooterBand());
        visibilityCrossBands.put("StiCrossDataBand", this.options.isShowCrossDataBand());
        Hashtable<String, Boolean> visibilityComponents = new Hashtable<String, Boolean>();
        parameters.put("visibilityComponents", visibilityComponents);
        visibilityComponents.put("StiText", this.options.isShowText());
        visibilityComponents.put("StiTextInCells", this.options.isShowTextInCells());
        visibilityComponents.put("StiRichText", this.options.isShowRichText());
        visibilityComponents.put("StiImage", this.options.isShowImage());
        visibilityComponents.put("StiBarCode", this.options.isShowBarCode());
        visibilityComponents.put("StiShape", this.options.isShowShape());
        visibilityComponents.put("StiPanel", this.options.isShowPanel());
        visibilityComponents.put("StiClone", this.options.isShowClone());
        visibilityComponents.put("StiCheckBox", this.options.isShowCheckBox());
        visibilityComponents.put("StiSubReport", this.options.isShowSubReport());
        visibilityComponents.put("StiZipCode", this.options.isShowZipCode());
        visibilityComponents.put("StiChart", this.options.isShowChart());
        visibilityComponents.put("StiHorizontalLinePrimitive", this.options.isShowHorizontalLinePrimitive());
        visibilityComponents.put("StiVerticalLinePrimitive", this.options.isShowVerticalLinePrimitive());
        visibilityComponents.put("StiRectanglePrimitive", this.options.isShowRectanglePrimitive());
        visibilityComponents.put("StiRoundedRectanglePrimitive", this.options.isShowRoundedRectanglePrimitive());
        parameters.put("showPropertiesGrid", this.options.isShowPropertiesGrid());
        parameters.put("propertiesGridWidth", this.options.getPropertiesGridWidth());
        parameters.put("propertiesGridLabelWidth", this.options.getPropertiesGridLabelWidth());
        parameters.put("showDictionary", this.options.isShowDictionary());
        parameters.put("permissionDataSources", this.options.getPermissionDataSources().toString());
        parameters.put("permissionDataColumns", this.options.getPermissionDataColumns().toString());
        parameters.put("permissionDataRelations", this.options.getPermissionDataRelations().toString());
        parameters.put("permissionDataConnections", this.options.getPermissionDataConnections().toString());
        parameters.put("permissionBusinessObjects", this.options.getPermissionBusinessObjects().toString());
        parameters.put("permissionVariables", this.options.getPermissionVariables().toString());
        parameters.put("showReportTree", this.options.isShowReportTree());
        parameters.put("urlCursorStyleSet", StiWebResourceHelper.getWebResourceUrl((String)url, (String)"webdesigner", (String)"/Images/Designer/Office2013/Cursors/StyleSet.cur"));
        parameters.put("urlCursorPen", StiWebResourceHelper.getWebResourceUrl((String)url, (String)"webdesigner", (String)"/Images/Designer/Office2013/Cursors/Pen.cur"));
        String jsParameters = new JSONObject(parameters).toString();
        Element mainPanel = StiHtmlElement.createPanelHtmlElement((Document)doc);
        StiHtmlElement.setID((Element)mainPanel, (String)(this.id + "_MainPanel"));
        StiHtmlElement.setCssClass((Element)mainPanel, (String)"stiDesignerMainPanel");
        root.appendChild(mainPanel);
        if (StiValidationUtil.isNullOrEmpty((String)this.options.getWidth()) && StiValidationUtil.isNullOrEmpty((String)this.options.getHeight())) {
            StiHtmlElement.addStyle((Element)root, (String)"position", (String)"absolute");
            StiHtmlElement.addStyle((Element)root, (String)"z-index", (String)"1000000");
            StiHtmlElement.addStyle((Element)root, (String)"top", (String)"0px");
            StiHtmlElement.addStyle((Element)root, (String)"left", (String)"0px");
            StiHtmlElement.addStyle((Element)root, (String)"right", (String)"0px");
            StiHtmlElement.addStyle((Element)root, (String)"bottom", (String)"0px");
        } else {
            StiHtmlElement.addStyle((Element)mainPanel, (String)"width", (String)this.options.getWidth());
            StiHtmlElement.addStyle((Element)mainPanel, (String)"height", (String)this.options.getHeight());
        }
        Element scriptEngine = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
        scriptEngine.setAttribute("src", url + "/" + "stimulsoft_webdesigner_action" + "?a=" + ACTION_DESIGNER_EVENT + "&mvcmobiledesigner_resource=scripts");
        root.appendChild(scriptEngine);
        Element scriptInit = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
        scriptInit.setTextContent("var js" + this.id + " = new StiMobileDesigner(" + jsParameters + ")");
        root.appendChild(scriptInit);
        if (this.options.getRefreshTimeout() > 0) {
            Element refreshScript = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
            refreshScript.setTextContent(String.format("function refreshSession(){ js%s.PostAjax('RefreshSession=' + Math.random(),'', function(){} ); setTimeout('refreshSession()',%s);}refreshSession();", this.id, this.options.getRefreshTimeout() * 60000));
            root.appendChild(refreshScript);
        }
        StiHtmlElement.setID((Element)root, (String)this.id);
        StiWebDesigner.saveReportObject(request, report, reportGuid);
        request.getSession().setAttribute(clipboardId + SESSION_ATTRIBUTE_HANDLER, (Object)handler);
        return StiWebDesigner.serialize(doc, true);
    }

    public void storeReport(HttpServletRequest httpContext, StiReport report, String viewerId) throws IOException, StiException {
        String reportGuid = viewerId + SESSION_ATTRIBUTE_CACHED_REPORT;
        httpContext.getSession().removeAttribute(viewerId + SESSION_ATTRIBUTE_PARAMETERS);
        if (report != null) {
            httpContext.getSession().setAttribute(reportGuid, (Object)report);
        }
    }

    public static String serialize(Document doc, boolean omitXMLDeclaration) throws IOException {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer t = transFactory.newTransformer();
            t.setOutputProperty("method", "html");
            t.setOutputProperty("omit-xml-declaration", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)bos, "UTF-8")));
            bos.close();
            return new String(bos.toByteArray(), "UTF8");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "", e);
            return "";
        }
    }

    public static String getActionCommandName(HttpServletRequest httpContext, JSONObject jsonObject) throws JSONException {
        return (String)jsonObject.get("command");
    }

    public static Object getObjectFromCache(HttpServletRequest httpContext, String objectId) {
        Object undoArray = httpContext.getSession().getAttribute(objectId);
        return undoArray;
    }

    public static Object saveObjectToCache(HttpServletRequest httpContext, String objectId, Object object) {
        httpContext.getSession().setAttribute(objectId, object);
        return object;
    }

    public static StiReport getReportObject_new(HttpServletRequest httpContext, JSONObject parameters) {
        return null;
    }

    public static StiReport getReportObject(HttpServletRequest httpContext, JSONObject parameters) throws JSONException {
        String reportGuid = parameters.getString("reportGuid");
        StiReport report = (StiReport)httpContext.getSession().getAttribute(reportGuid);
        if (report != null) {
            report.getInfo().setForceDesigningMode(true);
            if (parameters.has("reportName")) {
                report.setReportName(parameters.getString("reportName"));
            }
        }
        return report;
    }

    public static StiReport saveReportObject(HttpServletRequest httpContext, StiReport report, String reportGuid) {
        if (report != null) {
            httpContext.getSession().setAttribute(reportGuid, (Object)report);
        }
        return report;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String designerEventResult(HttpServletRequest httpContext, HttpServletResponse response, JSONObject parameterJSON) throws Exception {
        if (httpContext.getParameter("MvcMobileDesignerParameters") != null) {
            parameterJSON = new JSONObject(httpContext.getParameter("MvcMobileDesignerParameters"));
        }
        Hashtable parameters = StiJSONHelper.jsonToHash((JSONObject)parameterJSON);
        Hashtable<String, Object> callbackResult = new Hashtable<String, Object>();
        String command = (String)parameters.get("command");
        callbackResult.put("command", command);
        try {
            StiComponent table;
            StiComponent component;
            StiWebDesignerOptions options;
            StiReport report;
            block144: {
                report = StiWebDesigner.getReportObject(httpContext, parameterJSON);
                options = (StiWebDesignerOptions)httpContext.getSession().getAttribute(SESSION_OPTIONS_ID);
                if (!(report != null || "CloseReport".equals(command) || "CreateReport".equals(command) || "OpenReport".equals(command) || "WizardResult".equals(command))) {
                    callbackResult.put("command", "SessionCompleted");
                    return new JSONObject(callbackResult).toString();
                }
                if ("Synchronization".equals(command)) {
                    if (report == null) {
                        callbackResult.put("command", "SessionCompleted");
                    } else {
                        callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
                    }
                }
                if ("UpdateCache".equals(command)) {
                    callbackResult.put("command", "UpdateCache");
                }
                if ("CloseReport".equals(command)) {
                    report = null;
                }
                if ("MoveComponent".equals(command) || "ResizeComponent".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.changeRectComponent(report, parameters, callbackResult);
                }
                if ("CreateComponent".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.createComponent(report, parameters, callbackResult);
                }
                if ("RemoveComponent".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.removeComponent(report, parameters, callbackResult);
                }
                if ("AddPage".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.addPage(report, parameters, callbackResult);
                }
                if ("RemovePage".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.removePage(report, parameters, callbackResult);
                }
                if ("SendProperties".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.readAllPropertiesFromString(report, parameters, callbackResult);
                }
                if ("ChangeUnit".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.changeUnit(report, (String)parameters.get("reportUnit"));
                    callbackResult.put("reportUnit", parameters.get("reportUnit"));
                    callbackResult.put("gridSize", String.valueOf(report.getInfo().getGridSize()));
                    StiReportEdit.getAllComponentsPositions(report, callbackResult);
                }
                if ("RebuildPage".equals(command)) {
                    callbackResult.put("pageName", parameters.get("pageName"));
                    callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, StiReportEdit.getPageByName(report, (String)parameters.get("pageName"))));
                }
                if ("RenameComponent".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.renameComponent(report, parameters, callbackResult);
                }
                if ("Undo".equals(command)) {
                    report = StiReportEdit.getUndoStep(httpContext, report, parameters, callbackResult, null);
                    StiWebDesigner.saveReportObject(httpContext, report, (String)parameters.get("reportGuid"));
                }
                if ("Redo".equals(command)) {
                    report = StiReportEdit.getRedoStep(httpContext, report, parameters, callbackResult, null);
                    StiWebDesigner.saveReportObject(httpContext, report, (String)parameters.get("reportGuid"));
                }
                if ("SetToClipboard".equals(command)) {
                    StiReportEdit.setToClipboard(httpContext, report, parameters, callbackResult);
                }
                if ("GetFromClipboard".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiReportEdit.getFromClipboard(httpContext, report, parameters, callbackResult);
                }
                if ("PreviewAs".equals(command)) {
                    return StiWebDesigner.previewAs(report, parameterJSON, response);
                }
                if ("GetConnectionTypes".equals(command)) {
                    StiDictionaryHelper.getConnectionTypes(report, parameters, callbackResult, options);
                }
                if ("CreateOrEditConnection".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.createOrEditConnection(report, parameters, callbackResult, options);
                }
                if ("DeleteConnection".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteConnection(report, parameters, callbackResult);
                }
                if ("CreateOrEditRelation".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.createOrEditRelation(report, parameters, callbackResult);
                }
                if ("DeleteRelation".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteRelation(report, parameters, callbackResult);
                }
                if ("CreateOrEditColumn".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.createOrEditColumn(report, parameters, callbackResult);
                }
                if ("DeleteColumn".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteColumn(report, parameters, callbackResult);
                }
                if ("CreateOrEditParameter".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.createOrEditParameter(report, parameters, callbackResult);
                }
                if ("DeleteParameter".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteParameter(report, parameters, callbackResult);
                }
                if ("CreateOrEditDataSource".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.createOrEditDataSource(report, parameters, callbackResult, options);
                }
                if ("DeleteDataSource".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteDataSource(report, parameters, callbackResult);
                }
                if ("CreateOrEditBusinessObject".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.createOrEditBusinessObject(report, parameters, callbackResult);
                }
                if ("DeleteBusinessObject".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteBusinessObject(report, parameters, callbackResult);
                }
                if ("DeleteBusinessObjectCategory".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteBusinessObjectCategory(report, parameters, callbackResult);
                }
                if ("EditBusinessObjectCategory".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.editBusinessObjectCategory(report, parameters, callbackResult);
                }
                if ("CreateOrEditVariable".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.createOrEditVariable(report, parameters, callbackResult);
                }
                if ("DeleteVariable".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteVariable(report, parameters, callbackResult);
                }
                if ("DeleteVariablesCategory".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.deleteVariablesCategory(report, parameters, callbackResult);
                }
                if ("EditVariablesCategory".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.editVariablesCategory(report, parameters, callbackResult);
                }
                if ("CreateVariablesCategory".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiDictionaryHelper.createVariablesCategory(report, parameters, callbackResult);
                }
                if ("SynchronizeDictionary".equals(command)) {
                    StiDictionaryHelper.synchronizeDictionary(report, parameters, callbackResult);
                }
                if ("GetAllConnections".equals(command)) {
                    StiDictionaryHelper.getAllConnections(report, parameters, callbackResult, options);
                }
                if ("RetrieveColumns".equals(command)) {
                    StiDictionaryHelper.retrieveColumns(report, parameters, callbackResult);
                }
                if ("WizardResult".equals(command)) {
                    StiReport newReport = StiWebDesigner.getNewReport(null);
                    if (report != null) {
                        StiWebDesigner.copyReportDictionary(report, newReport);
                    }
                    StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), newReport);
                    String reportGuid = StiWebDesigner.getNewGuid();
                    JSONObject wizardResult = (JSONObject)parameters.get("wizardResult");
                    report = StiWizardHelper.getReportFromWizardOptions(report, (JSONObject)wizardResult.get("reportOptions"), (JSONObject)wizardResult.get("dataSources"));
                    StiWebDesigner.saveReportObject(httpContext, report, reportGuid);
                    StiWebDesigner.saveObjectToCache(httpContext, (String)parameters.get("undoArrayId"), new ArrayList());
                    callbackResult.put("reportGuid", reportGuid);
                    callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
                }
                if ("UpdateStyles".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiStylesHelper.updateStyles(report, parameters, callbackResult);
                }
                if ("AddStyle".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiStylesHelper.addStyle(report, parameters, callbackResult);
                }
                if ("RemoveStyle".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiStylesHelper.removeStyle(report, parameters, callbackResult);
                }
                if ("CreateStyleCollection".equals(command)) {
                    StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                    StiStylesHelper.createStyleCollection(report, parameters, callbackResult);
                }
                if ("StartEditChartComponent".equals(command) && (component = report.GetComponentByName((String)parameters.get("componentName"))) != null) {
                    StiReportEdit.saveComponentClone(httpContext, component, report, parameters, callbackResult, null);
                    callbackResult.put("properties", StiChartHelper.getChartProperties((StiChart)component));
                }
                if ("CanceledEditComponent".equals(command)) {
                    try {
                        StiReportEdit.canceledEditComponent(httpContext, report, parameters, callbackResult, null);
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) break block144;
                        e.printStackTrace();
                    }
                }
            }
            if ("AddSeries".equals(command)) {
                StiChartHelper.addSeries(report, parameters, callbackResult);
            }
            if ("RemoveSeries".equals(command)) {
                StiChartHelper.removeSeries(report, parameters, callbackResult);
            }
            if ("SeriesMove".equals(command)) {
                StiChartHelper.seriesMove(report, parameters, callbackResult);
            }
            if ("AddConstantLineOrStrip".equals(command)) {
                StiChartHelper.addConstantLineOrStrip(report, parameters, callbackResult);
            }
            if ("RemoveConstantLineOrStrip".equals(command)) {
                StiChartHelper.removeConstantLineOrStrip(report, parameters, callbackResult);
            }
            if ("ConstantLineOrStripMove".equals(command)) {
                StiChartHelper.constantLineOrStripMove(report, parameters, callbackResult);
            }
            if ("GetLabelsContent".equals(command)) {
                StiChartHelper.getLabelsContent(report, parameters, callbackResult);
            }
            if ("GetStylesContent".equals(command)) {
                StiChartHelper.getStylesContent(report, parameters, callbackResult, false);
            }
            if ("SetLabelsType".equals(command)) {
                StiChartHelper.setLabelsType(report, parameters, callbackResult);
            }
            if ("SetChartStyle".equals(command)) {
                StiChartHelper.setChartStyle(report, parameters, callbackResult);
            }
            if ("SetChartPropertyValue".equals(command)) {
                StiChartHelper.setChartPropertyValue(report, parameters, callbackResult);
            }
            if ("SendContainerValue".equals(command)) {
                StiChartHelper.setContainerValue(report, parameters, callbackResult);
            }
            if ("GetDatabaseData".equals(command)) {
                StiDictionaryHelper.getDatabaseData(report, parameters, callbackResult);
            }
            if ("ApplySelectedData".equals(command)) {
                StiDictionaryHelper.applySelectedData(report, parameters, callbackResult);
            }
            if ("CreateTextComponent".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.createTextComponentFromDictionary(report, parameters, callbackResult);
            }
            if ("CreateDataComponent".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.createDataComponentFromDictionary(report, parameters, callbackResult);
            }
            if ("SetReportProperties".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.setReportProperties(report, parameters, callbackResult);
            }
            if ("PageMove".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.pageMove(report, parameters, callbackResult);
            }
            if ("TestConnection".equals(command)) {
                StiDictionaryHelper.testConnection(report, parameters, callbackResult, options);
            }
            if ("RunQueryScript".equals(command)) {
                StiDictionaryHelper.runQueryScript(report, parameters, callbackResult);
            }
            if ("ViewData".equals(command)) {
                StiDictionaryHelper.viewData(report, parameters, callbackResult);
            }
            if ("ApplyDesignerOptions".equals(command)) {
                StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiJSONHelper.jsonToHash((JSONObject)((JSONObject)parameters.get("designerOptions"))), report);
                if (parameters.containsKey("reportFile")) {
                    report.setReportFile((String)parameters.get("reportFile"));
                }
                callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
            }
            if ("GetSqlParameterTypes".equals(command)) {
                StiDictionaryHelper.getSqlParameterTypes(report, parameters, callbackResult);
            }
            if ("AlignToGridComponents".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.alignToGridComponents(report, parameters, callbackResult);
            }
            if ("ChangeArrangeComponents".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.changeArrangeComponents(report, parameters, callbackResult);
            }
            if ("UpdateSampleTextFormat".equals(command)) {
                JSONObject param = parameters.get("textFormat") instanceof JSONObject ? (JSONObject)parameters.get("textFormat") : new JSONObject((Map)parameters.get("textFormat"));
                StiFormatService service = StiTextFormatHelper.getFormatService(param);
                if (!service.getIsFormatStringFromVariable()) {
                    callbackResult.put("sampleText", service.Format(service.getSample()));
                }
                service = null;
            }
            if ("StartEditCrossTabComponent".equals(command) && (component = report.GetComponentByName((String)parameters.get("componentName"))) != null) {
                StiReportEdit.saveComponentClone(httpContext, component, report, parameters, callbackResult, null);
            }
            if ("UpdateCrossTabComponent".equals(command) && (component = report.GetComponentByName((String)parameters.get("componentName"))) != null && component instanceof StiCrossTab) {
                StiCrossTabHelper crossTabHelper = new StiCrossTabHelper((StiCrossTab)component);
                crossTabHelper.executeJSCommand((JSONObject)parameters.get("updateParameters"), callbackResult);
                crossTabHelper.restorePositions();
                crossTabHelper = null;
            }
            if ("GetCrossTabColorStyles".equals(command)) {
                callbackResult.put("colorStyles", StiCrossTabHelper.getColorStyles());
            }
            if ("DuplicatePage".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.duplicatePage(report, parameters, callbackResult);
            }
            if ("UpdateEvents".equals(command)) {
                StiReportEdit.updateEvents(report, parameters, callbackResult);
            }
            if ("SetEventValue".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.setEventValue(report, parameters, callbackResult);
            }
            if ("GetChartStylesContent".equals(command)) {
                StiChartHelper.getStylesContent(report, parameters, callbackResult, true);
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
            }
            if ("GetCrossTabStylesContent".equals(command)) {
                callbackResult.put("stylesContent", StiCrossTabHelper.getColorStyles());
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
            }
            if ("GetTableStylesContent".equals(command)) {
                callbackResult.put("stylesContent", StiTableHelper.getTableStyles());
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
            }
            if ("ChangeTableComponent".equals(command) && (table = report.GetComponentByName((String)parameters.get("tableName"))) != null && table instanceof StiTable) {
                StiTableHelper tableHelper = new StiTableHelper((StiTable)table, StiReportEdit.strToDouble((String)parameters.get("zoom")));
                tableHelper.executeJSCommand((JSONObject)parameters.get("changeParameters"), callbackResult);
                tableHelper = null;
            }
            if ("DownloadReport".equals(command)) {
                String reportFile;
                String string = reportFile = parameters.containsKey("reportFile") ? (String)parameters.get("reportFile") : "Report.mrt";
                if (report == null) {
                    // empty if block
                }
            } else if ("DownloadStyles".equals(command)) {
                if (report != null) {
                    return report.getStyles().saveToString();
                }
            } else if ("OpenStyle".equals(command)) {
                StiStylesHelper.openStyle(report, parameters, callbackResult);
            } else if ("CopyStyle".equals(command)) {
                StiStylesHelper.copyStyle(httpContext, report, parameters, callbackResult);
            } else if ("PasteStyle".equals(command)) {
                StiStylesHelper.pasteStyle(httpContext, report, parameters, callbackResult);
            } else if ("DuplicateStyle".equals(command)) {
                StiStylesHelper.duplicateStyle(report, parameters, callbackResult);
            } else if ("ApplyStyleProperties".equals(command)) {
                JSONObject styleProperties = (JSONObject)parameters.get("styleProperties");
                StiBaseStyle style = report.getStyles().get((String)parameters.get("styleOldName"));
                if (style != null) {
                    StiStylesHelper.applyStyleProperties(style, styleProperties);
                }
            } else if ("CreateStyleFromComponent".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiStylesHelper.createStyleFromComponent(report, parameters, callbackResult);
            } else if ("ChangeSizeComponents".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportEdit.changeSizeComponents(report, parameters, callbackResult);
            } else if ("CreateFieldOnDblClick".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiDictionaryHelper.createFieldOnDblClick(report, parameters, callbackResult);
            } else if ("GetParamsFromQueryString".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiDictionaryHelper.getParamsFromQueryString(report, parameters, callbackResult);
            } else if ("CreateMovingCopyComponent".equals(command)) {
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiReportEdit.createMovingCopyComponent(httpContext, report, parameters, callbackResult);
            } else if ("GetReportCheckItems".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiReportCheckHelper.checkReport(httpContext, report, parameters, callbackResult);
            } else if ("GetCheckPreview".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiReportCheckHelper.getCheckPreview(httpContext, report, parameters, callbackResult);
            } else if ("ActionCheck".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiReportEdit.addReportToUndoArray(httpContext, report, parameters);
                StiReportCheckHelper.actionCheck(httpContext, report, parameters, callbackResult);
            } else if ("CheckExpression".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiReportCheckHelper.checkExpression(report, parameters, callbackResult);
            } else if ("GetGlobalizationStrings".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                callbackResult.put("globalizationStrings", StiCultureHelper.getReportGlobalizationStrings(report));
                callbackResult.put("cultures", StiCultureHelper.getItems());
            } else if ("AddGlobalizationStrings".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiCultureHelper.addReportGlobalizationStrings(report, parameters, callbackResult);
            } else if ("RemoveGlobalizationStrings".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiCultureHelper.removeReportGlobalizationStrings(report, parameters, callbackResult);
            } else if ("RemoveGlobalizationStrings".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiCultureHelper.removeReportGlobalizationStrings(report, parameters, callbackResult);
            } else if ("GetCultureSettingsFromReport".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiCultureHelper.getCultureSettingsFromReport(report, parameters, callbackResult);
            } else if ("SetCultureSettingsToReport".equals(command)) {
                callbackResult.put("callbackFunctionId", parameters.get("callbackFunctionId"));
                StiCultureHelper.setCultureSettingsToReport(report, parameters, callbackResult);
            } else if ("ApplyGlobalizationStrings".equals(command)) {
                StiCultureHelper.applyGlobalizationStrings(report, parameters, callbackResult);
            } else if ("StartEditGaugeComponent".equals(command) && (component = report.GetComponentByName((String)parameters.get("componentName"))) != null) {
                StiReportEdit.saveComponentClone(httpContext, component, report, parameters, callbackResult, null);
            }
            if (!parameters.contains("reportGuid")) return new JSONObject(callbackResult).toString();
            String reportGuid = (String)parameters.get("reportGuid");
            StiWebDesigner.saveReportObject(httpContext, report, reportGuid);
            return new JSONObject(callbackResult).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackResult.put("error", StiLoggingUtil.getHtmlError((String)(e.getClass() + " " + e.getMessage()), (Exception)e));
        }
        return new JSONObject(callbackResult).toString();
    }

    public static String getReportTemplateResult(HttpServletRequest httpContext, JSONObject jParameters) throws Exception {
        return StiWebDesigner.getReportTemplateResult(httpContext, null, jParameters);
    }

    public static String getReportTemplateResult(HttpServletRequest httpContext, StiReport report, JSONObject parameters) throws Exception {
        if (report == null) {
            report = StiWebDesigner.getNewReport(parameters);
        }
        String reportGuid = parameters.get("reportGuid") == JSONObject.NULL ? StiWebDesigner.getNewGuid() : parameters.getString("reportGuid");
        report.getInfo().setZoom(1.0);
        if (StiValidationUtil.isNullOrEmpty((String)report.getReportFile())) {
            report.setReportFile(!StiValidationUtil.isNullOrEmpty((String)report.getReportName()) ? report.getReportName() + ".mrt" : "Report.mrt");
        }
        StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), report);
        StiWebDesigner.saveReportObject(httpContext, report, reportGuid);
        Hashtable<String, String> callbackResult = new Hashtable<String, String>();
        callbackResult.put("reportGuid", reportGuid);
        callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        callbackResult.put("command", "LoadReport");
        return new JSONObject(callbackResult).toString();
    }

    public static String getReportSnapshotResult(HttpServletRequest httpContext, JSONObject jParameters) throws JSONException, StiException, IOException, SAXException, StiDeserializationException {
        return StiWebDesigner.getReportSnapshotResult(httpContext, null, jParameters);
    }

    public static String getReportSnapshotResult(HttpServletRequest httpContext, StiReport report, JSONObject parameters) throws JSONException, StiException, IOException, SAXException, StiDeserializationException {
        Hashtable<String, Object> callbackResult = new Hashtable<String, Object>();
        callbackResult.put("command", parameters.get("command"));
        StiReport newReport = report;
        if (newReport == null) {
            newReport = StiWebDesigner.getReportObject(httpContext, parameters);
        }
        StiReportCheckHelper.checkReport(httpContext, newReport, StiJSONHelper.jsonToHash((JSONObject)parameters), callbackResult);
        StiWebDesigner.getReportSnapshotCallbackResult(callbackResult, httpContext, newReport, parameters);
        return new JSONObject(callbackResult).toString();
    }

    public static String getNewReportDataResult(HttpServletRequest httpContext, JSONObject jParameters) throws Exception {
        return StiWebDesigner.getNewReportDataResultHelper(httpContext, null, null, jParameters);
    }

    public static String getNewReportDataResult(HttpServletRequest httpContext, DataSet data, JSONObject jParameters) throws Exception {
        return StiWebDesigner.getNewReportDataResultHelper(httpContext, null, data, jParameters);
    }

    public static String getNewReportDataResult(HttpServletRequest httpContext, StiReport report, JSONObject jParameters) throws Exception {
        return StiWebDesigner.getNewReportDataResultHelper(httpContext, report, null, jParameters);
    }

    public static String getNewReportDataResultHelper(HttpServletRequest httpContext, StiReport report, DataSet data, JSONObject parameters) throws Exception {
        Hashtable<String, Object> callbackResult = new Hashtable<String, Object>();
        callbackResult.put("command", parameters.get("command"));
        StiReport newReport = report;
        if (newReport == null) {
            newReport = StiWebDesigner.getNewReport(parameters);
        }
        StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), newReport);
        StiWebDesigerHandler handler = StiWebDesigner.getHandler(httpContext, parameters);
        handler.onNewReportTemplate(newReport, httpContext);
        callbackResult = StiWebDesigner.getNewReportCallbackResult(callbackResult, httpContext, newReport, parameters);
        return new JSONObject(callbackResult).toString();
    }

    public static String openReportTemplateResult(HttpServletRequest request, JSONObject parameters) throws JSONException, UnsupportedEncodingException {
        String content = URLDecoder.decode(parameters.getString("content"), "UTF-8");
        String fileContent = StiEncodingHelper.decodeString(content.substring(content.indexOf(44) + 1));
        Hashtable<String, Object> callbackResult = new Hashtable<String, Object>();
        callbackResult.put("command", "OpenReport");
        try {
            StiReport report = null;
            if (parameters.has("password")) {
                byte[] bytes = StiBase64DecoderUtil.decode((String)content.substring(content.indexOf(44) + 1).replace(' ', '+'));
                if ((char)bytes[0] != 'm' || (char)bytes[1] != 'r' || (char)bytes[2] != 'x') {
                    throw new Exception("This file is a not '.mrx' format.");
                }
                int[] dest = new int[bytes.length - 3];
                for (int i = 3; i < bytes.length; ++i) {
                    dest[i - 3] = bytes[i] >= 0 ? bytes[i] : 256 + bytes[i];
                }
                dest = StiEncryption.decrypt((int[])dest, (String)parameters.get("password").toString());
                try {
                    byte[] dest2 = new byte[dest.length];
                    for (int i = 0; i < dest.length; ++i) {
                        dest2[i] = (byte)dest[i];
                    }
                    byte[] unpacked = StiGZipHelper.unpack((byte[])dest2);
                    report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
                }
                catch (Exception ee) {
                    throw new Exception("File decryption error: wrong key.");
                }
            } else if (StiWebDesigner.isPackedFile(fileContent)) {
                byte[] unpacked = StiGZipHelper.unpack((byte[])fileContent.getBytes("UTF-8"));
                report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
            } else {
                report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(fileContent.getBytes("UTF-8")));
            }
            StiWebDesigner.setupDesign(report);
            StiWebDesigerHandler handler = StiWebDesigner.getHandler(request, parameters);
            handler.onOpenReportTemplate(report, request);
            report.getInfo().setZoom(1.0);
            if (parameters.has("fileName")) {
                report.setReportFile(parameters.getString("fileName"));
            }
            StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(request), report);
            String reportGuid = StiWebDesigner.getNewGuid();
            StiWebDesigner.saveReportObject(request, report, reportGuid);
            callbackResult.put("reportGuid", reportGuid);
            callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        }
        catch (Exception e) {
            callbackResult.put("reportGuid", JSONObject.NULL);
            callbackResult.put("reportObject", JSONObject.NULL);
            callbackResult.put("error", "Loading report ERROR! " + e.getMessage());
            e.printStackTrace();
        }
        StiWebDesigner.saveObjectToCache(request, parameters.getString("undoArrayId"), new ArrayList());
        return new JSONObject(callbackResult).toString();
    }

    public static String saveReportTemplateResult(HttpServletRequest request, JSONObject parameterJSON) throws JSONException {
        StiReport report = StiWebDesigner.getReportObject(request, parameterJSON);
        String reportName = parameterJSON.has("reportFile") ? parameterJSON.getString("reportFile") : "";
        StiWebDesigerHandler handler = StiWebDesigner.getHandler(request, parameterJSON);
        handler.onSaveReportTemplate(report, reportName, request);
        Hashtable<String, String> callbackResult = new Hashtable<String, String>();
        callbackResult.put("command", "SaveReport");
        if (parameterJSON.has("closeAction")) {
            callbackResult.put("closeAction", parameterJSON.getString("closeAction"));
        }
        return new JSONObject(callbackResult).toString();
    }

    private static void responseFile(HttpServletRequest context, OutputStream stream, String contentType, String fileName) {
    }

    private static void copyReportDictionary(StiReport reportFrom, StiReport reportTo) {
        reportTo.getDictionary().getDataStore().clear();
        reportTo.getDictionary().getDataSources().clear();
        reportTo.getDictionary().getDatabases().clear();
        reportTo.getDictionary().getRelations().clear();
        reportTo.getDictionary().getVariables().clear();
        reportTo.getDictionary().getRestrictions().Clear();
        if (DesignerOptions.NewReport.getAllowRegisterDataStoreFromOldReportInNewReport()) {
            reportTo.getDictionary().getDataStore().addAll((Collection)reportFrom.getDictionary().getDataStore());
        }
        if (DesignerOptions.NewReport.getAllowRegisterDatabasesFromOldReportInNewReport()) {
            reportTo.getDictionary().getDatabases().addAll((Collection)reportFrom.getDictionary().getDatabases());
        }
        if (DesignerOptions.NewReport.getAllowRegisterDataSourcesFromOldReportInNewReport()) {
            reportTo.getDictionary().getDataSources().addAll((Collection)reportFrom.getDictionary().getDataSources());
        }
        if (DesignerOptions.NewReport.getAllowRegisterRelationsFromOldReportInNewReport()) {
            reportTo.getDictionary().getRelations().addAll((Collection)reportFrom.getDictionary().getRelations());
        }
        if (DesignerOptions.NewReport.getAllowRegisterVariablesFromOldReportInNewReport()) {
            reportTo.getDictionary().getVariables().addAll((Collection)reportFrom.getDictionary().getVariables());
        }
        if (DesignerOptions.NewReport.getAllowRegisterRestrictionsFromOldReportInNewReport()) {
            reportTo.getDictionary().setRestrictions(reportFrom.getDictionary().getRestrictions());
        }
    }

    private static StiWebDesigerHandler getHandler(HttpServletRequest request, JSONObject parameterJSON) throws JSONException {
        String clipboardId = parameterJSON.getString("clipboardId");
        return (StiWebDesigerHandler)request.getSession().getAttribute(clipboardId + SESSION_ATTRIBUTE_HANDLER);
    }

    public static Hashtable<String, Object> getReportSnapshotCallbackResult(Hashtable<String, Object> callbackResult, HttpServletRequest httpContext, StiReport report, JSONObject parameters) throws StiException, IOException, SAXException, StiDeserializationException, JSONException {
        StiReportEdit.getPreviewPages(report, parameters, callbackResult);
        return callbackResult;
    }

    public static Hashtable<String, Object> getNewReportCallbackResult(Hashtable<String, Object> callbackResult, HttpServletRequest httpContext, StiReport report, JSONObject parameters) throws JSONException, ParserConfigurationException, IOException, TransformerException {
        String reportGuid = StiWebDesigner.getNewGuid();
        StiWebDesigner.saveReportObject(httpContext, report, reportGuid);
        StiWebDesigner.saveObjectToCache(httpContext, parameters.getString("undoArrayId"), new ArrayList());
        callbackResult.put("reportGuid", reportGuid);
        String command = parameters.getString("command");
        if ("CreateReport".equals(command)) {
            callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        }
        return callbackResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String previewAs(StiReport mainReport, JSONObject parameters, HttpServletResponse response) throws JSONException, StiException, IOException, SAXException, StiDeserializationException {
        StiReport report = StiReportEdit.cloneReport(mainReport, true);
        report.Render(false);
        report = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        String result = null;
        try {
            if ("pdf".equals(parameters.getString("format"))) {
                StiExportManager.exportPdf((StiReport)report, (OutputStream)stream);
                new StiWebActionResult(stream, "Report.pdf", "application/pdf", false).writeFile(response);
            } else {
                StiHtmlExportSettings settings = new StiHtmlExportSettings();
                StiHtmlExportService service = new StiHtmlExportService();
                service.exportHtml(report, (OutputStream)stream, settings);
                result = new String(stream.toByteArray(), "UTF-8");
            }
        }
        finally {
            stream.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void previewReport(StiReport mainReport, String format, HttpServletResponse response) throws IOException, SAXException, StiDeserializationException, StiException {
        StiReport report = StiReportEdit.cloneReport(mainReport, true);
        report.Render(false);
        report = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            if ("pdf".equals(format)) {
                StiExportManager.exportPdf((StiReport)report, (OutputStream)stream);
                new StiWebActionResult(stream, "Report.pdf", "application/pdf", true).writeFile(response);
            } else {
                StiHtmlExportSettings settings = new StiHtmlExportSettings();
                StiHtmlExportService service = new StiHtmlExportService();
                service.exportHtml(report, (OutputStream)stream, settings);
                StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)new String(stream.toByteArray(), "UTF-8"));
            }
        }
        finally {
            stream.close();
        }
    }

    private static String getNewGuid() {
        return StiGuid.newGuidString().substring(0, 16);
    }

    private String getCurrentHelpLanguage() {
        return "ru".equals(StiLocalization.getLocalizationCultureName()) ? "ru" : "en";
    }

    public static StiReport getNewReport(JSONObject parameters) throws JSONException {
        StiReport newReport = StiReport.newInstance();
        newReport.setReportGuid(StiWebDesigner.getNewGuid());
        newReport.getInfo().setForceDesigningMode(true);
        if (parameters != null && parameters.has("defaultUnit")) {
            newReport.setReportUnit(StiReportUnitType.valueOf((String)parameters.getString("defaultUnit")));
        }
        ((StiPage)newReport.getPages().get(0)).setPaperSize(StiPaperKind.Custom);
        ((StiPage)newReport.getPages().get(0)).setPageWidth(newReport.getUnit().ConvertFromHInches(827.0));
        ((StiPage)newReport.getPages().get(0)).setPageHeight(newReport.getUnit().ConvertFromHInches(1169.0));
        newReport.getInfo().setZoom(1.0);
        return newReport;
    }

    private static boolean isPackedFile(String bytes) {
        if (bytes == null || bytes.length() < 3) {
            return false;
        }
        return StiWebDesigner.isPackedFile(bytes.charAt(0), bytes.charAt(1), bytes.charAt(2));
    }

    private static boolean isPackedFile(int first, int second, int third) {
        if (first == 31 && second == 139 && third == 8) {
            return true;
        }
        return first == 80 && second == 75 && third == 3;
    }
}

