/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.web.helper.StiWebResourceHelper;
import com.stimulsoft.webdesigner.StiWebDesigerHandler;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.enums.StiWebDesignerTheme;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;

public class StiWebDesignerHelper {
    public String getWebDesigner(URL context, HttpServletRequest request, StiWebDesigerHandler handler, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebDesigner("WebDesigner1" + StiGuid.newGuidStringPlain(), context, request, handler, servletContext);
    }

    public String getWebDesigner(StiWebDesignerOptions options, URL context, HttpServletRequest request, StiWebDesigerHandler handler, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebDesigner("WebDesigner1" + StiGuid.newGuidStringPlain(), options, context, request, handler, servletContext);
    }

    public String getWebDesigner(String designerID, URL context, HttpServletRequest request, StiWebDesigerHandler handler, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebDesigner(designerID, new StiWebDesignerOptions(), context, request, handler, servletContext);
    }

    public String getWebDesigner(String designerID, StiWebDesignerOptions options, URL context, HttpServletRequest request, StiWebDesigerHandler handler, Object servletContext) throws ParserConfigurationException, IOException, StiException {
        if (options == null) {
            options = new StiWebDesignerOptions();
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)designerID)) {
            options.setDesignerID(designerID);
        } else {
            options.setDesignerID("WebDesigner1" + StiGuid.newGuidStringPlain());
        }
        StiWebDesigner designer = new StiWebDesigner(options, context, request);
        return designer.getDesigner(context, handler, request, servletContext);
    }

    public static String getDesignerStyles(String url, StiWebDesignerTheme theme) {
        StringBuilder css = new StringBuilder();
        String stylesFolder = theme.name();
        if (theme.name().startsWith("Office2013")) {
            stylesFolder = "Office2013";
        }
        Hashtable names = new Hashtable();
        String path = "webdesigner/Styles/Designer/" + stylesFolder + "/";
        try {
            StiWebResourceHelper.getResources(StiWebDesigner.class, (String)"webdesigner", (String)path, (String)url, (String)theme.name(), null, names);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Hashtable<String, String> constants = null;
        for (String name : names.keySet()) {
            if (!name.endsWith(".css")) continue;
            name = name.replaceAll("//", "/");
            StringBuffer cssText = null;
            try {
                cssText = StiIOUtil.toStringBuffer((InputStream)StiResourceUtil.getStream((String)("/" + name)));
            }
            catch (IOException e) {
                StiLoggingUtil.showWarning((String)("Error get stream for " + name), (Exception)e);
            }
            if (name.endsWith("Constants.css") && name.indexOf(theme.name() + "/Constants.css") > 0) {
                constants = StiWebDesignerHelper.getCssConstants(cssText);
                continue;
            }
            if (name.endsWith("Constants.css")) continue;
            css.append(cssText + "\r\n");
        }
        if (constants != null) {
            for (String key : constants.keySet()) {
                int i;
                int len = key.length();
                String val = (String)constants.get(key);
                while ((i = css.indexOf(key)) >= 0) {
                    css.replace(i, i + len, val);
                }
            }
        }
        return css.toString();
    }

    private static Hashtable<String, String> getCssConstants(StringBuffer cssText) {
        Hashtable<String, String> constants = new Hashtable<String, String>();
        int startIndex = cssText.indexOf("@");
        String constantsStr = cssText.substring(startIndex, cssText.lastIndexOf(";") - startIndex);
        String[] constantsArray = constantsStr.split(";");
        for (int i = 0; i < constantsArray.length; ++i) {
            String[] tmpArray = constantsArray[i].split("=");
            if (tmpArray.length != 2) continue;
            constants.put(tmpArray[0].trim(), tmpArray[1]);
        }
        return constants;
    }

    public static String getDesignerScripts(String url) throws IOException {
        StringBuilder script = new StringBuilder();
        Hashtable result = new Hashtable();
        try {
            StiWebResourceHelper.getResources(StiWebDesigner.class, (String)"webdesigner", (String)"webdesigner/Scripts/", (String)url, (String)StiWebDesignerTheme.Blue.name(), null, result);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        for (String file : result.keySet()) {
            if (!file.endsWith("js")) continue;
            script.append(StiIOUtil.toString((InputStream)StiResourceUtil.getStream((String)("/" + file))) + "\r\n");
        }
        return script.toString();
    }
}

