/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.crossTab.StiCrossColumn;
import com.stimulsoft.report.crossTab.StiCrossColumnTotal;
import com.stimulsoft.report.crossTab.StiCrossField;
import com.stimulsoft.report.crossTab.StiCrossHeader;
import com.stimulsoft.report.crossTab.StiCrossRow;
import com.stimulsoft.report.crossTab.StiCrossRowTotal;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.crossTab.StiCrossSummaryHeader;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.crossTab.StiCrossTitle;
import com.stimulsoft.report.crossTab.StiCrossTotal;
import com.stimulsoft.report.crossTab.core.enums.StiSummaryDirection;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.expressions.StiExpression;
import com.stimulsoft.report.options.DesignerOptions;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiCrossTabStyle;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiStylesHelper;
import com.stimulsoft.webdesigner.helper.StiTextFormatHelper;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class StiCrossTabHelper {
    private List<StiCrossTotal> rowTotals = new ArrayList<StiCrossTotal>();
    private List<StiCrossTotal> colTotals = new ArrayList<StiCrossTotal>();
    private List<StiCrossSummaryHeader> sumHeaders = new ArrayList<StiCrossSummaryHeader>();
    private Hashtable createdTotals;
    private StiCrossTab crossTab;
    private List<StiCrossField> columnsContainer = new ArrayList<StiCrossField>();
    private List<StiCrossField> rowsContainer = new ArrayList<StiCrossField>();
    private List<StiCrossField> summaryContainer = new ArrayList<StiCrossField>();
    private StiDataSource selectedDataSource;
    private StiBusinessObject selectedBusinessObject;
    private double oldLeft;
    private double oldTop;

    public void restorePositions() {
        this.crossTab.setLeft(this.oldLeft);
        this.crossTab.setTop(this.oldTop);
    }

    public void executeJSCommand(JSONObject parameters, Hashtable<String, Object> callbackResult) throws Exception {
        Hashtable<String, Object> updateResult = new Hashtable<String, Object>();
        updateResult.put("command", parameters.get("command"));
        String command = (String)parameters.get("command");
        if ("ChangedDataSource".equals(command)) {
            StiReportEdit.setDataSourceProperty(this.crossTab, "");
            StiReportEdit.setBusinessObjectProperty(this.crossTab, "");
            if (parameters.get("dataSourceType").equals("DataSource")) {
                StiReportEdit.setDataSourceProperty(this.crossTab, parameters.get("dataSourceName"));
            } else if (parameters.get("dataSourceType").equals("BusinessObject")) {
                StiReportEdit.setBusinessObjectProperty(this.crossTab, parameters.get("dataSourceName"));
            }
            this.crossTab.getComponents().clear();
        } else if ("InsertItemToContainer".equals(command)) {
            JSONObject itemObject = (JSONObject)parameters.get("itemObject");
            boolean createNewField = false;
            StiCrossColumn field = null;
            List<StiCrossField> destinationContainer = this.getContainerByName((String)parameters.get("destinationContainerName"));
            if (!parameters.get("sourceContainerName").equals("datasources")) {
                List<StiCrossField> sourceContainer = this.getContainerByName((String)parameters.get("sourceContainerName"));
                int index = parameters.getInt("sourceIndex");
                if (sourceContainer != null && index < sourceContainer.size()) {
                    field = sourceContainer.get(index);
                }
                sourceContainer.remove(field);
            }
            if (field == null) {
                createNewField = true;
                if (destinationContainer == this.columnsContainer) {
                    field = new StiCrossColumn();
                    field.setAlias((String)itemObject.get("alias"));
                    ((StiCrossHeader)field).getDisplayValue().setValue("{" + itemObject.get("columnFullName") + "}");
                    ((StiCrossHeader)field).getValue().setValue("{" + itemObject.get("columnFullName") + "}");
                } else if (destinationContainer == this.rowsContainer) {
                    field = new StiCrossRow();
                    field.setAlias((String)itemObject.get("alias"));
                    ((StiCrossHeader)field).getDisplayValue().setValue("{" + itemObject.get("columnFullName") + "}");
                    ((StiCrossHeader)field).getValue().setValue("{" + itemObject.get("columnFullName") + "}");
                } else if (destinationContainer == this.summaryContainer) {
                    field = new StiCrossSummary();
                    field.setAlias((String)itemObject.get("alias"));
                    ((StiCrossSummary)field).getValue().setValue("{" + itemObject.get("columnFullName") + "}");
                }
                this.crossTab.ApplyFieldStyle((StiCrossField)field);
            }
            if (!createNewField) {
                if (field instanceof StiCrossSummary && destinationContainer == this.rowsContainer) {
                    field = this.copySummaryToRow((StiCrossSummary)field);
                } else if (field instanceof StiCrossSummary && destinationContainer == this.columnsContainer) {
                    field = this.copySummaryToColumn((StiCrossSummary)field);
                } else if (field instanceof StiCrossHeader) {
                    if (destinationContainer == this.summaryContainer) {
                        field = this.copyHeaderToSummary((StiCrossHeader)field);
                    }
                    if (destinationContainer == this.rowsContainer) {
                        StiCrossColumn column = field instanceof StiCrossColumn ? field : null;
                        StiCrossRow row = this.copyColumnToRow(column);
                        this.convertColumnTotal(column, row);
                        field = row;
                    }
                    if (destinationContainer == this.columnsContainer) {
                        StiCrossRow row = field instanceof StiCrossRow ? (StiCrossRow)field : null;
                        StiCrossColumn column = this.copyRowToColumn(row);
                        this.convertRowTotal(row, column);
                        field = column;
                    }
                }
            }
            if (parameters.has("destinationIndex") && JSONObject.NULL != parameters.get("destinationIndex")) {
                destinationContainer.add(parameters.getInt("destinationIndex"), (StiCrossField)field);
            } else {
                destinationContainer.add((StiCrossField)field);
            }
            this.killRightTitle();
            this.updateCrossTab();
            updateResult.put("fieldsProperties", this.getFieldsPropertiesForJS());
            updateResult.put("containerName", parameters.get("destinationContainerName"));
            updateResult.put("selectedIndex", parameters.has("destinationIndex") && JSONObject.NULL != parameters.get("destinationIndex") ? parameters.get("destinationIndex") : Integer.valueOf(destinationContainer.size() - 1));
        } else if ("RemoveItemFromContainer".equals(command)) {
            List<StiCrossField> container = this.getContainerByName((String)parameters.get("containerName"));
            int indexForRemove = parameters.getInt("indexForRemove");
            if (container != null && indexForRemove < container.size()) {
                String containerName = parameters.getString("containerName");
                if ("rows".equals(containerName)) {
                    StiCrossRow row = (StiCrossRow)container.get(indexForRemove);
                    container.remove(indexForRemove);
                    StiCrossTitle title = row.getCrossRowTitle();
                    StiCrossRowTotal total = row.getCrossRowTotal();
                    if (this.crossTab.getComponents().contains((Object)row)) {
                        this.crossTab.getComponents().remove((Object)row);
                    }
                    if (title != null && this.crossTab.getComponents().contains((Object)title)) {
                        this.crossTab.getComponents().remove((Object)title);
                    }
                    if (total != null && this.crossTab.getComponents().contains((Object)total)) {
                        this.crossTab.getComponents().remove((Object)total);
                    }
                    this.orderRows();
                } else if ("columns".equals(containerName)) {
                    container.remove(indexForRemove);
                    this.killRightTitle();
                } else if ("summary".equals(containerName)) {
                    container.remove(indexForRemove);
                }
            }
            this.updateCrossTab();
            updateResult.put("fieldsProperties", this.getFieldsPropertiesForJS());
            updateResult.put("containerName", parameters.get("containerName"));
            updateResult.put("selectedIndex", parameters.get("selectIndexAfterRemoved"));
        } else if ("SwapColumnsAndRows".equals(command)) {
            this.swapColumnsAndRows();
            updateResult.put("fieldsProperties", this.getFieldsPropertiesForJS());
        } else if ("ItemMoveUp".equals(command) || "ItemMoveDown".equals(command)) {
            List<StiCrossField> container = this.getContainerByName((String)parameters.get("containerName"));
            int indexForMoving = parameters.getInt("indexForMoving");
            if (container != null) {
                if ("ItemMoveUp".equals(parameters.get("command"))) {
                    if (indexForMoving > 0 && indexForMoving < container.size()) {
                        StiCrossField selectedItem = container.get(indexForMoving);
                        container.remove(selectedItem);
                        container.add(indexForMoving - 1, selectedItem);
                    }
                } else if (indexForMoving < container.size() - 1) {
                    StiCrossField selectedItem = container.get(indexForMoving);
                    container.remove(selectedItem);
                    container.add(indexForMoving + 1, selectedItem);
                }
            }
            this.updateCrossTab();
            updateResult.put("fieldsProperties", this.getFieldsPropertiesForJS());
            updateResult.put("containerName", parameters.get("containerName"));
            updateResult.put("selectedIndex", parameters.get("selectedIndexAfterMoving"));
        } else if ("UpdateProperty".equals(command)) {
            StiComponent component = this.crossTab.getComponents().get((String)parameters.get("componentName"));
            if (component != null) {
                String propertyName = (String)parameters.get("propertyName");
                StiReportEdit.setPropertyValue(component.getReport(), StiReportEdit.upperFirstChar(propertyName), component, parameters.get("propertyValue"));
            }
            this.updateCrossTab();
            updateResult.put("fieldsProperties", this.getFieldsPropertiesForJS());
            updateResult.put("selectedComponentName", parameters.get("componentName"));
        } else if ("SetStyle".equals(command)) {
            if (parameters.has("indexColorStyles") && JSONObject.NULL != parameters.get("indexColorStyles")) {
                this.crossTab.setCrossTabStyle("");
                this.crossTab.setCrossTabStyleIndex(parameters.getInt("indexColorStyles"));
            } else {
                this.crossTab.setCrossTabStyleIndex(-1);
                this.crossTab.setCrossTabStyle((String)parameters.get("styleName"));
                this.crossTab.UpdateStyles();
            }
            this.crossTab.UpdateStyles();
            this.updateCrossTab();
            updateResult.put("fieldsProperties", this.getFieldsPropertiesForJS());
            updateResult.put("selectedComponentName", parameters.has("selectedComponentName") && parameters.get("selectedComponentName") != null ? parameters.get("selectedComponentName") : JSONObject.NULL);
        } else if ("ChangeSummaryDirection".equals(command)) {
            this.changeSummaryDirection(parameters.getString("summaryDirection"));
            updateResult.put("fieldsProperties", this.getFieldsPropertiesForJS());
        }
        callbackResult.put("updateResult", updateResult);
    }

    private List<StiCrossField> getContainerByName(String containerName) {
        if ("columns".equals(containerName)) {
            return this.columnsContainer;
        }
        if ("rows".equals(containerName)) {
            return this.rowsContainer;
        }
        if ("summary".equals(containerName)) {
            return this.summaryContainer;
        }
        return null;
    }

    public ArrayList<Hashtable<String, Object>> getCrossTabResult() throws ParserConfigurationException, IOException, TransformerException {
        ArrayList<Hashtable<String, Object>> components = new ArrayList<Hashtable<String, Object>>();
        for (StiComponent cm : this.crossTab.getComponents()) {
            StiCrossField component = (StiCrossField)cm;
            Hashtable<String, Object> mainProps = new Hashtable<String, Object>();
            components.add(mainProps);
            mainProps.put("name", component.getName());
            mainProps.put("typeComponent", "StiCrossField");
            mainProps.put("svgContent", StiReportEdit.getSvgContent((StiComponent)component, 1.0));
            mainProps.put("componentRect", String.format("%s!%s!%s!%s", StiReportEdit.doubleToStr(component.getClientRectangle().getLeft()), StiReportEdit.doubleToStr(component.getClientRectangle().getTop()), StiReportEdit.doubleToStr(component.getClientRectangle().getWidth()), StiReportEdit.doubleToStr(component.getClientRectangle().getHeight())));
            Hashtable additionalProps = new Hashtable();
            mainProps.put("properties", this.getCrossFieldJSProperies(component));
        }
        return components;
    }

    public Hashtable<String, Object> getCrossFieldJSProperies(StiCrossField crossField) {
        String[] propNames;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("parentCrossTabName", this.crossTab.getName());
        properties.put("name", crossField.getName());
        properties.put("alias", crossField.getAlias());
        properties.put("brush", StiReportEdit.brushToStr(crossField.getBrush()));
        properties.put("border", StiReportEdit.borderToStr(crossField.getBorder()));
        properties.put("componentStyle", crossField.getComponentStyle());
        properties.put("conditions", StiReportEdit.getConditionsProperty(crossField));
        properties.put("horAlignment", crossField.getHorAlignment().toString());
        properties.put("vertAlignment", crossField.getVertAlignment().toString());
        properties.put("useParentStyles", crossField.getUseParentStyles());
        properties.put("minSize", StiReportEdit.doubleToStr(crossField.getMinSize().width) + ";" + StiReportEdit.doubleToStr(crossField.getMinSize().height));
        properties.put("maxSize", StiReportEdit.doubleToStr(crossField.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(crossField.getMaxSize().height));
        properties.put("textOptions.trimming", crossField.getTextOptions().getTrimming().toString());
        properties.put("textOptions.rightToLeft", crossField.getTextOptions().getRightToLeft());
        properties.put("textOptions.lineLimit", crossField.getTextOptions().getLineLimit());
        properties.put("textOptions.hotkeyPrefix", crossField.getTextOptions().getHotkeyPrefix().toString());
        properties.put("textOptions.firstTabOffset", StiReportEdit.doubleToStr(crossField.getTextOptions().getFirstTabOffset()));
        properties.put("textOptions.distanceBetweenTabs", StiReportEdit.doubleToStr(crossField.getTextOptions().getDistanceBetweenTabs()));
        properties.put("wordWrap", crossField.getWordWrap());
        properties.put("margins", String.format("%s;%s;%s;%s", StiReportEdit.doubleToStr(crossField.getMargins().getLeft()), StiReportEdit.doubleToStr(crossField.getMargins().getRight()), StiReportEdit.doubleToStr(crossField.getMargins().getTop()), StiReportEdit.doubleToStr(crossField.getMargins().getBottom())));
        properties.put("font", StiReportEdit.fontToStr(crossField.getFont()));
        properties.put("angle", StiReportEdit.doubleToStr(crossField.getAngle()));
        properties.put("textBrush", StiReportEdit.brushToStr(crossField.getTextBrush()));
        properties.put("allowHtmlTags", crossField.getAllowHtmlTags());
        properties.put("mergeHeaders", crossField.getMergeHeaders());
        properties.put("interaction", StiReportEdit.getInteractionProperty(crossField.getInteraction()));
        properties.put("enabled", crossField.getEnabled());
        properties.put("textQuality", crossField.getTextQuality().toString());
        if (crossField instanceof StiCrossSummary || crossField instanceof StiCrossSummaryHeader) {
            properties.put("hideZeros", crossField.getHideZeros());
        }
        if (crossField instanceof StiCrossSummary || crossField instanceof StiCrossSummaryHeader || crossField instanceof StiCrossColumn || crossField instanceof StiCrossRow) {
            properties.put("textFormat", StiTextFormatHelper.getTextFormatItem(crossField.getTextFormat()));
        }
        for (String propName : propNames = new String[]{"text", "displayValue", "sortDirection", "sortType", "value", "enumeratorSeparator", "enumeratorType", "printOnAllPages", "showTotal", "showPercents", "summary", "summaryValues", "imageHorAlignment", "imageVertAlignment", "aspectRatio", "stretch", "useStyleOfSummaryInRowTotal", "useStyleOfSummaryInColumnTotal"}) {
            Object value = StiReportEdit.getPropertyValue(StiReportEdit.upperFirstChar(propName), crossField);
            if (value == null) continue;
            properties.put(propName, value);
        }
        if (properties.containsKey("value") && properties.containsKey("text")) {
            properties.remove("text");
        }
        return properties;
    }

    public Hashtable<String, Object> getFieldsPropertiesForJS() throws ParserConfigurationException, IOException, TransformerException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ArrayList<Hashtable<String, Object>> jsColumns = new ArrayList<Hashtable<String, Object>>();
        ArrayList<Hashtable<String, Object>> jsRows = new ArrayList<Hashtable<String, Object>>();
        ArrayList<Hashtable<String, Object>> jsSummary = new ArrayList<Hashtable<String, Object>>();
        for (StiCrossField crossField : this.columnsContainer) {
            jsColumns.add(this.getCrossFieldJSProperies(crossField));
        }
        for (StiCrossField crossField : this.rowsContainer) {
            jsRows.add(this.getCrossFieldJSProperies(crossField));
        }
        for (StiCrossField crossField : this.summaryContainer) {
            jsSummary.add(this.getCrossFieldJSProperies(crossField));
        }
        properties.put("columns", jsColumns);
        properties.put("rows", jsRows);
        properties.put("summary", jsSummary);
        properties.put("components", this.getCrossTabResult());
        properties.put("crossTabStyleIndex", this.crossTab.getCrossTabStyleIndex());
        properties.put("crossTabStyle", this.crossTab.getCrossTabStyle());
        return properties;
    }

    public static ArrayList<Hashtable<String, Object>> getColorStyles() {
        ArrayList<Hashtable<String, Object>> styles = new ArrayList<Hashtable<String, Object>>();
        int index = 0;
        for (StiColor color : DesignerOptions.CrossTab.getStyleColors()) {
            StiCrossTabStyle style = new StiCrossTabStyle(color.getName());
            style.setColor(color);
            String locName = StiLocalization.getValue((String)"PropertyColor", (String)color.getName());
            style.setName(locName != null ? locName : color.toHTML());
            Hashtable<String, Object> styleItem = StiStylesHelper.styleItem((StiBaseStyle)style);
            styleItem.put("indexColorStyles", index);
            styles.add(styleItem);
            ++index;
        }
        return styles;
    }

    private void updateCrossTab() {
        boolean needSummaryTitle;
        String name;
        StiCrossTitle title3;
        String type;
        StiCrossSummaryHeader header;
        this.rowTotals.clear();
        this.colTotals.clear();
        ArrayList<StiCrossRow> rowComps = new ArrayList<StiCrossRow>();
        ArrayList<StiCrossColumn> colComps = new ArrayList<StiCrossColumn>();
        Hashtable<Object, Object> usedComps = new Hashtable<Object, Object>();
        int rowIndex = 0;
        for (StiCrossField f : this.rowsContainer) {
            StiCrossRow row = (StiCrossRow)f;
            row.setPage(null);
            row.setName(this.crossTab.getName() + "_Row" + String.valueOf(rowIndex + 1));
            row.setPage(this.crossTab.getPage());
            if (this.crossTab.getComponents().contains((Object)row)) {
                this.crossTab.getComponents().remove((Object)row);
            }
            this.crossTab.getComponents().add((StiComponent)row);
            usedComps.put(row, row);
            rowComps.add(row);
            StiCrossTotal total = row.getTotal();
            if (total == null) {
                total = this.createRowTotal(row.getGuid());
                row.setTotalGuid(total.getGuid());
                this.crossTab.getComponents().add((StiComponent)total);
            }
            usedComps.put(total, total);
            this.rowTotals.add(total);
            ++rowIndex;
        }
        int columnIndex = 0;
        for (StiCrossField f : this.columnsContainer) {
            StiCrossColumn column = (StiCrossColumn)f;
            column.setPage(null);
            column.setName(this.crossTab.getName() + "_Column" + String.valueOf(columnIndex + 1));
            column.setPage(this.crossTab.getPage());
            if (this.crossTab.getComponents().contains((Object)column)) {
                this.crossTab.getComponents().remove((Object)column);
            }
            this.crossTab.getComponents().add((StiComponent)column);
            usedComps.put(column, column);
            colComps.add(column);
            StiCrossTotal total = column.getTotal();
            if (total == null) {
                total = this.createColTotal(column.getGuid());
                column.setTotalGuid(total.getGuid());
                this.crossTab.getComponents().add((StiComponent)total);
            }
            usedComps.put(total, total);
            this.colTotals.add(total);
            ++columnIndex;
        }
        int summaryIndex = 1;
        Iterator<StiCrossField> i$ = this.summaryContainer.iterator();
        while (i$.hasNext()) {
            StiCrossField f;
            StiCrossField summary = f = i$.next();
            summary.setPage(null);
            summary.setName(this.crossTab.getName() + "_Sum" + String.valueOf(summaryIndex));
            summary.setPage(this.crossTab.getPage());
            usedComps.put(summary, summary);
            if (this.crossTab.getComponents().contains((Object)summary)) {
                this.crossTab.getComponents().remove((Object)summary);
            }
            this.crossTab.getComponents().add((StiComponent)summary);
            ++summaryIndex;
        }
        summaryIndex = 1;
        if (this.summaryContainer.size() < 2) {
            for (StiCrossSummaryHeader header2 : this.sumHeaders) {
                if (!this.crossTab.getComponents().contains((Object)header2)) continue;
                this.crossTab.getComponents().remove((Object)header2);
            }
            this.sumHeaders.clear();
        } else if (this.sumHeaders.size() > this.summaryContainer.size()) {
            while (this.sumHeaders.size() > this.summaryContainer.size()) {
                header = this.sumHeaders.get(this.sumHeaders.size() - 1);
                if (this.crossTab.getComponents().contains((Object)header)) {
                    this.crossTab.getComponents().remove((Object)header);
                }
                this.sumHeaders.remove(this.sumHeaders.size() - 1);
            }
        } else if (this.sumHeaders.size() < this.summaryContainer.size()) {
            while (this.sumHeaders.size() < this.summaryContainer.size()) {
                header = new StiCrossSummaryHeader();
                StiExpression text = new StiExpression(String.valueOf(this.sumHeaders.size() + 1));
                header.setText(text);
                header.setPage(null);
                header.setName(this.crossTab.getName() + "_SumHeader" + String.valueOf(this.sumHeaders.size() + 1));
                header.setPage(this.crossTab.getPage());
                this.crossTab.ApplyFieldStyle((StiCrossField)header);
                this.crossTab.getComponents().add((StiComponent)header);
                this.sumHeaders.add(header);
            }
        }
        for (StiCrossSummaryHeader header2 : this.sumHeaders) {
            usedComps.put(header2, header2);
        }
        int rowTotalIndex = 1;
        for (StiCrossTotal rowTotal : this.rowTotals) {
            rowTotal.setPage(null);
            rowTotal.setName(this.crossTab.getName() + "_RowTotal" + String.valueOf(rowTotalIndex++));
            rowTotal.setPage(this.crossTab.getPage());
        }
        int colTotalIndex = 1;
        for (StiCrossTotal colTotal : this.colTotals) {
            colTotal.setPage(null);
            colTotal.setName(this.crossTab.getName() + "_ColTotal" + String.valueOf(colTotalIndex++));
            colTotal.setPage(this.crossTab.getPage());
        }
        boolean needTopTitle = this.columnsContainer.size() > 0 && this.rowsContainer.size() > 0;
        ArrayList<StiCrossTitle> titleCols = new ArrayList<StiCrossTitle>();
        ArrayList<StiCrossTitle> titleRows = new ArrayList<StiCrossTitle>();
        StiCrossTitle leftTitle = null;
        StiCrossTitle rightTitle = null;
        StiCrossTitle summaryTitle = null;
        for (StiComponent c : this.crossTab.getComponents()) {
            StiCrossField field = (StiCrossField)c;
            if (!(field instanceof StiCrossTitle)) continue;
            StiCrossTitle title2 = (StiCrossTitle)field;
            if (title2.getTypeOfComponent().startsWith("Col:")) {
                titleCols.add(title2);
            }
            if (title2.getTypeOfComponent().startsWith("Row:")) {
                titleRows.add(title2);
            }
            if (title2.getTypeOfComponent().startsWith("LeftTitle")) {
                leftTitle = title2;
            }
            if (title2.getTypeOfComponent().startsWith("RightTitle")) {
                rightTitle = title2;
            }
            if (!title2.getTypeOfComponent().startsWith("SummaryTitle")) continue;
            summaryTitle = title2;
        }
        if (this.rowsContainer.size() == 0) {
            for (StiCrossColumn col : colComps) {
                type = "Col:" + col.getName();
                boolean finded = false;
                for (StiCrossTitle title3 : titleCols) {
                    if (!type.equals(title3.getTypeOfComponent())) continue;
                    titleCols.remove(title3);
                    finded = true;
                    usedComps.put(title3, title3);
                    break;
                }
                if (finded) continue;
                name = "";
                for (StiCrossField col_ : this.columnsContainer) {
                    if (!col.equals(col_)) continue;
                    name = col_.getAlias();
                }
                title3 = new StiCrossTitle();
                title3.setName(col.getName() + "_Title");
                title3.setText(new StiExpression(name));
                title3.setTypeOfComponent("Col:" + col.getName());
                this.crossTab.ApplyFieldStyle((StiCrossField)title3);
                this.crossTab.getComponents().add((StiComponent)title3);
                usedComps.put(title3, title3);
            }
        }
        for (StiCrossRow row : rowComps) {
            type = "Row:" + row.getName();
            boolean finded = false;
            for (StiCrossTitle title3 : titleRows) {
                if (!type.equals(title3.getTypeOfComponent())) continue;
                titleRows.remove(title3);
                finded = true;
                usedComps.put(title3, title3);
                break;
            }
            if (finded) continue;
            name = "";
            for (StiCrossField row_ : this.rowsContainer) {
                if (!row.equals(row_)) continue;
                name = row_.getAlias();
            }
            title3 = new StiCrossTitle();
            title3.setName(row.getName() + "_Title");
            title3.setText(new StiExpression(name));
            title3.setTypeOfComponent("Row:" + row.getName());
            this.crossTab.ApplyFieldStyle((StiCrossField)title3);
            this.crossTab.getComponents().add((StiComponent)title3);
            usedComps.put(title3, title3);
        }
        if (leftTitle == null) {
            if (needTopTitle) {
                leftTitle = new StiCrossTitle();
                leftTitle.setName(this.crossTab.getName() + "_LeftTitle");
                if (this.selectedDataSource != null) {
                    leftTitle.getText().setValue(this.selectedDataSource.getName());
                } else if (this.selectedBusinessObject != null) {
                    leftTitle.getText().setValue(this.selectedBusinessObject.getName());
                } else {
                    leftTitle.getText().setValue("");
                }
                leftTitle.getText().setValue(this.selectedDataSource != null ? this.selectedDataSource.getName() : "");
                leftTitle.setTypeOfComponent("LeftTitle");
                this.crossTab.ApplyFieldStyle((StiCrossField)leftTitle);
                this.crossTab.getComponents().add((StiComponent)leftTitle);
                usedComps.put(leftTitle, leftTitle);
            }
        } else if (needTopTitle) {
            usedComps.put(leftTitle, leftTitle);
        }
        if (rightTitle == null) {
            if (needTopTitle) {
                String name2 = "";
                boolean first = true;
                for (StiCrossField col_ : this.columnsContainer) {
                    if (!first) {
                        name2 = name2 + ", ";
                    }
                    name2 = name2 + col_.getAlias();
                    first = false;
                }
                rightTitle = new StiCrossTitle();
                rightTitle.setName(this.crossTab.getName() + "_RightTitle");
                rightTitle.setText(new StiExpression(name2));
                rightTitle.setTypeOfComponent("RightTitle");
                this.crossTab.ApplyFieldStyle((StiCrossField)rightTitle);
                this.crossTab.getComponents().add((StiComponent)rightTitle);
                usedComps.put(rightTitle, rightTitle);
            }
        } else if (needTopTitle) {
            usedComps.put(rightTitle, rightTitle);
        }
        boolean bl = needSummaryTitle = (this.columnsContainer.size() == 0 || this.rowsContainer.size() == 0) && this.summaryContainer.size() > 0;
        if (summaryTitle == null) {
            if (needSummaryTitle) {
                String name3 = "";
                boolean first = true;
                for (StiCrossField summary_ : this.summaryContainer) {
                    if (!first) {
                        name3 = name3 + ", ";
                    }
                    name3 = name3 + summary_.getAlias();
                    first = false;
                }
                summaryTitle = new StiCrossTitle();
                summaryTitle.setName(this.crossTab.getName() + "_SummaryTitle");
                summaryTitle.setText(new StiExpression(name3));
                summaryTitle.setTypeOfComponent("SummaryTitle");
                this.crossTab.ApplyFieldStyle((StiCrossField)summaryTitle);
                this.crossTab.getComponents().add((StiComponent)summaryTitle);
                usedComps.put(summaryTitle, summaryTitle);
            }
        } else if (needSummaryTitle) {
            usedComps.put(summaryTitle, summaryTitle);
        }
        int index = 0;
        while (index < this.crossTab.getComponents().size()) {
            StiComponent comp = (StiComponent)this.crossTab.getComponents().get(index);
            if (!usedComps.containsKey(comp)) {
                this.crossTab.getComponents().remove(index);
                continue;
            }
            ++index;
        }
        StiRectangle rect = new StiRectangle();
        com.stimulsoft.report.crossTab.StiCrossTabHelper.BuildCross((StiCrossTab)this.crossTab, (boolean)true);
        for (StiComponent c : this.crossTab.getComponents()) {
            StiCrossField field = (StiCrossField)c;
            if (!(this.crossTab.getCrossTabInfo().Cross.getFields().get(field) instanceof Point)) continue;
            Point pos = (Point)this.crossTab.getCrossTabInfo().Cross.getFields().get(field);
            this.crossTab.getCrossTabInfo().Cross.SetTextOfCell(pos.x, pos.y, field.getCellText());
        }
        this.crossTab.getCrossTabInfo().Cross.MaxWidth = this.crossTab.getPage().getWidth();
        this.crossTab.getCrossTabInfo().Cross.MaxHeight = this.crossTab.getPage().getHeight();
        this.crossTab.getCrossTabInfo().Cross.DoAutoSize();
        Hashtable<StiCrossTotal, StiCrossTotal> hidedTotals = new Hashtable<StiCrossTotal, StiCrossTotal>();
        for (StiComponent c : this.crossTab.getComponents()) {
            StiCrossField field = (StiCrossField)c;
            StiCrossHeader header3 = field instanceof StiCrossHeader ? (StiCrossHeader)field : null;
            if (header3 == null || header3.isTotalVisible() || header3.getTotal() == null) continue;
            hidedTotals.put(header3.getTotal(), header3.getTotal());
        }
        double distXX = this.crossTab.getReport().getUnit().ConvertFromHInches(2.0);
        double distYY = this.crossTab.getReport().getUnit().ConvertFromHInches(2.0);
        for (StiComponent c : this.crossTab.getComponents()) {
            StiCrossField field = (StiCrossField)c;
            if (this.crossTab.getCrossTabInfo().Cross.getFields().get(field) instanceof Point) {
                StiCrossColumn col;
                StiCrossRowTotal rowTotal;
                StiCrossRow row;
                StiCrossTitle title4;
                Point pos = (Point)this.crossTab.getCrossTabInfo().Cross.getFields().get(field);
                StiRectangle fieldRect = this.crossTab.getReport().getUnit().ConvertToHInches(com.stimulsoft.report.crossTab.StiCrossTabHelper.GetCellRect((StiCrossTab)this.crossTab, (int)pos.x, (int)pos.y));
                rect.width = Math.max(rect.width, fieldRect.getRight());
                rect.height = Math.max(rect.height, fieldRect.getBottom());
                fieldRect = this.crossTab.getReport().getUnit().ConvertFromHInches(fieldRect);
                if (hidedTotals.containsKey(field)) {
                    fieldRect.width = 0.0;
                    fieldRect.height = 0.0;
                }
                double distX = 0.0;
                double distY = 0.0;
                StiCrossTitle stiCrossTitle = title4 = field instanceof StiCrossTitle ? (StiCrossTitle)field : null;
                if (title4 != null) {
                    if (title4.getTypeOfComponent().startsWith("LeftTitle")) {
                        distX = 0.0;
                        distY = 0.0;
                    }
                    if (title4.getTypeOfComponent().startsWith("RightTitle")) {
                        distX = distXX;
                        distY = 0.0;
                    }
                    if (title4.getTypeOfComponent().startsWith("SummaryTitle")) {
                        if (this.rowsContainer.size() == 0) {
                            distX = 0.0;
                            distY = distYY * 2.0;
                        }
                        if (this.columnsContainer.size() == 0) {
                            distX = distXX;
                            distY = distYY;
                        }
                    }
                    if (title4.getTypeOfComponent().startsWith("Row:")) {
                        distX = 0.0;
                        distY = distYY;
                    }
                    if (title4.getTypeOfComponent().startsWith("Col:")) {
                        distX = 0.0;
                        distY = distYY;
                    }
                }
                StiCrossRow stiCrossRow = row = field instanceof StiCrossRow ? (StiCrossRow)field : null;
                if (row != null) {
                    distX = 0.0;
                    distY = distYY * 2.0;
                }
                StiCrossRowTotal stiCrossRowTotal = rowTotal = field instanceof StiCrossRowTotal ? (StiCrossRowTotal)field : null;
                if (rowTotal != null) {
                    distX = 0.0;
                    distY = distYY * 2.0;
                }
                StiCrossColumn stiCrossColumn = col = field instanceof StiCrossColumn ? (StiCrossColumn)field : null;
                if (col != null) {
                    distX = distXX;
                    distY = distYY;
                }
                if (field instanceof StiCrossColumnTotal) {
                    distX = distXX;
                    distY = distYY;
                }
                if (field instanceof StiCrossSummary) {
                    distX = distXX;
                    distY = distYY * 2.0;
                }
                if (field instanceof StiCrossSummaryHeader) {
                    if (this.crossTab.getSummaryDirection() == StiSummaryDirection.LeftToRight) {
                        distX = distXX;
                        distY = distYY;
                    } else {
                        distX = 0.0;
                        distY = distYY * 2.0;
                    }
                }
                fieldRect.x += distX;
                fieldRect.y += distY;
                field.setClientRectangle(fieldRect);
            }
            field.SetTextInternal(field.getCellText());
        }
    }

    private StiCrossRowTotal createRowTotal(String rowGuid) {
        StiCrossRowTotal rowTotal;
        StiCrossRowTotal stiCrossRowTotal = rowTotal = this.createdTotals.get(rowGuid) instanceof StiCrossRowTotal ? (StiCrossRowTotal)this.createdTotals.get(rowGuid) : null;
        if (rowTotal == null) {
            rowTotal = new StiCrossRowTotal();
            this.crossTab.ApplyFieldStyle((StiCrossField)rowTotal);
        }
        this.createdTotals.put(rowGuid, rowTotal);
        return rowTotal;
    }

    private StiCrossColumnTotal createColTotal(String colGuid) {
        StiCrossColumnTotal colTotal;
        StiCrossColumnTotal stiCrossColumnTotal = colTotal = this.createdTotals.get(colGuid) instanceof StiCrossColumnTotal ? (StiCrossColumnTotal)this.createdTotals.get(colGuid) : null;
        if (colTotal == null) {
            colTotal = new StiCrossColumnTotal();
            this.crossTab.ApplyFieldStyle((StiCrossField)colTotal);
        }
        this.createdTotals.put(colGuid, colTotal);
        this.colTotals.add((StiCrossTotal)colTotal);
        return colTotal;
    }

    private void swapColumnsAndRows() {
        ArrayList<StiCrossRow> rows = new ArrayList<StiCrossRow>();
        for (StiCrossField c : this.columnsContainer) {
            StiCrossColumn column = (StiCrossColumn)c;
            StiCrossRow row = this.copyColumnToRow(column);
            rows.add(row);
            this.convertColumnTotal(column, row);
        }
        this.columnsContainer.clear();
        for (StiCrossField c : this.rowsContainer) {
            StiCrossRow row = (StiCrossRow)c;
            StiCrossColumn column = this.copyRowToColumn(row);
            this.columnsContainer.add((StiCrossField)column);
            this.convertRowTotal(row, column);
        }
        this.rowsContainer.clear();
        for (StiCrossRow row : rows) {
            this.rowsContainer.add((StiCrossField)row);
        }
        this.updateCrossTab();
    }

    private void changeSummaryDirection(String summaryDirection) {
        this.crossTab.setSummaryDirection(StiSummaryDirection.valueOf((String)summaryDirection));
        this.updateCrossTab();
    }

    private StiCrossHeader copySummaryToRow(StiCrossSummary field) {
        StiCrossRow header = new StiCrossRow();
        this.copyFieldToField((StiCrossField)header, (StiCrossField)field);
        header.getDisplayValue().setValue(field.getValue().getValue());
        header.getValue().setValue(field.getValue().getValue());
        return header;
    }

    private StiCrossHeader copySummaryToColumn(StiCrossSummary field) {
        StiCrossColumn header = new StiCrossColumn();
        this.copyFieldToField((StiCrossField)header, (StiCrossField)field);
        header.getDisplayValue().setValue(field.getValue().getValue());
        header.getValue().setValue(field.getValue().getValue());
        return header;
    }

    private StiCrossSummary copyHeaderToSummary(StiCrossHeader header) {
        StiCrossSummary field = new StiCrossSummary();
        this.copyFieldToField((StiCrossField)field, (StiCrossField)header);
        field.getValue().setValue(header.getValue().getValue());
        return field;
    }

    private StiCrossColumn copyRowToColumn(StiCrossRow row) {
        StiCrossColumn field = new StiCrossColumn();
        this.copyFieldToField((StiCrossField)field, (StiCrossField)row);
        field.getValue().setValue(row.getValue().getValue());
        field.getDisplayValue().setValue(row.getDisplayValue().getValue());
        return field;
    }

    private StiCrossRow copyColumnToRow(StiCrossColumn column) {
        StiCrossRow field = new StiCrossRow();
        this.copyFieldToField((StiCrossField)field, (StiCrossField)column);
        field.getValue().setValue(column.getValue().getValue());
        field.getDisplayValue().setValue(column.getDisplayValue().getValue());
        return field;
    }

    private StiCrossColumnTotal copyRowTotalToColumnTotal(StiCrossRowTotal row) {
        StiCrossColumnTotal field = new StiCrossColumnTotal();
        this.copyFieldToField((StiCrossField)field, (StiCrossField)row);
        field.getText().setValue(row.getText().getValue());
        return field;
    }

    private StiCrossRowTotal copyColumnTotalToRowTotal(StiCrossColumnTotal column) {
        StiCrossRowTotal field = new StiCrossRowTotal();
        this.copyFieldToField((StiCrossField)field, (StiCrossField)column);
        field.getText().setValue(column.getText().getValue());
        return field;
    }

    private void copyFieldToField(StiCrossField dest, StiCrossField source) {
        dest.setName(source.getName());
        dest.setAlias(source.getAlias());
        dest.setGuid(source.getGuid());
        dest.setBorder((StiBorder)source.getBorder().clone());
        dest.setBrush((StiBrush)source.getBrush().clone());
        dest.setFont((StiFont)source.getFont().clone());
        dest.setTextFormat((StiFormatService)source.getTextFormat().clone());
        dest.setTextBrush((StiBrush)source.getTextBrush().clone());
        dest.setTextOptions((StiTextOptions)source.getTextOptions().clone());
        if (source instanceof StiCrossHeader && dest instanceof StiCrossHeader) {
            ((StiCrossHeader)dest).setShowTotal(((StiCrossHeader)source).getShowTotal());
            ((StiCrossHeader)dest).setSortDirection(((StiCrossHeader)source).getSortDirection());
            ((StiCrossHeader)dest).setSortType(((StiCrossHeader)source).getSortType());
            ((StiCrossHeader)dest).setPrintOnAllPages(((StiCrossHeader)source).getPrintOnAllPages());
        }
        dest.setHorAlignment(source.getHorAlignment());
        dest.setVertAlignment(source.getVertAlignment());
    }

    private void convertColumnTotal(StiCrossColumn sourceColumn, StiCrossRow destRow) {
        if (sourceColumn.getTotalGuid() != null) {
            StiCrossColumnTotal columnTotal = (StiCrossColumnTotal)sourceColumn.getTotal();
            this.crossTab.getComponents().remove((Object)columnTotal);
            StiCrossRowTotal rowTotal = this.copyColumnTotalToRowTotal(columnTotal);
            this.crossTab.getComponents().add((StiComponent)rowTotal);
            destRow.setTotalGuid(rowTotal.getGuid());
        }
    }

    private void convertRowTotal(StiCrossRow sourceRow, StiCrossColumn destColumn) {
        if (sourceRow.getTotalGuid() != null) {
            StiCrossRowTotal rowTotal = (StiCrossRowTotal)sourceRow.getTotal();
            this.crossTab.getComponents().remove((Object)rowTotal);
            StiCrossColumnTotal columnTotal = this.copyRowTotalToColumnTotal(rowTotal);
            this.crossTab.getComponents().add((StiComponent)columnTotal);
            destColumn.setTotalGuid(columnTotal.getGuid());
        }
    }

    private void killRightTitle() {
        for (StiComponent comp : this.crossTab.getComponents()) {
            StiCrossTitle title = comp instanceof StiCrossTitle ? (StiCrossTitle)comp : null;
            if (title == null || !title.getTypeOfComponent().startsWith("RightTitle")) continue;
            this.crossTab.getComponents().remove((Object)comp);
            break;
        }
    }

    private void orderRows() {
        int rowIndex = 1;
        for (StiCrossField field : this.rowsContainer) {
            StiCrossRow row = (StiCrossRow)field;
            StiCrossTitle title = row.getCrossRowTitle();
            StiCrossRowTotal total = row.getCrossRowTotal();
            row.setName(String.format("%s_Row%s", this.crossTab.getName(), rowIndex));
            if (title != null) {
                title.setName(String.format("%s_Title", row.getName()));
                title.setTypeOfComponent(String.format("Row:%s", row.getName()));
            }
            if (total != null) {
                total.setName(String.format("%s_RowTotal%s", this.crossTab.getName(), rowIndex));
            }
            ++rowIndex;
        }
    }

    public StiCrossTabHelper(StiCrossTab crossTab) {
        this.createdTotals = new Hashtable();
        this.crossTab = crossTab;
        this.oldLeft = this.crossTab.getLeft();
        this.oldTop = this.crossTab.getTop();
        this.crossTab.setLeft(0.0);
        this.crossTab.setTop(0.0);
        this.selectedDataSource = crossTab.getDataSource();
        this.selectedBusinessObject = crossTab.getBusinessObject();
        for (StiComponent comp : this.crossTab.getComponents()) {
            StiCrossSummaryHeader summary;
            if (comp instanceof StiCrossSummary || comp instanceof StiCrossColumn || comp instanceof StiCrossRow) {
                if (comp instanceof StiCrossSummary) {
                    this.summaryContainer.add((StiCrossField)((StiCrossSummary)comp));
                }
                if (comp instanceof StiCrossColumn) {
                    this.columnsContainer.add((StiCrossField)((StiCrossColumn)comp));
                }
                if (comp instanceof StiCrossRow) {
                    this.rowsContainer.add((StiCrossField)((StiCrossRow)comp));
                }
            }
            if ((summary = comp instanceof StiCrossSummaryHeader ? (StiCrossSummaryHeader)comp : null) == null) continue;
            this.sumHeaders.add(summary);
        }
    }
}

