/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.webdesigner.helper.StiDictionaryHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiStylesHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class StiDesignReportHelper {
    private StiReport report = null;

    public StiDesignReportHelper(StiReport report) {
        this.report = report;
    }

    public Hashtable<String, Object> getReportToObject() throws ParserConfigurationException, IOException, TransformerException {
        Hashtable<String, Object> reportObject = new Hashtable<String, Object>();
        reportObject.put("zoom", StiReportEdit.doubleToStr(this.report.getInfo().getZoom()));
        reportObject.put("gridSize", StiReportEdit.doubleToStr(this.report.getUnit().ConvertToHInches(this.report.getInfo().getGridSize())));
        reportObject.put("dictionary", StiDictionaryHelper.getDictionaryTree(this.report));
        reportObject.put("stylesCollection", StiStylesHelper.getStyles(this.report));
        reportObject.put("pages", this.getPages());
        reportObject.put("properties", StiReportEdit.getReportProperties(this.report));
        reportObject.put("info", this.getReportInfo());
        return reportObject;
    }

    public ArrayList<Hashtable<String, Object>> getPages() throws ParserConfigurationException, IOException, TransformerException {
        ArrayList<Hashtable<String, Object>> pages = new ArrayList<Hashtable<String, Object>>();
        for (int pageIndex = 0; pageIndex < this.report.getPages().size(); ++pageIndex) {
            Hashtable<String, Object> page = this.getPage(pageIndex);
            if (page == null) continue;
            pages.add(page);
        }
        return pages;
    }

    public Hashtable<String, Object> getPage(int pageIndex) throws ParserConfigurationException, IOException, TransformerException {
        StiPage page = (StiPage)this.report.getPages().get(pageIndex);
        Hashtable<String, Object> pageObject = new Hashtable<String, Object>();
        pageObject.put("name", page.getName());
        pageObject.put("pageIndex", String.valueOf(pageIndex));
        pageObject.put("properties", StiReportEdit.getAllProperties((StiComponent)page));
        if (((Hashtable)pageObject.get("properties")).keySet().size() == 0) {
            return null;
        }
        pageObject.put("components", this.getComponents(page));
        return pageObject;
    }

    private ArrayList<Hashtable<String, Object>> getComponents(StiPage page) throws ParserConfigurationException, IOException, TransformerException {
        ArrayList<Hashtable<String, Object>> components = new ArrayList<Hashtable<String, Object>>();
        StiComponentsCollection comps = page.GetComponents();
        for (int index = 0; index < comps.size(); ++index) {
            StiComponent comp = (StiComponent)comps.get(index);
            components.add(this.getComponent(comp));
        }
        return components;
    }

    private Hashtable<String, Object> getComponent(StiComponent component) throws ParserConfigurationException, IOException, TransformerException {
        Hashtable<String, Object> compObject = new Hashtable<String, Object>();
        compObject.put("name", component.getName());
        compObject.put("typeComponent", component.getClass().getName().substring(component.getClass().getName().lastIndexOf(".") + 1));
        compObject.put("componentRect", StiReportEdit.getComponentRect(component));
        compObject.put("parentName", StiReportEdit.getParentName(component));
        compObject.put("parentIndex", String.valueOf(StiReportEdit.getParentIndex(component)));
        compObject.put("componentIndex", StiReportEdit.getComponentIndex(component).toString());
        compObject.put("childs", StiReportEdit.getAllChildComponents(component));
        compObject.put("svgContent", StiReportEdit.getSvgContent(component, 1.0));
        compObject.put("pageName", component.getPage().getName());
        compObject.put("properties", StiReportEdit.getAllProperties(component));
        return compObject;
    }

    private Hashtable<String, Object> getReportInfo() {
        String[] propNames;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (String propName : propNames = new String[]{"ShowHeaders", "ShowRulers", "ShowOrder", "RunDesignerAfterInsert", "UseLastFormat", "ShowDimensionLines", "GenerateLocalizedName", "AlignToGrid", "ShowGrid", "GridMode", "GridSizeInch", "GridSizeHundredthsOfInch", "GridSizeCentimetres", "GridSizeMillimeters", "GridSizePixels", "QuickInfoType", "QuickInfoOverlay", "AutoSaveInterval", "EnableAutoSaveMode"}) {
            Object value = StiReportEdit.getPropertyValue(propName, this.report.getInfo());
            if (value == null) continue;
            properties.put(StiReportEdit.lowerFirstChar(propName), value);
        }
        return properties;
    }
}

