/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.StiAlignValue;
import com.stimulsoft.base.StiBaseOptions;
import com.stimulsoft.base.StiJsonConverterVersion;
import com.stimulsoft.base.StiValueCollection;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.system.type.StiTypeList;
import com.stimulsoft.base.system.type.StiTypeNullable;
import com.stimulsoft.base.system.type.StiTypeRange;
import com.stimulsoft.base.system.type.StiTypeValue;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.IStiIgnoryStyle;
import com.stimulsoft.report.StiJsonToDataSetConverter;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.codedom.StiCodeDomExpressionHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.enums.StiSystemTextType;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiCalcDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDataParameter;
import com.stimulsoft.report.dictionary.StiDataParametersCollection;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRelationCollection;
import com.stimulsoft.report.dictionary.StiDataRelationsCollection;
import com.stimulsoft.report.dictionary.StiDatabaseInformation;
import com.stimulsoft.report.dictionary.StiDialogInfoItem;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.StiSystemVariablesHelper;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariablesCollection;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.adapters.StiJDBCParameters;
import com.stimulsoft.report.dictionary.adapters.StiJdbcAdapter;
import com.stimulsoft.report.dictionary.adapters.StiMsSqlAdapter;
import com.stimulsoft.report.dictionary.adapters.StiMySqlAdapter;
import com.stimulsoft.report.dictionary.adapters.StiOracleAdapter;
import com.stimulsoft.report.dictionary.adapters.StiPostgreSqlAdapter;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectsCollection;
import com.stimulsoft.report.dictionary.data.DBNull;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiOracleSource;
import com.stimulsoft.report.dictionary.dataSources.StiSqlSource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.databases.StiJDBCDatabase;
import com.stimulsoft.report.dictionary.databases.StiJsonDatabase;
import com.stimulsoft.report.dictionary.databases.StiXmlDatabase;
import com.stimulsoft.report.dictionary.enums.StiDataType;
import com.stimulsoft.report.dictionary.enums.StiDateTimeType;
import com.stimulsoft.report.dictionary.enums.StiItemsInitializationType;
import com.stimulsoft.report.dictionary.enums.StiSelectionMode;
import com.stimulsoft.report.dictionary.enums.StiSqlSourceType;
import com.stimulsoft.report.dictionary.enums.StiTypeMode;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.dictionary.functions.StiFunctions;
import com.stimulsoft.report.engine.engineV1.builders.StiDataBandV1Builder;
import com.stimulsoft.report.json.StiJsonToDataSetConverterV2;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiStyle;
import com.stimulsoft.report.utils.data.StiDataColumnsUtil;
import com.stimulsoft.report.utils.data.StiSqlField;
import com.stimulsoft.report.utils.data.StiTableFieldsRequest;
import com.stimulsoft.report.utils.data.StiXmlTable;
import com.stimulsoft.report.utils.data.StiXmlTableFieldsRequest;
import com.stimulsoft.web.utils.StiConnectionType;
import com.stimulsoft.web.utils.StiConstants;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.enums.StiImagesID;
import com.stimulsoft.webdesigner.helper.StiEncodingHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiViewDataHelper;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StiDictionaryHelper {
    private static final String[] SYSTEM_TYPES = new String[]{"bool", "byte", "byte[]", "char", "datetime", "decimal", "double", "guid", "short", "int", "long", "sbyte", "float", "string", "timespan", "ushort", "uint", "ulong", "image", "bool (Nullable)", "byte (Nullable)", "char (Nullable)", "datetime (Nullable)", "decimal (Nullable)", "double (Nullable)", "guid (Nullable)", "short (Nullable)", "int (Nullable)", "long (Nullable)", "byte (Nullable)", "sbyte (Nullable)", "float (Nullable)", "timespan (Nullable)", "ushort (Nullable)", "uint (Nullable)", "ulong (Nullable)", "object", "refcursor"};

    private static Hashtable<String, Object> databaseItem(String name, String nameInSource, String alias, boolean dataInStore) {
        Hashtable<String, Object> dataBaseItem = new Hashtable<String, Object>();
        dataBaseItem.put("typeItem", "DataBase");
        dataBaseItem.put("typeIcon", dataInStore ? "DataStore" : "ConnectionFail");
        dataBaseItem.put("typeConnection", JSONObject.NULL);
        dataBaseItem.put("name", name);
        dataBaseItem.put("alias", alias);
        dataBaseItem.put("nameInSource", nameInSource);
        dataBaseItem.put("dataInStore", dataInStore);
        dataBaseItem.put("dataSources", new ArrayList());
        return dataBaseItem;
    }

    private static Hashtable<String, Object> databaseItem(StiDatabase database) {
        Hashtable<String, Object> dataBaseItem = StiDictionaryHelper.databaseItem(database.getName(), database.getString(), database.getAlias(), false);
        dataBaseItem.put("typeIcon", "Connection");
        dataBaseItem.put("typeConnection", database.getServiceType().getName().substring(database.getServiceType().getName().lastIndexOf(46) + 1));
        if (database instanceof StiXmlDatabase) {
            dataBaseItem.put("pathData", StiEncodingHelper.encode(((StiXmlDatabase)database).getPathData()));
            dataBaseItem.put("pathSchema", StiEncodingHelper.encode(((StiXmlDatabase)database).getPathSchema()));
            dataBaseItem.put("xmlType", "AdoNetXml");
        } else if (database instanceof StiJsonDatabase) {
            String pathData = ((StiJsonDatabase)database).getPathData();
            if (pathData != null) {
                dataBaseItem.put("pathData", StiEncodingHelper.encode(pathData));
            }
        } else {
            try {
                String connectionString = (String)database.getClass().getMethod("getConnectionString", new Class[0]).invoke((Object)database, new Object[0]);
                dataBaseItem.put("connectionString", connectionString != null ? StiEncodingHelper.encode(connectionString) : "");
                Boolean promptUserNameAndPassword = (Boolean)database.getClass().getMethod("getPromptUserNameAndPassword", new Class[0]).invoke((Object)database, new Object[0]);
                dataBaseItem.put("promptUserNameAndPassword", promptUserNameAndPassword != null ? promptUserNameAndPassword : false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataBaseItem;
    }

    private static Hashtable<String, Object> datasourceItem(StiDataSource datasource) {
        Hashtable<String, Object> datasourceItem;
        block7: {
            Method method;
            block6: {
                String typeIcon = "DataSource";
                if (datasource.getInherited()) {
                    typeIcon = "LockedDataSource";
                }
                datasourceItem = new Hashtable<String, Object>();
                datasourceItem.put("typeItem", "DataSource");
                datasourceItem.put("typeIcon", typeIcon);
                datasourceItem.put("isCloud", false);
                datasourceItem.put("typeDataSource", datasource.getClass().getName().substring(datasource.getClass().getName().lastIndexOf(46) + 1));
                datasourceItem.put("typeDataAdapter", datasource.getClass().getName().substring(datasource.getClass().getName().lastIndexOf(46) + 1));
                datasourceItem.put("name", datasource.getName());
                datasourceItem.put("correctName", StiNameValidator.CorrectName((String)datasource.getName()));
                datasourceItem.put("nameInSource", ((StiDataStoreSource)datasource).getNameInSource());
                datasourceItem.put("alias", datasource.getAlias());
                datasourceItem.put("columns", StiDictionaryHelper.getColumnsTree(datasource.getColumns(), false));
                datasourceItem.put("parameters", StiDictionaryHelper.getParametersTree(datasource.getParameters(), false));
                if (datasource instanceof StiSqlSource) {
                    datasourceItem.put("parameterTypes", StiDictionaryHelper.getDataParameterTypes((StiSqlSource)datasource));
                    datasourceItem.put("reconnectOnEachRow", false);
                    datasourceItem.put("commandTimeout", String.valueOf(((StiSqlSource)datasource).getCommandTimeout()));
                }
                datasourceItem.put("relations", StiDictionaryHelper.getRelationsTree(null, datasource.GetParentRelations(), false, new Hashtable<String, Object>()));
                try {
                    method = datasource.getClass().getMethod("getSqlCommand", new Class[0]);
                    datasourceItem.put("sqlCommand", StiEncodingHelper.encode((String)method.invoke((Object)datasource, new Object[0])));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block6;
                    e.printStackTrace();
                }
            }
            try {
                method = datasource.getClass().getMethod("getType", new Class[0]);
                datasourceItem.put("type", ((StiSqlSourceType)method.invoke((Object)datasource, new Object[0])).toString());
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block7;
                e.printStackTrace();
            }
        }
        return datasourceItem;
    }

    private static Hashtable<String, Object> columnItem(StiDataColumn column) {
        Hashtable<String, Object> columnItem = new Hashtable<String, Object>();
        columnItem.put("typeItem", "Parameters".equals(column.getCaption()) ? "Parameter" : "Column");
        columnItem.put("typeIcon", "Parameters".equals(column.getCaption()) ? "Parameter" : StiDictionaryHelper.getDataColumnImageIdFromType(column.getSystemType(), true).toString());
        columnItem.put("type", StiDictionaryHelper.getTypeValueToString(column.getSystemType()));
        columnItem.put("name", column.getName());
        columnItem.put("correctName", StiNameValidator.CorrectName((String)column.getName()));
        columnItem.put("alias", column.getAlias());
        columnItem.put("nameInSource", column.getNameInSource());
        columnItem.put("isCalcColumn", column instanceof StiCalcDataColumn);
        columnItem.put("expression", column instanceof StiCalcDataColumn ? StiEncodingHelper.encode(((StiCalcDataColumn)column).getExpression()) : "");
        return columnItem;
    }

    private static Hashtable<String, Object> ParameterItem(StiDataParameter parameter) {
        Hashtable<String, Object> parameterItem = new Hashtable<String, Object>();
        parameterItem.put("typeItem", "Parameter");
        parameterItem.put("typeIcon", "Parameter");
        parameterItem.put("type", parameter.getType());
        parameterItem.put("size", parameter.getSize());
        parameterItem.put("name", parameter.getName());
        parameterItem.put("correctName", StiNameValidator.CorrectName((String)parameter.getName()));
        parameterItem.put("expression", StiEncodingHelper.encode(parameter.getExpression()));
        return parameterItem;
    }

    private static Hashtable<String, Object> columnItem2(StiSqlField column) {
        Hashtable<String, Object> columnItem = new Hashtable<String, Object>();
        columnItem.put("typeItem", "Column");
        columnItem.put("typeIcon", StiDictionaryHelper.getIconTypeForColumn(column.getSystemType()).toString());
        columnItem.put("type", StiDictionaryHelper.getTypeValueToString(column.getSystemType()));
        columnItem.put("name", column.getName());
        columnItem.put("correctName", StiNameValidator.CorrectName((String)column.getName()));
        columnItem.put("alias", column.getName());
        columnItem.put("nameInSource", column.getName());
        columnItem.put("isCalcColumn", false);
        columnItem.put("expression", "");
        return columnItem;
    }

    private static Hashtable<String, Object> relationItem(StiDataRelation relation, Hashtable<String, Object> upLevelRelations) {
        Hashtable<String, Object> relationItem = new Hashtable<String, Object>();
        relationItem.put("typeItem", "Relation");
        relationItem.put("typeIcon", relation.getInherited() ? "LockedRelation" : "Relation");
        relationItem.put("name", relation.getName());
        relationItem.put("correctName", StiNameValidator.CorrectName((String)relation.getName()));
        relationItem.put("alias", relation.getAlias());
        relationItem.put("nameInSource", relation.getNameInSource());
        relationItem.put("parentDataSource", relation.getParentSource() != null ? relation.getParentSource().getName() : "");
        relationItem.put("childDataSource", relation.getChildSource() != null ? relation.getChildSource().getName() : "");
        ArrayList<String> jsParentColumns = new ArrayList<String>();
        for (String parentColumns : relation.getParentColumns()) {
            jsParentColumns.add(parentColumns);
        }
        relationItem.put("parentColumns", jsParentColumns);
        ArrayList<String> jsChildColumns = new ArrayList<String>();
        for (String childColumns : relation.getChildColumns()) {
            jsChildColumns.add(childColumns);
        }
        relationItem.put("childColumns", jsChildColumns);
        upLevelRelations.put(relation.getName(), true);
        relationItem.put("relations", relation.getParentSource() != null ? StiDictionaryHelper.getRelationsTree(relation, relation.getParentSource().GetParentRelations(), false, upLevelRelations) : new ArrayList());
        return relationItem;
    }

    private static Hashtable<String, Object> businessObjectItem(StiBusinessObject businessObject) {
        Hashtable<String, Object> businessObjectItem = new Hashtable<String, Object>();
        businessObjectItem.put("typeItem", "BusinessObject");
        businessObjectItem.put("typeIcon", "BusinessObject");
        businessObjectItem.put("category", businessObject.getCategory());
        businessObjectItem.put("name", businessObject.getName());
        businessObjectItem.put("correctName", StiNameValidator.CorrectName((String)businessObject.getName()));
        businessObjectItem.put("alias", businessObject.getAlias());
        businessObjectItem.put("columns", StiDictionaryHelper.getColumnsTree(businessObject.getColumns()));
        businessObjectItem.put("businessObjects", StiDictionaryHelper.getChildBusinessObjectsTree(businessObject));
        businessObjectItem.put("fullName", businessObject.GetFullName());
        return businessObjectItem;
    }

    private static Hashtable<String, Object> variableItem(StiVariable variable) {
        Hashtable<String, Object> variableItem = new Hashtable<String, Object>();
        variableItem.put("typeItem", "Variable");
        variableItem.put("typeIcon", StiDictionaryHelper.getDataColumnImageIdFromType(variable.getSystemType(), !variable.getInherited()).toString());
        variableItem.put("basicType", StiDictionaryHelper.getVariableBasicType(variable));
        variableItem.put("type", StiDictionaryHelper.getVariableType(variable));
        variableItem.put("name", variable.getName());
        variableItem.put("correctName", StiNameValidator.CorrectName((String)variable.getName()));
        variableItem.put("alias", variable.getAlias());
        variableItem.put("category", variable.getCategory());
        variableItem.put("description", StiEncodingHelper.encode(variable.getDescription()));
        variableItem.put("initBy", variable.getInitBy());
        variableItem.put("readOnly", variable.getReadOnly());
        variableItem.put("allowUseAsSqlParameter", variable.isAllowUseAsSqlParameter());
        variableItem.put("requestFromUser", variable.getRequestFromUser());
        variableItem.put("allowUserValues", variable.getDialogInfo().getAllowUserValues());
        variableItem.put("dateTimeFormat", variable.getDialogInfo().getDateTimeType());
        variableItem.put("dataSource", variable.getDialogInfo().getItemsInitializationType());
        variableItem.put("selection", variable.getSelection().toString());
        variableItem.put("formatMask", StiEncodingHelper.encode(variable.getDialogInfo().getMask()));
        variableItem.put("items", StiDictionaryHelper.getItems(variable, (String)variableItem.get("type")));
        variableItem.put("keys", variable.getDialogInfo().getKeysColumn());
        variableItem.put("values", variable.getDialogInfo().getValuesColumn());
        if ("Value".equals(variableItem.get("basicType")) || "NullableValue".equals(variableItem.get("basicType"))) {
            if (variable.getInitBy() == StiVariableInitBy.Value) {
                String valueString;
                String string = valueString = variable.getValue() != null ? variable.getValue() : "";
                if (variable.getValueObject() != null && "datetime".equals(variableItem.get("type"))) {
                    valueString = ((StiDateTime)variable.getValueObject()).format("MM/dd/yyyy hh:mm:ss a");
                }
                variableItem.put("value", StiEncodingHelper.encode(valueString));
            } else {
                variableItem.put("expression", StiEncodingHelper.encode(variable.getValue()));
            }
        } else if ("Range".equals(variableItem.get("basicType"))) {
            if (variable.getInitBy() == StiVariableInitBy.Value) {
                Object fromObject = ((Range)variable.getValueObject()).getFromObject();
                Object toObject = ((Range)variable.getValueObject()).getToObject();
                String fromObjectString = "";
                String toObjectString = "";
                if (fromObject != null) {
                    String string = fromObjectString = "datetime".equals(variableItem.get("type")) ? ((StiDateTime)fromObject).formatEnDateTime() : fromObject.toString();
                }
                if (toObject != null) {
                    toObjectString = "datetime".equals(variableItem.get("type")) ? ((StiDateTime)toObject).formatEnDateTime() : toObject.toString();
                }
                variableItem.put("valueFrom", StiEncodingHelper.encode(fromObjectString));
                variableItem.put("valueTo", StiEncodingHelper.encode(toObjectString));
            } else {
                variableItem.put("expressionFrom", StiEncodingHelper.encode(variable.getInitByExpressionFrom()));
                variableItem.put("expressionTo", StiEncodingHelper.encode(variable.getInitByExpressionTo()));
            }
        }
        return variableItem;
    }

    private static Hashtable<String, Object> tableItem(DataTable table) {
        Hashtable<String, Object> tableItem = new Hashtable<String, Object>();
        tableItem.put("typeItem", "Table");
        tableItem.put("name", table.getTableName());
        tableItem.put("correctName", StiNameValidator.CorrectName((String)table.getTableName()));
        tableItem.put("columns", StiDictionaryHelper.getColumnsTree2(table.getColumns()));
        return tableItem;
    }

    private static Hashtable<String, Object> functionItem(StiFunction function, StiReport report) {
        Hashtable<String, Object> functionItem = new Hashtable<String, Object>();
        functionItem.put("typeItem", "Function");
        functionItem.put("typeIcon", "Function");
        functionItem.put("name", function.getFunctionName());
        functionItem.put("caption", function.getFunctionString(report.getScriptLanguage()));
        functionItem.put("description", function.getDescription());
        functionItem.put("returnDescription", function.getReturnDescription());
        functionItem.put("text", String.format("%s(%s)", function.getFunctionName(), function.getArgumentNames() == null || function.getArgumentNames().length == 0 ? "" : StiDictionaryHelper.repeatString(",", function.getArgumentNames().length - 1)));
        return functionItem;
    }

    private static String repeatString(String st, int length) {
        String result = "";
        for (int i = 0; i < length; ++i) {
            result = result + st;
        }
        return result;
    }

    private static Hashtable<String, Object> functionsCategoryItem(String name, String typeIcon) {
        Hashtable<String, Object> categoryItem = new Hashtable<String, Object>();
        categoryItem.put("typeItem", "FunctionsCategory");
        categoryItem.put("typeIcon", typeIcon);
        categoryItem.put("name", name);
        categoryItem.put("items", new ArrayList());
        return categoryItem;
    }

    private static ArrayList<Hashtable<String, Object>> getDataParameterTypes(StiSqlSource source) {
        ArrayList<Hashtable<String, Object>> types = new ArrayList<Hashtable<String, Object>>();
        int i = 0;
        for (String type : SYSTEM_TYPES) {
            Hashtable<String, Object> typeObject = new Hashtable<String, Object>();
            typeObject.put("typeValue", i++);
            typeObject.put("typeName", type);
            types.add(typeObject);
        }
        if (source instanceof StiOracleSource) {
            Hashtable<String, Object> typeObject = new Hashtable<String, Object>();
            typeObject.put("typeValue", i++);
            typeObject.put("typeName", "RefCursor");
            types.add(typeObject);
        }
        return types;
    }

    private static String getItemType(StiDialogInfoItem itemVariable) {
        if (itemVariable instanceof StiDialogInfoItem.StiExpressionDialogInfoItem || itemVariable instanceof StiDialogInfoItem.StiExpressionRangeDialogInfoItem) {
            return "expression";
        }
        return "value";
    }

    private static Object getItemKeyObject(Object itemKey, String type, String itemType) {
        String keyObject = null;
        if (itemKey != null) {
            keyObject = StiEncodingHelper.encode("datetime".equalsIgnoreCase(type) && "value".equalsIgnoreCase(itemType) ? ((StiDateTime)itemKey).formatEnDateTime() : itemKey.toString());
        }
        return keyObject;
    }

    private static Object getItems(StiVariable variable, String type) {
        ArrayList items = new ArrayList();
        int index = 0;
        if (variable.getDialogInfo().getKeys() != null && variable.getDialogInfo().getKeys().size() != 0) {
            List itemsVariable = variable.getDialogInfo().getDialogInfoItems(variable.getType());
            for (StiDialogInfoItem itemVariable : itemsVariable) {
                Hashtable<String, Object> item = new Hashtable<String, Object>();
                String itemType = StiDictionaryHelper.getItemType(itemVariable);
                item.put("type", itemType);
                item.put("value", StiEncodingHelper.encode(itemVariable.getValue()) != null ? StiEncodingHelper.encode(itemVariable.getValue()) : JSONObject.NULL);
                item.put("key", StiDictionaryHelper.getItemKeyObject(itemVariable.getKey(), type, itemType) != null ? StiDictionaryHelper.getItemKeyObject(itemVariable.getKey(), type, itemType) : JSONObject.NULL);
                item.put("keyTo", StiDictionaryHelper.getItemKeyObject(itemVariable.getTo(), type, itemType) != null ? StiDictionaryHelper.getItemKeyObject(itemVariable.getTo(), type, itemType) : JSONObject.NULL);
                items.add(item);
                ++index;
            }
        }
        return index != 0 ? items : JSONObject.NULL;
    }

    private static StiDatabase createDataBaseByTypeName(String typeDatabase, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException {
        for (Class<? extends StiDatabase> class_ : options.getConnectionTypes()) {
            if (!typeDatabase.equals(class_.getName().substring(class_.getName().lastIndexOf(46) + 1)) && !typeDatabase.equals(class_.getName())) continue;
            return class_.newInstance();
        }
        return null;
    }

    private static StiDataSource createDataAdapterByTypeName(String typeDataAdapter, StiWebDesignerOptions options, StiDictionary dictionary, String nameInSource) throws InstantiationException, IllegalAccessException {
        if (("StiDataTableSource".equals(typeDataAdapter = typeDataAdapter.replace("AdapterService", "Source")) || "StiSqlSource".equals(typeDataAdapter)) && dictionary != null && nameInSource != null) {
            if (nameInSource.indexOf(46) >= 0) {
                nameInSource = nameInSource.substring(0, nameInSource.indexOf(46));
            }
            for (StiDatabase source : dictionary.getDatabases()) {
                if (!source.getName().equals(nameInSource)) continue;
                typeDataAdapter = source.getClass().getName();
                typeDataAdapter = typeDataAdapter.substring(typeDataAdapter.lastIndexOf(46) + 1).replace("Database", "") + "Source";
            }
        }
        for (Class<? extends StiDataSource> class_ : options.getDataSources()) {
            if (!typeDataAdapter.equals(class_.getName().substring(class_.getName().lastIndexOf(46) + 1))) continue;
            return class_.newInstance();
        }
        return null;
    }

    private static void copyProperties(String[] propertyNames, JSONObject fromObject, Hashtable<String, Object> toObject) throws JSONException {
        for (String propName : propertyNames) {
            if (!fromObject.has(propName)) continue;
            toObject.put(propName, fromObject.getString(propName));
        }
    }

    private static void copyProperties(String[] propertyNames, Hashtable<String, Object> fromObject, Hashtable<String, Object> toObject) throws JSONException {
        for (String propName : propertyNames) {
            toObject.put(propName, fromObject.get(propName) != null ? fromObject.get(propName) : JSONObject.NULL);
        }
    }

    private static StiDataColumnsCollection getColumnsByTypeAndNameOfObject(StiReport report, Object prps) throws JSONException {
        Hashtable props = prps instanceof Hashtable ? (Hashtable)prps : StiJSONHelper.jsonToHash((JSONObject)((JSONObject)prps));
        String currentParentType = (String)props.get("currentParentType");
        StiDataSource resultObject = null;
        if ("DataSource".equals(currentParentType) && (resultObject = report.getDictionary().getDataSources().get((String)props.get("currentParentName"))) != null) {
            return resultObject.getColumns();
        }
        if ("BusinessObject".equals(currentParentType)) {
            resultObject = StiDictionaryHelper.getBusinessObjectByFullName(report, props.get("currentParentName"));
            return ((StiBusinessObject)resultObject).getColumns();
        }
        return null;
    }

    private static Hashtable<String, Object> getDatabaseByName(String name, ArrayList<Hashtable<String, Object>> databasesTree) {
        for (Hashtable<String, Object> database : databasesTree) {
            if (!((String)database.get("name")).toLowerCase().equals(name.toLowerCase())) continue;
            return database;
        }
        return null;
    }

    private static void updateColumns(StiDataColumnsCollection columns, JSONArray columnsSource) throws JSONException {
        columns.clear();
        for (int i = 0; i < columnsSource.length(); ++i) {
            JSONObject columnProps = columnsSource.getJSONObject(i);
            Object column = columnProps.getBoolean("isCalcColumn") ? new StiCalcDataColumn() : new StiDataColumn();
            columns.add(column);
            StiDictionaryHelper.applyColumnProps((StiDataColumn)column, columnProps);
        }
    }

    private static void updateParameters(StiDataParametersCollection parameters, JSONArray parametersSource) throws JSONException {
        parameters.clear();
        for (int i = 0; i < parametersSource.length(); ++i) {
            JSONObject parametersProps = parametersSource.getJSONObject(i);
            StiDataParameter parameter = new StiDataParameter();
            parameters.add((Object)parameter);
            StiDictionaryHelper.applyParameterProps(parameter, parametersProps);
        }
    }

    private static String getVariableBasicType(StiVariable variable) {
        if (variable.getSystemType().isNullable()) {
            return "NullableValue";
        }
        if (variable.getSystemType().isList()) {
            return "List";
        }
        if (variable.getSystemType().isRange()) {
            return "Range";
        }
        return "Value";
    }

    private static String getVariableType(StiVariable variable) {
        if (variable.getType() == StiSystemTypeEnum.SystemString) {
            return "String";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemChar) {
            return "char";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemBoolean) {
            return "bool";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDateTime) {
            return "datetime";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemTimeSpan) {
            return "timespan";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemGuid) {
            return "guid";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDrawingImage) {
            return "image";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemFloat) {
            return "float";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDouble) {
            return "double";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDecimal) {
            return "decimal";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt32) {
            return "int";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt32) {
            return "uint";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt16) {
            return "short";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt16) {
            return "ushort";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt64) {
            return "long";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt64) {
            return "ulong";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemByte) {
            return "byte";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemSByte) {
            return "sbyte";
        }
        return "Object";
    }

    private static Object getValueByType(String StringValue, String typeVariable, String basicType, boolean canReturnNull) {
        String decimalSeparator = ".";
        if ("String".equalsIgnoreCase(typeVariable)) {
            return StringValue;
        }
        if ("".equalsIgnoreCase(StringValue) && "NullableValue".equalsIgnoreCase(basicType) && canReturnNull) {
            return null;
        }
        if ("float".equalsIgnoreCase(typeVariable)) {
            float value;
            block43: {
                value = 0.0f;
                try {
                    value = Float.parseFloat(StringValue.replace(".", ",").replace(",", decimalSeparator));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block43;
                    e.printStackTrace();
                }
            }
            return Float.valueOf(value);
        }
        if ("double".equalsIgnoreCase(typeVariable)) {
            double value;
            block44: {
                value = 0.0;
                try {
                    value = Double.parseDouble(StringValue.replace(".", ",").replace(",", decimalSeparator));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block44;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("decimal".equalsIgnoreCase(typeVariable)) {
            double value;
            block45: {
                value = 0.0;
                try {
                    value = Double.parseDouble(StringValue.replace(".", ",").replace(",", decimalSeparator));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block45;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("int".equalsIgnoreCase(typeVariable) || "uint".equalsIgnoreCase(typeVariable)) {
            int value;
            block46: {
                value = 0;
                try {
                    value = Integer.parseInt(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block46;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("short".equalsIgnoreCase(typeVariable) || "ushort".equalsIgnoreCase(typeVariable)) {
            short value;
            block47: {
                value = 0;
                try {
                    value = Short.parseShort(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block47;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("long".equalsIgnoreCase(typeVariable) || "ulong".equalsIgnoreCase(typeVariable)) {
            long value;
            block48: {
                value = 0L;
                try {
                    value = Long.parseLong(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block48;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("byte".equalsIgnoreCase(typeVariable) || "sbyte".equalsIgnoreCase(typeVariable)) {
            byte value;
            block49: {
                value = 0;
                try {
                    value = Byte.parseByte(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block49;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("char".equalsIgnoreCase(typeVariable)) {
            char value;
            block50: {
                value = ' ';
                try {
                    value = StringValue.charAt(0);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block50;
                    e.printStackTrace();
                }
            }
            return Character.valueOf(value);
        }
        if ("bool".equalsIgnoreCase(typeVariable)) {
            boolean value;
            block51: {
                value = false;
                try {
                    value = Boolean.parseBoolean(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block51;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("datetime".equalsIgnoreCase(typeVariable)) {
            StiDateTime value;
            block52: {
                if ("".equalsIgnoreCase(StringValue) && canReturnNull) {
                    return null;
                }
                value = StiDateTime.currentDate();
                try {
                    value = StiDateTime.fromString((String)StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block52;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("timespan".equalsIgnoreCase(typeVariable)) {
            StiTimeSpan value;
            block53: {
                if ("".equalsIgnoreCase(StringValue) && canReturnNull) {
                    return null;
                }
                value = StiTimeSpan.ZERO;
                try {
                    value = StiTimeSpan.valueOf((String)StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block53;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("guid".equalsIgnoreCase(typeVariable)) {
            StiGuid variableGuid;
            block54: {
                if ("".equalsIgnoreCase(StringValue) && "NullableValue".equalsIgnoreCase(basicType) && canReturnNull) {
                    return null;
                }
                variableGuid = StiGuid.EMPTY;
                try {
                    variableGuid = new StiGuid(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block54;
                    e.printStackTrace();
                }
            }
            return variableGuid;
        }
        if ("Object".equalsIgnoreCase(typeVariable)) {
            if ("".equalsIgnoreCase(StringValue) && canReturnNull) {
                return null;
            }
            return StringValue;
        }
        return null;
    }

    private static void setDialogInfoItems(StiVariable variable, Object itemsObject, String type, String basicType) throws JSONException {
        if (itemsObject == null) {
            variable.getDialogInfo().setKeys(new ArrayList());
            variable.getDialogInfo().setValues(new ArrayList());
            return;
        }
        JSONArray items = itemsObject != JSONObject.NULL ? (JSONArray)itemsObject : new JSONArray();
        String[] keys = new String[items.length()];
        String[] values = new String[items.length()];
        for (int index = 0; index < items.length(); ++index) {
            Object keyObject;
            JSONObject item;
            block8: {
                item = items.getJSONObject(index);
                keyObject = null;
                String itemType = (String)item.get("type");
                String key = item.get("key") != null ? StiEncodingHelper.decodeString(item.getString("key")) : "";
                String keyTo = item.get("keyTo") != null ? StiEncodingHelper.decodeString(item.getString("keyTo")) : "";
                try {
                    if ("expression".equals(itemType)) {
                        keyObject = !"Range".equals(basicType) ? String.format("{{%s}}", key) : String.format("{{%s<<|>>%s}}", key, keyTo);
                    } else if (!"Range".equals(basicType)) {
                        Object obj;
                        keyObject = !"datetime".equals(type) ? ((obj = StiDictionaryHelper.getValueByType(key, type, basicType, false)) != null ? obj.toString() : "") : key;
                    } else {
                        Range range = (Range)Class.forName("com.stimulsoft.base.range." + variable.getSystemType().getSerializeValue().replace("System.", "") + "Range").newInstance();
                        range.setFromObject(StiDictionaryHelper.getValueByType(key, type, basicType, false));
                        range.setToObject(StiDictionaryHelper.getValueByType(keyTo, type, basicType, false));
                        keyObject = String.format("%s,%s,%s", variable.getSystemType().getSerializeValue().replace("System.", ""), range.getFromObject(), range.getToObject());
                    }
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block8;
                    e.printStackTrace();
                }
            }
            keys[index] = keyObject == null ? "" : keyObject.toString();
            values[index] = StiEncodingHelper.decodeString((String)item.get("value"));
        }
        variable.getDialogInfo().setKeys(Arrays.asList(keys));
        variable.getDialogInfo().setValues(Arrays.asList(values));
    }

    public static StiBusinessObject getBusinessObjectByFullName(StiReport report, Object fullName) {
        StiBusinessObjectsCollection businessObjectsCollection = report.getDictionary().getBusinessObjects();
        StiBusinessObject businessObject = null;
        if (fullName != null && ((ArrayList)fullName).size() != 0) {
            ArrayList fullNameArray = (ArrayList)fullName;
            for (int i = fullNameArray.size() - 1; i >= 0; --i) {
                businessObject = businessObjectsCollection.getItem((String)fullNameArray.get(i));
                if (businessObject == null) {
                    return null;
                }
                businessObjectsCollection = businessObject.getBusinessObjects();
            }
        }
        return businessObject;
    }

    private static Hashtable<String, Object> getAjaxDataFromDatabaseInformation(StiDatabaseInformation information) {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        List[] collections = new List[]{information.getTables(), information.getViews(), information.getStoredProcedures()};
        String[] types = new String[]{"Table", "View", "StoredProcedure"};
        for (int i = 0; i < collections.length; ++i) {
            ArrayList<Hashtable<String, Object>> tables = new ArrayList<Hashtable<String, Object>>();
            for (DataTable table : collections[i]) {
                Hashtable<String, Object> item = StiDictionaryHelper.tableItem(table);
                item.put("typeItem", types[i]);
                tables.add(item);
            }
            if (tables.size() <= 0) continue;
            data.put(types[i] + "s", tables);
        }
        return data;
    }

    private static StiDatabaseInformation convertAjaxDatabaseInfoToDatabaseInfo(JSONArray data, boolean allInfo) throws JSONException {
        StiDatabaseInformation information = new StiDatabaseInformation();
        for (int i = 0; i < data.length(); ++i) {
            JSONObject tableObject = data.getJSONObject(i);
            DataTable dataTable = new DataTable(tableObject.getString("name"), new StiDataColumnsCollection());
            JSONArray columns = allInfo ? tableObject.getJSONArray("allColumns") : tableObject.getJSONArray("columns");
            for (int j = 0; j < columns.length(); ++j) {
                JSONObject columnObject = columns.getJSONObject(j);
                StiDataColumn dataColumn = new StiDataColumn(columnObject.getString("name"), columnObject.getString("name"), StiDictionaryHelper.getTypeFromString(columnObject.getString("type"), "value"));
                dataTable.getColumns().add((Object)dataColumn);
                if (!"StoredProcedure".equals(tableObject.getString("typeItem"))) continue;
                dataColumn.setCaption("Parameter".equals(columnObject.getString("typeItem")) ? "Parameters" : "Columns");
            }
            if (tableObject.has("query")) {
                // empty if block
            }
            if ("Table".equals(tableObject.getString("typeItem"))) {
                information.getTables().add(dataTable);
                Collections.sort(information.getTables(), new StiSortDataTableComparer());
            } else if ("View".equals(tableObject.getString("typeItem"))) {
                information.getViews().add(dataTable);
                Collections.sort(information.getViews(), new StiSortDataTableComparer());
            }
            if (!"StoredProcedure".equals(tableObject.getString("typeItem"))) continue;
            information.getStoredProcedures().add(dataTable);
            Collections.sort(information.getStoredProcedures(), new StiSortDataTableComparer());
        }
        return information;
    }

    private static void applyDataSourceProps(StiDataSource dataSource, JSONObject dataSourceProps) throws JSONException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String[] props;
        for (String propName : props = new String[]{"name", "nameInSource", "alias", "sqlCommand", "type", "reconnectOnEachRow", "commandTimeout"}) {
            Method property;
            block3: {
                String propNameUpper = propName.substring(0, 1).toUpperCase() + propName.substring(1);
                property = null;
                try {
                    Class[] classArray = new Class[1];
                    classArray[0] = !"type".equals(propName) ? (!"commandTimeout".equals(propName) ? String.class : Integer.TYPE) : StiSqlSourceType.class;
                    property = dataSource.getClass().getMethod("set" + propNameUpper, classArray);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block3;
                    e.printStackTrace();
                }
            }
            if (property == null || !dataSourceProps.has(propName)) continue;
            Object p = "type".equals(propName) ? StiSqlSourceType.valueOf((String)dataSourceProps.getString(propName)) : ("sqlCommand".equals(propName) ? StiEncodingHelper.decodeString(dataSourceProps.getString(propName)) : ("reconnectOnEachRow".equals(propName) ? Boolean.valueOf(dataSourceProps.getBoolean(propName)) : ("commandTimeout".equals(propName) ? Integer.valueOf(StiReportEdit.strToInt(dataSourceProps.getString(propName))) : dataSourceProps.getString(propName))));
            property.invoke((Object)dataSource, p);
        }
    }

    private static void applyDataSourceProps2(StiDataSource dataSource, Hashtable dataSourceProps) throws JSONException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String[] props;
        for (String propName : props = new String[]{"name", "alias", "nameInSource", "sqlCommand", "type", "reconnectOnEachRow", "commandTimeout"}) {
            Method property;
            block3: {
                String propNameUpper = propName.substring(0, 1).toUpperCase() + propName.substring(1);
                property = null;
                try {
                    property = dataSource.getClass().getMethod("set" + propNameUpper, !"Type".equals(propName) ? String.class : StiSqlSourceType.class);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block3;
                    e.printStackTrace();
                }
            }
            if (property == null || !dataSourceProps.containsKey(propName)) continue;
            Object p = "type".equals(propName) ? StiSqlSourceType.valueOf((String)((String)dataSourceProps.get(propName))) : ("sqlCommand".equals(propName) ? StiEncodingHelper.decodeString((String)dataSourceProps.get(propName)) : ("reconnectOnEachRow".equals(propName) ? (Comparable<Boolean>)Boolean.valueOf(Boolean.parseBoolean(dataSourceProps.get(propName).toString())) : (Comparable<Boolean>)("commandTimeout".equals(propName) ? Integer.valueOf(StiReportEdit.strToInt(dataSourceProps.get(propName).toString())) : dataSourceProps.get(propName))));
            property.invoke((Object)dataSource, p);
        }
    }

    private static String fixName(StiDatabase database, StiDictionary dictionary, String name) {
        Boolean res = true;
        while (res.booleanValue()) {
            res = false;
            for (StiDatabase db : dictionary.getDatabases()) {
                if (db == database || !db.getName().equals(name)) continue;
                res = true;
                name = name + "_";
            }
        }
        return name;
    }

    private static void applyConnectionProps(StiDatabase database, JSONObject connectionProps, StiDictionary dictionary) {
        String[] props;
        for (String propName : props = new String[]{"name", "alias", "connectionString", "pathData", "pathSchema", "promptUserNameAndPassword"}) {
            String propNameUpper = propName.substring(0, 1).toUpperCase() + propName.substring(1);
            try {
                Method method = database.getClass().getMethod("set" + propNameUpper, !propName.equals("promptUserNameAndPassword") ? String.class : Boolean.class);
                if (method == null || !connectionProps.has(propName)) continue;
                Object p = null;
                if ("connectionString".equals(propName) || "pathData".equals(propName) || "pathSchema".equals(propName)) {
                    p = StiEncodingHelper.decodeString(connectionProps.getString(propName));
                } else if ("promptUserNameAndPassword".equals(propName) || "firstRowIsHeader".equals(propName)) {
                    p = connectionProps.getBoolean(propName);
                } else if (!"embeddedData".equals(propName)) {
                    p = connectionProps.getString(propName);
                }
                if ("name".equals(propName)) {
                    p = StiDictionaryHelper.fixName(database, dictionary, (String)p);
                }
                method.invoke((Object)database, p);
            }
            catch (NoSuchMethodException e) {
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static void applyColumnProps(StiDataColumn column, JSONObject columnProps) throws JSONException {
        column.setAlias(columnProps.getString("alias"));
        column.setName(columnProps.getString("name"));
        column.setNameInSource(columnProps.getString("nameInSource"));
        if (columnProps.getBoolean("isCalcColumn")) {
            ((StiCalcDataColumn)column).setValue(StiEncodingHelper.decodeString(columnProps.getString("expression")));
        }
        column.setSystemType(StiDictionaryHelper.getTypeFromString(columnProps.getString("type"), "value"));
    }

    private static void applyColumnProps(StiDataColumn column, Hashtable<String, Object> columnProps) {
        column.setAlias((String)columnProps.get("alias"));
        column.setName((String)columnProps.get("name"));
        column.setNameInSource((String)columnProps.get("nameInSource"));
        if (((Boolean)columnProps.get("isCalcColumn")).booleanValue()) {
            ((StiCalcDataColumn)column).setExpression((String)columnProps.get("expression"));
        }
        column.setSystemType(StiDictionaryHelper.getTypeFromString((String)columnProps.get("type"), "value"));
    }

    private static void applyParameterProps(StiDataParameter parameter, JSONObject parameterProps) throws JSONException {
        parameter.setName(parameterProps.getString("name"));
        parameter.setType(StiReportEdit.strToInt(parameterProps.getString("type")));
        parameter.setSize(StiReportEdit.strToInt(parameterProps.getString("size")));
        parameter.setExpression(StiEncodingHelper.decodeString(parameterProps.getString("expression")));
    }

    private static ArrayList<String> toSringList(JSONArray array) throws JSONException {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            result.add(array.getString(i));
        }
        return result;
    }

    private static void applyRelationProps(StiReport report, StiDataRelation relation, JSONObject relationProps) throws JSONException {
        relation.setAlias(relationProps.getString("alias"));
        relation.setName(relationProps.getString("name"));
        relation.setNameInSource(relationProps.getString("nameInSource"));
        relation.setParentSource(report.getDictionary().getDataSources().get((String)relationProps.get("parentDataSource")));
        relation.setChildSource(report.getDictionary().getDataSources().get((String)relationProps.get("childDataSource")));
        relation.setChildColumns(StiDictionaryHelper.toSringList((JSONArray)relationProps.get("childColumns")));
        relation.setParentColumns(StiDictionaryHelper.toSringList((JSONArray)relationProps.get("parentColumns")));
    }

    private static void applyBusinessObjectProps(StiBusinessObject businessObject, Hashtable<String, Object> businessObjectProps) {
        businessObject.setAlias((String)businessObjectProps.get("alias"));
        businessObject.setName((String)businessObjectProps.get("name"));
        businessObject.setCategory((String)businessObjectProps.get("category"));
    }

    private static void applyVariableProps(StiReport report, StiVariable variable, JSONObject variableProps) throws JSONException {
        String type = variableProps.getString("type");
        String basicType = variableProps.getString("basicType");
        StiTypeMode typeMode = StiValidationUtil.isEmpty((String)variableProps.getString("basicType")) ? StiTypeMode.Value : StiTypeMode.valueOf((String)variableProps.getString("basicType"));
        StiSystemType variableType = StiDictionaryHelper.getTypeFromString(variableProps.getString("type").toLowerCase(), basicType);
        variable.setSystemType(variableType);
        variable.setAlias(variableProps.getString("alias"));
        variable.setName((String)variableProps.get("name"));
        variable.setDescription(StiEncodingHelper.decodeString((String)variableProps.get("description")));
        variable.setCategory((String)variableProps.get("category"));
        if (variableProps.has("initBy")) {
            variable.setInitBy(StiVariableInitBy.valueOf((String)((String)variableProps.get("initBy"))));
        }
        variable.setReadOnly(variableProps.getBoolean("readOnly"));
        variable.setRequestFromUser(variableProps.getBoolean("requestFromUser"));
        variable.setAllowUseAsSqlParameter(variableProps.getBoolean("allowUseAsSqlParameter"));
        variable.getDialogInfo().setAllowUserValues(variableProps.getBoolean("allowUserValues"));
        variable.getDialogInfo().setDateTimeType(StiDateTimeType.valueOf((String)((String)variableProps.get("dateTimeFormat"))));
        variable.getDialogInfo().setItemsInitializationType(StiItemsInitializationType.valueOf((String)((String)variableProps.get("dataSource"))));
        variable.getDialogInfo().setMask(StiEncodingHelper.decodeString((String)variableProps.get("formatMask")));
        variable.getDialogInfo().setKeysColumn(variableProps.getString("keys"));
        variable.getDialogInfo().setValuesColumn(variableProps.getString("values"));
        variable.setSelection(StiSelectionMode.valueOf((String)variableProps.getString("selection")));
        if (typeMode == StiTypeMode.Value || typeMode == StiTypeMode.NullableValue) {
            if (variable.getInitBy() == StiVariableInitBy.Value && variableProps.get("value") != null) {
                variable.setValueObject(StiDictionaryHelper.getValueByType(StiEncodingHelper.decodeString((String)variableProps.get("value")), type, basicType, true));
            }
            if (variable.getInitBy() == StiVariableInitBy.Expression && variableProps.get("expression") != null) {
                variable.setValueObject((Object)StiEncodingHelper.decodeString((String)variableProps.get("expression")));
            }
        } else if (typeMode == StiTypeMode.Range) {
            block15: {
                if (variable.getInitBy() == StiVariableInitBy.Value) {
                    try {
                        Range range = (Range)Class.forName("com.stimulsoft.base.range." + ((StiTypeRange)variableType).getEnumType().toString().replace("System", "") + "Range").newInstance();
                        if (variableProps.has("valueFrom")) {
                            range.setFromObject(StiDictionaryHelper.getValueByType(StiEncodingHelper.decodeString(variableProps.getString("valueFrom")), type, basicType, true));
                        }
                        if (variableProps.has("valueTo")) {
                            range.setToObject(StiDictionaryHelper.getValueByType(StiEncodingHelper.decodeString(variableProps.getString("valueTo")), type, basicType, true));
                        }
                        variable.setValueObject((Object)range);
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) break block15;
                        e.printStackTrace();
                    }
                }
            }
            if (variable.getInitBy() == StiVariableInitBy.Expression) {
                if (variableProps.get("expressionFrom") != null) {
                    variable.setInitByExpressionFrom(StiEncodingHelper.decodeString((String)variableProps.get("expressionFrom")));
                }
                if (variableProps.get("expressionTo") != null) {
                    variable.setInitByExpressionTo(StiEncodingHelper.decodeString((String)variableProps.get("expressionTo")));
                }
            }
        }
        if (variable.getDialogInfo().getItemsInitializationType() == StiItemsInitializationType.Columns) {
            variableProps.put("items", JSONObject.NULL);
        }
        StiDictionaryHelper.setDialogInfoItems(variable, variableProps.get("items"), type, basicType);
    }

    public static StiImagesID getIconTypeForColumn(StiSystemType type) {
        return StiDictionaryHelper.getDataColumnImageIdFromType(type, true);
    }

    public static StiImagesID getLockedCalcImageIDFromType(StiSystemType systemType, boolean inherited) {
        StiSystemTypeEnum type;
        StiSystemTypeEnum stiSystemTypeEnum = type = systemType != null ? systemType.getEnumType() : null;
        if (type == StiSystemTypeEnum.SystemBoolean) {
            return inherited ? StiImagesID.LockedCalcColumnBool : StiImagesID.CalcColumnBool;
        }
        if (type == StiSystemTypeEnum.SystemChar) {
            return inherited ? StiImagesID.LockedCalcColumnChar : StiImagesID.CalcColumnChar;
        }
        if (type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemTimeSpan) {
            return inherited ? StiImagesID.LockedCalcColumnDateTime : StiImagesID.CalcColumnDateTime;
        }
        if (type == StiSystemTypeEnum.SystemDecimal) {
            return inherited ? StiImagesID.LockedCalcColumnDecimal : StiImagesID.CalcColumnDecimal;
        }
        if (type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemSByte || type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32) {
            return inherited ? StiImagesID.LockedCalcColumnInt : StiImagesID.CalcColumnInt;
        }
        if (type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble) {
            return inherited ? StiImagesID.LockedCalcColumnFloat : StiImagesID.CalcColumnFloat;
        }
        if (type == StiSystemTypeEnum.SystemDrawingImage) {
            return inherited ? StiImagesID.LockedCalcColumnImage : StiImagesID.CalcColumnImage;
        }
        if (type != null && systemType.isList()) {
            return inherited ? StiImagesID.LockedCalcColumnBinary : StiImagesID.CalcColumnBinary;
        }
        return inherited ? StiImagesID.LockedCalcColumnString : StiImagesID.CalcColumnString;
    }

    private static StiImagesID getDataColumnImageIdFromType(StiSystemType systemType, boolean isDataColumn) {
        StiSystemTypeEnum type;
        StiSystemTypeEnum stiSystemTypeEnum = type = systemType != null ? systemType.getEnumType() : null;
        if (type == StiSystemTypeEnum.SystemBoolean) {
            return isDataColumn ? StiImagesID.DataColumnBool : StiImagesID.LockedDataColumnBool;
        }
        if (type == StiSystemTypeEnum.SystemChar) {
            return isDataColumn ? StiImagesID.DataColumnChar : StiImagesID.LockedDataColumnChar;
        }
        if (type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemTimeSpan) {
            return isDataColumn ? StiImagesID.DataColumnDateTime : StiImagesID.LockedDataColumnDateTime;
        }
        if (type == StiSystemTypeEnum.SystemDecimal) {
            return isDataColumn ? StiImagesID.DataColumnDecimal : StiImagesID.LockedDataColumnDecimal;
        }
        if (type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemSByte || type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16) {
            return isDataColumn ? StiImagesID.DataColumnInt : StiImagesID.LockedDataColumnInt;
        }
        if (type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble) {
            return isDataColumn ? StiImagesID.DataColumnFloat : StiImagesID.LockedDataColumnFloat;
        }
        if (type == StiSystemTypeEnum.SystemDrawingImage || type == StiSystemTypeEnum.SystemDrawingBitmap) {
            return isDataColumn ? StiImagesID.DataColumnImage : StiImagesID.LockedDataColumnImage;
        }
        if (type == StiSystemTypeEnum.SystemChar && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeChar : StiImagesID.LockedVariableRangeChar;
        }
        if ((type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemTimeSpan) && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeDateTime : StiImagesID.LockedVariableRangeDateTime;
        }
        if (type == StiSystemTypeEnum.SystemDecimal && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeDecimal : StiImagesID.LockedVariableRangeDecimal;
        }
        if ((type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16 || type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemSByte) && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeInt : StiImagesID.LockedVariableRangeInt;
        }
        if ((type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble) && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeFloat : StiImagesID.LockedVariableRangeFloat;
        }
        if ((type == StiSystemTypeEnum.SystemString || type == StiSystemTypeEnum.SystemGuid) && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeString : StiImagesID.LockedVariableRangeString;
        }
        if (type == StiSystemTypeEnum.SystemBoolean && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListBool : StiImagesID.LockedVariableListBool;
        }
        if ((type == StiSystemTypeEnum.SystemString || type == StiSystemTypeEnum.SystemGuid) && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListString : StiImagesID.LockedVariableListString;
        }
        if (type == StiSystemTypeEnum.SystemChar && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListChar : StiImagesID.LockedVariableListChar;
        }
        if ((type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemTimeSpan) && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListDateTime : StiImagesID.LockedVariableListDateTime;
        }
        if (type == StiSystemTypeEnum.SystemDecimal && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListDecimal : StiImagesID.LockedVariableListDecimal;
        }
        if ((type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16 || type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemSByte) && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListInt : StiImagesID.LockedVariableListInt;
        }
        if ((type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble) && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListFloat : StiImagesID.LockedVariableListFloat;
        }
        if (type != null && systemType.isList()) {
            return isDataColumn ? StiImagesID.DataColumnBinary : StiImagesID.LockedDataColumnBinary;
        }
        return isDataColumn ? StiImagesID.DataColumnString : StiImagesID.LockedDataColumnString;
    }

    private static String getTypeValueToString(StiSystemType stype) {
        String nType;
        StiSystemTypeEnum type = stype.getEnumType();
        String string = nType = stype.isNullable() ? " (Nullable)" : "";
        if (type == null) {
            return "null";
        }
        if (type == StiSystemTypeEnum.SystemBoolean) {
            return "bool" + nType;
        }
        if (type == StiSystemTypeEnum.SystemByte) {
            return "byte" + nType;
        }
        if (type == StiSystemTypeEnum.SystemByteArray) {
            return "byte[]";
        }
        if (type == StiSystemTypeEnum.SystemChar) {
            return "char" + nType;
        }
        if (type == StiSystemTypeEnum.SystemDateTime) {
            return "datetime" + nType;
        }
        if (type == StiSystemTypeEnum.SystemDecimal) {
            return "decimal" + nType;
        }
        if (type == StiSystemTypeEnum.SystemDouble) {
            return "double" + nType;
        }
        if (type == StiSystemTypeEnum.SystemGuid) {
            return "guid" + nType;
        }
        if (type == StiSystemTypeEnum.SystemInt16) {
            return "short" + nType;
        }
        if (type == StiSystemTypeEnum.SystemInt32) {
            return "int" + nType;
        }
        if (type == StiSystemTypeEnum.SystemInt64) {
            return "long" + nType;
        }
        if (type == StiSystemTypeEnum.SystemSByte) {
            return "sbyte" + nType;
        }
        if (type == StiSystemTypeEnum.SystemFloat) {
            return "float" + nType;
        }
        if (type == StiSystemTypeEnum.SystemString) {
            return "string" + nType;
        }
        if (type == StiSystemTypeEnum.SystemTimeSpan) {
            return "timespan" + nType;
        }
        if (type == StiSystemTypeEnum.SystemUInt16) {
            return "ushort" + nType;
        }
        if (type == StiSystemTypeEnum.SystemUInt32) {
            return "uint" + nType;
        }
        if (type == StiSystemTypeEnum.SystemUInt64) {
            return "ulong" + nType;
        }
        if (type == StiSystemTypeEnum.SystemDrawingImage) {
            return "image";
        }
        if (type == StiSystemTypeEnum.RefCursor) {
            return "RefCursor";
        }
        if (type == StiSystemTypeEnum.SystemObject) {
            return "object";
        }
        return "object";
    }

    private static StiSystemType getTypeFromString(String type, String basicType) {
        StiSystemTypeEnum result = StiSystemTypeEnum.SystemObject;
        if (type.equalsIgnoreCase("null")) {
            result = null;
        }
        if (type.equalsIgnoreCase("bool")) {
            result = StiSystemTypeEnum.SystemBoolean;
        }
        if (type.equalsIgnoreCase("byte")) {
            result = StiSystemTypeEnum.SystemByte;
        }
        if (type.equalsIgnoreCase("byte[]")) {
            result = StiSystemTypeEnum.SystemByteArray;
        }
        if (type.equalsIgnoreCase("char")) {
            result = StiSystemTypeEnum.SystemChar;
        }
        if (type.equalsIgnoreCase("datetime")) {
            result = StiSystemTypeEnum.SystemDateTime;
        }
        if (type.equalsIgnoreCase("decimal")) {
            result = StiSystemTypeEnum.SystemDecimal;
        }
        if (type.equalsIgnoreCase("double")) {
            result = StiSystemTypeEnum.SystemDouble;
        }
        if (type.equalsIgnoreCase("guid")) {
            result = StiSystemTypeEnum.SystemGuid;
        }
        if (type.equalsIgnoreCase("short")) {
            result = StiSystemTypeEnum.SystemInt16;
        }
        if (type.equalsIgnoreCase("int")) {
            result = StiSystemTypeEnum.SystemInt32;
        }
        if (type.equalsIgnoreCase("long")) {
            result = StiSystemTypeEnum.SystemInt64;
        }
        if (type.equalsIgnoreCase("sbyte")) {
            result = StiSystemTypeEnum.SystemSByte;
        }
        if (type.equalsIgnoreCase("float")) {
            result = StiSystemTypeEnum.SystemFloat;
        }
        if (type.equalsIgnoreCase("String")) {
            result = StiSystemTypeEnum.SystemString;
        }
        if (type.equalsIgnoreCase("timespan")) {
            result = StiSystemTypeEnum.SystemTimeSpan;
        }
        if (type.equalsIgnoreCase("ushort")) {
            result = StiSystemTypeEnum.SystemUInt16;
        }
        if (type.equalsIgnoreCase("uint")) {
            result = StiSystemTypeEnum.SystemUInt32;
        }
        if (type.equalsIgnoreCase("ulong")) {
            result = StiSystemTypeEnum.SystemUInt64;
        }
        if (type.equalsIgnoreCase("image")) {
            result = StiSystemTypeEnum.SystemDrawingImage;
        }
        if (type.equalsIgnoreCase("refcursor")) {
            result = StiSystemTypeEnum.RefCursor;
        }
        if (type.equalsIgnoreCase("bool (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemBoolean;
        }
        if (type.equalsIgnoreCase("byte (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemByte;
        }
        if (type.equalsIgnoreCase("char (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemChar;
        }
        if (type.equalsIgnoreCase("datetime (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemDateTime;
        }
        if (type.equalsIgnoreCase("decimal (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemDecimal;
        }
        if (type.equalsIgnoreCase("double (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemDouble;
        }
        if (type.equalsIgnoreCase("guid (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemGuid;
        }
        if (type.equalsIgnoreCase("short (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemInt16;
        }
        if (type.equalsIgnoreCase("int (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemInt32;
        }
        if (type.equalsIgnoreCase("long (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemInt64;
        }
        if (type.equalsIgnoreCase("sbyte (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemByte;
        }
        if (type.equalsIgnoreCase("float (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemFloat;
        }
        if (type.equalsIgnoreCase("timespan (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemTimeSpan;
        }
        if (type.equalsIgnoreCase("ushort (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemUInt16;
        }
        if (type.equalsIgnoreCase("uint (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemUInt32;
        }
        if (type.equalsIgnoreCase("ulong (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemUInt64;
        }
        if (type.equalsIgnoreCase("Object")) {
            result = StiSystemTypeEnum.SystemObject;
        }
        if ("list".equalsIgnoreCase(basicType)) {
            StiTypeList result2 = new StiTypeList(result.getSystemType());
            switch (result.getSystemType().getEnumType()) {
                case SystemString: {
                    result2.setSerializeValue("Stimulsoft.Report.StringList");
                    break;
                }
                case SystemSingle: {
                    result2.setSerializeValue("Stimulsoft.Report.FloatList");
                    break;
                }
                case SystemDouble: {
                    result2.setSerializeValue("Stimulsoft.Report.DoubleList");
                    break;
                }
                case SystemDecimal: {
                    result2.setSerializeValue("Stimulsoft.Report.DecimalLis");
                    break;
                }
                case SystemDateTime: {
                    result2.setSerializeValue("Stimulsoft.Report.DateTimeList");
                    break;
                }
                case SystemTimeSpan: {
                    result2.setSerializeValue("Stimulsoft.Report.TimeSpanList");
                    break;
                }
                case SystemByte: {
                    result2.setSerializeValue("Stimulsoft.Report.ByteList");
                    break;
                }
                case SystemInt16: {
                    result2.setSerializeValue("Stimulsoft.Report.ShortList");
                    break;
                }
                case SystemInt32: {
                    result2.setSerializeValue("Stimulsoft.Report.IntList");
                    break;
                }
                case SystemInt64: {
                    result2.setSerializeValue("Stimulsoft.Report.LongList");
                    break;
                }
                case SystemBoolean: {
                    result2.setSerializeValue("Stimulsoft.Report.BoolList");
                    break;
                }
                case SystemChar: {
                    result2.setSerializeValue("Stimulsoft.Report.CharList");
                    break;
                }
                case SystemGuid: {
                    result2.setSerializeValue("Stimulsoft.Report.GuidList");
                    break;
                }
            }
            return result2;
        }
        if ("range".equalsIgnoreCase(basicType)) {
            StiTypeRange result2 = new StiTypeRange((StiTypeValue)result.getSystemType());
            switch (result.getSystemType().getEnumType()) {
                case SystemString: {
                    result2.setSerializeValue("Stimulsoft.Report.StringRange");
                    break;
                }
                case SystemSingle: {
                    result2.setSerializeValue("Stimulsoft.Report.FloatRange");
                    break;
                }
                case SystemDouble: {
                    result2.setSerializeValue("Stimulsoft.Report.DoubleRange");
                    break;
                }
                case SystemDecimal: {
                    result2.setSerializeValue("Stimulsoft.Report.DecimalLis");
                    break;
                }
                case SystemDateTime: {
                    result2.setSerializeValue("Stimulsoft.Report.DateTimeRange");
                    break;
                }
                case SystemTimeSpan: {
                    result2.setSerializeValue("Stimulsoft.Report.TimeSpanRange");
                    break;
                }
                case SystemByte: {
                    result2.setSerializeValue("Stimulsoft.Report.ByteRange");
                    break;
                }
                case SystemInt16: {
                    result2.setSerializeValue("Stimulsoft.Report.ShortRange");
                    break;
                }
                case SystemInt32: {
                    result2.setSerializeValue("Stimulsoft.Report.IntRange");
                    break;
                }
                case SystemInt64: {
                    result2.setSerializeValue("Stimulsoft.Report.LongRange");
                    break;
                }
                case SystemBoolean: {
                    result2.setSerializeValue("Stimulsoft.Report.BoolRange");
                    break;
                }
                case SystemChar: {
                    result2.setSerializeValue("Stimulsoft.Report.CharRange");
                    break;
                }
                case SystemGuid: {
                    result2.setSerializeValue("Stimulsoft.Report.GuidRange");
                    break;
                }
            }
            return result2;
        }
        if ("NullableValue".equals(basicType)) {
            return new StiTypeNullable(result.getSystemType());
        }
        return result.getSystemType();
    }

    public static Hashtable<String, Object> getDictionaryTree(StiReport report) {
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        dictionary.put("databases", StiDictionaryHelper.getDataBasesTree(report));
        dictionary.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
        dictionary.put("variables", StiDictionaryHelper.getVariablesTree(report));
        dictionary.put("systemVariables", StiDictionaryHelper.getSystemVariablesTree(report));
        dictionary.put("functions", StiDictionaryHelper.getFunctionsTree(report));
        return dictionary;
    }

    public static ArrayList<Hashtable<String, Object>> getFunctionsTree(StiReport report) {
        String[] categories;
        StiDictionary dictionary = report.getDictionary();
        ArrayList<Hashtable<String, Object>> functionsTree = new ArrayList<Hashtable<String, Object>>();
        Hashtable hash = StiFunctions.getFunctionsGrouppedInCategories();
        for (String category : categories = hash.keySet().toArray(new String[0])) {
            Hashtable<String, Object> categoryItem = StiDictionaryHelper.functionsCategoryItem(category, "Folder");
            functionsTree.add(categoryItem);
            List list = (List)hash.get(category);
            Hashtable<String, String> hashFunctions = new Hashtable<String, String>();
            for (StiFunction function : list) {
                hashFunctions.put(function.getGroupFunctionName(), function.getGroupFunctionName());
            }
            Object[] functions = hashFunctions.keySet().toArray(new String[0]);
            Arrays.sort(functions);
            for (Object function : functions) {
                Object[] funcs = StiFunctions.getFunctions((StiReport)dictionary.getReport(), (String)function, (boolean)false);
                Arrays.sort(funcs);
                Hashtable<String, Object> parentNode = categoryItem;
                if (funcs.length > 1) {
                    parentNode = StiDictionaryHelper.functionsCategoryItem((String)function, "Function");
                    ArrayList items = (ArrayList)categoryItem.get("items");
                    items.add(parentNode);
                }
                for (Object func : funcs) {
                    Hashtable<String, Object> functionItem = StiDictionaryHelper.functionItem((StiFunction)func, report);
                    ArrayList items = (ArrayList)parentNode.get("items");
                    items.add(functionItem);
                }
            }
        }
        return functionsTree;
    }

    public static ArrayList<String> getSystemVariablesTree(StiReport report) {
        ArrayList<String> systemVariables = new ArrayList<String>();
        systemVariables.addAll(Arrays.asList(StiSystemVariablesHelper.getSystemVariables((StiReport)report)));
        return systemVariables;
    }

    private static ArrayList<Hashtable<String, Object>> getDataBasesTree(StiReport report) {
        StiDictionary dictionary = report.getDictionary();
        ArrayList<Hashtable<String, Object>> databasesTree = new ArrayList<Hashtable<String, Object>>();
        for (StiDatabase database : dictionary.getDatabases()) {
            if (!dictionary.getRestrictions().isAllowShow(database.getName(), StiDataType.Database)) continue;
            databasesTree.add(StiDictionaryHelper.databaseItem(database));
        }
        for (StiDataSource dataSource : dictionary.getDataSources()) {
            if (!dictionary.getRestrictions().isAllowShow(dataSource.getName(), StiDataType.DataSource)) continue;
            String category = dataSource.GetCategoryName();
            Hashtable<String, Object> databaseItem = StiDictionaryHelper.getDatabaseByName(category, databasesTree);
            if (databaseItem == null) {
                databaseItem = StiDictionaryHelper.databaseItem(category, category, category, false);
                databaseItem.put("isCloud", false);
                databasesTree.add(databaseItem);
            }
            ((ArrayList)databaseItem.get("dataSources")).add(StiDictionaryHelper.datasourceItem(dataSource));
        }
        return databasesTree;
    }

    private static Hashtable<String, Object> getObjectsTreeByCategories(StiReport report, StiValueCollection<?> collectionObjects) {
        StiDictionary dictionary = report.getDictionary();
        Hashtable<String, Object> objectsTree = new Hashtable<String, Object>();
        objectsTree.put("MainCategory", new ArrayList());
        objectsTree.put("Categories", new Hashtable());
        boolean isVariablesCollection = collectionObjects instanceof StiVariablesCollection;
        StiVariable variable = null;
        StiBusinessObject businessObject = null;
        for (Object object_ : collectionObjects) {
            ArrayList objects;
            String category;
            if (isVariablesCollection) {
                variable = (StiVariable)object_;
            } else {
                businessObject = (StiBusinessObject)object_;
            }
            String name = isVariablesCollection ? variable.getName() : businessObject.getName();
            String string = category = isVariablesCollection ? variable.getCategory() : businessObject.getCategory();
            if (!dictionary.getRestrictions().isAllowShow(name, StiDataType.Variable)) continue;
            if (StiValidationUtil.isEmpty((String)category)) {
                objects = (ArrayList)objectsTree.get("MainCategory");
            } else {
                Hashtable categories = (Hashtable)objectsTree.get("Categories");
                if (categories.get(category) == null) {
                    objects = new ArrayList();
                    categories.put(category, objects);
                } else {
                    objects = (ArrayList)categories.get(category);
                }
            }
            if (!isVariablesCollection) {
                objects.add(StiDictionaryHelper.businessObjectItem(businessObject));
                continue;
            }
            if (variable.getName().length() <= 0) continue;
            objects.add(StiDictionaryHelper.variableItem(variable));
        }
        return objectsTree;
    }

    private static Hashtable<String, Object> getBusinessObjectsTree(StiReport report) {
        return new Hashtable<String, Object>();
    }

    private static ArrayList<StiBusinessObject> getChildBusinessObjectsTree(StiBusinessObject businessObject) {
        ArrayList<StiBusinessObject> businessObjets = new ArrayList<StiBusinessObject>();
        if (businessObject.getBusinessObjects() != null) {
            for (StiBusinessObject childBusinessObject : businessObject.getBusinessObjects()) {
                businessObjets.add(childBusinessObject);
            }
        }
        return businessObjets;
    }

    private static Hashtable<String, Object> getVariablesTree(StiReport report) {
        return StiDictionaryHelper.getObjectsTreeByCategories(report, report.getDictionary().getVariables());
    }

    private static ArrayList<Hashtable<String, Object>> getColumnsTree2(StiDataColumnsCollection columnsCollection) {
        ArrayList<Hashtable<String, Object>> columns = new ArrayList<Hashtable<String, Object>>();
        for (StiDataColumn column : columnsCollection) {
            Hashtable<String, Object> columnItem = new Hashtable<String, Object>();
            columnItem.put("typeItem", "Parameters".equals(column.getCaption()) ? "Parameter" : "Column");
            columnItem.put("typeIcon", StiDictionaryHelper.getDataColumnImageIdFromType(column.getSystemType(), true).toString());
            columnItem.put("type", StiDictionaryHelper.getTypeValueToString(column.getSystemType()));
            columnItem.put("name", column.getName());
            columnItem.put("correctName", StiNameValidator.CorrectName((String)column.getName()));
            columnItem.put("nameInSource", column.getName());
            columnItem.put("alias", column.getName());
            columnItem.put("isCalcColumn", false);
            columnItem.put("expression", "");
            columns.add(columnItem);
        }
        return columns;
    }

    private static ArrayList<Hashtable<String, Object>> getColumnsTree(StiDataColumnsCollection columnsCollection, boolean isCloud) {
        ArrayList<Hashtable<String, Object>> columns = new ArrayList<Hashtable<String, Object>>();
        for (StiDataColumn column : columnsCollection) {
            Hashtable<String, Object> columnObject = StiDictionaryHelper.columnItem(column);
            columnObject.put("isCloud", isCloud);
            columns.add(columnObject);
        }
        return columns;
    }

    private static ArrayList<Hashtable<String, Object>> getColumnsTree(StiDataColumnsCollection columnsCollection) {
        ArrayList<Hashtable<String, Object>> columns = new ArrayList<Hashtable<String, Object>>();
        for (StiDataColumn column : columnsCollection) {
            columns.add(StiDictionaryHelper.columnItem(column));
        }
        return columns;
    }

    private static ArrayList<Hashtable<String, Object>> getColumnsTree2(List<StiSqlField> fields) {
        ArrayList<Hashtable<String, Object>> columns = new ArrayList<Hashtable<String, Object>>();
        for (StiSqlField column : fields) {
            columns.add(StiDictionaryHelper.columnItem2(column));
        }
        return columns;
    }

    private static ArrayList<Hashtable<String, Object>> getParametersTree(StiDataParametersCollection parametersCollection, boolean isCloud) {
        ArrayList<Hashtable<String, Object>> parameters = new ArrayList<Hashtable<String, Object>>();
        for (StiDataParameter parameter : parametersCollection) {
            Hashtable<String, Object> parameterObject = StiDictionaryHelper.ParameterItem(parameter);
            parameterObject.put("isCloud", isCloud);
            parameters.add(parameterObject);
        }
        return parameters;
    }

    private static ArrayList<Hashtable<String, Object>> GetRelationsTree(StiDataRelation parentRelation, StiDataRelationsCollection relations, boolean isCloud, Hashtable<String, Object> upLevelRelations) {
        ArrayList<Hashtable<String, Object>> relationsTree = new ArrayList<Hashtable<String, Object>>();
        for (StiDataRelation relation : relations) {
            if (parentRelation == relation) continue;
            if (upLevelRelations.containsKey(relation.getName())) {
                return new ArrayList<Hashtable<String, Object>>();
            }
            Hashtable<String, Object> relationObject = StiDictionaryHelper.relationItem(relation, upLevelRelations);
            relationObject.put("isCloud", isCloud);
            relationsTree.add(relationObject);
        }
        return relationsTree;
    }

    private static ArrayList<Hashtable<String, Object>> getRelationsTree(StiDataRelation parentRelation, StiDataRelationsCollection relations, boolean isCloud, Hashtable<String, Object> upLevelRelations) {
        ArrayList<Hashtable<String, Object>> relationsTree = new ArrayList<Hashtable<String, Object>>();
        for (StiDataRelation relation : relations) {
            if (parentRelation == relation) continue;
            if (upLevelRelations.containsKey(relation.getName())) {
                return new ArrayList<Hashtable<String, Object>>();
            }
            Hashtable<String, Object> relationObject = StiDictionaryHelper.relationItem(relation, upLevelRelations);
            relationObject.put("isCloud", isCloud);
            relationsTree.add(relationObject);
        }
        return relationsTree;
    }

    private static ArrayList<Hashtable<String, Object>> getRelationsTree(StiDataRelationCollection relationsCollection) {
        ArrayList<Hashtable<String, Object>> relations = new ArrayList<Hashtable<String, Object>>();
        for (StiDataRelation relation : relationsCollection) {
            Hashtable<String, Object> relationItem = new Hashtable<String, Object>();
            relationItem.put("typeItem", "Relation");
            relationItem.put("typeIcon", "Relation");
            ArrayList<String> jsParentColumns = new ArrayList<String>();
            for (String parentColumn : relation.getParentColumns()) {
                jsParentColumns.add(parentColumn);
            }
            relationItem.put("parentColumns", jsParentColumns);
            ArrayList<String> jsChildColumns = new ArrayList<String>();
            for (String childColumn : relation.getChildColumns()) {
                jsChildColumns.add(childColumn);
            }
            relationItem.put("childColumns", jsChildColumns);
            relations.add(relationItem);
        }
        return relations;
    }

    public static void getConnectionTypes(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException {
        ArrayList connectionTypes = new ArrayList();
        Hashtable connections = new Hashtable();
        ArrayList<StiDatabase> listCreatedConnection = new ArrayList<StiDatabase>();
        for (StiDatabase database : report.getDictionary().getDatabases()) {
            if (!report.getDictionary().getRestrictions().isAllowShow(database.getName(), StiDataType.Database)) continue;
            listCreatedConnection.add(database);
        }
        if (listCreatedConnection.size() > 0) {
            ArrayList reportConnections = new ArrayList();
            connections.put("ReportConnections", reportConnections);
            Collections.sort(listCreatedConnection, new Comparator<StiDatabase>(){

                @Override
                public int compare(StiDatabase o1, StiDatabase o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (StiDatabase database : listCreatedConnection) {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("name", database.getName());
                properties.put("type", database.getServiceType().getName().substring(database.getServiceType().getName().lastIndexOf(46) + 1));
                reportConnections.add(properties);
            }
        }
        ArrayList sqlConnections = new ArrayList();
        ArrayList fileConnections = new ArrayList();
        for (Class<? extends StiDatabase> class_ : options.getConnectionTypes()) {
            StiDatabase db = class_.newInstance();
            String name = class_.getName().substring(class_.getName().lastIndexOf(46) + 1);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("name", db.getServiceName());
            properties.put("type", class_.getName().substring(class_.getName().lastIndexOf(46) + 1));
            if (name.indexOf("Xml") >= 0 || name.indexOf("Json") >= 0) {
                fileConnections.add(properties);
                continue;
            }
            sqlConnections.add(properties);
        }
        connections.put("SQL", sqlConnections);
        connections.put("Files", fileConnections);
        callbackResult.put("connections", connections);
    }

    public static void getDataAdapterTypes(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult, StiWebDesignerOptions options) {
        ArrayList<String> dataAdapterTypes = new ArrayList<String>();
        for (Class<? extends StiDataSource> class_ : options.getDataSources()) {
            dataAdapterTypes.add(class_.getName().substring(class_.getName().lastIndexOf(46) + 1));
        }
        ArrayList connections = new ArrayList();
        for (StiDatabase database : report.getDictionary().getDatabases()) {
            if (!report.getDictionary().getRestrictions().isAllowShow(database.getName(), StiDataType.Database)) continue;
            Hashtable<String, String> connection = new Hashtable<String, String>();
            connection.put("name", database.getName());
            connection.put("fullName", database.getName() + " [" + database.getClass().getName().substring(database.getClass().getName().lastIndexOf(46) + 1) + "]");
            connections.add(connection);
        }
        callbackResult.put("dataAdapterTypes", dataAdapterTypes);
        callbackResult.put("connections", connections);
    }

    public static void createOrEditConnection(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult, StiWebDesignerOptions options) throws JSONException, InstantiationException, IllegalAccessException {
        JSONObject connectionProps = (JSONObject)param.get("connectionFormResult");
        StiDatabase database = null;
        if ("Edit".equals(connectionProps.getString("mode"))) {
            database = report.getDictionary().getDatabases().get((String)connectionProps.get("oldName"));
        } else {
            String typeConnection = (String)connectionProps.get("typeConnection");
            database = StiDictionaryHelper.createDataBaseByTypeName(typeConnection, options);
            if (database != null) {
                report.getDictionary().getDatabases().add((Object)database);
            }
        }
        if (database != null) {
            StiDictionaryHelper.applyConnectionProps(database, connectionProps, report.getDictionary());
            callbackResult.put("itemObject", StiDictionaryHelper.databaseItem(database));
        }
        callbackResult.put("mode", connectionProps.get("mode"));
        callbackResult.put("skipSchemaWizard", connectionProps.has("skipSchemaWizard") ? connectionProps.get("skipSchemaWizard") : JSONObject.NULL);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteConnection(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        JSONObject dataSourceNames;
        boolean canDelete;
        StiDatabase database = report.getDictionary().getDatabases().get((String)param.get("connectionName"));
        boolean bl = canDelete = database != null && report.getDictionary().getDatabases().contains((Object)database);
        if (canDelete) {
            report.getDictionary().getDatabases().remove((Object)database);
        }
        if (JSONObject.getNames((JSONObject)(dataSourceNames = (JSONObject)param.get("dataSourceNames"))) != null) {
            for (String key : JSONObject.getNames((JSONObject)dataSourceNames)) {
                StiDataSource dataSource = report.getDictionary().getDataSources().get(dataSourceNames.getString(key));
                if (dataSource == null) continue;
                report.getDictionary().getDataSources().remove((Object)dataSource);
            }
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void createOrEditRelation(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        JSONObject relationProps = (JSONObject)param.get("relationFormResult");
        StiDataRelation relation = null;
        if ("Edit".equals(relationProps.getString("mode"))) {
            relation = report.getDictionary().getRelations().get((String)relationProps.get("oldNameInSource"));
        } else {
            relation = new StiDataRelation();
            report.getDictionary().getRelations().add(relation);
        }
        if (relation != null) {
            StiDictionaryHelper.applyRelationProps(report, relation, relationProps);
            callbackResult.put("itemObject", StiDictionaryHelper.relationItem(relation, new Hashtable<String, Object>()));
        }
        StiDictionaryHelper.copyProperties(new String[]{"mode", "oldNameInSource", "changedChildDataSource"}, relationProps, callbackResult);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteRelation(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        boolean canDelete;
        StiDataRelation relation = report.getDictionary().getRelations().get((String)param.get("relationNameInSource"));
        boolean bl = canDelete = relation != null && report.getDictionary().getRelations().contains((Object)relation);
        if (canDelete) {
            report.getDictionary().getRelations().remove((Object)relation);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void createOrEditColumn(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        JSONObject columnProps = (JSONObject)param.get("columnFormResult");
        Object column = null;
        StiDataColumnsCollection columns = StiDictionaryHelper.getColumnsByTypeAndNameOfObject(report, columnProps);
        if (columns != null) {
            if ("Edit".equals(columnProps.get("mode"))) {
                column = columns.get((String)columnProps.get("oldName"));
            } else {
                column = (Boolean)columnProps.get("isCalcColumn") != false ? new StiCalcDataColumn() : new StiDataColumn();
                columns.add(column);
            }
        }
        if (column != null) {
            StiDictionaryHelper.applyColumnProps(column, (JSONObject)param.get("columnFormResult"));
            callbackResult.put("itemObject", StiDictionaryHelper.columnItem(column));
        }
        StiDictionaryHelper.copyProperties(new String[]{"currentParentType", "currentParentName", "mode"}, (JSONObject)param.get("columnFormResult"), callbackResult);
        if ("DataSource".equals(columnProps.get("currentParentType"))) {
            callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
        } else {
            callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
        }
    }

    public static void createOrEditParameter(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        JSONObject parameterProps = (JSONObject)param.get("parameterFormResult");
        StiDataSource dataSource = report.getDictionary().getDataSources().get((String)parameterProps.get("currentParentName"));
        if (dataSource != null) {
            StiDataParameter parameter = null;
            StiDataParametersCollection parameters = dataSource.getParameters();
            if ("Edit".equals(parameterProps.get("mode"))) {
                parameter = parameters.getByName((String)parameterProps.get("oldName"));
            } else {
                parameter = new StiDataParameter();
                parameters.add((Object)parameter);
            }
            if (parameter != null) {
                StiDictionaryHelper.applyParameterProps(parameter, parameterProps);
                callbackResult.put("itemObject", StiDictionaryHelper.ParameterItem(parameter));
            }
        }
        StiDictionaryHelper.copyProperties(new String[]{"currentParentName", "mode"}, parameterProps, callbackResult);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteParameter(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        block5: {
            try {
                StiDataSource dataSource = report.getDictionary().getDataSources().get((String)param.get("currentParentName"));
                if (dataSource != null) {
                    StiDataParametersCollection parameters = dataSource.getParameters();
                    StiDataParameter parameter = null;
                    boolean canDelete = false;
                    if (parameters != null) {
                        parameter = parameters.getByName((String)param.get("parameterName"));
                        boolean bl = canDelete = parameter != null && !parameter.getInherited() && parameters.contains((Object)parameter);
                        if (canDelete) {
                            parameters.remove((Object)parameter);
                        }
                    }
                    callbackResult.put("deleteResult", canDelete);
                    StiDictionaryHelper.copyProperties(new String[]{"currentParentName", "mode"}, param, callbackResult);
                }
            }
            catch (Exception e) {
                callbackResult.put("error", e.getMessage());
                if (StiOptions.Engine.logLevel < 10) break block5;
                e.printStackTrace();
            }
        }
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteColumn(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        StiDataColumnsCollection columns = StiDictionaryHelper.getColumnsByTypeAndNameOfObject(report, new JSONObject(param));
        StiDataColumn column = null;
        boolean canDelete = false;
        if (columns != null) {
            column = columns.get((String)param.get("columnName"));
            boolean bl = canDelete = column != null && !column.getInherited() && columns.contains((Object)column);
            if (canDelete) {
                columns.remove((Object)column);
            }
        }
        callbackResult.put("deleteResult", canDelete);
        StiDictionaryHelper.copyProperties(new String[]{"currentParentType", "currentParentName", "mode"}, param, callbackResult);
        if ("DataSource".equals(param.get("currentParentType"))) {
            callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
        } else {
            callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
        }
    }

    public static void createOrEditDataSource(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException, StiException, JSONException, IllegalArgumentException, InvocationTargetException {
        JSONObject dataSourceProps = (JSONObject)param.get("dataSourceFormResult");
        StiDataSource dataSource = null;
        if ("Edit".equals(dataSourceProps.getString("mode"))) {
            dataSource = report.getDictionary().getDataSources().get(dataSourceProps.getString("oldName"));
        } else {
            dataSource = StiDictionaryHelper.createDataAdapterByTypeName(dataSourceProps.getString("typeDataAdapter"), options, report.getDictionary(), dataSourceProps.getString("nameInSource"));
            if (dataSource != null) {
                report.getDictionary().getDataSources().add((Object)dataSource);
                dataSource.setDictionary(report.getDictionary());
            }
        }
        if (dataSource != null) {
            StiDictionaryHelper.applyDataSourceProps(dataSource, dataSourceProps);
            StiDictionaryHelper.updateColumns(dataSource.getColumns(), (JSONArray)dataSourceProps.get("columns"));
            StiDictionaryHelper.updateParameters(dataSource.getParameters(), (JSONArray)dataSourceProps.get("parameters"));
            callbackResult.put("itemObject", StiDictionaryHelper.datasourceItem(dataSource));
        }
        callbackResult.put("mode", dataSourceProps.get("mode"));
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteDataSource(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        boolean canDelete;
        StiDataSource dataSource = report.getDictionary().getDataSources().get((String)param.get("dataSourceName"));
        boolean bl = canDelete = dataSource != null && report.getDictionary().getDataSources().contains((Object)dataSource);
        if (canDelete) {
            report.getDictionary().getDataSources().remove((Object)dataSource);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void createOrEditBusinessObject(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        Hashtable businessObjectProps = (Hashtable)param.get("businessObjectFormResult");
        StiBusinessObject businessObject = null;
        if ("Edit".equals(businessObjectProps.get("mode"))) {
            businessObject = StiDictionaryHelper.getBusinessObjectByFullName(report, businessObjectProps.get("businessObjectFullName"));
        } else {
            businessObject = new StiBusinessObject();
            StiBusinessObject parentBusinessObject = StiDictionaryHelper.getBusinessObjectByFullName(report, businessObjectProps.get("businessObjectFullName"));
            StiBusinessObjectsCollection businessObjectsCollection = parentBusinessObject != null ? parentBusinessObject.getBusinessObjects() : report.getDictionary().getBusinessObjects();
            businessObjectsCollection.add((Object)businessObject);
            if (parentBusinessObject != null) {
                callbackResult.put("parentBusinessObjectFullName", businessObjectProps.get("businessObjectFullName"));
            }
        }
        if (businessObject != null) {
            StiDictionaryHelper.applyBusinessObjectProps(businessObject, businessObjectProps);
            StiDictionaryHelper.updateColumns(businessObject.getColumns(), (JSONArray)businessObjectProps.get("columns"));
            callbackResult.put("itemObject", businessObject);
        }
        callbackResult.put("mode", businessObjectProps.get("mode"));
        callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
    }

    public static void deleteBusinessObject(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        boolean canDelete;
        StiBusinessObject businessObject = StiDictionaryHelper.getBusinessObjectByFullName(report, param.get("businessObjectFullName"));
        boolean bl = canDelete = businessObject != null;
        if (canDelete) {
            StiBusinessObjectsCollection businessObjectsCollection = businessObject.getParentBusinessObject() != null ? businessObject.getParentBusinessObject().getBusinessObjects() : report.getDictionary().getBusinessObjects();
            businessObjectsCollection.remove((Object)businessObject);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
    }

    public static void createOrEditVariable(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        JSONObject variableProps = (JSONObject)param.get("variableFormResult");
        StiVariable variable = null;
        if ("Edit".equals(variableProps.getString("mode"))) {
            variable = report.getDictionary().getVariables().get(variableProps.getString("oldName"));
        } else {
            variable = new StiVariable();
            report.getDictionary().getVariables().add(variable);
        }
        if (variable != null) {
            StiDictionaryHelper.applyVariableProps(report, variable, variableProps);
            callbackResult.put("itemObject", StiDictionaryHelper.variableItem(variable));
        }
        StiDictionaryHelper.copyProperties(new String[]{"mode", "oldName"}, variableProps, callbackResult);
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void deleteVariable(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        boolean canDelete;
        StiVariable variable = report.getDictionary().getVariables().get((String)param.get("variableName"));
        boolean bl = canDelete = variable != null && report.getDictionary().getVariables().contains((Object)variable);
        if (canDelete) {
            report.getDictionary().getVariables().remove((Object)variable);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void deleteVariablesCategory(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        report.getDictionary().getVariables().removeCategory((String)param.get("categoryName"));
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void editVariablesCategory(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        Hashtable categoryProps = (Hashtable)param.get("categoryFormResult");
        String oldCategoryName = (String)categoryProps.get("oldName");
        String newCategoryName = (String)categoryProps.get("name");
        for (StiVariable variable : report.getDictionary().getVariables()) {
            if (!oldCategoryName.equals(variable.getCategory())) continue;
            variable.setCategory(newCategoryName);
        }
        callbackResult.put("newName", newCategoryName);
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void createVariablesCategory(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        JSONObject categoryProps = (JSONObject)param.get("categoryFormResult");
        StiVariable category = new StiVariable(categoryProps.getString("name"));
        report.getDictionary().getVariables().add(category);
        callbackResult.put("name", categoryProps.getString("name"));
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void deleteBusinessObjectCategory(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        ArrayList<StiBusinessObject> collectionForRemove = new ArrayList<StiBusinessObject>();
        for (StiBusinessObject businessObject : report.getDictionary().getBusinessObjects()) {
            if (!businessObject.getCategory().equals(param.get("categoryName"))) continue;
            collectionForRemove.add(businessObject);
        }
        for (StiBusinessObject businessObject : collectionForRemove) {
            report.getDictionary().getBusinessObjects().remove((Object)businessObject);
        }
        callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
    }

    public static void editBusinessObjectCategory(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException {
        JSONObject categoryProps = (JSONObject)param.get("categoryFormResult");
        String oldCategoryName = categoryProps.getString("oldName");
        String newCategoryName = categoryProps.getString("name");
        for (StiBusinessObject businessObject : report.getDictionary().getBusinessObjects()) {
            if (!businessObject.getCategory().equals(oldCategoryName)) continue;
            businessObject.setCategory(newCategoryName);
        }
        StiDictionaryHelper.copyProperties(new String[]{"oldName", "name"}, categoryProps, callbackResult);
        callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
    }

    public static void synchronizeDictionary(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        callbackResult.put("dictionary", StiDictionaryHelper.getDictionaryTree(report));
    }

    public static void getAllConnections(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException {
        Hashtable result = new Hashtable();
        for (StiDatabase db : report.getDictionary().getDatabases()) {
            String category = db.getName();
            if (result.get(category) == null) {
                result.put(category, new ArrayList());
            }
            if (db instanceof StiXmlDatabase) {
                try {
                    InputStream is = ((StiXmlDatabase)db).getSchemaInputStream();
                    StiXmlTableFieldsRequest request = StiDataColumnsUtil.parceXSDSchema((InputStream)is);
                    for (StiXmlTable table : request.getTables()) {
                        String name = category + "." + table.getName();
                        List datas = (List)result.get(category);
                        if (datas.contains(name)) continue;
                        datas.add(name);
                    }
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (db instanceof StiJsonDatabase) {
                try {
                    DataSet dataSet = StiBaseOptions.getDefaultJsonConverterVersion() == StiJsonConverterVersion.ConverterV1 ? StiJsonToDataSetConverter.getDataTable((JSONObject)((StiJsonDatabase)db).getJSONObject()) : StiJsonToDataSetConverterV2.getDataSet((JSONObject)((StiJsonDatabase)db).getJSONObject());
                    for (DataTable table : dataSet.getTables()) {
                        String name = category + "." + table.getName();
                        List datas = (List)result.get(category);
                        if (datas.contains(name)) continue;
                        datas.add(name);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callbackResult.put("error", e.getClass() + " " + e.getMessage());
                    continue;
                }
            }
            try {
                StiJDBCDatabase jdb = (StiJDBCDatabase)db;
                StiAbstractAdapter adapter = StiDictionaryHelper.getAdapter(jdb.getConnectionString(), db.getClass().getName().substring(db.getClass().getName().lastIndexOf(46) + 1));
                Connection con = StiDictionaryHelper.getConnection(adapter.getJdbcParameters());
                StiDatabaseInformation information = db.getDatabaseInformation(con, adapter);
                for (DataTable table : information.getTables()) {
                    String name = category + "." + table.getName();
                    List datas = (List)result.get(category);
                    if (datas.contains(name)) continue;
                    datas.add(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                callbackResult.put("error", e.getClass() + " " + e.getMessage());
            }
        }
        callbackResult.put("connections", result);
    }

    public static StiJDBCParameters getJDBCConnection(String connectionString, String connectionType) {
        return StiDictionaryHelper.getAdapter(connectionString, connectionType).getJdbcParameters();
    }

    public static StiAbstractAdapter getAdapter(String connectionString, String connectionType) {
        if ("StiJDBCDatabase".equals(connectionType)) {
            connectionType = "StiJdbcDatabase";
        }
        StiConnectionType type = StiConnectionType.valueOf((String)connectionType);
        switch (type) {
            case StiJdbcDatabase: {
                return new StiJdbcAdapter(connectionString);
            }
            case StiMySqlDatabase: {
                return new StiMySqlAdapter(connectionString);
            }
            case StiPostgreSQLDatabase: {
                return new StiPostgreSqlAdapter(connectionString);
            }
            case StiOracleDatabase: {
                return new StiOracleAdapter(connectionString);
            }
            case StiMsSqlDatabase: {
                return new StiMsSqlAdapter(connectionString);
            }
        }
        throw new IllegalArgumentException("This type of connection '" + type.name() + "' is not supported");
    }

    private static StiDataStoreSource saveDataSourceParam(StiDataStoreSource dataSourceWithParam, StiReport report, StiDataStoreSource dataSource, Hashtable param) throws InstantiationException, IllegalAccessException, JSONException {
        if (dataSource == null) {
            return null;
        }
        JSONArray currColumns = (JSONArray)param.get("columns");
        JSONArray currParameters = (JSONArray)param.get("parameters");
        if (dataSourceWithParam == null) {
            dataSourceWithParam = (StiDataStoreSource)dataSource.getClass().newInstance();
            dataSourceWithParam.setDictionary(report.getDictionary());
        }
        StiDataColumnsCollection columns = new StiDataColumnsCollection();
        columns.addAll((Collection)dataSourceWithParam.getColumns());
        dataSourceWithParam.getColumns().clear();
        for (int i = 0; i < currColumns.length(); ++i) {
            JSONObject columnProps = currColumns.getJSONObject(i);
            Object column = columnProps.getBoolean("isCalcColumn") ? new StiCalcDataColumn() : new StiDataColumn();
            StiDictionaryHelper.applyColumnProps((StiDataColumn)column, columnProps);
            StiDataColumn cl = dataSourceWithParam.getColumns().get(columnProps.getString("name"));
            if (cl == null) {
                dataSourceWithParam.getColumns().add(column);
                continue;
            }
            dataSourceWithParam.getColumns().add((Object)cl);
        }
        if (dataSourceWithParam instanceof StiSqlSource) {
            StiDataParametersCollection parameters = new StiDataParametersCollection();
            parameters.addAll((Collection)dataSourceWithParam.getParameters());
            dataSourceWithParam.getParameters().clear();
            for (int i = 0; i < currParameters.length(); ++i) {
                StiDataParameter parameter = new StiDataParameter();
                StiDictionaryHelper.applyParameterProps(parameter, currParameters.getJSONObject(i));
                StiDataParameter pr = dataSourceWithParam.getParameters().getByName(parameter.getName());
                if (pr == null) {
                    dataSourceWithParam.getParameters().add((Object)parameter);
                    continue;
                }
                dataSourceWithParam.getParameters().add((Object)pr);
            }
            ((StiSqlSource)dataSourceWithParam).setSqlCommand(StiEncodingHelper.decodeString((String)param.get("sqlCommand")));
            if ("Table".equals(param.get("type"))) {
                ((StiSqlSource)dataSourceWithParam).setType(StiSqlSourceType.Table);
            } else {
                ((StiSqlSource)dataSourceWithParam).setType(StiSqlSourceType.StoredProcedure);
            }
        }
        dataSourceWithParam.setNameInSource((String)param.get("nameInSource"));
        dataSourceWithParam.setName((String)param.get("name"));
        dataSourceWithParam.setAlias((String)param.get("alias"));
        if (dataSourceWithParam.getName().equals(dataSourceWithParam.getAlias())) {
            dataSourceWithParam.setAlias((String)param.get("name"));
        }
        dataSourceWithParam.setName((String)param.get("name"));
        return dataSourceWithParam;
    }

    private static void applyParametersToSqlSourse(StiSqlSource sqlSource, JSONObject parameters) throws JSONException {
        Iterator keys = parameters.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("{") || !key.endsWith("}")) continue;
            while (sqlSource.getSqlCommand().indexOf(key) >= 0) {
                sqlSource.setSqlCommand(sqlSource.getSqlCommand().replace(key, StiEncodingHelper.decodeString(parameters.getString(key))));
            }
        }
        for (StiDataParameter parameter : sqlSource.getParameters()) {
            if (!parameters.has(parameter.getName())) continue;
            String text = StiEncodingHelper.decodeString(parameters.getString(parameter.getName()));
            parameter.setValue(text);
            try {
                int dbType = parameter.getType();
                if (dbType == 4 || dbType == 14 || dbType == 22 || dbType == 33) {
                    parameter.setParameterValue((Object)StiDateTime.Parse((String)text));
                    continue;
                }
                if (dbType == 0 || dbType == 19) {
                    parameter.setParameterValue((Object)Boolean.parseBoolean(text));
                    continue;
                }
                if (dbType == 3 || dbType == 13 || dbType == 21) {
                    parameter.setParameterValue((Object)text);
                    continue;
                }
                if (dbType == 8 || dbType == 9 || dbType == 10 || dbType == 1 || dbType == 11 || dbType == 15 || dbType == 16 || dbType == 17 || dbType == 20 || dbType == 27 || dbType == 28 || dbType == 29 || dbType == 30 || dbType == 31 || dbType == 35 || dbType == 36 || dbType == 34) {
                    parameter.setParameterValue((Object)Long.parseLong(text));
                    continue;
                }
                if (dbType == 5 || dbType == 24) {
                    parameter.setParameterValue((Object)new BigDecimal(text.replace(',', '.')));
                    continue;
                }
                if (dbType == 6 || dbType == 12 || dbType == 25 || dbType == 32) {
                    parameter.setParameterValue((Object)Double.parseDouble(text.replace(',', '.')));
                    continue;
                }
                if (dbType == 7 || dbType == 26) {
                    parameter.setParameterValue((Object)new StiGuid(text));
                    continue;
                }
                parameter.setParameterValue((Object)text);
            }
            catch (Exception e) {
                parameter.setParameterValue((Object)DBNull.getValue());
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
    }

    public static void retrieveColumns(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws JSONException, ClassNotFoundException, SQLException, StiException, InstantiationException, IllegalAccessException {
        StiDictionary dictionary = report.getDictionary();
        ArrayList<Object> columns = new ArrayList();
        ArrayList parameters = new ArrayList();
        StiDataStoreSource dataSource = null;
        StiDataStoreSource currentDataSource = null;
        Object adapter = null;
        String nameInSource = (String)param.get("nameInSource");
        if ("Edit".equals(param.get("mode"))) {
            currentDataSource = (StiDataStoreSource)dictionary.getDataSources().get((String)param.get("name"));
        }
        if (currentDataSource == null) {
            currentDataSource = (StiDataStoreSource)StiDictionaryHelper.createDataAdapterByTypeName((String)param.get("typeDataAdapter"), new StiWebDesignerOptions(), dictionary, (String)param.get("nameInSource"));
        }
        dataSource = StiDictionaryHelper.saveDataSourceParam(dataSource, report, currentDataSource, param);
        if (nameInSource.trim().length() == 0) {
            dictionary.Disconnect();
            callbackResult.put("error", String.format(StiLocalization.Get((String)"Errors", (String)"FieldRequire").replaceAll("{0}", "%s"), StiLocalization.Get((String)"Report", (String)"LabelNameInSource")));
            return;
        }
        if (dataSource != null) {
            for (StiDatabase db : dictionary.getDatabases()) {
                if (db instanceof StiXmlDatabase) {
                    try {
                        String sName;
                        String string = sName = nameInSource.indexOf(".") >= 0 ? nameInSource.substring(0, nameInSource.lastIndexOf(".")) : nameInSource;
                        if (!db.getName().equalsIgnoreCase(sName)) continue;
                        String tableName = nameInSource.substring(nameInSource.lastIndexOf(".") + 1);
                        InputStream is = ((StiXmlDatabase)db).getSchemaInputStream();
                        StiXmlTableFieldsRequest request = StiDataColumnsUtil.parceXSDSchema((InputStream)is);
                        for (StiXmlTable table : request.getTables()) {
                            if (!table.getName().equals(tableName)) continue;
                            columns = StiDictionaryHelper.getColumnsTree2(table.getColumns());
                        }
                        is.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callbackResult.put("error", e.getClass() + " " + e.getMessage());
                    }
                    continue;
                }
                if (db instanceof StiJsonDatabase) {
                    try {
                        if (!db.getName().equalsIgnoreCase(nameInSource.substring(0, nameInSource.lastIndexOf(".")))) continue;
                        String tableName = nameInSource.substring(nameInSource.lastIndexOf(".") + 1);
                        DataSet dataSet = StiBaseOptions.getDefaultJsonConverterVersion() == StiJsonConverterVersion.ConverterV1 ? StiJsonToDataSetConverter.getDataTable((JSONObject)((StiJsonDatabase)db).getJSONObject()) : StiJsonToDataSetConverterV2.getDataSet((JSONObject)((StiJsonDatabase)db).getJSONObject());
                        for (DataTable table : dataSet.getTables()) {
                            if (!table.getName().equals(tableName)) continue;
                            columns = StiDictionaryHelper.getColumnsTree2(table.getColumns());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callbackResult.put("error", e.getClass() + " " + e.getMessage());
                        continue;
                    }
                }
                if (!db.getName().toLowerCase().equals(nameInSource.toLowerCase())) continue;
                try {
                    StiSqlSource sqlSource = (StiSqlSource)dataSource;
                    sqlSource.setSqlCommand(StiEncodingHelper.decodeString((String)param.get("sqlCommand")));
                    sqlSource.setType(StiSqlSourceType.valueOf((String)((String)param.get("type"))));
                    if (param.containsKey("parametersValues")) {
                        StiDictionaryHelper.applyParametersToSqlSourse(sqlSource, (JSONObject)param.get("parametersValues"));
                    }
                    if (param.containsKey("onlyParameters")) continue;
                    StiJDBCDatabase jdb = (StiJDBCDatabase)db;
                    String connectionsString = StiEncodingHelper.decodeString((String)param.get("sqlCommand"));
                    Connection con = StiDictionaryHelper.getConnection(StiDictionaryHelper.getJDBCConnection(jdb.getConnectionString(), db.getClass().getName().substring(db.getClass().getName().lastIndexOf(46) + 1)));
                    StiTableFieldsRequest request = StiDataColumnsUtil.getFields((Connection)con, (String)connectionsString, (StiDataSource)dataSource);
                    columns = StiDictionaryHelper.getColumnsTree2(request.getColunns());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callbackResult.put("error", e.getClass() + " " + e.getMessage());
                }
            }
        }
        callbackResult.put("columns", columns);
        callbackResult.put("parameters", parameters);
    }

    public static Connection getConnection(StiJDBCParameters param) throws ClassNotFoundException, SQLException {
        Class.forName(param.getDriverName());
        Properties info = new Properties();
        info.setProperty("user", param.getUser());
        info.setProperty("password", param.getPassword());
        if (param.isDefaultEncoding()) {
            info.setProperty("useUnicode", "true");
            info.setProperty("characterEncoding", StiConstants.ENCODING.value);
        }
        info.putAll((Map<?, ?>)param.getOther());
        return DriverManager.getConnection(param.getConnectionURL(), info);
    }

    public static void getDatabaseData(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        StiDatabase db = report.getDictionary().getDatabases().get((String)param.get("databaseName"));
        StiDictionaryHelper.getDatabaseData(db, callbackResult);
    }

    public static void getDatabaseData(StiDatabase db, Hashtable<String, Object> callbackResult) {
        if (db != null) {
            try {
                StiDatabaseInformation information = null;
                if (db instanceof StiXmlDatabase || db instanceof StiJsonDatabase) {
                    try {
                        information = db.getDatabaseInformation(null, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callbackResult.put("error", e.getClass() + " " + e.getMessage());
                    }
                } else {
                    StiJDBCDatabase jdb = (StiJDBCDatabase)db;
                    if (StiValidationUtil.isNullOrEmpty((String)jdb.getConnectionString())) {
                        callbackResult.put("data", "{}");
                        return;
                    }
                    StiAbstractAdapter adapter = StiDictionaryHelper.getAdapter(jdb.getConnectionString(), db.getClass().getName().substring(db.getClass().getName().lastIndexOf(46) + 1));
                    Connection con = StiDictionaryHelper.getConnection(adapter.getJdbcParameters());
                    information = db.getDatabaseInformation(con, adapter);
                }
                if (information != null) {
                    callbackResult.put("data", StiDictionaryHelper.getAjaxDataFromDatabaseInformation(information));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                callbackResult.put("error", e.getClass() + " " + e.getMessage());
            }
        }
    }

    public static void applySelectedData(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        JSONArray data = (JSONArray)param.get("data");
        String databaseName = (String)param.get("databaseName");
        StiDatabase database = report.getDictionary().getDatabases().get(databaseName);
        if (database != null && data.length() > 0) {
            try {
                StiDatabaseInformation info = StiDictionaryHelper.convertAjaxDatabaseInfoToDatabaseInfo(data, false);
                StiDatabaseInformation allInfo = StiDictionaryHelper.convertAjaxDatabaseInfoToDatabaseInfo(data, true);
                database.applyDatabaseInformation(info, report, allInfo);
                for (int i = 0; i < data.length(); ++i) {
                    JSONObject dataSourceObject = data.getJSONObject(i);
                    if (dataSourceObject.get("relations") == null) continue;
                    JSONArray relations = dataSourceObject.getJSONArray("relations");
                    for (int j = 0; j < relations.length(); ++j) {
                        JSONObject relationObject = relations.getJSONObject(j);
                        StiDataRelation relation = new StiDataRelation();
                        report.getDictionary().getRelations().add(relation);
                        StiDictionaryHelper.applyRelationProps(report, relation, relationObject);
                    }
                }
                callbackResult.put("dictionary", StiDictionaryHelper.getDictionaryTree(report));
                if (data != null && data.length() > 0) {
                    callbackResult.put("selectedDataSource", data.get(data.length() - 1));
                }
                callbackResult.put("databaseName", databaseName);
            }
            catch (Exception e) {
                e.printStackTrace();
                callbackResult.put("error", e.getClass() + " " + e.getMessage());
            }
        }
    }

    public static void testConnection(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult, StiWebDesignerOptions options) throws JSONException, InstantiationException, IllegalAccessException {
        try {
            String typeConnection = (String)param.get("typeConnection");
            String connectionString = StiEncodingHelper.decodeString((String)param.get("connectionString"));
            StiDatabase db = StiDictionaryHelper.createDataBaseByTypeName(typeConnection, options);
            if (db instanceof StiJDBCDatabase) {
                StiAbstractAdapter adapter = StiDictionaryHelper.getAdapter(connectionString, db.getClass().getName().substring(db.getClass().getName().lastIndexOf(46) + 1));
                Connection con = StiDictionaryHelper.getConnection(adapter.getJdbcParameters());
                ((StiJDBCDatabase)db).testConnection(con, adapter);
            } else if (db instanceof StiXmlDatabase) {
                if (((StiXmlDatabase)db).getDataInputStream() == null) {
                    callbackResult.put("testResult", StiLocalization.getValue((String)"DesignerFx", (String)"ConnectionError"));
                }
            } else if (db instanceof StiJsonDatabase && ((StiJsonDatabase)db).getDataInputStream() == null) {
                callbackResult.put("testResult", StiLocalization.getValue((String)"DesignerFx", (String)"ConnectionError"));
            }
        }
        catch (Exception e) {
            callbackResult.put("testResult", StiLoggingUtil.getHtmlError((String)"", (Exception)e));
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return;
        }
        callbackResult.put("testResult", StiLocalization.getValue((String)"DesignerFx", (String)"ConnectionSuccessfull"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runQueryScript(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) {
        block9: {
            StiDictionary dictionary = report.getDictionary();
            StiDataStoreSource dataSource = null;
            StiDataStoreSource currentDataSource = null;
            try {
                if ("Edit".equals(param.get("mode"))) {
                    currentDataSource = (StiDataStoreSource)dictionary.getDataSources().get((String)param.get("name"));
                }
                if (currentDataSource == null) {
                    currentDataSource = (StiDataStoreSource)StiDictionaryHelper.createDataStoreSourceFromParams(report, param, dictionary);
                }
                dataSource = StiDictionaryHelper.saveDataSourceParam(dataSource, report, currentDataSource, param);
                if (param.containsKey("parametersValues") && dataSource instanceof StiSqlSource) {
                    StiDictionaryHelper.applyParametersToSqlSourse((StiSqlSource)dataSource, (JSONObject)param.get("parametersValues"));
                }
                if (dataSource == null) break block9;
                if (StiValidationUtil.isNullOrEmpty((String)dataSource.getNameInSource())) {
                    callbackResult.put("resultQueryScript", StiLocalization.format((String)"Errors", (String)"FieldRequire", (Object[])new Object[]{StiLocalization.Get((String)"Report", (String)"LabelNameInSource")}));
                    return;
                }
                try {
                    dataSource.setDictionary(dictionary);
                    dataSource.connect();
                    callbackResult.put("resultQueryScript", "successfully");
                }
                finally {
                    dataSource.disconnect();
                    dictionary.Disconnect();
                }
            }
            catch (Exception ee) {
                callbackResult.put("resultQueryScript", ee.getMessage() != null ? ee.getMessage() : ee.getCause());
                ee.printStackTrace();
            }
        }
    }

    private static StiDataSource createDataStoreSourceFromParams(StiReport report, Hashtable param, StiDictionary dictionary) throws IllegalArgumentException, JSONException, IllegalAccessException, InvocationTargetException, InstantiationException {
        StiDataSource dataSource = StiDictionaryHelper.createDataAdapterByTypeName((String)param.get("typeDataAdapter"), new StiWebDesignerOptions(), dictionary, (String)param.get("nameInSource"));
        if (dataSource != null) {
            dataSource.setDictionary(report.getDictionary());
            StiDictionaryHelper.applyDataSourceProps2(dataSource, param);
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewData(StiReport report, Hashtable param, Hashtable callbackResult) {
        StiDictionary dictionary = report.getDictionary();
        StiDataStoreSource currentDataSource = null;
        StiDataStoreSource dataSource = null;
        try {
            if ("Edit".equals(param.get("mode"))) {
                currentDataSource = (StiDataStoreSource)dictionary.getDataSources().get((String)param.get("name"));
            }
            if (currentDataSource == null) {
                currentDataSource = (StiDataStoreSource)StiDictionaryHelper.createDataStoreSourceFromParams(report, param, dictionary);
            }
            if ((dataSource = StiDictionaryHelper.saveDataSourceParam(dataSource, report, currentDataSource, param)) != null) {
                dataSource.setDictionary(dictionary);
                dataSource.connect();
                if (param.containsKey("parametersValues") && dataSource instanceof StiSqlSource) {
                    StiDictionaryHelper.applyParametersToSqlSourse((StiSqlSource)dataSource, (JSONObject)param.get("parametersValues"));
                }
                StiViewDataHelper viewDataHelper = new StiViewDataHelper((StiDataSource)dataSource);
                DataTable dataTable = viewDataHelper.ResultDataTable;
                ArrayList resultData = new ArrayList();
                ArrayList<StiDataColumn> dictionaryColumns = new ArrayList<StiDataColumn>();
                ArrayList<String> captions = new ArrayList<String>();
                for (int k = 0; k < dataTable.getColumns().size(); ++k) {
                    StiDataColumn dictionaryColumn = dataSource.getColumns().get(((StiDataColumn)dataTable.getColumns().get(k)).getName());
                    captions.add(((StiDataColumn)dataTable.getColumns().get(k)).getName());
                    dictionaryColumns.add(dictionaryColumn);
                }
                resultData.add(captions);
                for (int i = 0; i < dataTable.getRows().size(); ++i) {
                    ArrayList<Hashtable<String, String>> rowArray = new ArrayList<Hashtable<String, String>>();
                    resultData.add(rowArray);
                    for (int k = 0; k < dataTable.getColumns().size(); ++k) {
                        rowArray.add(StiDictionaryHelper.getViewDataItemValue(((DataRow)dataTable.getRows().get(i)).getValue(k), (StiDataColumn)dictionaryColumns.get(k)));
                    }
                }
                callbackResult.put("resultData", resultData);
                callbackResult.put("dataSourceName", dataSource.getName());
            }
        }
        catch (Exception e) {
            callbackResult.put("error", e.getMessage() != null ? e.getMessage() : "Error " + e.getCause().toString());
            e.printStackTrace();
        }
        finally {
            dataSource.disconnect();
        }
    }

    private static Hashtable<String, String> getViewDataItemValue(Object item, StiDataColumn dictionaryColumn) {
        Hashtable<String, String> resultItem = new Hashtable<String, String>();
        String type = dictionaryColumn != null ? dictionaryColumn.getClass().getName() : (item != null ? item.getClass().getName() : "");
        resultItem.put("type", type);
        if (item instanceof byte[]) {
            resultItem.put("value", String.format("data:image;base64,%s", new Object[]{StiBase64DecoderUtil.decode((byte[])((byte[])item))}));
        }
        if (item instanceof StiImage) {
            resultItem.put("value", String.format("data:image;base64,%s", new Object[]{StiBase64DecoderUtil.decode((String)((StiImage)item).getImage())}));
        } else {
            resultItem.put("value", item != null ? item.toString() : "");
        }
        return resultItem;
    }

    public static void getSqlParameterTypes(StiReport report, Hashtable<String, Object> param, Hashtable<String, Object> callbackResult) throws InstantiationException, IllegalAccessException, JSONException {
        String typeDataSource = ((JSONObject)param.get("dataSource")).getString("typeDataSource");
        StiDataSource dataSource = null;
        for (Class<? extends StiDataSource> source : new StiWebDesignerOptions().getDataSources()) {
            if (!source.getName().endsWith(typeDataSource)) continue;
            dataSource = source.newInstance();
        }
        if (dataSource != null && dataSource instanceof StiSqlSource) {
            callbackResult.put("sqlParameterTypes", StiDictionaryHelper.getDataParameterTypes((StiSqlSource)dataSource));
        }
    }

    public static void createFieldOnDblClick(StiReport report, Hashtable<String, Object> param, Hashtable callbackResult) throws Exception {
        StiDataParametersCollection parameters;
        StiDataColumn column = null;
        StiDataParameter parameter = null;
        StiDataSource dataSource = null;
        StiDataBand dataBand = null;
        StiDataBand firstDataBand = null;
        StiDataBand selectedDataBand = null;
        StiPage currentPage = report.getPages().get((String)param.get("pageName"));
        JSONArray selectedComponentNames = (JSONArray)param.get("selectedComponents");
        ArrayList<Hashtable<String, Object>> newComponents = new ArrayList<Hashtable<String, Object>>();
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        if (param.containsKey("columnName")) {
            StiDataColumnsCollection columns = StiDictionaryHelper.getColumnsByTypeAndNameOfObject(report, param);
            if (columns != null) {
                column = columns.get((String)param.get("columnName"));
            }
            if (column != null) {
                dataSource = column.getDataSource();
            }
        } else if (param.containsKey("parameterName") && (dataSource = report.getDictionary().getDataSources().get((String)param.get("currentParentName"))) != null && (parameters = dataSource.getParameters()) != null) {
            parameter = parameters.getByName((String)param.get("parameterName"));
        }
        for (StiComponent component : currentPage.GetComponents()) {
            component.setIsSelected(false);
        }
        for (int i = 0; i < selectedComponentNames.length(); ++i) {
            String componentName = selectedComponentNames.getString(i);
            StiComponent component = report.GetComponentByName(componentName);
            if (component == null) continue;
            component.select();
        }
        ArrayList<StiDataBand> selectedDataBands = new ArrayList<StiDataBand>();
        StiComponentsCollection comps = currentPage.GetComponents();
        for (StiComponent component : comps) {
            StiDataBand band = component instanceof StiDataBand ? (StiDataBand)component : null;
            if (band == null) continue;
            if (firstDataBand == null) {
                firstDataBand = band;
            }
            if (selectedDataBand == null && band.getIsSelected()) {
                selectedDataBand = band;
            }
            if (band.getDataSource() != dataSource) continue;
            selectedDataBands.add(band);
        }
        if (selectedDataBands.size() > 0) {
            for (StiDataBand band : selectedDataBands) {
                if (dataBand == null) {
                    dataBand = band;
                    continue;
                }
                if (dataBand.getIsSelected() || !band.getIsSelected()) continue;
                dataBand = band;
                break;
            }
        }
        if (dataBand == null) {
            dataBand = selectedDataBand != null ? selectedDataBand : firstDataBand;
        }
        if (dataBand != null) {
            StiStyle style = new StiStyle();
            double posX = 0.0;
            for (StiComponent comp : dataBand.getComponents()) {
                if (!(posX < comp.getRight())) continue;
                posX = comp.getRight();
                if (comp instanceof IStiIgnoryStyle) continue;
                style = StiBaseStyle.getStyle((StiComponent)comp);
            }
            double width = StiAlignValue.alignToMaxGrid((double)(dataBand.width / 8.0), (double)currentPage.getGridSize(), (boolean)true);
            StiRectangle rect = new StiRectangle(posX, 0.0, width, dataBand.getHeight());
            StiText text = new StiText(rect);
            if (!(text instanceof IStiIgnoryStyle)) {
                if (param.containsKey("lastStyleProperties")) {
                    StiReportEdit.setAllProperties((StiComponent)text, (JSONArray)param.get("lastStyleProperties"));
                } else {
                    style.SetStyleToComponent((StiComponent)text);
                }
            }
            text.setText((String)param.get("fullName"));
            text.setType(StiSystemTextType.DataColumn);
            dataBand.getComponents().add((StiComponent)text);
            newComponents.add(StiReportEdit.getComponentMainProperties((StiComponent)text, zoom));
            StiDataBandV1Builder builder = new StiDataBandV1Builder();
            StiComponentsCollection headers = builder.getHeaders(dataBand);
            for (StiComponent cmp : headers) {
                StiHeaderBand header = (StiHeaderBand)cmp;
                posX = 0.0;
                for (StiComponent comp : header.getComponents()) {
                    if (!(posX < comp.getRight())) continue;
                    posX = comp.getRight();
                    if (comp instanceof IStiIgnoryStyle) continue;
                    style = StiBaseStyle.getStyle((StiComponent)comp);
                }
                text = new StiText(rect);
                text.setHeight(header.getHeight());
                text.setHorAlignment(StiTextHorAlignment.Center);
                if (!(text instanceof IStiIgnoryStyle)) {
                    style.SetStyleToComponent((StiComponent)text);
                }
                if (column != null) {
                    text.setText(column.getAlias());
                } else {
                    String str = parameter.getName();
                    if (str.startsWith("@")) {
                        str = str.substring(1);
                    }
                    text.setText(str);
                }
                header.getComponents().add((StiComponent)text);
                newComponents.add(StiReportEdit.getComponentMainProperties((StiComponent)text, zoom));
            }
        }
        callbackResult.put("pageName", currentPage.getName());
        callbackResult.put("newComponents", newComponents);
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
    }

    public static void getParamsFromQueryString(StiReport report, Hashtable param, Hashtable callbackResult) {
        StiSqlSource dataSource;
        StiDataSource ds = report.getDictionary().getDataSources().get((String)param.get("dataSourceName"));
        StiSqlSource stiSqlSource = dataSource = ds instanceof StiSqlSource ? (StiSqlSource)ds : null;
        if (dataSource != null) {
            String queryString = StiEncodingHelper.decodeString((String)param.get("queryString"));
            List exps = dataSource.getAllowExpressions() ? StiCodeDomExpressionHelper.getLexem((String)queryString) : new ArrayList();
            ArrayList<String> parameters = new ArrayList<String>();
            for (String value : exps) {
                if (!value.startsWith("{") || !value.endsWith("}")) continue;
                parameters.add(value);
            }
            callbackResult.put("params", parameters);
        }
    }

    public static class StiSortDataTableComparer
    implements Comparator<DataTable> {
        @Override
        public int compare(DataTable x, DataTable y) {
            if (x.getTableName() == null) {
                if (y.getTableName() == null) {
                    return 0;
                }
                return -1;
            }
            if (y.getTableName() == null) {
                return 1;
            }
            return y.getTableName().compareTo(y.getTableName());
        }
    }
}

