/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentHelper;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.interfaces.IStiComponentGuid;
import com.stimulsoft.report.components.interfaces.IStiComponentGuidReference;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiPointPrimitive;
import com.stimulsoft.report.units.StiHundredthsOfInchUnit;
import com.stimulsoft.report.units.StiUnit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Hashtable;

public class StiGroup
extends StiContainer {
    public StiGroup() {
        this.components.clear();
    }

    public Object clone() {
        StiGroup group = (StiGroup)((Object)this.MemberwiseClone());
        group.getComponents().clear();
        for (StiComponent comp : this.getComponents()) {
            group.getComponents().add((StiComponent)comp.clone());
        }
        return group;
    }

    public String toString(String application) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.setReference(0);
        StiSerializerControler.serializeDocument((IStiSerializableRef)this, (OutputStream)bos);
        byte[] res = bos.toByteArray();
        return new String(res, Charset.forName("UTF-8"));
    }

    public static StiGroup createFromString(String text, String application) {
        return (StiGroup)StiDeserializerControler.deserializeDocument((InputStream)new ByteArrayInputStream(text.getBytes(Charset.forName("UTF-8"))), StiGroup.class);
    }

    public static StiComponentsCollection getSelectedComponents(boolean isSelectedFinded, int level, StiContainer cont, StiComponentsCollection allComps, Hashtable<String, Object> lists) {
        StiComponentsCollection comps = new StiComponentsCollection();
        for (StiComponent comp : cont.getComponents()) {
            StiContainer cont2;
            StiPointPrimitive point = comp instanceof StiPointPrimitive ? (StiPointPrimitive)comp : null;
            boolean isSelectedFinded2 = isSelectedFinded;
            boolean isAdded = false;
            if (level == 0 && comp.getIsSelected()) {
                comps.add(comp);
                allComps.add(comp);
                isSelectedFinded2 = true;
            }
            if (level != 0) {
                allComps.add(comp);
                isAdded = true;
            }
            if (isAdded && point != null && point.getReferenceToGuid() != null) {
                lists.put(point.getReferenceToGuid(), comp);
            }
            if ((cont2 = comp instanceof StiContainer ? (StiContainer)comp : null) == null) continue;
            int prevLevel = level++;
            if (isSelectedFinded2) {
                // empty if block
            }
            comps.addAll((Collection)StiGroup.getSelectedComponents(isSelectedFinded2, level, cont2, allComps, lists));
            level = prevLevel;
        }
        return comps;
    }

    public static StiGroup getGroupFromPage(StiPage page) {
        StiPage pg = (StiPage)StiComponentHelper.clone((StiComponent)page);
        StiComponentsCollection allComps = new StiComponentsCollection();
        Hashtable<String, Object> lists = new Hashtable<String, Object>();
        StiComponentsCollection comps = StiGroup.getSelectedComponents(false, 0, (StiContainer)pg, allComps, lists);
        if (lists.size() > 0) {
            Hashtable<String, StiCrossLinePrimitive> addedList = new Hashtable<String, StiCrossLinePrimitive>();
            for (StiComponent comp : comps) {
                if (!(comp instanceof StiCrossLinePrimitive)) continue;
                StiCrossLinePrimitive crossLine = (StiCrossLinePrimitive)comp;
                addedList.put(crossLine.getGuid(), crossLine);
            }
            for (StiComponent comp : pg.getComponents()) {
                StiCrossLinePrimitive line = comp instanceof StiCrossLinePrimitive ? (StiCrossLinePrimitive)comp : null;
                if (line == null || !lists.containsKey(line.getGuid()) || addedList.containsKey(line.getGuid())) continue;
                comps.add((StiComponent)line);
                allComps.add((StiComponent)line);
                addedList.put(line.getGuid(), line);
            }
        }
        for (StiComponent comp : comps) {
            if (comp.getParent() == comp.getPage()) continue;
            comp.setDisplayRectangle(comp.ComponentToPage(comp.getDisplayRectangle()));
        }
        StiGroup group = new StiGroup();
        StiHundredthsOfInchUnit newUnit = new StiHundredthsOfInchUnit();
        for (StiComponent comp : comps) {
            StiContainer cont = comp instanceof StiContainer ? (StiContainer)comp : null;
            if (cont == null) continue;
            StiGroup.resetSelection(cont);
        }
        for (StiComponent comp : allComps) {
            if (comp instanceof StiCrossLinePrimitive) continue;
            comp.setLinked(false);
            comp.setPage(null);
            comp.setParent(null);
            if (comp instanceof StiContainer) {
                ((StiContainer)comp).Convert(((StiPage)page.getReport().getPages().get(page.getReport().getCurrentPage())).getUnit(), (StiUnit)newUnit, false);
                continue;
            }
            comp.convert(((StiPage)page.getReport().getPages().get(page.getReport().getCurrentPage())).getUnit(), (StiUnit)newUnit);
        }
        for (StiComponent comp : comps) {
            group.getComponents().add(comp);
        }
        return group;
    }

    private static void resetSelection(StiContainer cont) {
        for (StiComponent comp : cont.getComponents()) {
            comp.Reset();
            StiContainer cont2 = comp instanceof StiContainer ? (StiContainer)comp : null;
            if (cont2 == null) continue;
            StiGroup.resetSelection(cont2);
        }
    }

    private static StiComponentsCollection getAllComps(StiComponentsCollection comps) {
        StiComponentsCollection comps2 = new StiComponentsCollection();
        for (StiComponent comp : comps) {
            comps2.add(comp);
            StiContainer cont = comp instanceof StiContainer ? (StiContainer)comp : null;
            if (cont == null) continue;
            comps2.addAll((Collection)StiGroup.getAllComps(cont.getComponents()));
        }
        return comps2;
    }

    public StiComponentsCollection insertIntoPage(StiPage page) {
        StiComponentsCollection comps = new StiComponentsCollection();
        StiHundredthsOfInchUnit oldUnit = new StiHundredthsOfInchUnit();
        page.ResetSelection();
        StiComponentsCollection allComps = StiGroup.getAllComps(this.getComponents());
        for (StiComponent comp : allComps) {
            Object guid = comp instanceof IStiComponentGuid ? comp : null;
            if (guid == null) continue;
            String oldGuid = guid.getGuid();
            guid.NewGuid();
            for (StiComponent comp2 : allComps) {
                IStiComponentGuidReference guidReference = comp2 instanceof IStiComponentGuidReference ? (IStiComponentGuidReference)comp2 : null;
                if (guidReference == null || !guidReference.getReferenceToGuid().equals(oldGuid)) continue;
                guidReference.setReferenceToGuid(guid.getGuid());
            }
        }
        StiComponentsCollection compsReport = page.getReport().GetComponents();
        Hashtable<String, StiComponent> compsReportHash = new Hashtable<String, StiComponent>();
        for (StiComponent comp : compsReport) {
            compsReportHash.put(comp.getName(), comp);
        }
        for (StiComponent comp : allComps) {
            StiContainer cont;
            if (!(comp instanceof StiCrossLinePrimitive)) {
                if (comp instanceof StiContainer) {
                    ((StiContainer)comp).Convert((StiUnit)oldUnit, page.getUnit(), false);
                } else {
                    comp.convert((StiUnit)oldUnit, page.getUnit());
                }
            }
            comp.setPage(page);
            if (this.getComponents().indexOf((Object)comp) != -1) {
                if (!(comp instanceof StiPointPrimitive)) {
                    page.getComponents().add(comp);
                }
                comp.select();
            }
            if (compsReportHash.containsKey(comp.getName())) {
                comp.setName(StiNameCreation.createName((StiReport)page.getReport(), (String)StiNameCreation.generateName((StiReport)page.getReport(), (String)comp.getLocalizedName(), (String)comp.getClass().getName().substring(comp.getClass().getName().lastIndexOf(46) + 1))));
            }
            StiContainer stiContainer = cont = comp instanceof StiContainer ? (StiContainer)comp : null;
            if (cont != null) {
                cont.getComponents().SetParent(cont);
            }
            if (comp instanceof StiPointPrimitive) continue;
            comps.add(comp);
        }
        return comps;
    }
}

