/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.exception.StiParserException;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheck;
import com.stimulsoft.report.check.StiCheckEngine;
import com.stimulsoft.report.check.actions.StiAction;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.helper.StiEncodingHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class StiReportCheckHelper {
    private static Hashtable<String, Object> checkItem(StiCheck check) {
        Hashtable<String, Object> checkObject = new Hashtable<String, Object>();
        checkObject.put("actions", StiReportCheckHelper.getActions(check));
        checkObject.put("defaultStateEnabled", check.isDefaultStateEnabled());
        checkObject.put("element", check.getElement() != null ? check.getElement().getClass().getName().substring(check.getElement().getClass().getName().lastIndexOf(46) + 1) : null);
        checkObject.put("elementName", check.getElementName());
        checkObject.put("enabled", check.getEnabled());
        checkObject.put("longMessage", check.getLongMessage());
        checkObject.put("objectType", check.getObjectType());
        checkObject.put("previewVisible", check.getPreviewVisible());
        checkObject.put("shortMessage", check.getShortMessage());
        checkObject.put("status", check.getStatus());
        return checkObject;
    }

    private static Hashtable<String, String> checkActionItem(StiAction action) {
        Hashtable<String, String> actionObject = new Hashtable<String, String>();
        actionObject.put("name", action.getName());
        actionObject.put("description", action.getDescription());
        return actionObject;
    }

    private static ArrayList<Hashtable<String, String>> getActions(StiCheck check) {
        ArrayList<Hashtable<String, String>> actions = new ArrayList<Hashtable<String, String>>();
        for (StiAction action : check.getActions()) {
            actions.add(StiReportCheckHelper.checkActionItem(action));
        }
        return actions;
    }

    private static void removeCheck(StiCheck check, List<StiCheck> checks) {
        if (checks != null && checks.contains(check)) {
            checks.remove(check);
        }
    }

    private static ArrayList<Hashtable<String, Object>> getChecksJSCollection(List<StiCheck> checks) {
        ArrayList<Hashtable<String, Object>> checkItems = new ArrayList<Hashtable<String, Object>>();
        if (checks != null) {
            for (StiCheck check : checks) {
                checkItems.add(StiReportCheckHelper.checkItem(check));
            }
        }
        return checkItems;
    }

    private static void updateCurrentReport(StiReport report, Hashtable parameters, Hashtable callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        callbackResult.put("selectedObjectName", parameters.get("selectedObjectName"));
        report.getInfo().setZoom(StiReportEdit.strToDouble((String)parameters.get("zoom")));
        if (parameters.containsKey("reportFile")) {
            report.setReportFile((String)parameters.get("reportFile"));
        }
        callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        callbackResult.put("reportGuid", parameters.get("reportGuid"));
    }

    private static Map<String, BufferedImage> createImage(StiCheck check) {
        if (!check.getPreviewVisible()) {
            return null;
        }
        return check.createPreviewImage();
    }

    public static void checkReport(HttpServletRequest httpContext, StiReport report, Hashtable<String, Object> parameters, Hashtable<String, Object> callbackResult) throws StiException {
        StiCheckEngine engine = new StiCheckEngine();
        List checks = engine.checkReport(report);
        StiWebDesigner.saveObjectToCache(httpContext, (String)parameters.get("reportCheckersId"), checks);
        callbackResult.put("checkItems", StiReportCheckHelper.getChecksJSCollection(checks));
    }

    public static void getCheckPreview(HttpServletRequest httpContext, StiReport report, Hashtable<String, Object> parameters, Hashtable<String, Object> callbackResult) {
        StiCheck check;
        Map<String, BufferedImage> images;
        List checks = (List)StiWebDesigner.getObjectFromCache(httpContext, (String)parameters.get("reportCheckersId"));
        int checkIndex = Integer.parseInt(parameters.get("checkIndex").toString());
        if (checks != null && checkIndex < checks.size() && (images = StiReportCheckHelper.createImage(check = (StiCheck)checks.get(checkIndex))) != null && images.size() > 0) {
            BufferedImage img = images.containsKey("highlightedElementImage") ? images.get("highlightedElementImage") : images.get("elementImage");
            StiImage image = new StiImage(StiImageHelper.imageToBase64((BufferedImage)img, (StiImageFormat)StiImageFormat.Png));
            callbackResult.put("previewImage", "data:image/png;base64," + StiReportEdit.imageToBase64(image, StiImageFormat.Png));
        }
    }

    public static void actionCheck(HttpServletRequest httpContext, StiReport report, Hashtable<String, Object> parameters, Hashtable<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        StiCheck check;
        List checks = (List)StiWebDesigner.getObjectFromCache(httpContext, (String)parameters.get("reportCheckersId"));
        int checkIndex = Integer.parseInt(parameters.get("checkIndex").toString());
        int actionIndex = Integer.parseInt(parameters.get("actionIndex").toString());
        if (checks != null && checkIndex < checks.size() && (check = (StiCheck)checks.get(checkIndex)).getActions() != null && actionIndex < check.getActions().size()) {
            StiAction action = (StiAction)check.getActions().get(actionIndex);
            boolean needUpdateReport = false;
            action.invoke(report, check.getElement(), check.getElementName());
            needUpdateReport = true;
            if (needUpdateReport) {
                StiReportCheckHelper.removeCheck(check, checks);
                StiWebDesigner.saveObjectToCache(httpContext, (String)parameters.get("reportCheckersId"), checks);
                callbackResult.put("checkItems", StiReportCheckHelper.getChecksJSCollection(checks));
                StiReportCheckHelper.updateCurrentReport(report, parameters, callbackResult);
            }
        }
    }

    public static void checkExpression(StiReport report, Hashtable<String, Object> parameters, Hashtable<String, Object> callbackResult) {
        StiParserException pex = StiParser.checkExpression((String)StiEncodingHelper.decodeString((String)parameters.get("expressionText")), (StiComponent)report.GetComponentByName((String)parameters.get("componentName")));
        callbackResult.put("checkResult", StiEncodingHelper.encode(pex != null ? pex.BaseMessage : "OK"));
    }
}

