/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiTextFormatState;
import com.stimulsoft.report.components.textFormats.StiBooleanFormatService;
import com.stimulsoft.report.components.textFormats.StiCurrencyFormatService;
import com.stimulsoft.report.components.textFormats.StiCustomFormatService;
import com.stimulsoft.report.components.textFormats.StiDateFormatService;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.components.textFormats.StiGeneralFormatService;
import com.stimulsoft.report.components.textFormats.StiNumberFormatService;
import com.stimulsoft.report.components.textFormats.StiPercentageFormatService;
import com.stimulsoft.report.components.textFormats.StiTimeFormatService;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class StiTextFormatHelper {
    public static Hashtable<String, Object> generalTextFormatItem(StiGeneralFormatService service) {
        Hashtable<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        return textFormatItem;
    }

    public static Hashtable<String, Object> numberTextFormatItem(StiNumberFormatService service) {
        Hashtable<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("useGroupSeparator", service.getUseGroupSeparator());
        textFormatItem.put("useLocalSetting", service.getUseLocalSetting());
        textFormatItem.put("decimalDigits", service.getDecimalDigits());
        textFormatItem.put("decimalSeparator", service.getDecimalSeparator());
        textFormatItem.put("groupSeparator", service.getGroupSeparator());
        textFormatItem.put("groupSize", service.getGroupSize());
        textFormatItem.put("numberNegativePattern", service.getNegativePattern());
        textFormatItem.put("state", service.getState().toString());
        return textFormatItem;
    }

    public static Hashtable<String, Object> currencyTextFormatItem(StiCurrencyFormatService service) {
        Hashtable<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("useGroupSeparator", service.getUseGroupSeparator());
        textFormatItem.put("useLocalSetting", service.getUseLocalSetting());
        textFormatItem.put("decimalDigits", service.getDecimalDigits());
        textFormatItem.put("decimalSeparator", service.getDecimalSeparator());
        textFormatItem.put("groupSeparator", service.getGroupSeparator());
        textFormatItem.put("groupSize", service.getGroupSize());
        textFormatItem.put("currencyPositivePattern", service.getPositivePattern());
        textFormatItem.put("currencyNegativePattern", service.getNegativePattern());
        textFormatItem.put("currencySymbol", service.getSymbol());
        textFormatItem.put("state", service.getState().toString());
        return textFormatItem;
    }

    public static Hashtable<String, Object> dateTextFormatItem(StiDateFormatService service) {
        Hashtable<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("dateFormat", service.getStringFormat());
        return textFormatItem;
    }

    public static Hashtable<String, Object> timeTextFormatItem(StiTimeFormatService service) {
        Hashtable<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("timeFormat", service.getStringFormat());
        return textFormatItem;
    }

    public static Hashtable<String, Object> percentageTextFormatItem(StiPercentageFormatService service) {
        Hashtable<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("useGroupSeparator", service.getUseGroupSeparator());
        textFormatItem.put("useLocalSetting", service.getUseLocalSetting());
        textFormatItem.put("decimalDigits", service.getDecimalDigits());
        textFormatItem.put("decimalSeparator", service.getDecimalSeparator());
        textFormatItem.put("groupSeparator", service.getGroupSeparator());
        textFormatItem.put("groupSize", service.getGroupSize());
        textFormatItem.put("percentagePositivePattern", service.getPositivePattern());
        textFormatItem.put("percentageNegativePattern", service.getNegativePattern());
        textFormatItem.put("percentageSymbol", service.getSymbol());
        textFormatItem.put("state", service.getState().toString());
        return textFormatItem;
    }

    public static Hashtable<String, Object> booleanTextFormatItem(StiBooleanFormatService service) {
        Hashtable<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("falseValue", service.getFalseValue());
        textFormatItem.put("falseDisplay", service.getFalseDisplay());
        textFormatItem.put("trueValue", service.getTrueValue());
        textFormatItem.put("trueDisplay", service.getTrueDisplay());
        return textFormatItem;
    }

    public static Hashtable<String, Object> customTextFormatItem(StiCustomFormatService service) {
        Hashtable<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("customFormat", service.getStringFormat());
        return textFormatItem;
    }

    public static Hashtable<String, Object> commonTextFormatItem(StiFormatService service) {
        Hashtable<String, Object> textFormatItem = new Hashtable<String, Object>();
        textFormatItem.put("type", service.getClass().getName().substring(service.getClass().getName().lastIndexOf(46) + 1));
        textFormatItem.put("sample", service.getSample().toString());
        return textFormatItem;
    }

    private static StiEnumSet<StiTextFormatState> getStateProperty(String propertyValue) {
        StiEnumSet value = StiEnumSet.of((Enum)StiTextFormatState.None);
        if (propertyValue.indexOf("DecimalDigits") >= 0) {
            value.add((IStiEnum)StiTextFormatState.DecimalDigits);
        }
        if (propertyValue.indexOf("DecimalSeparator") >= 0) {
            value.add((IStiEnum)StiTextFormatState.DecimalSeparator);
        }
        if (propertyValue.indexOf("GroupSeparator") >= 0) {
            value.add((IStiEnum)StiTextFormatState.GroupSeparator);
        }
        if (propertyValue.indexOf("GroupSize") >= 0) {
            value.add((IStiEnum)StiTextFormatState.GroupSize);
        }
        if (propertyValue.indexOf("PositivePattern") >= 0) {
            value.add((IStiEnum)StiTextFormatState.PositivePattern);
        }
        if (propertyValue.indexOf("NegativePattern") >= 0) {
            value.add((IStiEnum)StiTextFormatState.NegativePattern);
        }
        if (propertyValue.indexOf("CurrencySymbol") >= 0) {
            value.add((IStiEnum)StiTextFormatState.CurrencySymbol);
        }
        if (propertyValue.indexOf("PercentageSymbol") >= 0) {
            value.add((IStiEnum)StiTextFormatState.PercentageSymbol);
        }
        return value;
    }

    public static ArrayList<Object> getCurrencySymbols() {
        ArrayList<Object> currencySymbols = new ArrayList<Object>();
        String cr = Currency.getInstance(Locale.getDefault()).getSymbol();
        currencySymbols.add(cr);
        currencySymbols.add(Character.valueOf('$'));
        currencySymbols.add(Character.valueOf('\u20ac'));
        currencySymbols.add(Character.valueOf('\u00a2'));
        currencySymbols.add(Character.valueOf('\u00a3'));
        currencySymbols.add(Character.valueOf('\u00a4'));
        currencySymbols.add(Character.valueOf('\u00a5'));
        currencySymbols.add(Character.valueOf('\u20a3'));
        currencySymbols.add(Character.valueOf('\u20a4'));
        currencySymbols.add(Character.valueOf('\u20a7'));
        currencySymbols.add(Character.valueOf('\u20aa'));
        currencySymbols.add(Character.valueOf('\u20ab'));
        currencySymbols.add(Character.valueOf('\u0e3f'));
        currencySymbols.add(Character.valueOf('\u20a0'));
        currencySymbols.add(Character.valueOf('\u20a1'));
        currencySymbols.add(Character.valueOf('\u20a2'));
        currencySymbols.add(Character.valueOf('\u20a5'));
        currencySymbols.add(Character.valueOf('\u20a6'));
        currencySymbols.add(Character.valueOf('\u20a8'));
        currencySymbols.add(Character.valueOf('\u20a9'));
        currencySymbols.add(Character.valueOf('\u20ab'));
        currencySymbols.add("R$");
        return currencySymbols;
    }

    public static StiFormatService getFormatService(JSONObject properties) throws JSONException {
        String type = properties.getString("type");
        if ("StiNumberFormatService".equals(type)) {
            StiNumberFormatService format = new StiNumberFormatService();
            format.setUseGroupSeparator(properties.tryGetBoolean("useGroupSeparator"));
            format.setUseLocalSetting(properties.tryGetBoolean("useLocalSetting"));
            format.setDecimalDigits(properties.tryGetInt("decimalDigits"));
            format.setDecimalSeparator(properties.tryGetString("decimalSeparator"));
            format.setGroupSeparator(properties.tryGetString("groupSeparator"));
            format.setGroupSize(properties.tryGetInt("groupSize"));
            format.setNegativePattern(properties.tryGetInt("numberNegativePattern"));
            format.setState(StiTextFormatHelper.getStateProperty(properties.tryGetString("state")));
            return format;
        }
        if ("StiCurrencyFormatService".equals(type)) {
            StiCurrencyFormatService format = new StiCurrencyFormatService();
            format.setUseGroupSeparator(properties.tryGetBoolean("useGroupSeparator"));
            format.setUseLocalSetting(properties.tryGetBoolean("useLocalSetting"));
            format.setDecimalDigits(properties.tryGetInt("decimalDigits"));
            format.setDecimalSeparator(properties.tryGetString("decimalSeparator"));
            format.setGroupSeparator(properties.tryGetString("groupSeparator"));
            format.setGroupSize(properties.tryGetInt("groupSize"));
            format.setPositivePattern(properties.tryGetInt("currencyPositivePattern"));
            format.setNegativePattern(properties.tryGetInt("currencyNegativePattern"));
            format.setSymbol(properties.tryGetString("currencySymbol"));
            format.setState(StiTextFormatHelper.getStateProperty(properties.tryGetString("state")));
            return format;
        }
        if ("StiDateFormatService".equals(type)) {
            StiDateFormatService format = new StiDateFormatService();
            format.setStringFormat(properties.tryGetString("dateFormat"));
            return format;
        }
        if ("StiTimeFormatService".equals(type)) {
            StiTimeFormatService format = new StiTimeFormatService();
            format.setStringFormat(properties.tryGetString("timeFormat"));
            return format;
        }
        if ("StiPercentageFormatService".equals(type)) {
            StiPercentageFormatService format = new StiPercentageFormatService();
            format.setUseGroupSeparator(properties.tryGetBoolean("useGroupSeparator"));
            format.setUseLocalSetting(properties.tryGetBoolean("useLocalSetting"));
            format.setDecimalDigits(properties.tryGetInt("decimalDigits"));
            format.setDecimalSeparator(properties.tryGetString("decimalSeparator"));
            format.setGroupSeparator(properties.tryGetString("groupSeparator"));
            format.setGroupSize(properties.tryGetInt("groupSize"));
            format.setPositivePattern(properties.tryGetInt("percentagePositivePattern"));
            format.setNegativePattern(properties.tryGetInt("percentageNegativePattern"));
            format.setSymbol(properties.tryGetString("percentageSymbol"));
            format.setState(StiTextFormatHelper.getStateProperty(properties.tryGetString("state")));
            return format;
        }
        if ("StiBooleanFormatService".equals(type)) {
            StiBooleanFormatService format = new StiBooleanFormatService();
            format.setFalseValue(properties.tryGetString("falseValue"));
            format.setFalseDisplay(properties.tryGetString("falseDisplay"));
            format.setTrueValue(properties.tryGetString("trueValue"));
            format.setTrueDisplay(properties.tryGetString("trueDisplay"));
            return format;
        }
        if ("StiCustomFormatService".equals(type)) {
            StiCustomFormatService format = new StiCustomFormatService();
            format.setStringFormat(properties.tryGetString("customFormat"));
            return format;
        }
        return new StiGeneralFormatService();
    }

    public static ArrayList<Hashtable<String, Object>> getDateAndTimeFormats(String category, StiFormatService service) {
        ArrayList<Hashtable<String, Object>> items = new ArrayList<Hashtable<String, Object>>();
        Set keys = ((Map)StiLocalization.getLocalization().languageProp.get("Formats")).keySet();
        for (String key : keys) {
            String value;
            if (key.indexOf(category) <= -1 || (value = StiLocalization.getValue((String)"Formats", (String)key)) == null) continue;
            try {
                Hashtable<String, String> item = new Hashtable<String, String>();
                if (value.length() > 0 && value.charAt(0) == '*') {
                    item.put("key", value.substring(1));
                    item.put("value", '*' + service.format(value.substring(1), service.getSample()));
                } else {
                    item.put("key", value);
                    item.put("value", service.format(value, service.getSample()));
                }
                items.add(item);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
        return items;
    }

    public static Hashtable<String, Object> getTextFormatItem(StiFormatService service) {
        if (service instanceof StiGeneralFormatService) {
            return StiTextFormatHelper.generalTextFormatItem((StiGeneralFormatService)service);
        }
        if (service instanceof StiPercentageFormatService) {
            return StiTextFormatHelper.percentageTextFormatItem((StiPercentageFormatService)service);
        }
        if (service instanceof StiCurrencyFormatService) {
            return StiTextFormatHelper.currencyTextFormatItem((StiCurrencyFormatService)service);
        }
        if (service instanceof StiNumberFormatService) {
            return StiTextFormatHelper.numberTextFormatItem((StiNumberFormatService)service);
        }
        if (service instanceof StiDateFormatService) {
            return StiTextFormatHelper.dateTextFormatItem((StiDateFormatService)service);
        }
        if (service instanceof StiTimeFormatService) {
            return StiTextFormatHelper.timeTextFormatItem((StiTimeFormatService)service);
        }
        if (service instanceof StiBooleanFormatService) {
            return StiTextFormatHelper.booleanTextFormatItem((StiBooleanFormatService)service);
        }
        if (service instanceof StiCustomFormatService) {
            return StiTextFormatHelper.customTextFormatItem((StiCustomFormatService)service);
        }
        return StiTextFormatHelper.commonTextFormatItem(service);
    }

    public static Hashtable<String, Object> getTextFormatItems() {
        Hashtable<String, Object> items = new Hashtable<String, Object>();
        for (StiFormatService service : StiOptions.Services.getFormats()) {
            items.put(service.getClass().getName().substring(service.getClass().getName().lastIndexOf(46) + 1), StiTextFormatHelper.getTextFormatItem(service));
        }
        return items;
    }
}

