/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.webdesigner.helper.StiEncodingHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class StiWebDesignerOptionsHelper {
    public static Hashtable<String, Object> getDefaultDesignerOptions() {
        Hashtable<String, Object> defaultOptions = new Hashtable<String, Object>();
        defaultOptions.put("showHeaders", true);
        defaultOptions.put("showRulers", true);
        defaultOptions.put("showOrder", false);
        defaultOptions.put("runDesignerAfterInsert", true);
        defaultOptions.put("useLastFormat", false);
        defaultOptions.put("showDimensionLines", true);
        defaultOptions.put("generateLocalizedName", false);
        defaultOptions.put("alignToGrid", true);
        defaultOptions.put("showGrid", true);
        defaultOptions.put("gridMode", "Lines");
        defaultOptions.put("gridSizeInch", "0.1");
        defaultOptions.put("gridSizeHundredthsOfInch", "10");
        defaultOptions.put("gridSizeCentimetres", "0.2");
        defaultOptions.put("gridSizeMillimeters", "2");
        defaultOptions.put("gridSizePixels", "8");
        defaultOptions.put("quickInfoType", "None");
        defaultOptions.put("quickInfoOverlay", true);
        defaultOptions.put("autoSaveInterval", "15");
        defaultOptions.put("enableAutoSaveMode", false);
        return defaultOptions;
    }

    public static Hashtable<String, Object> getDesignerOptions(HttpServletRequest httpContext) throws JSONException {
        Cookie[] cookies = httpContext.getCookies();
        Cookie mdo = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("StimulsoftMobileDesignerOptions")) continue;
                mdo = cookies[i];
                break;
            }
        }
        if (mdo != null) {
            String designerOptions = mdo.getValue();
            designerOptions = StiEncodingHelper.decodeString(designerOptions.replace("%3D", "="));
            return StiJSONHelper.jsonToHash((JSONObject)new JSONObject(designerOptions));
        }
        return StiWebDesignerOptionsHelper.getDefaultDesignerOptions();
    }

    public static void applyDesignerOptionsToReport(Hashtable<String, Object> designerOptions, StiReport report) throws Exception {
        if (designerOptions == null) {
            return;
        }
        for (String key : designerOptions.keySet()) {
            StiReportEdit.setPropertyValue(report, StiReportEdit.upperFirstChar(key), report.getInfo(), designerOptions.get(key));
        }
    }
}

