/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.servlet;

import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.web.servlet.StiServlet;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.StiWebDesignerHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StiWebDesignerActionServlet
extends StiServlet {
    private static final long serialVersionUID = 6328262305717281579L;
    protected static final Logger LOG = Logger.getLogger(StiWebDesignerActionServlet.class.getName());
    public static final String ACTION_PARAM = "a";
    public static final String AJAX_SERVLET_MAPPING = "stimulsoft_webdesigner_action";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processing(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processing(request, response);
    }

    private void processing(HttpServletRequest request, HttpServletResponse response) {
        try {
            String action = request.getParameter(ACTION_PARAM);
            StringBuffer jb = new StringBuffer();
            try {
                String line = null;
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    jb.append(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JSONObject jParameters = new JSONObject();
            if (jb.indexOf("&MvcMobileDesignerParameters=") == 0 && jb.length() > 32) {
                jParameters = new JSONObject(jb.substring("&MvcMobileDesignerParameters".length() + 1));
            }
            if (action != null) {
                String result = null;
                response.setHeader("X-UA-Compatible", "IE=Edge");
                if ("ReportTemplate".equals(action)) {
                    result = StiWebDesigner.getReportTemplateResult(request, StiWebDesigner.getReportObject(request, jParameters), jParameters);
                } else if ("DesignerEvent".equals(action)) {
                    if ("scripts".equals(request.getParameter("mvcmobiledesigner_resource"))) {
                        byte[] bytes = StiWebDesignerHelper.getDesignerScripts(null).getBytes(Charset.forName("UTF-8"));
                        response.setContentLength(bytes.length);
                        response.setContentType("text/javascript");
                        response.addHeader("Cache-Control", "public, max-age=31536000");
                        response.addHeader("Content-Length", String.valueOf(bytes.length));
                        StiIOUtil.writeInputStream((OutputStream)response.getOutputStream(), (InputStream)new ByteArrayInputStream(bytes));
                    } else {
                        result = StiWebDesigner.designerEventResult(request, response, jParameters);
                        JSONObject parameterJSON = jParameters;
                        Hashtable parameters = StiJSONHelper.jsonToHash((JSONObject)parameterJSON);
                        if (parameters.containsKey("command") && "PreviewAs".equals(parameters.get("command"))) {
                            if ("pdf".equals(parameterJSON.getString("format"))) {
                                response.setContentType("application/pdf");
                            } else {
                                response.setContentType("text/html");
                            }
                        } else if (parameters.containsKey("command") && "DownloadStyles".equals(parameters.get("command"))) {
                            response.setHeader("Content-Disposition", "attachment; filename=\"Styles.sts\"");
                            response.addHeader("Content-Length", String.valueOf(result.length()));
                            response.setContentType("text/html");
                        }
                    }
                } else if ("SaveReportTemplate".equals(action) || "SaveAsReportTemplate".equals(action)) {
                    result = StiWebDesigner.saveReportTemplateResult(request, jParameters);
                    StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)result);
                } else if ("OpenReportTemplate".equals(action)) {
                    result = StiWebDesigner.openReportTemplateResult(request, jParameters);
                } else if ("GetNewReportData".equals(action)) {
                    result = StiWebDesigner.getNewReportDataResult(request, jParameters);
                } else if ("ReportSnapshot".equals(action)) {
                    result = StiWebDesigner.getReportSnapshotResult(request, jParameters);
                } else if ("ExportReport".equals(action)) {
                    StiReport report = StiWebDesigner.getReportObject(request, new JSONObject("{reportGuid: " + request.getParameter("stimulsoft_reportguid") + "}"));
                    StiWebDesigner.previewReport(report, request.getParameter("stimulsoft_export"), response);
                } else if (StiValidationUtil.isNotNullOrEmpty((String)action) && action.startsWith("RefreshSession")) {
                    StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)"{}");
                }
                if (result != null) {
                    StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)result);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "", e);
            try {
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                e.printStackTrace(ps);
            }
            catch (IOException e1) {
                LOG.log(Level.SEVERE, "", e);
            }
        }
    }
}

