
StiMobileDesigner.prototype.FindPosX = function (obj, mainClassName, noScroll) {
    var curleft = noScroll ? 0 : this.GetScrollXOffset(obj, mainClassName);
    if (obj.offsetParent) {
        while (obj.className != mainClassName) {            
            curleft += obj.offsetLeft;
            if (!obj.offsetParent) {
                break;
            }
            obj = obj.offsetParent;
            
        }
    } else if (obj.x) {
        curleft += obj.x;
    }
    return curleft;
}

StiMobileDesigner.prototype.FindPosY = function (obj, mainClassName, noScroll, mainElement) {
    var curtop = noScroll ? 0 : this.GetScrollYOffset(obj, mainClassName, mainElement);
    if (obj.offsetParent) {
        while (mainClassName ? obj.className != mainClassName : obj != mainElement) {
            curtop += obj.offsetTop;
            if (!obj.offsetParent) {
                break;
            }
            obj = obj.offsetParent;
        }
    } else if (obj.y) {
        curtop += obj.y;
    }
    return curtop;
}

StiMobileDesigner.prototype.GetScrollXOffset = function (obj, mainClassName) {
    var scrollleft = 0;
    if (obj.parentElement) {
        while (obj.className != mainClassName) {
            if ("scrollLeft" in obj) { scrollleft -= obj.scrollLeft }
            if (!obj.parentElement) {
                break;
            }
            obj = obj.parentElement;
        }
    }
    
    return scrollleft;
}

StiMobileDesigner.prototype.GetScrollYOffset = function (obj, mainClassName, mainElement) {
    var scrolltop = 0;
    if (obj.parentElement) {
        while (mainClassName ? obj.className != mainClassName : obj != mainElement) {
            if ("scrollTop" in obj) { scrolltop -= obj.scrollTop }
            if (!obj.parentElement) {
                break;
            }
            obj = obj.parentElement;
        }
    }
    
    return scrolltop;
}

StiMobileDesigner.prototype.FindPagePositions = function () {
    var body = document.getElementsByTagName('BODY')[0];
    var scrollTopDocument = document.documentElement.scrollTop == 0 ? body.scrollTop : document.documentElement.scrollTop;
    var scrollLeftDocument = document.documentElement.scrollLeft == 0 ? body.scrollLeft : document.documentElement.scrollLeft;

    var posXPaintPanel = this.FindPosX(this.options.paintPanel, null, true) - scrollLeftDocument;
    var posYPaintPanel = this.FindPosY(this.options.paintPanel, null, true) - scrollTopDocument;

    var scrollTopPaintPanel = this.options.paintPanel.scrollTop;
    var scrollLeftPaintPanel = this.options.paintPanel.scrollLeft;
    
    return { 
        posX: posXPaintPanel - scrollLeftPaintPanel + this.options.paintPanelPadding + 1,
        posY: posYPaintPanel - scrollTopPaintPanel + this.options.paintPanelPadding + 1
     }
}

StiMobileDesigner.prototype.FindMousePosOnSvgPage = function (page, evnt) {
    var pagePositions = this.FindPagePositions();
    var mouseClientX = 0;
    var mouseClientY = 0;

    if (evnt) {
        if (evnt.touches != null) {
            mouseClientX = evnt.touches[0].pageX;
            mouseClientY = evnt.touches[0].pageY;
        }
        else {
            mouseClientX = evnt.clientX || evnt.x;
            mouseClientY = evnt.clientY || evnt.y;
        }
    }

    var point = {};
    point.xUnits = this.ConvertPixelToUnit((mouseClientX - pagePositions.posX - page.marginsPx[0]) / this.options.report.zoom);
    point.yUnits = this.ConvertPixelToUnit((mouseClientY - pagePositions.posY - page.marginsPx[1]) / this.options.report.zoom);
    point.xPixels = parseInt(mouseClientX - pagePositions.posX);
    point.yPixels = parseInt(mouseClientY - pagePositions.posY);

    return point;
}

StiMobileDesigner.prototype.FindMousePosOnMainPanel = function (evnt) {
    var body = document.getElementsByTagName('BODY')[0];
    var scrollTopDocument = document.documentElement.scrollTop == 0 ? body.scrollTop : document.documentElement.scrollTop;
    var scrollLeftDocument = document.documentElement.scrollLeft == 0 ? body.scrollLeft : document.documentElement.scrollLeft;    
    
    var posXMainPanel = this.FindPosX(this.options.mainPanel, null, true) - scrollLeftDocument;
    var posYMainPanel = this.FindPosY(this.options.mainPanel, null, true) - scrollTopDocument;

    var mouseClientX = 0;
    var mouseClientY = 0;

    if (evnt.touches != null) {
        mouseClientX = evnt.touches[0].pageX;
        mouseClientY = evnt.touches[0].pageY;
    }
    else {
        mouseClientX = evnt.clientX || evnt.x;
        mouseClientY = evnt.clientY || evnt.y;
    }

    var point = {};
    point.xPixels = parseInt(mouseClientX - posXMainPanel);
    point.yPixels = parseInt(mouseClientY - posYMainPanel);

    return point;
}


