﻿
StiMobileDesigner.prototype.DataTree = function (width, height) {
    var dataTree = this.Tree();
    if (width) dataTree.style.width = width + "px";
    if (height) dataTree.style.height = height + "px";
    dataTree.style.padding = "12px";
    dataTree.key = "";
    dataTree.selectingItemType = "Column";

    dataTree.build = function (selectingItemType, dataSourceName, allowDragDrop) {
        this.clear();
        this.allowDragDrop = allowDragDrop;
        this.selectingItemType = (selectingItemType) ? selectingItemType : "Column";
        this.mainItem = this.jsObject.DataTreeItem("Main", "", { "typeItem": "MainItem" }, dataTree);
        this.mainItem.childsRow.style.display = "";
        this.mainItem.button.style.display = "none";
        this.mainItem.iconOpening.style.display = "none";
        this.appendChild(this.mainItem);
        this.noneItem = this.jsObject.DataTreeItem(this.jsObject.loc.FormFormatEditor.nameNo, "ItemNo.png", { "typeItem": "NoItem" }, dataTree);
        this.mainItem.addChild(this.noneItem);
        this.noneItem.setSelected();
        if (dataSourceName == "[Not Assigned]") return;
        if (this.jsObject.options.report == null) return;
        var dictionary = this.jsObject.options.report.dictionary;
        if (dictionary == null) return;
        if (dataSourceName != null) {
            var dataSource = this.jsObject.GetDataSourceByNameFromDictionary(dataSourceName);
            if (!dataSource) dataSource = this.jsObject.GetBusinessObjectByNameFromDictionary(dataSourceName);
            if (dataSource) this.addTreeItems([dataSource], this.mainItem);
        }
        else {
            if (selectingItemType != "BusinessObject") this.addTreeItems(dictionary.databases, this.mainItem);
            this.addItemsByCategories(dictionary.businessObjects, this.mainItem);
        }
    }

    //Add Tree Items
    dataTree.addTreeItems = function (collection, parentItem) {
        if (collection) {

            var tempArray = [];
            collection.sort(this.jsObject.SortByName);
            for (var i = 0; i < collection.length; i++) {
                if (collection[i].typeItem != "DataBase") var childItem = parentItem.addChild(this.jsObject.DataTreeItemFromObject(collection[i], dataTree));
                var childCollection;
                switch (collection[i].typeItem) {
                    case "DataBase": { childCollection = collection[i].dataSources; childItem = parentItem; break; }
                    case "DataSource": { childCollection = collection[i].relations; break; }
                    case "Relation": { childCollection = collection[i].relations; break; }
                    case "BusinessObject": { childCollection = collection[i].businessObjects; break; }
                }
                this.addTreeItems(childCollection, childItem);
            }

            if (parentItem.itemObject["columns"]) { this.addColumns(parentItem, parentItem.itemObject["columns"]); return; }
            if (parentItem.itemObject.typeItem == "Relation") {
                var dataSource = this.jsObject.GetDataSourceByNameFromDictionary(parentItem.itemObject.parentDataSource);
                if (dataSource) this.addColumns(parentItem, dataSource.columns);
            }
        }
    }

    //Add Items by Categories
    dataTree.addItemsByCategories = function (collection, parentItem) {
        for (var nameCategory in collection["Categories"]) {
            this.addTreeItems(collection["Categories"][nameCategory], parentItem);
        }
        this.addTreeItems(collection["MainCategory"], parentItem);
    }

    dataTree.addColumns = function (item, columns) {
        if (columns) {
            for (var i = 0; i < columns.length; i++) {
                var columnItem = this.jsObject.DataTreeItemFromObject(columns[i], dataTree);
                item.addChild(columnItem);

                if (this.allowDragDrop) {
                    //Touch Start
                    columnItem.button.ontouchstart = function (event, mouseProcess) {
                        var this_ = this;
                        this.isTouchStartFlag = mouseProcess ? false : true;
                        clearTimeout(this.isTouchStartTimer);

                        if (event) event.preventDefault();
                        this.action();

                        if (event.button != 2) {
                            var itemInDragObject = this.jsObject.TreeItemIconForDragDrop(this.treeItem.itemObject, this.treeItem.tree);
                            var fullName = "";
                            var currItem = this.treeItem;
                            while (currItem.parent != null) {
                                if (fullName != "") fullName = "." + fullName;
                                fullName = (currItem.itemObject.correctName || currItem.itemObject.name) + fullName;
                                if (currItem.itemObject.typeItem == "BusinessObject" && currItem.parent != null &&
                                currItem.parent.itemObject.typeItem != "BusinessObject" || currItem.itemObject.typeItem == "DataSource") break;
                                currItem = currItem.parent;
                            }
                            itemInDragObject.itemObject.columnFullName = fullName;
                            
                            itemInDragObject.originalItem = this.treeItem;
                            itemInDragObject.beginingOffset = 0;
                            this.jsObject.options.itemInDrag = itemInDragObject;
                        }

                        this.isTouchStartTimer = setTimeout(function () {
                            this_.isTouchStartFlag = false;
                        }, 1000);
                    }

                    //Mouse Down
                    columnItem.button.onmousedown = function (event) {
                        if (this.isTouchStartFlag) return;
                        this.ontouchstart(event, true);
                    }
                }
            }
        }
    }

    dataTree.onSelectedItem = function (item) {
        var typeItem = item.itemObject.typeItem;
        if (typeItem == "NoItem" || typeItem != dataTree.selectingItemType) {
            this.key = "";
        }
        else {
            this.key = item.getFullName();
        }
    }

    dataTree.selectItemByFullName = function (fullName) {
        var nameArray = fullName.split(".");
        var parentItem = this.mainItem;
        if (!parentItem) return false;
        for (var i in nameArray) {
            parentItem = parentItem.getChildByName(nameArray[i], true);
            if (!parentItem) return false;
        }
        parentItem.setSelected();
        parentItem.openTree();
        return true;
    };

    dataTree.setKey = function (key) {
        this.key = key;
        if (this.key == "") {
            if (this.noneItem) this.noneItem.setSelected();
            return false;
        }
        return this.selectItemByFullName(key);
    }

    dataTree.action = function () {
    };

    return dataTree;
}

StiMobileDesigner.prototype.DataTreeItem = function (caption, imageName, itemObject, tree, showCheckBox) {
    var dataTreeItem = this.TreeItem(caption, imageName, itemObject, tree, showCheckBox);

    dataTreeItem.getBusinessObjectFullName = function () {
        var currItem = this;
        var fullName = [];
        while (currItem.parent != null) {
            if (currItem.itemObject.typeItem == "BusinessObject") {
                fullName.push(currItem.itemObject.name);
            }
            currItem = currItem.parent;
        }

        return fullName;
    }

    dataTreeItem.button.ondblclick = function () {
        tree.onSelectedItem(dataTreeItem);
        tree.action();
    }

    return dataTreeItem;
}

StiMobileDesigner.prototype.DataTreeItemFromObject = function (itemObject, tree) {
    var dataTreeItem = this.DataTreeItem(
            itemObject.typeItem == "DataBase" ? itemObject.nameInSource : this.options.dictionaryTree.getItemCaption(itemObject.name, itemObject.alias),
            itemObject.typeIcon + ".png", itemObject, tree);

    return dataTreeItem;
}