﻿
StiMobileDesigner.prototype.TextAreaWithEditButton = function (name, width, height, readOnly) {

    var textAreaWithButton = this.CreateHTMLTable();
    textAreaWithButton.textArea = this.TextArea(name, width, height);
    textAreaWithButton.addCell(textAreaWithButton.textArea);

    textAreaWithButton.button = this.SmallButton(name + "Button", null, null, "TextEditButton.png", this.loc.QueryBuilder.Edit, null, this.GetStyles("FormButton"), true);
    //Override
    textAreaWithButton.button.style.width = this.options.isTouchDevice ? "26px" : "21px";
    textAreaWithButton.button.style.height = this.options.isTouchDevice ? "26px" : "21px";
    textAreaWithButton.button.innerTable.style.width = "100%";
    textAreaWithButton.button.textArea = textAreaWithButton.textArea;
    var buttonCell = textAreaWithButton.addCell(textAreaWithButton.button);
    buttonCell.style.verticalAlign = "top";
    textAreaWithButton.button.style.marginLeft = "4px";

    if (readOnly) {
        textAreaWithButton.textArea.readOnly = readOnly;
        textAreaWithButton.textArea.style.cursor = "default";
        textAreaWithButton.textArea.mainControl = textAreaWithButton;
        
        textAreaWithButton.textArea.onclick = function () {
            if (!this.isTouchEndFlag && !this.jsObject.options.isTouchClick) 
                this.mainControl.button.onclick();
        }

        textAreaWithButton.textArea.ontouchend = function () {
            var this_ = this;
            this.isTouchEndFlag = true;
            clearTimeout(this.isTouchEndTimer);
            this.mainControl.button.ontouchend();
            this.isTouchEndTimer = setTimeout(function () {
                this_.isTouchEndFlag = false;
            }, 1000);
        }
    }

    return textAreaWithButton;
}