﻿
StiMobileDesigner.prototype.TextBoxWithEditButton = function (name, width, height, readOnly) {
    var textBoxWithButton = this.CreateHTMLTable();
    textBoxWithButton.style.borderCollapse = "separate";
    var buttonWidth = this.options.isTouchDevice ? 23 : 15;
    var textBoxWidth = width - (buttonWidth + 1);
    textBoxWithButton.textBox = this.TextBox(name, textBoxWidth, height);
    textBoxWithButton.textBox.mainControl = textBoxWithButton;
    textBoxWithButton.addCell(textBoxWithButton.textBox).style.fontSize = "0px";

    textBoxWithButton.button = this.StandartSmallButton(name + "Button", null, null, "TextEditButton.png", this.loc.QueryBuilder.Edit, null);
    textBoxWithButton.button.textBox = textBoxWithButton.textBox;

    //Override
    textBoxWithButton.button.innerTable.style.width = "100%";
    textBoxWithButton.button.style.width = buttonWidth + "px";
    if (height) textBoxWithButton.button.style.height = (this.options.isTouchDevice ? height + 5 : height) + "px";
    else textBoxWithButton.button.style.height = this.options.isTouchDevice ? "26px" : "21px";
    var buttonCell = textBoxWithButton.addCell(textBoxWithButton.button);
    buttonCell.className = "stiDesignerTextBoxEditButton";

    if (readOnly) {
        textBoxWithButton.textBox.readOnly = readOnly;
        textBoxWithButton.textBox.style.cursor = "default";
        textBoxWithButton.textBox.onclick = function () { if (!this.jsObject.options.isTouchDevice) this.mainControl.button.onclick(); }
        textBoxWithButton.textBox.ontouchend = function () { this.mainControl.button.ontouchend(); }
    }

    textBoxWithButton.action = function () { };

    textBoxWithButton.textBox.action = function () { textBoxWithButton.action(); }

    textBoxWithButton.setEnabled = function (state) {
        this.textBox.setEnabled(state);
        this.button.setEnabled(state);
        buttonCell.className = state ? "stiDesignerTextBoxEditButton" : "stiDesignerTextBoxEditButtonDisabled";
    }

    return textBoxWithButton;
}

StiMobileDesigner.prototype.DinamicTextBoxWithEditButton = function (name, width, height, readOnly) {
    var textBox = this.TextBoxWithEditButton(name, width, height, readOnly);
    delete this.options.controls[name];
    delete this.options.buttons[name + "Button"];

    return textBox;
}

StiMobileDesigner.prototype.ExpressionTextBox = function (name, width, height, readOnly) {
    var textBox = this.TextBoxWithEditButton(name, width, height, readOnly);
     
    textBox.button.action = function () {
        var this_ = this;
        this.jsObject.InitializeTextEditorFormOnlyText(function (textEditorOnlyText) {
            textEditorOnlyText.controlTextBox = this_.textBox;

            textEditorOnlyText.showFunction = function () {
                this.textArea.value = this.controlTextBox.value;
            }

            textEditorOnlyText.actionFunction = function () {
                this.controlTextBox.value = this.textArea.value;
                textBox.action();
            }

            textEditorOnlyText.changeVisibleState(true);
        });
    }

    return textBox;
}

StiMobileDesigner.prototype.ExpressionFromDictionaryTextBox = function (name, width, height, readOnly) {
    var textBox = this.TextBoxWithEditButton(name, width, height, readOnly);

    textBox.button.action = function () {
        var this_ = this;
        this.jsObject.InitializeTextEditorForm(function (textEditorForm) {
            textEditorForm.controlTextBox = this_.textBox;

            textEditorForm.showFunction = function () {
                this.container.style.visibility = "visible";                
                this.mainButtons.SummaryText.style.display = "none";
                this.mainButtons.DataColumn.style.display = "none";
                this.mainButtons.SystemVariable.style.display = "none";                
                this.jsObject.options.propertiesPanel.setDictionaryMode(true);
                this.setMode("Expression");
                this.expressionTextArea.focus();
                this.expressionTextArea.value = this.controlTextBox.value;
            }

            textEditorForm.actionFunction = function () {
                this.controlTextBox.value = this.expressionTextArea.value;
                textBox.action();
            }

            textEditorForm.changeVisibleState(true);
        });
    }

    return textBox;
}


