﻿
StiMobileDesigner.prototype.DictionaryPanel = function () {
    var dictionaryPanel = document.createElement("div");
    dictionaryPanel.jsObject = this;
    dictionaryPanel.className = "stiDesignerPropertiesPanelInnerContent";
    this.options.dictionaryPanel = dictionaryPanel;
    dictionaryPanel.style.top = "35px";

    //Main Dictionary
    dictionaryPanel.mainDictionary = document.createElement("div");
    dictionaryPanel.appendChild(dictionaryPanel.mainDictionary);

    //Dictionary Toolbar
    dictionaryPanel.toolBar = this.CreateHTMLTable();
    dictionaryPanel.toolBar.jsObject = this;
    dictionaryPanel.toolBar.controls = {};
    dictionaryPanel.mainDictionary.appendChild(dictionaryPanel.toolBar);

    dictionaryPanel.toolBar.updateControls = function (currentMenu) {
        if (this.jsObject.options.dictionaryTree.selectedItem == null) return;
        var selectedItemObject = this.jsObject.options.dictionaryTree.selectedItem.itemObject;

        //Permissions
        var permissionDataSources = this.jsObject.options.permissionDataSources;
        var permissionDataConnections = this.jsObject.options.permissionDataConnections;
        var permissionBusinessObjects = this.jsObject.options.permissionBusinessObjects;
        var permissionVariables = this.jsObject.options.permissionVariables;
        var permissionDataRelations = this.jsObject.options.permissionDataRelations;
        var permissionDataColumns = this.jsObject.options.permissionDataColumns;

        var getPermissionResult = function (selectedItemObject, permissionType) {
            return (selectedItemObject.typeItem == "DataBase" && !(permissionDataConnections.indexOf("All") >= 0 || permissionDataConnections.indexOf(permissionType) >= 0)) ||
            (selectedItemObject.typeItem == "DataSource" && !(permissionDataSources.indexOf("All") >= 0 || permissionDataSources.indexOf(permissionType) >= 0)) ||
            (selectedItemObject.typeItem == "BusinessObject" && !(permissionBusinessObjects.indexOf("All") >= 0 || permissionBusinessObjects.indexOf(permissionType) >= 0)) ||
            (selectedItemObject.typeItem == "Variable" && !(permissionVariables.indexOf("All") >= 0 || permissionVariables.indexOf(permissionType) >= 0)) ||
            (selectedItemObject.typeItem == "Relation" && !(permissionDataRelations.indexOf("All") >= 0 || permissionDataRelations.indexOf(permissionType) >= 0)) ||
            (selectedItemObject.typeItem == "Column" && !(permissionDataColumns.indexOf("All") >= 0 || permissionDataColumns.indexOf(permissionType) >= 0))
        }

        var cannotEdit = getPermissionResult(selectedItemObject, "Modify");
        var cannotDelete = getPermissionResult(selectedItemObject, "Delete");

        //Enabled or Disabled Buttons
        var enableEdit = !(selectedItemObject.typeItem.indexOf("MainItem") != -1 || selectedItemObject.isCloud ||
            (selectedItemObject.typeItem == "DataBase" && selectedItemObject.typeIcon == "ConnectionFail"))
            && selectedItemObject.typeItem != "SystemVariable" && selectedItemObject.typeItem != "Function" &&
            selectedItemObject.typeItem != "FunctionsCategory" && selectedItemObject.typeItem != "Parameters";

        this.controls["EditItem"].setEnabled(enableEdit && !cannotEdit);
        this.controls["DeleteItem"].setEnabled(enableEdit && !cannotDelete);

        var showColumnItem = (selectedItemObject.typeItem == "DataSource" || selectedItemObject.typeItem == "BusinessObject"
            || selectedItemObject.typeItem == "Column") && !selectedItemObject.isCloud &&
            (permissionDataColumns.indexOf("All") >= 0 || permissionDataColumns.indexOf("Create") >= 0);

        var showParameterItem = ((selectedItemObject.typeItem == "DataSource" && selectedItemObject.parameterTypes) ||
            selectedItemObject.typeItem == "Parameter" || selectedItemObject.typeItem == "Parameters" ||
            (selectedItemObject.typeItem == "Column" || this.jsObject.options.dictionaryTree.getCurrentColumnParent().parameterTypes) &&
            !selectedItemObject.isCloud && (permissionDataColumns.indexOf("All") >= 0 || permissionDataColumns.indexOf("Create") >= 0));

        if (currentMenu) {
            if (currentMenu.items["editItem"]) currentMenu.items["editItem"].setEnabled(enableEdit && !cannotEdit);
            if (currentMenu.items["deleteItem"]) currentMenu.items["deleteItem"].setEnabled(enableEdit && !cannotDelete);

            currentMenu.items["columnNew"].style.display = showColumnItem ? "" : "none";
            currentMenu.items["calcColumnNew"].style.display = showColumnItem ? "" : "none";
            currentMenu.items["parameterNew"].style.display = showParameterItem && !this.jsObject.options.jsMode ? "" : "none";
            currentMenu.items["dataSourceNew"].style.display =
                ((permissionDataSources.indexOf("All") >= 0 || permissionDataSources.indexOf("Create") >= 0) &&
                (permissionDataConnections.indexOf("All") >= 0 || permissionDataConnections.indexOf("Create") >= 0)) ? "" : "none";
            currentMenu.items["separator1"].style.display = currentMenu.items["dataSourceNew"].style.display;
            if (!this.jsObject.options.isJava) {
                currentMenu.items["businessObjectNew"].style.display = (permissionBusinessObjects.indexOf("All") >= 0 || permissionBusinessObjects.indexOf("Create") >= 0) ? "" : "none";
            }
            currentMenu.items["relationNew"].style.display = (permissionDataRelations.indexOf("All") >= 0 || permissionDataRelations.indexOf("Create") >= 0) ? "" : "none";
            currentMenu.items["variableNew"].style.display = (permissionVariables.indexOf("All") >= 0 || permissionVariables.indexOf("Create") >= 0) ? "" : "none";
            currentMenu.items["categoryNew"].style.display = currentMenu.items["variableNew"].style.display;
            currentMenu.items["separator2"].style.display = currentMenu.items["variableNew"].style.display;

            if (currentMenu.items["separator3_0"] && currentMenu.items["viewData"]) {
                currentMenu.items["separator3_0"].style.display = selectedItemObject.typeItem == "DataSource" ? "" : "none";
                currentMenu.items["viewData"].style.display = selectedItemObject.typeItem == "DataSource" ? "" : "none";
            }
        }
        if (currentMenu && currentMenu == this.jsObject.options.menus.dictionaryNewItemMenu) {
            var hideParentButton = true;
            for (var i in currentMenu.items) {
                if (currentMenu.items[i].style.display == "") hideParentButton = false;
            }
            this.controls["NewItem"].style.display = hideParentButton ? "none" : "";
        }
    }

    var buttons = [
        ["NewItem", null, "NewItem.png", this.loc.FormDictionaryDesigner.NewItem, "Down"],
        ["EditItem", null, "Edit.png", this.loc.QueryBuilder.Edit, null],
        ["DeleteItem", null, "Remove.png", this.loc.MainMenu.menuEditDelete.replace("&", ""), null]
    ]

    for (var i in buttons) {
        var dictionaryToolbarButton =
            this.SmallButton("dictionary" + buttons[i][0], null, buttons[i][1], buttons[i][2], buttons[i][1] || buttons[i][3], buttons[i][4], this.GetStyles("StandartSmallButton"));
        dictionaryPanel.toolBar.controls[buttons[i][0]] = dictionaryToolbarButton;
        dictionaryToolbarButton.style.margin = this.options.isTouchDevice ? "3px 0px 3px 3px" : "5px 0px 5px 5px";
        dictionaryPanel.toolBar.addCell(dictionaryToolbarButton);
    }

    dictionaryPanel.toolBar.controls["NewItem"].action = function () {
        var dictionaryNewItemMenu = this.jsObject.options.menus.dictionaryNewItemMenu || this.jsObject.InitializeDictionaryNewItemMenu();
        if (!dictionaryNewItemMenu.visible) dictionaryPanel.toolBar.updateControls(dictionaryNewItemMenu);
        dictionaryNewItemMenu.changeVisibleState(!dictionaryNewItemMenu.visible);
    }
    dictionaryPanel.toolBar.controls["EditItem"].action = function () { this.jsObject.EditItemDictionaryTree(); }
    dictionaryPanel.toolBar.controls["DeleteItem"].action = function () { this.jsObject.DeleteItemDictionaryTree(); }

    //Dictionary Separator
    var dictionarySeparator = document.createElement("div");
    dictionarySeparator.className = "stiDesignerDictionarySeparator";
    dictionaryPanel.mainDictionary.appendChild(dictionarySeparator);

    //Items Container
    var dictionaryItemsContainer = document.createElement("div");
    dictionaryItemsContainer.className = "stiDesignerDictionaryItemsContainer";
    dictionaryItemsContainer.style.top = this.options.isTouchDevice ? "35px" : "34px";
    dictionaryPanel.mainDictionary.appendChild(dictionaryItemsContainer);
    dictionaryItemsContainer.appendChild(this.DictionaryTree());

    dictionaryPanel.onmouseup = function (event) {
        if (event.button == 2) {
            event.stopPropagation();
            if (!this.jsObject.options.report) return;
            var dictionaryContextMenu = this.jsObject.options.menus.dictionaryContextMenu || this.jsObject.InitializeDictionaryContextMenu();
            dictionaryPanel.toolBar.updateControls(dictionaryContextMenu);
            var point = this.jsObject.FindMousePosOnMainPanel(event);
            dictionaryContextMenu.show(point.xPixels + 3, point.yPixels + 3, "Down", "Right");
        }
        return false;
    }

    dictionaryPanel.oncontextmenu = function (event) {
        return false;
    }    

    return dictionaryPanel;
}
