﻿
StiMobileDesigner.prototype.InitializeOpenPanel = function () {
    var openPanel = document.createElement("div");
    openPanel.jsObject = this;
    this.options.openPanel = openPanel;
    this.options.mainPanel.appendChild(openPanel);
    openPanel.style.display = "none";
    openPanel.className = "stiDesignerNewReportPanel";
    openPanel.style.overflow = "auto";
    var jsObject = this;

    var header = this.FileMenuPanelHeader(this.loc.MainMenu.menuFileOpen.replace("&", "").replace("...", ""));
    openPanel.appendChild(header);

    var mainTable = this.CreateHTMLTable();
    openPanel.appendChild(mainTable);
    mainTable.style.margin = "10px 30px 0px 30px";
    mainTable.style.height = "calc(100% - 130px)";

    var mainButtonsTable = this.CreateHTMLTable();
    mainTable.addCell(mainButtonsTable).className = "wizardFormStepsPanel";

    var additionalCell = mainTable.addCell();
    additionalCell.style.verticalAlign = "top";

    //Import
    var importButtonsTable = this.CreateHTMLTable();
    importButtonsTable.style.display = "none";
    additionalCell.appendChild(importButtonsTable);

    var importButtons = [];
    importButtons.push(["ActiveReports", "Active Reports", "Open.ImportFiles.png"]);
    importButtons.push(["ComponentOneReports", "ComponentOne Reports", "Open.ImportFiles.png"]);
    importButtons.push(["CrystalReports", "Crystal Reports", "Open.ImportFiles.png"]);
    importButtons.push(["FastReports", "FastReport.Net", "Open.ImportFiles.png"]);
    importButtons.push(["ReportSharpShooter", "Report SharpShooter", "Open.ImportFiles.png"]);
    importButtons.push(["RichText", "Rich Text Format", "Open.ImportFiles.png"]);
    importButtons.push(["ReportingServices", "Reporting Services", "Open.ImportFiles.png"]);
    importButtons.push(["TelerikReports", "Telerik Reporting", "Open.ImportFiles.png"]);
    importButtons.push(["VisualFoxPro", "Visual FoxPro", "Open.ImportFiles.png"]);
    //importButtons.push(["XtraReports", "XtraReports", "Open.ImportFiles.png"]);
    
    for (var i = 0; i < importButtons.length; i++) {
        var button = this.RecentPanelButton(importButtons[i][0], null, importButtons[i][1], importButtons[i][2]);
        button.style.margin = "0px 10px 3px 10px";
        importButtonsTable.addCellInNextRow(button);

        button.action = function () {
            if (this.name == "VisualFoxPro") {
                jsObject.ActionImportFile(this.name);
            }
            else {
                var this_ = this;
                var fileMenu = jsObject.options.menus.fileMenu || jsObject.InitializeFileMenu();
                fileMenu.changeVisibleState(false);
                setTimeout(function () {
                    jsObject.ActionImportFile(this_.name);
                }, 200);
            }
        }
    }

    //Main Buttons
    var mainButtons = [];
    mainButtons.push(["recentFiles", this.loc.FormDatabaseEdit.RecentConnections, "Open.RecentFiles.png"]);
    mainButtons.push(["importFiles", this.loc.ReportOpen.Import, "Open.ImportFiles.png"]);
    mainButtons.push(["browseFiles", this.loc.ReportOpen.Browse, "Open.OpenFiles.png"]);
                       
    for (var i = 0; i < mainButtons.length; i++) {
        var button = this.RecentPanelButton(mainButtons[i][0], "RecentMainButtons", mainButtons[i][1], mainButtons[i][2]);
        button.style.marginBottom = "3px";
        mainButtonsTable.addCellInNextRow(button);

        button.action = function () {            
            this.setSelected(true);

            switch (this.name) {
                case "recentFiles": {
                    importButtonsTable.style.display = "none";
                    if (openPanel.recentButtonsTable) openPanel.recentButtonsTable.style.display = "";
                    break;
                }
                case "importFiles": {
                    importButtonsTable.style.display = "";
                    if (openPanel.recentButtonsTable) openPanel.recentButtonsTable.style.display = "none";
                    break;
                }
                case "browseFiles": {
                    var fileMenu = jsObject.options.menus.fileMenu || jsObject.InitializeFileMenu();
                    fileMenu.changeVisibleState(false);
                    setTimeout(function () { jsObject.ActionOpenReport(); }, 200);
                    break;
                }
            }
        }
    }   
    
    openPanel.changeVisibleState = function (state) {
        this.style.display = state ? "" : "none";
        if (state) {
            //Recent
            jsObject.options.buttons.recentFiles.action();
            
            if (openPanel.recentButtonsTable) additionalCell.removeChild(openPanel.recentButtonsTable);
            openPanel.recentButtonsTable = jsObject.CreateHTMLTable();
            additionalCell.appendChild(openPanel.recentButtonsTable);

            var recentArray = jsObject.GetRecentArray();

            for (var i = 0; i < recentArray.length; i++) {
                var icon = "Open.ReportFileMrt.png";
                if (jsObject.EndsWith(recentArray[i].name.toString().toLowerCase(), ".mrx")) icon = "Open.ReportFileMrx.png";
                else if (jsObject.EndsWith(recentArray[i].name.toString().toLowerCase(), ".mrz")) icon = "Open.ReportFileMrz.png";

                var button = jsObject.RecentPanelButton(null, null, recentArray[i].name + "<br>" + recentArray[i].path, icon);
                button.style.margin = "0px 10px 3px 10px";
                button.fileObject = recentArray[i];
                openPanel.recentButtonsTable.addCellInNextRow(button);

                button.action = function () {
                    var this_ = this;
                    var fileMenu = jsObject.options.menus.fileMenu || jsObject.InitializeFileMenu();
                    fileMenu.changeVisibleState(false);                    
                    setTimeout(function () {
                        jsObject.ActionOpenRecentFile(this_.fileObject);
                    }, 200);
                }
            }
        }
    }

    return openPanel;
}

StiMobileDesigner.prototype.RecentPanelButton = function (name, groupName, caption, image) {
    var button = this.SmallButton(name, groupName, caption, image, caption, null, this.GetStyles("StandartSmallButton"), true);
    if (button.imageCell) button.imageCell.style.padding = "0 10px 0 10px";
    if (button.caption) {
        button.caption.style.padding = "0 20px 0 10px";
        button.caption.style.lineHeight = "1.4";
    }
    button.style.minWidth = "250px";
    button.style.height = "50px";
        
    return button;
}

StiMobileDesigner.prototype.ActionOpenRecentFile = function (fileObject) {}

StiMobileDesigner.prototype.ActionImportFile = function (importType) {}