﻿
StiMobileDesigner.prototype.InitializeEasyImageForm_ = function () {
    //Image Form
    var easyImageForm = this.BaseForm("easyImageForm", this.loc.PropertyCategory.ImageCategory, 2, this.HelpLinks["image"]);
    easyImageForm.resultControlName = "";

    var toolBarImageSrc = this.CreateHTMLTable();
    easyImageForm.container.appendChild(toolBarImageSrc);
    easyImageForm.container.style.padding = "0px";

    var sep1 = document.createElement("Div");
    sep1.className = "stiDesignerImageFormSeparator";
    easyImageForm.container.appendChild(sep1);

    var openText = this.loc.MainMenu.menuFileOpen.replace("&", "").replace("...", "");
    var openButton = this.StandartSmallButton("easyImageFormOpenButton", null, openText, "Open.png", openText, null);
    toolBarImageSrc.addCell(openButton).style.padding = "4px";
    openButton.action = function () {
        if (this.jsObject.options.canOpenFiles) {
            this.jsObject.InitializeOpenDialog("loadImageFromFile", this.jsObject.StiHandleLoadImageFromFile, "image/*");
            this.jsObject.options.openDialogs.loadImageFromFile.action();
        }
    }

    var removeButton = this.StandartSmallButton("easyImageFormRemoveButton", null, this.loc.MainMenu.menuEditDelete.replace("&", ""),
        "Remove.png", this.loc.PropertyEnum.StiImageProcessingDuplicatesTypeRemoveImage, null);
    toolBarImageSrc.addCell(removeButton).style.padding = "4px 4px 4px 0";
    removeButton.action = function () {
        easyImageForm.imageContainer.style.display = "none";
        easyImageForm.imageContainer.src = "";
        easyImageForm.imageContainer.dataSrc = "";
    }

    var imageSrcPanel = document.createElement("Div");
    imageSrcPanel.className = "stiDesignerImageFormImagePanel";
    imageSrcPanel.style.height = "300px";
    easyImageForm.container.appendChild(imageSrcPanel);

    easyImageForm.imageContainer = document.createElement("Img");
    imageSrcPanel.appendChild(easyImageForm.imageContainer);

    easyImageForm.onshow = function () {
        var resultControl = easyImageForm.jsObject.options.controls[easyImageForm.resultControlName];
        var selectedObject = this.jsObject.options.selectedObject;
        openButton.setEnabled(easyImageForm.jsObject.options.canOpenFiles);
        var imageSrc = resultControl
            ? resultControl.key
            : selectedObject.properties["watermarkImageSrc"];
        easyImageForm.imageContainer.style.display = imageSrc ? "" : "none";
        easyImageForm.imageContainer.src = imageSrc;
        easyImageForm.imageContainer.dataSrc = imageSrc;
    }

    easyImageForm.action = function () {
        easyImageForm.changeVisibleState(false);
        var selectedObject = this.jsObject.options.selectedObject;
        var resultControl = easyImageForm.jsObject.options.controls[easyImageForm.resultControlName];
        if (resultControl) {
            resultControl.key = easyImageForm.imageContainer.dataSrc;
            resultControl.value = easyImageForm.imageContainer.dataSrc
                ? "[" + easyImageForm.jsObject.loc.PropertyCategory.ImageCategory + "]"
                : "[" + easyImageForm.jsObject.loc.Report.NotAssigned + "]";
        }
        else {
            selectedObject.properties["watermarkImageSrc"] = easyImageForm.imageContainer.dataSrc;
            easyImageForm.jsObject.SendCommandSendProperties(selectedObject, ["watermarkImageSrc"]);
        }
    }

    return easyImageForm;
}