﻿
StiMobileDesigner.prototype.InitializeEditConnectionForm_ = function () {

    //Edit Connection Form
    var editConnectionForm = this.BaseForm("editConnectionForm", this.loc.Database.Connection, 3, this.HelpLinks["connectionEdit"]);
    editConnectionForm.connection = null;
    editConnectionForm.mode = "Edit";

    var testButton = this.FormButton(null, null, this.loc.Buttons.Test, null);
    testButton.style.margin = "8px";
    testButton.style.display = "inline-block";
    editConnectionForm.testButton = testButton;

    var footerTable = this.CreateHTMLTable();
    footerTable.style.width = "450px";
    var buttonsPanel = editConnectionForm.buttonsPanel;
    editConnectionForm.removeChild(buttonsPanel);
    editConnectionForm.appendChild(footerTable);
    footerTable.addCell(testButton).style.width = "1px";
    footerTable.addCell().style.width = "100%";
    footerTable.addCell(editConnectionForm.buttonOk).style.width = "1px";
    footerTable.addCell(editConnectionForm.buttonCancel).style.width = "1px";

    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "5px";
    editConnectionForm.container.appendChild(innerTable);

    var csvSeparatorTable = this.CreateHTMLTable();
    editConnectionForm.csvSeparatorControl = this.DropDownList(null, 200, null, this.GetCsvSeparatorItems(), true, false, null, true);
    editConnectionForm.csvSeparatorTextControl = this.TextBox(null, 80);
    csvSeparatorTable.addCell(editConnectionForm.csvSeparatorControl);
    csvSeparatorTable.addCell(editConnectionForm.csvSeparatorTextControl).style.paddingLeft = "10px";

    editConnectionForm.csvSeparatorControl.action = function () {
        editConnectionForm.csvSeparatorTextControl.style.display = this.key == "Other" ? "" : "none";
    }

    var controlProps = [
        ["name", this.loc.PropertyMain.Name + ":", this.TextBox(null, 180)],
        ["alias", this.loc.PropertyMain.Alias + ":", this.TextBox(null, 180)],
        ["xmlType", this.loc.FormDatabaseEdit.XmlType, this.DropDownList("editConnectionFormXmlType", 250, null, this.GetXmlTypeItems(), true, false, null, true)],
        ["pathSchema", this.loc.FormDatabaseEdit.PathSchema, this.TextBox(null, 300)],
        ["pathData", this.loc.FormDatabaseEdit.PathToData, this.TextBox(null, 300)],
        ["codePageDbase", this.loc.Export.Encoding, this.DropDownList(null, 300, null, this.GetDBaseCodePageItems(), true, false, null, true)],
        ["codePageCsv", this.loc.Export.Encoding, this.DropDownList(null, 300, null, this.GetCsvCodePageItems(), true, false, null, true)],
        ["csvSeparatorTable", this.loc.Export.Separator, csvSeparatorTable],
        ["firstRowIsHeader", "", this.CheckBox(null, this.loc.FormDatabaseEdit.FirstRowIsHeader)]/*,
        ["embeddedData", "", this.CheckBox(null, this.loc.FormDatabaseEdit.EmbeddedData)]*/
    ]
    //PathToData
    for (var i in controlProps) {
        editConnectionForm[controlProps[i][0] + "ControlRow"] = innerTable.addRow();
        var text = innerTable.addCellInLastRow();
        text.className = "stiDesignerCaptionControlsBigIntervals";
        text.innerHTML = controlProps[i][1];
        var control = controlProps[i][2];
        control.textCell = text;
        editConnectionForm[controlProps[i][0] + "Control"] = control;
        innerTable.addCellInLastRow(control).className = "stiDesignerControlCellsBigIntervals";
    }

    editConnectionForm.firstRowIsHeaderControl.style.margin = "3px 0 3px 0";
    //editConnectionForm.embeddedDataControl.style.margin = "3px 0 3px 0";

    editConnectionForm.xmlTypeControl.action = function () {
        editConnectionForm.pathSchemaControlRow.style.display = this.key == "AdoNetXml" ? "" : "none";
    }

    editConnectionForm.nameControl.action = function () {
        if (editConnectionForm.mode == "New" && editConnectionForm.connection.name != editConnectionForm.nameControl.value) editConnectionForm.nameIsChanged = true;
    }

    editConnectionForm.aliasControl.action = function () {
        if (editConnectionForm.mode == "New" && editConnectionForm.connection.alias != editConnectionForm.aliasControl.value) editConnectionForm.aliasIsChanged = true;
    }

    editConnectionForm.pathDataControl.action = function () {
        if (editConnectionForm.mode == "New" && !editConnectionForm.nameIsChanged) {
            editConnectionForm.nameControl.value = editConnectionForm.jsObject.GetConnectionNameFromPathData(this.value) || editConnectionForm.connection.name;
            if (!editConnectionForm.aliasIsChanged) editConnectionForm.aliasControl.value = editConnectionForm.nameControl.value;
        }
    }

    editConnectionForm.pathDataControl.onkeyup = function () { editConnectionForm.pathDataControl.action(); }
        
    //Connection String
    editConnectionForm.connectionStringRow = innerTable.addRow();
    var connectionStringText = innerTable.addCellInLastRow();
    connectionStringText.className = "stiDesignerCaptionControlsBigIntervals";
    connectionStringText.style.paddingTop = "10px";
    connectionStringText.style.verticalAlign = "top";
    connectionStringText.innerHTML = this.loc.FormDatabaseEdit.ConnectionString;
    editConnectionForm.connectionStringControl = this.TextArea("editConnectionFormConnectionStringTextBox", 380, 150);
    innerTable.addCellInLastRow(editConnectionForm.connectionStringControl).className = "stiDesignerControlCellsBigIntervals";

    //Test Connection
    testButton.action = function () {
        testButton.setEnabled(false);
        this.jsObject.SendCommandTestConnection(
            editConnectionForm.connection.typeConnection,
            Base64.encode(editConnectionForm.connectionStringControl.value)
        );
    }

    //PromptUserNameAndPassword
    editConnectionForm.promptUserNameAndPasswordRow = innerTable.addRow();
    var promptUserNameAndPasswordText = innerTable.addCellInLastRow();
    promptUserNameAndPasswordText.className = "stiDesignerCaptionControlsBigIntervals";
    editConnectionForm.promptUserNameAndPasswordControl = this.CheckBox("editConnectionFormPromptUserNameAndPassword", this.loc.FormDatabaseEdit.PromptUserNameAndPassword);
    innerTable.addCellInLastRow(editConnectionForm.promptUserNameAndPasswordControl).className = "stiDesignerControlCellsBigIntervals";

    editConnectionForm.getCsvSeparatorType = function (sepText) {
        switch (sepText) {
            case "": return "System";
            case "\t": return "Tab"
            case ";": return "Semicolon";
            case ",": return "Comma";
            case " ": return "Space";
            default: return "Other";
        }
    }

    editConnectionForm.getCsvSeparatorText = function (sepType) {
        switch (sepType) {
            case "System": return "";
            case "Tab": return "\t";
            case "Semicolon": return ";";
            case "Comma": return ",";
            case "Space": return " ";
            case "Other": return this.csvSeparatorTextControl.value;
        }
    }

    editConnectionForm.onshow = function () {
        this.mode = "Edit";
        testButton.setEnabled(true);
        this.nameIsChanged = false;
        this.aliasIsChanged = false;

        if (typeof (this.connection) == "string") {
            this.connection = this.jsObject.ConnectionObject(this.connection);
            this.mode = "New";
        } else if (this.connection.isRecentConnection) {
            this.mode = "New";
        }

        var caption = (this.connection.typeConnection && (this.connection.typeConnection.endsWith("StiXmlDatabase") || this.connection.typeConnection.endsWith("StiJsonDatabase")))
            ? this.jsObject.loc.FormDatabaseEdit[(this.connection.typeConnection && this.connection.typeConnection.endsWith("StiXmlDatabase") ? "Xml" : "Json") + this.mode]
            : this.jsObject.loc.FormDatabaseEdit[this.mode + "Connection"].replace("{0}", this.jsObject.GetConnectionNames(this.connection.typeConnection, true));

        if (caption) this.caption.innerHTML = caption;
        this.csvSeparatorTextControl.value = "";
        this.csvSeparatorTextControl.style.display = "none";
        this.nameControl.value = this.connection.name;
        this.aliasControl.value = this.connection.alias;
        var isXmlConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiXmlDatabase");
        var isJsonConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiJsonDatabase");
        var isDBaseConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiDBaseDatabase");
        var isCsvConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiCsvDatabase");
        var isExcelConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiExcelDatabase");
        var isFileDataConnection = isXmlConnection || isJsonConnection || isDBaseConnection || isCsvConnection || isExcelConnection;

        if (isFileDataConnection) {
            //this.embeddedDataControl.setChecked(this.connection.embeddedData);
            if (this.connection.pathData != null) this.pathDataControl.value = Base64.decode(this.connection.pathData);
        }

        if (isXmlConnection) {
            this.pathDataControl.textCell.innerHTML = this.jsObject.loc.FormDatabaseEdit.PathData;
            if (this.connection.pathSchema != null) this.pathSchemaControl.value = Base64.decode(this.connection.pathSchema);
            this.xmlTypeControl.setKey(this.connection.xmlType);
        }
        else if (isJsonConnection) {
            this.pathDataControl.textCell.innerHTML = this.jsObject.loc.FormDatabaseEdit.PathJsonData;
        }
        else if (isDBaseConnection) {
            this.pathDataControl.textCell.innerHTML = this.jsObject.loc.FormDatabaseEdit.PathToData;
            this.codePageDbaseControl.setKey(this.connection.codePage);
        }
        else if (isCsvConnection) {
            this.pathDataControl.textCell.innerHTML = this.jsObject.loc.FormDatabaseEdit.PathToData;
            this.codePageCsvControl.setKey(this.connection.codePage);
            var sepType = this.getCsvSeparatorType(this.connection.separator);
            this.csvSeparatorControl.setKey(sepType);
            this.csvSeparatorTextControl.style.display = sepType == "Other" ? "" : "none";
            if (sepType == "Other") this.csvSeparatorTextControl.value = this.connection.separator;
        }
        else if (isExcelConnection) {
            this.pathDataControl.textCell.innerHTML = this.jsObject.loc.FormDatabaseEdit.PathToData;
            this.firstRowIsHeaderControl.setChecked(this.connection.firstRowIsHeader);
        }
        else {
            if (this.connection.connectionString != null) this.connectionStringControl.value = Base64.decode(this.connection.connectionString);
            this.promptUserNameAndPasswordControl.setChecked(this.connection.promptUserNameAndPassword);
        }

        this.xmlTypeControlRow.style.display = isXmlConnection && !this.jsObject.options.isJava ? "" : "none";
        this.pathDataControlRow.style.display = isFileDataConnection ? "" : "none";
        this.pathSchemaControlRow.style.display = isXmlConnection && this.xmlTypeControl.key == "AdoNetXml" ? "" : "none";
        this.connectionStringRow.style.display = !isFileDataConnection ? "" : "none";
        testButton.style.display = this.connectionStringRow.style.display == "" ? "inline-block" : "none";
        this.promptUserNameAndPasswordRow.style.display = this.connectionStringRow.style.display == "" && this.connection.typeConnection != "StiMSAccessDatabase" ? "" : "none";
        this.codePageDbaseControlRow.style.display = isDBaseConnection ? "" : "none";
        this.codePageCsvControlRow.style.display = isCsvConnection ? "" : "none";
        this.csvSeparatorTableControlRow.style.display = isCsvConnection ? "" : "none";
        this.firstRowIsHeaderControlRow.style.display = isExcelConnection ? "" : "none";
        //this.embeddedDataControlRow.style.display = isFileDataConnection && !this.jsObject.options.jsMode ? "" : "none";

        footerTable.style.width = editConnectionForm.container.offsetWidth + "px"; //fix bug
    }

    editConnectionForm.action = function () {
        this.connection.mode = this.mode;
        this.connection.skipSchemaWizard = this.skipSchemaWizard;
        if (this.mode == "Edit") this.connection["oldName"] = this.connection.name;
                
        this.connection.name = this.nameControl.value;
        this.connection.alias = this.aliasControl.value;

        var isXmlConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiXmlDatabase");
        var isJsonConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiJsonDatabase");
        var isDBaseConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiDBaseDatabase");
        var isCsvConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiCsvDatabase");
        var isExcelConnection = this.connection.typeConnection && this.connection.typeConnection.endsWith("StiExcelDatabase");
        var isFileDataConnection = isXmlConnection || isJsonConnection || isDBaseConnection || isCsvConnection || isExcelConnection;

        //if (isFileDataConnection) {
        //    this.connection.embeddedData = this.embeddedDataControl.isChecked;
        //}

        if (isXmlConnection) {
            this.connection.xmlType = this.xmlTypeControl.key;
            this.connection.pathData = Base64.encode(this.pathDataControl.value);
            this.connection.pathSchema = this.xmlTypeControl.key == "AdoNetXml" ? Base64.encode(this.pathSchemaControl.value) : "";
        }
        else if (isJsonConnection) {
            this.connection.pathData = Base64.encode(this.pathDataControl.value);
        }
        else if (isDBaseConnection) {
            this.connection.pathData = Base64.encode(this.pathDataControl.value);
            this.connection.codePage = this.codePageDbaseControl.key;
        }
        else if (isCsvConnection) {
            this.connection.pathData = Base64.encode(this.pathDataControl.value);
            this.connection.codePage = this.codePageCsvControl.key;
            this.connection.separator = this.getCsvSeparatorText(this.csvSeparatorControl.key);
        }
        else if (isExcelConnection) {
            this.connection.pathData = Base64.encode(this.pathDataControl.value);
            this.connection.firstRowIsHeader = this.firstRowIsHeaderControl.isChecked;
        }
        else {
            this.connection.connectionString = Base64.encode(this.connectionStringControl.value);
            this.connection.promptUserNameAndPassword = this.promptUserNameAndPasswordControl.isChecked;
        }

        if (this.mode == "New" && !this.connection.isRecentConnection) {
            this.jsObject.SaveRecentConnectionToCookies(this.connection);
        }
        this.changeVisibleState(false);
        this.jsObject.SendCommandCreateOrEditConnection(this.connection);
    }

    return editConnectionForm;
}