﻿
StiMobileDesigner.prototype.InitializeEditGaugeForm_ = function () {
    //Edit Chart Form
    var editGaugeForm = this.BaseFormPanel("editGauge", " ", 1);

    //Chart Image
    editGaugeForm.gaugeImage = document.createElement("div");
    editGaugeForm.gaugeImage.className = "stiDesignerChartImage";

    editGaugeForm.gaugeImage.update = function () {
        this.innerHTML = editGaugeForm.gaugeProperties.gaugeImage;
    }

    //Tabs
    var tabs = [];
    tabs.push({ "name": "Gauge", "caption": this.loc.Components.StiGauge });
    tabs.push({ "name": "Styles", "caption": this.loc.PropertyMain.Styles });
    var tabbedPane = this.TabbedPane("editGaugeTabbedPane", tabs, this.GetStyles("StandartTab"));
    editGaugeForm.tabbedPane = tabbedPane;
    editGaugeForm.container.appendChild(tabbedPane);

    for (var i in tabs) {
        tabbedPane.tabsPanels[tabs[i].name].appendChild(this.FormSeparator());
        var tabsPanel = null;
        switch (tabs[i].name) {
            case "Gauge": tabsPanel = this.GaugeFormGaugeTabPanel(editGaugeForm); break;
            case "Styles": tabsPanel = this.GaugeFormStylesTabPanel(editGaugeForm); break;
        }

        if (tabsPanel) {
            tabsPanel.style.width = "750px";
            tabsPanel.style.height = "460px";
            tabbedPane.tabsPanels[tabs[i].name].appendChild(tabsPanel);
        }

        //Methods Tabs On Show Event
        tabbedPane.tabsPanels[tabs[i].name].onshow = function () {
            //Move Chart Image To Current Panel
            var imageContainer = editGaugeForm["imageContainer" + this.name + "Tab"];
            if (imageContainer) {
                imageContainer.appendChild(editGaugeForm.gaugeImage);
            }

            //Show Current Properties 
            //editGaugeForm.jsObject.options.propertiesPanel.editGaugePropertiesPanel.showInnerPanel(this.name);
            //editGaugeForm.onChangeTabs();

            //On Show Events
            //if (this.name == "Chart") {
            //    var seriesCount = editGaugeForm.seriesContainer.items.length;
            //    editGaugeForm.seriesWizardContainer.style.display = seriesCount == 0 ? "" : "none";
            //    editGaugeForm.chartTabMainTable.style.display = seriesCount == 0 ? "none" : "";
            //    editGaugeForm.chartPropertiesContainer.buttons.Common.action();
            //}
            //if (this.name == "Series") {
            //    editGaugeForm.seriesPropertiesContainer.update();
            //}
            //if (this.name == "Area") {
            //    editGaugeForm.areaPropertiesContainer.update();
            //}
            //if (this.name == "Labels") {
            //    if (editGaugeForm.chartProperties.area.type != editGaugeForm.lastAreaTypeForLabels ||
            //        editGaugeForm.chartProperties.style.type + editGaugeForm.chartProperties.style.name != editGaugeForm.lastStyleId) {
            //        editGaugeForm.labelsContainer.labelsProgress.style.display = "";
            //        editGaugeForm.labelsContainer.clear();
            //        editGaugeForm.jsObject.SendCommandGetLabelsContent({ componentName: editGaugeForm.chartProperties.name });
            //    }
            //    else {
            //        editGaugeForm.labelPropertiesContainer.buttons.Common.action();
            //    }
            //}
            //if (this.name == "Styles") {
            //    if (editGaugeForm.chartProperties.area.type != editGaugeForm.lastAreaTypeForStyles) {
            //        editGaugeForm.stylesContainer.stylesProgress.style.display = "";
            //        editGaugeForm.stylesContainer.clear();
            //        editGaugeForm.jsObject.SendCommandGetStylesContent({ componentName: editGaugeForm.chartProperties.name });
            //    }
            //}
        }
    }

    //Hide Header Caption
    editGaugeForm.caption.innerHTML = "";
    editGaugeForm.caption.appendChild(tabbedPane.tabsPanel);
    editGaugeForm.caption.style.padding = "0px";
    editGaugeForm.container.style.borderTop = "0px";

    //Form Methods
    editGaugeForm.onshow = function () {
        editGaugeForm.jsObject.options.propertiesPanel.setEditGaugeMode(true);
        //editGaugeForm.seriesContainer.update();
        editGaugeForm.gaugeImage.update();
        tabbedPane.showTabPanel("Gauge");
    }

    editGaugeForm.onhide = function () {
        editGaugeForm.jsObject.options.propertiesPanel.setEditGaugeMode(false);
    }

    editGaugeForm.cancelAction = function () {
        editGaugeForm.jsObject.SendCommandCanceledEditComponent(editGaugeForm.gaugeProperties.name);
    }

    editGaugeForm.action = function () {
        //var containerNames = ["seriesConditionsPanel", "labelsConditionsPanel", "seriesFiltersPanel"];
        //for (var i in containerNames) {
        //    if (editGaugeForm[containerNames[i]].container.isModified) {
        //        editGaugeForm[containerNames[i]].container.isModified = false;
        //        editGaugeForm[containerNames[i]].container.sendValueToServer(true);
        //        return;
        //    }
        //}
        editGaugeForm.changeVisibleState(false);
        editGaugeForm.jsObject.SendCommandSendProperties(editGaugeForm.currentGaugeComponent, []);
    }

    editGaugeForm.update = function () {
        var properties = editGaugeForm.gaugeProperties;
    }

    return editGaugeForm;
}

//Series Tab
StiMobileDesigner.prototype.GaugeFormGaugeTabPanel = function (editGaugeForm) {
    var mainTable = this.CreateHTMLTable();

    //Toolbar
    var buttons = [
        ["addGaugeItem", this.loc.Gauge.AddNewItem, "Gauge.GaugeNew.png", null, "Down"],
        ["removeGaugeItem", null, "Remove.png", this.loc.Buttons.Delete, null],
        ["separator"],
        ["moveUp", null, "MoveUp.png", this.loc.QueryBuilder.MoveUp, null],
        ["moveDown", null, "MoveDown.png", this.loc.QueryBuilder.MoveDown, null]
    ]

    var toolBar = this.CreateHTMLTable();
    toolBar.style.margin = "4px";
    editGaugeForm.gaugeToolBar = toolBar;
    var toolBarCell = mainTable.addCell(toolBar);
    editGaugeForm.toolBarCell = toolBarCell;
    toolBarCell.className = "stiDesignerChartFormToolBarCell";
    toolBarCell.setAttribute("colspan", "2");
        
    for (var i in buttons) {
        if (buttons[i][0] == "separator") {
            toolBar.addCell(this.HomePanelSeparator());
            continue;
        }
        var button = this.SmallButton("editGaugeForm" + buttons[i][0], null, buttons[i][1], buttons[i][2], buttons[i][3], buttons[i][4], this.GetStyles("StandartSmallButton"), true);
        button.style.margin = "1px";
        toolBar[buttons[i][0]] = button;
        toolBar.addCell(button);
    }

    //Add Gauge Items Menu
    var addGaugeItemsMenu = this.InitializeAddGaugeItemsMenu(editGaugeForm);
    addGaugeItemsMenu.innerContent.style.maxHeight = null;
    toolBar.addGaugeItem.action = function () { addGaugeItemsMenu.changeVisibleState(!this.isSelected); }

    addGaugeItemsMenu.action = function (menuItem) {
        //addGaugeItemsMenu.jsObject.SendCommandAddSeries({
        //    componentName: editGaugeForm.gaugeProperties.name,
        //    seriesType: menuItem.key
        //});
    }

    //Remove Series
    toolBar.removeGaugeItem.action = function () {
        //editGaugeForm.jsObject.SendCommandRemoveSeries({
        //    componentName: editGaugeForm.gaugeProperties.name,
        //    seriesIndex: editGaugeForm.seriesContainer.getSelectedIndex()
        //});
    }

    var gaugeItemMove = function (direction) {
        //editGaugeForm.jsObject.SendCommandSeriesMove({
        //    componentName: editGaugeForm.gaugeProperties.name,
        //    seriesIndex: editGaugeForm.seriesContainer.getSelectedIndex(),
        //    direction: direction
        //});
    }

    //Series Move Up
    toolBar.moveUp.action = function () { gaugeItemMove("Up"); }

    //Series Move Down
    toolBar.moveDown.action = function () { gaugeItemMove("Down"); }

    //Series Container
    var gaugeTree = this.GaugeTree(editGaugeForm, 300, this.options.isTouchDevice ? 420 : 425);
    gaugeTree.className = "stiDesignerSeriesContainer";
    editGaugeForm.gaugeTree = gaugeTree;
    mainTable.addCellInNextRow(gaugeTree).style.width = "1px";

    //gaugeTree.onChange = function () {
    //    //editGaugeForm.seriesPropertiesContainer.update();
    //    //toolBar.removeSeries.setEnabled(seriesContainer.items.length > 0);
    //    //var selectedIndex = seriesContainer.getSelectedIndex();
    //    //toolBar.moveUp.setEnabled(selectedIndex != -1 && selectedIndex > 0);
    //    //toolBar.moveDown.setEnabled(selectedIndex != -1 && selectedIndex < seriesContainer.items.length - 1);
    //}

    //gaugeTree.update = function (notSelectedAfter) {
    //    //seriesContainer.clear();
    //    //for (var i in editGaugeForm.gaugeProperties.series) {
    //    //    seriesContainer.addItemAndNotAction(editGaugeForm.gaugeProperties.series[i].name, editGaugeForm.gaugeProperties.series[i]);
    //    //}
    //    //if (seriesContainer.items.length > 0 && !notSelectedAfter) seriesContainer.items[0].action();
    //}

    //Chart image container
    editGaugeForm.imageContainerGaugeTab = mainTable.addCellInLastRow();
    editGaugeForm.imageContainerGaugeTab.style.textAlign = "center";

    return mainTable;
}

//Styles Tab
StiMobileDesigner.prototype.GaugeFormStylesTabPanel = function (editGaugeForm) {
    var mainTable = this.CreateHTMLTable();

    //Toolbar
    editGaugeForm.stylesToolBar = this.CreateHTMLTable();
    var toolBarCell = mainTable.addCell(editGaugeForm.stylesToolBar);
    toolBarCell.className = "stiDesignerChartFormToolBarCell";
    toolBarCell.setAttribute("colspan", "2");

    //AddStyle Button
    editGaugeForm.stylesToolBar.addStyle = this.StandartSmallButton("editGaugeFormAddStyle", null, this.loc.Toolbars.StyleDesigner, "Styles.StiChartStyle.png");
    editGaugeForm.stylesToolBar.addStyle.style.margin = "5px";
    editGaugeForm.stylesToolBar.addCell(editGaugeForm.stylesToolBar.addStyle);
    editGaugeForm.stylesToolBar.addStyle.action = function () {
        editGaugeForm.jsObject.InitializeStyleDesignerForm(function (styleDesignerForm) {
            styleDesignerForm.changeVisibleState(true);
        });
    };

    //Styles Container
    var stylesProgress = this.Progress();
    editGaugeForm.stylesContainer = this.StylesContainer(editGaugeForm);
    stylesProgress.className = "stiDesignerChartFormProgress";
    stylesProgress.style.display = "none";

    var containerCell = mainTable.addCellInNextRow();
    containerCell.style.width = "1px";
    containerCell.appendChild(stylesProgress);
    containerCell.appendChild(editGaugeForm.stylesContainer);
    editGaugeForm.stylesContainer.stylesProgress = stylesProgress;

    //Chart image container
    editGaugeForm.imageContainerStylesTab = mainTable.addCellInLastRow();
    editGaugeForm.imageContainerStylesTab.style.textAlign = "center";

    return mainTable;
}

//Gauge Tree
StiMobileDesigner.prototype.GaugeTree = function (editGaugeForm, width, height) {
    var tree = this.Tree(width, height);

    return tree;
}

//Styles Container
StiMobileDesigner.prototype.StylesContainer = function (editGaugeForm) {
    var stylesContainer = this.ContainerWithBigItems("editGaugeFormStylesContainer", 200, this.options.isTouchDevice ? 420 : 425);
    stylesContainer.className = "stiDesignerSeriesContainer";
    stylesContainer.buttons = {};
    
    stylesContainer.onAction = function () {
        if (stylesContainer.selectedItem != null) {
            var params = {
                componentName: editGaugeForm.gaugeProperties.name,
                styleType: stylesContainer.selectedItem.itemObject.type,
                styleName: stylesContainer.selectedItem.itemObject.name
            }
            editGaugeForm.jsObject.SendCommandSetChartStyle(params);
        }
    }

    stylesContainer.update = function (stylesContent) {
        editGaugeForm.lastAreaTypeForStyles = editGaugeForm.gaugeProperties.area.type;
        stylesContainer.clear();
        for (var i in stylesContent) {
            var name = stylesContent[i].type + stylesContent[i].name;
            var button = stylesContainer.addItemAndNotAction(name, null, " ", stylesContent[i]);
            button.cellImage.removeChild(button.image);
            button.image = document.createElement("div");
            button.image.innerHTML = stylesContent[i].image;
            button.cellImage.appendChild(button.image);
            stylesContainer.buttons[name] = button;

            if (editGaugeForm.gaugeProperties.style.type + editGaugeForm.gaugeProperties.style.name == name) {
                button.selected();
            }
            button.style.display = "inline-block";
        }
        editGaugeForm.stylesContainer.stylesProgress.style.display = "none";
    }

    return stylesContainer;
}