﻿
StiMobileDesigner.prototype.InitializeEditRichTextForm_ = function () {

    //RichText Form
    var richTextForm = this.BaseFormPanel("richTextForm", this.loc.FormRichTextEditor.title, 1);
    richTextForm.dataTree = this.options.dataTree;
    richTextForm.mode = "RichTextExpression";

    //Main Table
    var mainTable = this.CreateHTMLTable();
    mainTable.className = "stiDesignerImageFormMainPanel";
    richTextForm.container.appendChild(mainTable);
    richTextForm.container.style.padding = "0px";

    //Buttons
    var buttonProps = [
        ["RichTextExpression", "BigRichTextExpression.png", this.loc.PropertyMain.Expression],
        ["RichTextDataColumn", "BigRichTextDataColumn.png", this.loc.PropertyMain.DataColumn],
        ["RichTextFile", "BigRichTextFile.png", this.loc.MainMenu.menuFile.replace("&", "")],
        ["RichTextUrl", "BigRichTextUrl.png", "URL"]
    ];

    if (this.options.cloudMode) {
        buttonProps.push(["RichTextServer", "BigRichTextCloud.png", "Server"]);
    }

    //Add Panels && Buttons
    var panelsContainer = mainTable.addCell();
    var buttonsPanel = mainTable.addCell();
    buttonsPanel.style.verticalAlign = "top";
    richTextForm.mainButtons = {};
    richTextForm.panels = {};

    for (var i = 0; i < buttonProps.length; i++) {
        var panel = document.createElement("Div");
        panel.className = "stiDesignerRichTextFormPanel";
        if (this.options.isTouchDevice) panel.style.width = "630px";
        if (i != 0) panel.style.display = "none";
        panelsContainer.appendChild(panel);
        richTextForm.panels[buttonProps[i][0]] = panel;
        if (buttonProps[i][0] == "RichTextExpression") panel.style.overflow = "hidden";

        var button = this.StandartFormBigButton("richTextForm" + buttonProps[i][0] + "Button", null, buttonProps[i][2], buttonProps[i][1], buttonProps[i][2], 80);
        button.style.margin = "2px";
        richTextForm.mainButtons[buttonProps[i][0]] = button;
        buttonsPanel.appendChild(button);
        button.panelName = buttonProps[i][0];
        button.action = function () {
            richTextForm.setMode(this.panelName);
        }
    }

    //Expression
    var textControl = this.RichTextEditor("editRichTextFormEditor", this.options.isTouchDevice ? 616 : 536, this.options.isTouchDevice ? 398 : 400);
    richTextForm.panels.RichTextExpression.appendChild(textControl);

    //File Name
    var toolBarFileName = this.CreateHTMLTable();
    richTextForm.panels.RichTextFile.appendChild(toolBarFileName);

    var sep2 = document.createElement("Div");
    sep2.className = "stiDesignerImageFormSeparator";
    richTextForm.panels.RichTextFile.appendChild(sep2);

    var captionCell = toolBarFileName.addCell();
    captionCell.style.padding = "0 8px 0 8px";
    captionCell.innerHTML = this.loc.MainMenu.menuFile.replace("&", "") + ":";

    richTextForm.fileNameTextBox = this.TextBox("richTextFormFileName", this.options.isTouchDevice ? 530 : 480);
    richTextForm.fileNameTextBox.style.margin = "4px";
    toolBarFileName.addCell(richTextForm.fileNameTextBox);

    //Data Url
    richTextForm.urlTextArea = this.TextArea("richTextFormUrl", this.options.isTouchDevice ? 612 : 582, 436);
    richTextForm.urlTextArea.style.margin = "6px 0 0 6px";
    richTextForm.panels.RichTextUrl.appendChild(richTextForm.urlTextArea);

    //Events
    richTextForm.urlTextArea.onmouseup = function () {
        if (this.jsObject.options.itemInDrag) {
            var dictionaryTree = this.jsObject.options.dictionaryTree;
            if (dictionaryTree.selectedItem) {
                this.value += dictionaryTree.selectedItem.getResultForEditForm();
            } 
        } 
    }
    richTextForm.urlTextArea.ontouchend = function () { this.onmouseup(); }

    //Image Server
    if (this.options.cloudMode) {
        richTextForm.cloudContainer = this.CloudContainer("richTextFormCloudContainer", ["RichText"], this.options.isTouchDevice ? 610 : 580);
        richTextForm.cloudContainer.style.margin = "8px auto 0 auto";
        richTextForm.panels.RichTextServer.appendChild(richTextForm.cloudContainer);
        if (this.options.dictionaryTree.selectedItem) this.options.dictionaryTree.selectedItem.setSelected();
    }

    //Form Methods
    richTextForm.setMode = function (mode) {
        richTextForm.mode = mode;
        for (var panelName in richTextForm.panels) {
            richTextForm.panels[panelName].style.display = mode == panelName ? "" : "none";
            richTextForm.mainButtons[panelName].setSelected(mode == panelName);
        }
        var propertiesPanel = richTextForm.jsObject.options.propertiesPanel;
        propertiesPanel.editFormControl = null;
        propertiesPanel.setEnabled(mode == "RichTextUrl" || mode == "RichTextServer" || mode == "RichTextExpression");
        if (mode == "RichTextUrl") propertiesPanel.editFormControl = richTextForm.urlTextArea;
        if (mode == "RichTextServer") propertiesPanel.editFormControl = richTextForm.cloudContainer;
    }

    richTextForm.onhide = function () {
        richTextForm.jsObject.options.propertiesPanel.setDictionaryMode(false);
    }

    richTextForm.show = function () {
        richTextForm.jsObject.options.propertiesPanel.setDictionaryMode(true);
        richTextForm.changeVisibleState(true);

        //Data Tree Build
        richTextForm.panels.RichTextDataColumn.appendChild(richTextForm.dataTree);
        richTextForm.dataTree.build();
        richTextForm.dataTree.action = function () {
            richTextForm.action();
        }

        var selectedObject = this.jsObject.options.selectedObject || this.jsObject.GetCommonObject(this.jsObject.options.selectedObjects);
        if (!selectedObject) return;

        var props = ["richText", "richTextDataColumn", "richTextUrl"];
        for (var i in props) {
            richTextForm[props[i]] = selectedObject.properties[props[i]] != null && selectedObject.properties[props[i]] != "StiEmptyValue"
                ? Base64.decode(selectedObject.properties[props[i]]) : null;
        }
        if (richTextForm.richTextDataColumn) {
            richTextForm.setMode("RichTextDataColumn");
            richTextForm.dataTree.setKey(richTextForm.richTextDataColumn);
        }
        else if (richTextForm.richTextUrl) {
            if (richTextForm.richTextUrl.indexOf("file://") == 0) {
                richTextForm.setMode("RichTextFile");
                richTextForm.fileNameTextBox.value = richTextForm.richTextUrl.replace("file://", "");
            }
            else {
                richTextForm.setMode("RichTextUrl");
                richTextForm.urlTextArea.value = richTextForm.richTextUrl;
            }
        }
        else if (richTextForm.richText && richTextForm.richText.indexOf(this.jsObject.options.cloudServerUrl) == 0) {
            richTextForm.setMode("RichTextServer");
            var key = richTextForm.richText.replace(this.jsObject.options.cloudServerUrl, "");
            var item = this.jsObject.options.dictionaryTree.getCloudItemByKey("RichText", key);
            if (item && richTextForm.cloudContainer) richTextForm.cloudContainer.addItem(item.itemObject);
        }
        else {
            richTextForm.setMode("RichTextExpression");
            if (richTextForm.richText) textControl.setText(richTextForm.richText);
        }
    }

    richTextForm.action = function () {
        this.changeVisibleState(false);

        var selectedObjects = this.jsObject.options.selectedObjects || [this.jsObject.options.selectedObject];
        if (!selectedObjects) return;
        var propertyNames = ["richText", "richTextDataColumn", "richTextUrl"];

        for (var i = 0; i < selectedObjects.length; i++) {
            var selectedObject = selectedObjects[i];

            for (var k in propertyNames) selectedObject.properties[propertyNames[k]] = "";

            switch (richTextForm.mode) {
                case "RichTextUrl":
                    {
                        selectedObject.properties.richTextUrl = Base64.encode(richTextForm.urlTextArea.value);
                        break;
                    }
                case "RichTextFile":
                    {
                        selectedObject.properties.richTextUrl = Base64.encode("file://" + richTextForm.fileNameTextBox.value);
                        break;
                    }
                case "RichTextDataColumn":
                    {
                        selectedObject.properties.richTextDataColumn = Base64.encode(richTextForm.dataTree.key || "");
                        break;
                    }
                case "RichTextExpression":
                    {
                        selectedObject.properties.richText = Base64.encode(textControl.getText());
                        break;
                    }
                case "RichTextServer":
                    {
                        if (richTextForm.cloudContainer && richTextForm.cloudContainer.item && this.jsObject.options.cloudServerUrl) {
                            selectedObject.properties.richText = Base64.encode(this.jsObject.options.cloudServerUrl + richTextForm.cloudContainer.item.itemObject.key);
                        }
                        else
                            selectedObject.properties.richText = "";
                        break;
                    }
            }
        }
        richTextForm.jsObject.SendCommandSendProperties(selectedObjects, propertyNames);
    }

    return richTextForm;
}