﻿
StiMobileDesigner.prototype.InitializeImageForm_ = function () {
    //Image Form
    var imageForm = this.BaseFormPanel("imageForm", this.loc.PropertyCategory.ImageCategory, 2, this.HelpLinks["image"]);
    imageForm.dataTree = this.options.dataTree;
    imageForm.mode = "ImageSrc";

    //Main Table
    var mainTable = this.CreateHTMLTable();
    mainTable.className = "stiDesignerImageFormMainPanel";
    imageForm.container.appendChild(mainTable);
    imageForm.container.style.padding = "0px";

    //Buttons
    var buttonProps = [
        ["ImageSrc", "BigImage.png", this.loc.PropertyCategory.ImageCategory],
        ["ImageFile", "BigImageLocalFile.png", this.loc.MainMenu.menuFile.replace("&", "")],
        ["ImageUrl", "BigImageWebUrl.png", this.loc.PropertyMain.ImageURL],
        ["ImageDataColumn", "BigImageDataColumn.png", this.loc.PropertyMain.DataColumn],
        ["ImageVariable", "BigImageVariable.png", this.loc.PropertyMain.Variable],
        ["ImageData", "BigImageExpression.png", this.loc.PropertyMain.ImageData]
    ];

    if (this.options.cloudMode) {
        buttonProps.push(["ImageServer", "BigImageCloud.png", "Server"]);
    }

    //Add Panels && Buttons
    var panelsContainer = mainTable.addCell();
    var buttonsPanel = mainTable.addCell();
    buttonsPanel.style.verticalAlign = "top";
    imageForm.mainButtons = {};
    imageForm.panels = {};

    for (var i = 0; i < buttonProps.length; i++) {
        var panel = document.createElement("Div");
        panel.className = "stiDesignerImageFormPanel";
        if (i != 0) panel.style.display = "none";
        panel.style.height = "500px";
        panelsContainer.appendChild(panel);
        imageForm.panels[buttonProps[i][0]] = panel;

        var button = this.StandartFormBigButton("imageForm" + buttonProps[i][0] + "Button", null, buttonProps[i][2], buttonProps[i][1], buttonProps[i][2], 80);
        button.style.margin = "2px";
        imageForm.mainButtons[buttonProps[i][0]] = button;
        buttonsPanel.appendChild(button);
        button.panelName = buttonProps[i][0];
        button.action = function () {
            imageForm.setMode(this.panelName);
        }
    }

    //ImageSrc
    var toolBarImageSrc = this.CreateHTMLTable();
    imageForm.panels.ImageSrc.appendChild(toolBarImageSrc);

    var sep1 = document.createElement("Div");
    sep1.className = "stiDesignerImageFormSeparator";
    imageForm.panels.ImageSrc.appendChild(sep1);

    var openText = this.loc.MainMenu.menuFileOpen.replace("&", "").replace("...", "");
    var openButton = this.StandartSmallButton("imageFormOpenButton", null, openText, "Open.png", openText, null);
    toolBarImageSrc.addCell(openButton).style.padding = "4px";
    openButton.action = function () {
        if (this.jsObject.options.canOpenFiles) {
            this.jsObject.InitializeOpenDialog("loadImageFromFile", this.jsObject.StiHandleLoadImageFromFile, "image/*");
            this.jsObject.options.openDialogs.loadImageFromFile.action();
        }
    }

    var removeButton = this.StandartSmallButton("imageFormRemoveButton", null, this.loc.MainMenu.menuEditDelete.replace("&", ""),
        "Remove.png", this.loc.PropertyEnum.StiImageProcessingDuplicatesTypeRemoveImage, null);
    toolBarImageSrc.addCell(removeButton).style.padding = "4px 4px 4px 0";
    removeButton.action = function () {
        imageForm.imageContainer.style.display = "none";
        imageForm.imageContainer.src = "";
        imageForm.imageContainer.dataSrc = "";
    }

    var imageSrcPanel = document.createElement("Div");
    imageSrcPanel.className = "stiDesignerImageFormImagePanel";
    imageSrcPanel.style.height = this.options.isTouchDevice ? "455px" : "460px";
    imageForm.panels.ImageSrc.appendChild(imageSrcPanel);

    imageForm.imageContainer = document.createElement("Img");
    imageSrcPanel.appendChild(imageForm.imageContainer);

    //File Name
    var toolBarFileName = this.CreateHTMLTable();
    imageForm.panels.ImageFile.appendChild(toolBarFileName);

    var sep2 = document.createElement("Div");
    sep2.className = "stiDesignerImageFormSeparator";
    imageForm.panels.ImageFile.appendChild(sep2);

    var captionCell = toolBarFileName.addCell();
    captionCell.style.padding = "0 8px 0 8px";
    captionCell.innerHTML = this.loc.MainMenu.menuFile.replace("&", "") + ":";

    imageForm.fileNameTextBox = this.TextBox("imageFormFileName", 300);
    imageForm.fileNameTextBox.style.margin = "4px";
    toolBarFileName.addCell(imageForm.fileNameTextBox);

    //Image Url
    imageForm.imageUrlTextArea = this.TextArea("imageFormFileUrl", 436, 490);
    imageForm.imageUrlTextArea.style.margin = "4px 0 0 4px";
    imageForm.panels.ImageUrl.appendChild(imageForm.imageUrlTextArea);

    //Events
    imageForm.imageUrlTextArea.onmouseup = function () {
        if (this.jsObject.options.itemInDrag) {
            var dictionaryTree = insertButton.jsObject.options.dictionaryTree;
            if (dictionaryTree.selectedItem) { this.value += dictionaryTree.selectedItem.getResultForEditForm(); }
        }
    }
    imageForm.imageUrlTextArea.ontouchend = function () { this.onmouseup(); }

    //Image Data
    imageForm.imageDataTextArea = this.TextArea("imageFormImageData", 436, 490);
    imageForm.imageDataTextArea.style.margin = "4px 0 0 4px";
    imageForm.panels.ImageData.appendChild(imageForm.imageDataTextArea);
    imageForm.imageDataTextArea.addInsertButton();
   
    //Image Server
    if (this.options.cloudMode) {
        imageForm.cloudContainer = this.CloudContainer("imageFormCloudContainer", ["Image"], 405);
        imageForm.cloudContainer.style.margin = "8px auto 0 auto";
        imageForm.panels.ImageServer.appendChild(imageForm.cloudContainer);
        if (this.options.dictionaryTree.selectedItem) this.options.dictionaryTree.selectedItem.setSelected();
    }

    //Image Variable
    var variablesTree = this.VariablesTree();
    imageForm.panels.ImageVariable.appendChild(variablesTree);

    variablesTree.action = function () { imageForm.action(); };

    //Form Methods
    imageForm.reset = function () {
        imageForm.dataTree.setKey("");
        imageForm.fileNameTextBox.value = "";
        imageForm.imageUrlTextArea.value = "";
        imageForm.imageDataTextArea.value = "";
        imageForm.imageContainer.src = "";
        imageForm.imageContainer.dataSrc = "";
        imageForm.imageContainer.style.display = "none";
        if (imageForm.cloudContainer) imageForm.cloudContainer.clear();
        imageForm.setMode("ImageSrc");
    }

    imageForm.setMode = function (mode) {
        imageForm.mode = mode;
        for (var panelName in imageForm.panels) {
            imageForm.panels[panelName].style.display = mode == panelName ? "" : "none";
            imageForm.mainButtons[panelName].setSelected(mode == panelName);
        }
        var propertiesPanel = imageForm.jsObject.options.propertiesPanel;
        propertiesPanel.editFormControl = null;
        propertiesPanel.setEnabled(mode == "ImageUrl" || mode == "ImageData" || mode == "ImageServer");
        if (mode == "ImageUrl") propertiesPanel.editFormControl = imageForm.imageUrlTextArea;
        if (mode == "ImageData") propertiesPanel.editFormControl = imageForm.imageDataTextArea;
        if (mode == "ImageServer") propertiesPanel.editFormControl = imageForm.cloudContainer;
    }

    imageForm.onhide = function () {
        imageForm.jsObject.options.propertiesPanel.setDictionaryMode(false);
    }

    imageForm.onshow = function () {
        imageForm.jsObject.options.propertiesPanel.setDictionaryMode(true);
        openButton.setEnabled(imageForm.jsObject.options.canOpenFiles);

        //Variables Tree Build
        variablesTree.build();

        //Data Tree Build
        imageForm.panels.ImageDataColumn.appendChild(imageForm.dataTree);
        imageForm.dataTree.build();
        imageForm.dataTree.action = function () {
            imageForm.action();
        }
        imageForm.reset();

        if (this.jsObject.options.selectedObjects) {
            imageForm.setMode("ImageSrc");
        }
        else {
            var selectedObject = this.jsObject.options.selectedObject;
            var props = ["imageSrc", "imageUrl", "imageFile", "imageDataColumn", "imageData"];
            for (var i in props) {
                imageForm[props[i]] = selectedObject.properties[props[i]] != null
                ? (props[i] == "imageSrc" ? selectedObject.properties[props[i]] : Base64.decode(selectedObject.properties[props[i]]))
                : null;
            }

            if (imageForm.imageSrc) {
                imageForm.setMode("ImageSrc");
                imageForm.imageContainer.src = imageForm.imageSrc;
                imageForm.imageContainer.dataSrc = imageForm.imageSrc;
                imageForm.imageContainer.style.display = "";
            }
            else if (imageForm.imageUrl) {
                if (imageForm.imageUrl.indexOf(this.jsObject.options.cloudServerUrl) == 0) {
                    imageForm.setMode("ImageServer");
                    var key = imageForm.imageUrl.replace(this.jsObject.options.cloudServerUrl, "");
                    var item = this.jsObject.options.dictionaryTree.getCloudItemByKey("Image", key);
                    if (item && imageForm.cloudContainer) imageForm.cloudContainer.addItem(item.itemObject);
                } else {
                    imageForm.setMode("ImageUrl");
                    imageForm.imageUrlTextArea.value = imageForm.imageUrl;
                }
            }
            else if (imageForm.imageFile) {
                imageForm.setMode("ImageFile");
                imageForm.fileNameTextBox.value = imageForm.imageFile;
            }
            else if (imageForm.imageDataColumn) {
                imageForm.setMode("ImageDataColumn");
                imageForm.dataTree.setKey(imageForm.imageDataColumn);
            }
            else if (imageForm.imageData) {

                var subStringPropertyValue = imageForm.imageData.length > 1 ? imageForm.imageData.substring(1, imageForm.imageData.length - 1) : "";
                var selectedItem = variablesTree.mainItem.getChildByName(subStringPropertyValue);
                if (selectedItem)
                    selectedItem.setSelected();
                else
                    imageForm.imageDataTextArea.value = imageForm.imageData;
                imageForm.setMode(selectedItem ? "ImageVariable" : "ImageData");
            }
        }
    }

    imageForm.action = function () {
        this.changeVisibleState(false);
        var selectedObjects = this.jsObject.options.selectedObjects || [this.jsObject.options.selectedObject];
        var propertyNames = ["imageSrc", "imageUrl", "imageFile", "imageDataColumn", "imageData"];

        for (var i = 0; i < selectedObjects.length; i++) {
            var selectedObject = selectedObjects[i];
            for (var k in propertyNames) selectedObject.properties[propertyNames[k]] = "";

            switch (imageForm.mode) {
                case "ImageSrc":
                    {
                        selectedObject.properties.imageSrc = encodeURIComponent(imageForm.imageContainer.dataSrc);
                        break;
                    }
                case "ImageUrl":
                    {
                        selectedObject.properties.imageUrl = Base64.encode(imageForm.imageUrlTextArea.value);
                        break;
                    }
                case "ImageFile":
                    {
                        selectedObject.properties.imageFile = Base64.encode(imageForm.fileNameTextBox.value);
                        break;
                    }
                case "ImageDataColumn":
                    {
                        selectedObject.properties.imageDataColumn = Base64.encode(imageForm.dataTree.key || "");
                        break;
                    }
                case "ImageData":
                    {
                        selectedObject.properties.imageData = Base64.encode(imageForm.imageDataTextArea.value);
                        break;
                    }
                case "ImageVariable":
                    {
                        selectedObject.properties.imageData = variablesTree.selectedItem && variablesTree.selectedItem.itemObject.typeItem != "NoItem"
                        ? Base64.encode("{" + variablesTree.selectedItem.itemObject.name + "}") : "";
                        break;
                    }
                case "ImageServer":
                    {
                        if (imageForm.cloudContainer && imageForm.cloudContainer.item && this.jsObject.options.cloudServerUrl) {
                            selectedObject.properties.imageUrl = Base64.encode(this.jsObject.options.cloudServerUrl + imageForm.cloudContainer.item.itemObject.key);
                        }
                        else
                            selectedObject.properties.imageUrl = "";
                        break;
                    }
            }
        }
        imageForm.jsObject.SendCommandSendProperties(selectedObjects, propertyNames);
    }

    return imageForm;
}