﻿
StiMobileDesigner.prototype.InitializeNewReportWizardForm_ = function () {

    var form = this.BaseForm("newReportWizardForm", this.loc.MainMenu.menuFileReportWizardNew.replace("&", "").replace("...", ""), 1);
    form.buttonOk.style.display = "none";
    form.buttonCancel.caption.innerHTML = this.loc.Buttons.Close;

    var buttonsTable = this.CreateHTMLTable();
    buttonsTable.style.margin = "10px";
    form.container.appendChild(buttonsTable);

    var buttonsProps = [
        ["blankReportButton", this.loc.Wizards.BlankReport, "BlankReport.png"],
        ["standartReportButton", this.loc.Wizards.StandardReport, "StandartReport.png"],
        ["masterDetailReportButton", this.loc.Wizards.MasterDetailReport, "MasterDetailReport.png"]
    ]

    for (var i = 0; i < buttonsProps.length; i++) {
        var button = this.NewReportPanelButton(null, buttonsProps[i][1], buttonsProps[i][2]);
        buttonsTable.addCell(button);
        if (i == buttonsProps.length -1) button.style.marginRight = "0px";
        button.key = buttonsProps[i][0];
        button.action = function () {
            form.changeVisibleState(false);
            switch (this.key) {
                case "blankReportButton": { this.jsObject.ActionNewReport(); break; }
                case "standartReportButton":
                case "masterDetailReportButton":
                    {
                        var wizardForm = this.jsObject.options.forms.wizardForm || this.jsObject.InitializeWizardForm();
                        wizardForm.typeReport = this.key == "masterDetailReportButton" ? "MasterDetail" : "Standart";
                        var dataSources = this.jsObject.options.report ? this.jsObject.GetDataSourcesFromDictionary(this.jsObject.options.report.dictionary) : null;
                        wizardForm.dataSourcesFromServer = dataSources;
                        wizardForm.changeVisibleState(true);
                        break;
                    }
            }
        }
    }

    return form;
}