﻿
StiMobileDesigner.prototype.InitializePageSetupForm_ = function () {

    //Image Form
    var pageSetupForm = this.BaseForm("pageSetup", this.loc.Toolbars.ToolbarPageSetup, 1, this.HelpLinks["watermark"]);
    pageSetupForm.mode = "Paper";
    pageSetupForm.width = this.options.isTouchDevice ? 670 : 520;
    pageSetupForm.height = this.options.isTouchDevice ? 550 : 500;

    //Main Table
    var mainTable = this.CreateHTMLTable();
    mainTable.className = "stiDesignerImageFormMainPanel";
    pageSetupForm.container.appendChild(mainTable);
    pageSetupForm.container.style.padding = "0px";

    //Buttons
    var buttonProps = [
        ["Paper", "PagePaper.png", this.loc.PropertyMain.Paper],
        ["Columns", "PageColumns.png", this.loc.PropertyMain.Columns],
        ["Watermark", "PageWatermark.png", this.loc.PropertyMain.Watermark]
    ];

    //Add Panels && Buttons
    var panelsContainer = mainTable.addCell();
    panelsContainer.className = "stiDesignerPageSetupFormPanel";
    var buttonsPanel = mainTable.addCell();
    buttonsPanel.style.verticalAlign = "top";
    pageSetupForm.mainButtons = {};
    pageSetupForm.panels = {};

    for (var i = 0; i < buttonProps.length; i++) {
        var panel = document.createElement("Div");
        if (i != 0) panel.style.display = "none";
        panelsContainer.appendChild(panel);
        pageSetupForm.panels[buttonProps[i][0]] = panel;

        var button = this.StandartFormBigButton("pageSetupForm" + buttonProps[i][0] + "Button", null, buttonProps[i][2], buttonProps[i][1], buttonProps[i][2], 80);
        button.style.margin = "2px";
        pageSetupForm.mainButtons[buttonProps[i][0]] = button;
        buttonsPanel.appendChild(button);
        button.panelName = buttonProps[i][0];
        button.action = function () {
            pageSetupForm.setMode(this.panelName);
        }
    }

    pageSetupForm.panels.Paper.appendChild(this.PageSetupPaperBlock(pageSetupForm));
    pageSetupForm.panels.Columns.appendChild(this.PageSetupColumnsBlock(pageSetupForm));
    pageSetupForm.panels.Watermark.appendChild(this.PageSetupWatermarkBlock(pageSetupForm));

    pageSetupForm.setMode = function (mode) {
        pageSetupForm.mode = mode;
        for (var panelName in pageSetupForm.panels) {
            pageSetupForm.panels[panelName].style.display = mode == panelName ? "" : "none";
            pageSetupForm.mainButtons[panelName].setSelected(mode == panelName);
        }
    }

    pageSetupForm.changeSizeValues = function () {
        var controls = this.jsObject.options.controls;
        var buttons = this.jsObject.options.buttons;
        var temp = controls.pageSetupPageWidth.value;
        controls.pageSetupPageWidth.value = controls.pageSetupPageHeight.value;
        controls.pageSetupPageHeight.value = temp;
        var leftMargin = controls.pageSetupLeftMargin.value;
        var topMargin = controls.pageSetupTopMargin.value;
        var rightMargin = controls.pageSetupRightMargin.value;
        var bottomMargin = controls.pageSetupBottomMargin.value;
        controls.pageSetupLeftMargin.value = buttons.pageSetupPortrait.isSelected ? bottomMargin : topMargin;
        controls.pageSetupTopMargin.value = buttons.pageSetupPortrait.isSelected ? leftMargin : rightMargin;
        controls.pageSetupRightMargin.value = buttons.pageSetupPortrait.isSelected ? topMargin : bottomMargin;
        controls.pageSetupBottomMargin.value = buttons.pageSetupPortrait.isSelected ? rightMargin : leftMargin;
    }

    pageSetupForm.action = function () {
        var currentPage = this.jsObject.options.currentPage;
        var controls = this.jsObject.options.controls;
        var buttons = this.jsObject.options.buttons;

        currentPage.properties.paperSize = buttons.pageSetupPaperSize.key;
        currentPage.properties.unitWidth = controls.pageSetupPageWidth.value;
        currentPage.properties.unitHeight = controls.pageSetupPageHeight.value;
        currentPage.properties.orientation = buttons.pageSetupPortrait.isSelected ? "Portrait" : "Landscape";
        currentPage.properties.unitMargins = controls.pageSetupLeftMargin.value + "!" + controls.pageSetupTopMargin.value + "!" +
            controls.pageSetupRightMargin.value + "!" + controls.pageSetupBottomMargin.value;
        currentPage.properties.mirrorMargins = controls.pageSetupMirrorMargins.isChecked;
        currentPage.properties.columns = controls.pageSetupNumberOfColumns.value;
        currentPage.properties.columnWidth = controls.pageSetupColumnWidth.value;
        currentPage.properties.columnGaps = controls.pageSetupColumnGaps.value;
        currentPage.properties.rightToLeft = controls.pageSetupColumnsRightToLeft.isChecked;
        currentPage.properties.waterMarkText = Base64.encode(controls.pageSetupWatermarkText.value);
        currentPage.properties.waterMarkAngle = controls.pageSetupWatermarkAngle.value;
        currentPage.properties.waterMarkFont = controls.pageSetupWatermarkFontName.key + "!" + controls.pageSetupWatermarkFontSize.key + "!" +
            (buttons.pageSetupWatermarkFontBold.isSelected ? "1" : "0") + "!" + (buttons.pageSetupWatermarkFontItalic.isSelected ? "1" : "0") + "!" +
            (buttons.pageSetupWatermarkFontUnderline.isSelected ? "1" : "0") + "!" + (buttons.pageSetupWatermarkFontStrikeout.isSelected ? "1" : "0");
        currentPage.properties.waterMarkTextBrush = controls.pageSetupWatermarkTextBrush.key;
        currentPage.properties.waterMarkEnabled = controls.pageSetupWatermarkEnabled.key != "False";
        currentPage.properties.waterMarkEnabledExpression = controls.pageSetupWatermarkEnabled.key == "Expression" ?
            Base64.encode(controls.pageSetupWatermarkEnabledExpression.value) : "";

        currentPage.properties.waterMarkRightToLeft = controls.pageSetupWatermarkRightToLeft.isChecked;
        currentPage.properties.waterMarkTextBehind = controls.pageSetupWatermarkShowBehind.isChecked;
        currentPage.properties.watermarkImageSrc = encodeURIComponent(controls.pageSetupWatermarkImage.key);
        currentPage.properties.waterMarkImageAlign = controls.pageSetupWatermarkImageAlignment.key;
        currentPage.properties.waterMarkMultipleFactor = controls.pageSetupWatermarkMultipleFactor.value;
        currentPage.properties.waterMarkTransparency = controls.pageSetupWatermarkTransparency.value;
        currentPage.properties.waterMarkRatio = controls.pageSetupWatermarkAspectRatio.isChecked;
        currentPage.properties.waterMarkImageBehind = controls.pageSetupWatermarkShowImageBehind.isChecked;
        currentPage.properties.waterMarkStretch = controls.pageSetupWatermarkImageStretch.isChecked;
        currentPage.properties.waterMarkTiling = controls.pageSetupWatermarkImageTiling.isChecked;

        this.changeVisibleState(false);
        this.jsObject.SendCommandSendProperties(currentPage, ["paperSize", "orientation", "unitWidth", "unitHeight", "unitMargins", "columns", "columnWidth", "columnGaps",
            "rightToLeft", "waterMarkText", "waterMarkAngle", "waterMarkFont", "waterMarkTextBrush", "waterMarkEnabled", "waterMarkEnabledExpression", "waterMarkRightToLeft",
            "waterMarkTextBehind", "waterMarkImageAlign", "waterMarkMultipleFactor", "waterMarkTransparency", "waterMarkRatio", "waterMarkImageBehind", "waterMarkStretch",
            "waterMarkTiling", "watermarkImageSrc", "mirrorMargins"]);
    }
    pageSetupForm.onshow = function () {
        var currentPage = this.jsObject.options.currentPage;
        var controls = this.jsObject.options.controls;
        var buttons = this.jsObject.options.buttons;
        pageSetupForm.setMode("Paper");

        buttons.pageSetupPaperSize.setKey(currentPage.properties.paperSize);
        controls.pageSetupPageWidth.value = currentPage.properties.unitWidth;
        controls.pageSetupPageHeight.value = currentPage.properties.unitHeight;
        if (currentPage.properties.orientation == "Portrait") buttons.pageSetupPortrait.setSelected(true);
        else buttons.pageSetupLandscape.setSelected(true);
        var margins = currentPage.properties.unitMargins.split("!");
        controls.pageSetupLeftMargin.value = margins[0];
        controls.pageSetupTopMargin.value = margins[1];
        controls.pageSetupRightMargin.value = margins[2];
        controls.pageSetupBottomMargin.value = margins[3];
        controls.pageSetupMirrorMargins.setChecked(currentPage.properties.mirrorMargins);
        controls.pageSetupNumberOfColumns.value = currentPage.properties.columns;
        controls.pageSetupColumnWidth.value = currentPage.properties.columnWidth;
        controls.pageSetupColumnGaps.value = currentPage.properties.columnGaps;
        controls.pageSetupColumnsRightToLeft.setChecked(currentPage.properties.rightToLeft);
        controls.pageSetupWatermarkText.value = Base64.decode(currentPage.properties.waterMarkText);
        controls.pageSetupWatermarkAngle.value = currentPage.properties.waterMarkAngle;
        var font = currentPage.properties.waterMarkFont.split("!");
        controls.pageSetupWatermarkFontName.setKey(font[0]);
        controls.pageSetupWatermarkFontSize.setKey(font[1]);
        buttons.pageSetupWatermarkFontBold.setSelected(font[2] == "1");
        buttons.pageSetupWatermarkFontItalic.setSelected(font[3] == "1");
        buttons.pageSetupWatermarkFontUnderline.setSelected(font[4] == "1");
        buttons.pageSetupWatermarkFontStrikeout.setSelected(font[5] == "1");
        controls.pageSetupWatermarkTextBrush.setKey(currentPage.properties.waterMarkTextBrush);

        var waterMarkEnabledExpression = Base64.decode(currentPage.properties.waterMarkEnabledExpression);
        controls.pageSetupWatermarkEnabled.setKey(waterMarkEnabledExpression ? "Expression" : (currentPage.properties.waterMarkEnabled ? "True" : "False"));
        controls.pageSetupWatermarkEnabledExpression.value = waterMarkEnabledExpression;
        pageSetupForm.watermarkExpressionRow.style.display = controls.pageSetupWatermarkEnabled.key == "Expression" ? "" : "none";

        controls.pageSetupWatermarkRightToLeft.setChecked(currentPage.properties.waterMarkRightToLeft);
        controls.pageSetupWatermarkShowBehind.setChecked(currentPage.properties.waterMarkTextBehind);
        controls.pageSetupWatermarkImageAlignment.setKey(currentPage.properties.waterMarkImageAlign);
        controls.pageSetupWatermarkMultipleFactor.value = currentPage.properties.waterMarkMultipleFactor;
        controls.pageSetupWatermarkTransparency.value = currentPage.properties.waterMarkTransparency;
        controls.pageSetupWatermarkImage.key = currentPage.properties.watermarkImageSrc;
        controls.pageSetupWatermarkImage.value = currentPage.properties.watermarkImageSrc
                ? "[" + this.jsObject.loc.PropertyCategory.ImageCategory + "]"
                : "[" + this.jsObject.loc.Report.NotAssigned + "]";

        controls.pageSetupWatermarkAspectRatio.setChecked(currentPage.properties.waterMarkRatio);
        controls.pageSetupWatermarkShowImageBehind.setChecked(currentPage.properties.waterMarkImageBehind);
        controls.pageSetupWatermarkImageStretch.setChecked(currentPage.properties.waterMarkStretch);
        controls.pageSetupWatermarkImageTiling.setChecked(currentPage.properties.waterMarkTiling);
    };

    //Override
    //pageSetupForm.tabbedPane = tabbedPane;
    if (pageSetupForm["buttonHelp"])
        pageSetupForm.buttonHelp.action = function () {
            switch (pageSetupForm.mode) {
                case "Watermark": this.jsObject.ShowHelpWindow(this.jsObject.HelpLinks["watermark"]); break;
                case "Columns": this.jsObject.ShowHelpWindow(this.jsObject.HelpLinks["columns"]); break;
                case "Paper": this.jsObject.ShowHelpWindow(this.form.helpUrl); break;
            }
        };

    return pageSetupForm
}

//Paper Block
StiMobileDesigner.prototype.PageSetupPaperBlock = function (pageSetupForm) {
    var paperSizeBlock = this.FormBlock(pageSetupForm.width, pageSetupForm.height);    
    paperSizeBlock.appendChild(this.FormBlockHeader(this.loc.PropertyMain.PaperSize));
    
    var paperSizeTable = this.CreateHTMLTable();
    paperSizeTable.style.width = "100%";
    paperSizeTable.style.margin = "6px 0 6px 0";
    paperSizeBlock.appendChild(paperSizeTable);
    
    //Paper Size
    var sizeText = paperSizeTable.addCell();
    sizeText.className = "stiDesignerCaptionControlsBigIntervals";
    sizeText.innerHTML = this.loc.PropertyMain.Size + ":";
    
    var sizeButton = this.StandartSmallButton("pageSetupPaperSize", null, " ", null, null, "Down");    
    var sizeMenu = this.PageSizeMenu("pageSetupPageSizeMenu", sizeButton);    
    var buttonTable = this.CreateHTMLTable();
    buttonTable.addCell(sizeButton);
    var sizeButtonCell = paperSizeTable.addCell(buttonTable);    
    sizeButtonCell.className = "stiDesignerControlCellsBigIntervals";
    
    sizeButton.action = function (){ this.jsObject.options.menus.pageSetupPageSizeMenu.changeVisibleState(!this.jsObject.options.menus.pageSetupPageSizeMenu.visible); } 
            
    sizeButton.TextSizes = function (jsObject, num){            
            if (num == 0) return "";
            var unit = jsObject.options.report.properties.reportUnit;
            var pageWidth = jsObject.ConvertPixelToUnit(jsObject.PaperSizesInPixels[num][0]).toFixed(1);
            var pageHeight = jsObject.ConvertPixelToUnit(jsObject.PaperSizesInPixels[num][1]).toFixed(1);
            
            return pageWidth + unit + " X " + pageHeight + unit; 
    }
            
    //Override methods        
    sizeButton.setKey = function (key) {
        this.key = key;
        this.caption.style.fontSize = "12px";
        var text = "<b>" + this.jsObject.options.paperSizes[key] + "</b>  ";
        if (key != 0) text += "(" + this.TextSizes(this.jsObject, key) + ") ";
        this.caption.innerHTML = text;
    }
    
    sizeMenu.action = function (menuItem) {
        menuItem.setSelected(true);
        this.changeVisibleState(false);
        this.parentButton.setKey(menuItem.key);
        if (menuItem.key == 0) return;
        var pageWidth = this.jsObject.ConvertPixelToUnit(this.jsObject.PaperSizesInPixels[parseInt(menuItem.key)][0]).toFixed(1);
        var pageHeight = this.jsObject.ConvertPixelToUnit(this.jsObject.PaperSizesInPixels[parseInt(menuItem.key)][1]).toFixed(1);
        if (Math.round(pageWidth) == pageWidth) pageWidth = Math.round(pageWidth);
        if (Math.round(pageHeight) == pageHeight) pageHeight = Math.round(pageHeight);
        this.jsObject.options.controls.pageSetupPageWidth.value = (this.jsObject.options.buttons.pageSetupPortrait.isSelected) ? pageWidth.toString() : pageHeight.toString();
        this.jsObject.options.controls.pageSetupPageHeight.value = (this.jsObject.options.buttons.pageSetupPortrait.isSelected) ? pageHeight.toString() : pageWidth.toString();
    }
    
    sizeMenu.onshow = function() {        
        for (var itemName in this.items) {
            var num = parseInt(this.items[itemName].key);
            if (this.items[itemName].key == this.parentButton.key) this.items[itemName].setSelected(true);
            this.items[itemName].caption.innerHTML = "<b>" + this.jsObject.options.paperSizes[num] + "</b><br>  " +
                this.parentButton.TextSizes(this.jsObject, num);
        }
    }       
            
    //Page Width
    paperSizeTable.addRow();    
    var pageWidthText = paperSizeTable.addCellInLastRow();
    pageWidthText.className = "stiDesignerCaptionControlsBigIntervals";
    pageWidthText.innerHTML = this.loc.PropertyMain.Width + ":";

    var pageWidthControl = this.TextBoxDoubleValue("pageSetupPageWidth", 70);   
    var pageWidthControlCell = paperSizeTable.addCellInLastRow(pageWidthControl);
    pageWidthControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Page Height
    paperSizeTable.addRow();    
    var pageHeightText = paperSizeTable.addCellInLastRow();
    pageHeightText.className = "stiDesignerCaptionControlsBigIntervals";
    pageHeightText.innerHTML = this.loc.PropertyMain.Height + ":";

    var pageHeightControl = this.TextBoxDoubleValue("pageSetupPageHeight", 70);   
    var pageHeightControlCell = paperSizeTable.addCellInLastRow(pageHeightControl);
    pageHeightControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Orientation
    paperSizeTable.addRow();    
    var cellOrientation = paperSizeTable.addCellInLastRow();
    cellOrientation.style.padding = "10px 0 6px 0";
    cellOrientation.setAttribute("colspan", "2");    
    cellOrientation.appendChild(this.FormBlockHeader(this.loc.PropertyMain.Orientation));
    
    var orientationTable = this.CreateHTMLTable();
    orientationTable.style.marginLeft = "10px";
    cellOrientation.appendChild(orientationTable);    
    var portraitButton = this.StandartBigButton("pageSetupPortrait", "pageSetupOrientation",
        this.loc.FormPageSetup.PageOrientationPortrait, "Portrait.png", null, null);
    portraitButton.action = function() { if (!this.isSelected) { this.setSelected(true); this.jsObject.options.forms.pageSetup.changeSizeValues() }; }
    orientationTable.addCell(portraitButton).style.padding = "5px";
    var landscapeButton = this.StandartBigButton("pageSetupLandscape", "pageSetupOrientation",
        this.loc.FormPageSetup.PageOrientationLandscape, "Landscape.png", null, null);
    landscapeButton.action = function() { if (!this.isSelected) { this.setSelected(true); this.jsObject.options.forms.pageSetup.changeSizeValues() }; }
    orientationTable.addCell(landscapeButton).style.padding = "5px";
        
    //Margins
    paperSizeTable.addRow();    
    var cellMargins = paperSizeTable.addCellInLastRow();
    cellMargins.style.padding = "10px 0 6px 0";
    cellMargins.setAttribute("colspan", "2");    
    cellMargins.appendChild(this.FormBlockHeader(this.loc.FormPageSetup.groupMargins));
    
    //Left
    paperSizeTable.addRow();    
    var leftText = paperSizeTable.addCellInLastRow();
    leftText.className = "stiDesignerCaptionControlsBigIntervals";
    leftText.innerHTML = (this.loc.PropertyEnum.StiBorderSidesLeft) + ":";

    var leftControl = this.TextBoxDoubleValue("pageSetupLeftMargin", 70);   
    var leftControlCell = paperSizeTable.addCellInLastRow(leftControl);
    leftControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Right
    paperSizeTable.addRow();    
    var rightText = paperSizeTable.addCellInLastRow();
    rightText.className = "stiDesignerCaptionControlsBigIntervals";
    rightText.innerHTML = (this.loc.PropertyEnum.StiBorderSidesRight) + ":";

    var rightControl = this.TextBoxDoubleValue("pageSetupRightMargin", 70);   
    var rightControlCell = paperSizeTable.addCellInLastRow(rightControl);
    rightControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Top
    paperSizeTable.addRow();    
    var topText = paperSizeTable.addCellInLastRow();
    topText.className = "stiDesignerCaptionControlsBigIntervals";
    topText.innerHTML = (this.loc.PropertyEnum.StiBorderSidesTop) + ":";

    var topControl = this.TextBoxDoubleValue("pageSetupTopMargin", 70);   
    var topControlCell = paperSizeTable.addCellInLastRow(topControl);
    topControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Bottom
    paperSizeTable.addRow();    
    var bottomText = paperSizeTable.addCellInLastRow();
    bottomText.className = "stiDesignerCaptionControlsBigIntervals";
    bottomText.innerHTML = (this.loc.PropertyEnum.StiBorderSidesBottom) + ":";

    var bottomControl = this.TextBoxDoubleValue("pageSetupBottomMargin", 70);   
    var bottomControlCell = paperSizeTable.addCellInLastRow(bottomControl);
    bottomControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Margins
    paperSizeTable.addRow();
    var mirrorMarginsControl = this.CheckBox("pageSetupMirrorMargins", this.loc.PropertyMain.MirrorMargins);
    mirrorMarginsControl.style.marginTop = "5px";
    paperSizeTable.addCellInLastRow(mirrorMarginsControl).className = "stiDesignerCaptionControlsBigIntervals";

    return paperSizeBlock;
}

//Columns Block
StiMobileDesigner.prototype.PageSetupColumnsBlock = function (pageSetupForm) {
    var columnsBlock = this.FormBlock(pageSetupForm.width, pageSetupForm.height);    
    columnsBlock.appendChild(this.FormBlockHeader(this.loc.PropertyMain.Columns));
    
    var columnsTable = this.CreateHTMLTable();
    columnsTable.style.width = "100%";
    columnsTable.style.margin = "6px 0 6px 0";
    columnsBlock.appendChild(columnsTable);
                    
    //NumberOfColumns
    columnsTable.addRow();    
    var numColumnText = columnsTable.addCellInLastRow();
    numColumnText.className = "stiDesignerCaptionControlsBigIntervals";
    numColumnText.innerHTML = this.loc.FormPageSetup.NumberOfColumns;

    var numColumnControl = this.TextBoxPositiveIntValue("pageSetupNumberOfColumns", 70);   
    var numColumnControlCell = columnsTable.addCellInLastRow(numColumnControl);
    numColumnControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Column Width
    columnsTable.addRow();    
    var widthColumnText = columnsTable.addCellInLastRow();
    widthColumnText.className = "stiDesignerCaptionControlsBigIntervals";
    widthColumnText.innerHTML = this.loc.PropertyMain.ColumnWidth + ":";

    var widthColumnControl = this.TextBoxDoubleValue("pageSetupColumnWidth", 70);   
    var widthColumnControlCell = columnsTable.addCellInLastRow(widthColumnControl);
    widthColumnControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Column Gaps
    columnsTable.addRow();    
    var gapsColumnText = columnsTable.addCellInLastRow();
    gapsColumnText.className = "stiDesignerCaptionControlsBigIntervals";
    gapsColumnText.innerHTML = this.loc.PropertyMain.ColumnGaps + ":";

    var gapsColumnControl = this.TextBoxDoubleValue("pageSetupColumnGaps", 70);   
    var gapsColumnControlCell = columnsTable.addCellInLastRow(gapsColumnControl);
    gapsColumnControlCell.className = "stiDesignerControlCellsBigIntervals";
    
    //Columns Right To Left
    columnsTable.addRow();
    
    var rightToLeftColumnsCell = columnsTable.addCellInLastRow();
    rightToLeftColumnsCell.className = "stiDesignerCaptionControlsBigIntervals";
    rightToLeftColumnsCell.style.paddingTop = "7px";
    rightToLeftColumnsCell.style.paddingBottom = "7px";
    rightToLeftColumnsCell.setAttribute("colspan", "2");
        
    var rightToLeftColumnsControl = this.CheckBox("pageSetupColumnsRightToLeft", this.loc.PropertyMain.RightToLeft);
    rightToLeftColumnsCell.appendChild(rightToLeftColumnsControl);
        
    return columnsBlock;
}

//Watermark Block
StiMobileDesigner.prototype.PageSetupWatermarkBlock = function (pageSetupForm) {
    var watermarkBlock = this.FormBlock(pageSetupForm.width, pageSetupForm.height);
    watermarkBlock.appendChild(this.FormBlockHeader(this.loc.Toolbars.ToolbarWatermarkText));

    var watermarkTable = this.CreateHTMLTable();
    watermarkTable.style.width = "100%";
    watermarkTable.style.margin = "6px 0 6px 0";
    watermarkBlock.appendChild(watermarkTable);

    //Text
    watermarkTable.addRow();
    var watermarkTextText = watermarkTable.addCellInLastRow();
    watermarkTextText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkTextText.innerHTML = this.loc.PropertyMain.Text + ":";

    var watermarkTextControl = this.TextArea("pageSetupWatermarkText", 280, 40);
    var watermarkTextControlCell = watermarkTable.addCellInLastRow(watermarkTextControl);
    watermarkTextControlCell.className = "stiDesignerControlCellsBigIntervals";

    //Angle
    watermarkTable.addRow();
    var watermarkAngleText = watermarkTable.addCellInLastRow();
    watermarkAngleText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkAngleText.innerHTML = this.loc.PropertyMain.Angle + ":";

    var watermarkAngleControl = this.TextBoxIntValue("pageSetupWatermarkAngle", 50);
    var watermarkAngleControlCell = watermarkTable.addCellInLastRow(watermarkAngleControl);
    watermarkAngleControlCell.className = "stiDesignerControlCellsBigIntervals";

    //Font
    watermarkTable.addRow();
    var watermarkFontText = watermarkTable.addCellInLastRow();
    watermarkFontText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkFontText.innerHTML = this.loc.PropertyMain.Font + ":";

    var fontTable = this.CreateHTMLTable();
    var watermarkFontControlCell = watermarkTable.addCellInLastRow(fontTable);
    watermarkFontControlCell.className = "stiDesignerControlCellsBigIntervals";

    var fontName = this.FontList("pageSetupWatermarkFontName", 96);
    fontName.action = function () {
        if (this.key == "Aharoni") { this.jsObject.options.buttons.pageSetupWatermarkFontBold.setSelected(true); }
        this.jsObject.options.buttons.pageSetupWatermarkFontBold.isEnabled = !(this.key == "Aharoni");
    };

    fontTable.addCell(fontName);

    var sizeItems = [];
    for (var i in this.options.fontSizes) sizeItems.push(this.Item("sizesFont" + i, this.options.fontSizes[i], null, this.options.fontSizes[i]));
    var fontSize = this.DropDownList("pageSetupWatermarkFontSize", 50, this.loc.HelpDesigner.FontSize, sizeItems, false);
    fontSize.action = function () { this.setKey(Math.abs(this.jsObject.StrToDouble(this.key)).toString()); }
    fontTable.addCell(fontSize).style.padding = "0 4px 0 4px";

    var textBrushButton = this.BrushControl("pageSetupWatermarkTextBrush", null, "TextColor.png", this.loc.PropertyMain.TextBrush);
    fontTable.addCell(textBrushButton).style.padding = "0 2px 0 2px";

    var boldButton = this.StandartSmallButton("pageSetupWatermarkFontBold", null, null, "Bold.png", this.loc.PropertyMain.Bold, null);
    boldButton.action = function () { this.setSelected(!this.isSelected); }
    fontTable.addCell(boldButton).style.padding = "0 2px 0 4px";

    var italicButton = this.StandartSmallButton("pageSetupWatermarkFontItalic", null, null, "Italic.png", this.loc.PropertyMain.Italic, null);
    italicButton.action = function () { this.setSelected(!this.isSelected); }
    fontTable.addCell(italicButton).style.padding = "0 2px 0 2px";

    var underlineButton = this.StandartSmallButton("pageSetupWatermarkFontUnderline", null, null, "Underline.png", this.loc.PropertyMain.Underline, null);
    underlineButton.action = function () { this.setSelected(!this.isSelected); }
    fontTable.addCell(underlineButton).style.padding = "0 2px 0 2px";

    var strikeoutButton = this.StandartSmallButton("pageSetupWatermarkFontStrikeout", null, null, "Strikeout.png", this.loc.PropertyMain.FontStrikeout, null);
    strikeoutButton.action = function () { this.setSelected(!this.isSelected); }
    fontTable.addCell(strikeoutButton).style.padding = "0 2px 0 2px";

    //Watermark Enabled
    watermarkTable.addRow();
    var watermarkEnabledText = watermarkTable.addCellInLastRow();
    watermarkEnabledText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkEnabledText.innerHTML = this.loc.PropertyMain.Enabled + ":";
    var watermarkEnabledControl = this.DropDownList("pageSetupWatermarkEnabled", 180, null, this.GetWatermarkEnabledItems(), false, null, false, true);
    var watermarkEnabledControlCell = watermarkTable.addCellInLastRow(watermarkEnabledControl);
    watermarkEnabledControlCell.className = "stiDesignerControlCellsBigIntervals";
    watermarkEnabledControl.action = function () {
        pageSetupForm.watermarkExpressionRow.style.display = this.key == "Expression" ? "" : "none";
    }

    //Watermark Enabled Expression
    pageSetupForm.watermarkExpressionRow = watermarkTable.addRow();
    var watermarkExpressionText = watermarkTable.addCellInLastRow();
    watermarkExpressionText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkExpressionText.innerHTML = this.loc.PropertyMain.Expression + ":";

    var watermarkExpressionControl = this.ExpressionTextBox("pageSetupWatermarkEnabledExpression", 180);
    var watermarkExpressionControlCell = watermarkTable.addCellInLastRow(watermarkExpressionControl);
    watermarkExpressionControlCell.className = "stiDesignerControlCellsBigIntervals";

    //Watermark Right To Left
    watermarkTable.addRow();
    var watermarkRightToLeftCell = watermarkTable.addCellInLastRow();
    watermarkRightToLeftCell.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkRightToLeftCell.style.paddingTop = "6px";
    watermarkRightToLeftCell.style.paddingBottom = "6px";
    watermarkRightToLeftCell.setAttribute("colspan", "2");

    var watermarkRightToLeftControl = this.CheckBox("pageSetupWatermarkRightToLeft", this.loc.PropertyMain.RightToLeft);
    watermarkRightToLeftCell.appendChild(watermarkRightToLeftControl);

    //Watermark Show Behind
    watermarkTable.addRow();
    var watermarkShowBehindCell = watermarkTable.addCellInLastRow();
    watermarkShowBehindCell.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkShowBehindCell.style.paddingTop = "6px";
    watermarkShowBehindCell.style.paddingBottom = "6px";
    watermarkShowBehindCell.setAttribute("colspan", "2");

    var watermarkShowBehindControl = this.CheckBox("pageSetupWatermarkShowBehind", this.loc.PropertyMain.ShowBehind);
    watermarkShowBehindCell.appendChild(watermarkShowBehindControl);

    //Orientation
    watermarkTable.addRow();
    var cellWatermarkImage = watermarkTable.addCellInLastRow();
    cellWatermarkImage.style.padding = "6px 0 6px 0";
    cellWatermarkImage.setAttribute("colspan", "2");
    cellWatermarkImage.appendChild(this.FormBlockHeader(this.loc.Toolbars.ToolbarWatermarkImage));

    //Watermark Image
    watermarkTable.addRow();
    var watermarkImageText = watermarkTable.addCellInLastRow();
    watermarkImageText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkImageText.innerHTML = this.loc.PropertyCategory.ImageCategory + ":";

    var watermarkImage = this.TextBoxWithEditButton("pageSetupWatermarkImage", 200, null, true);
    watermarkImage.button.action = function () {
        this.jsObject.InitializeEasyImageForm(function (easyImageForm) {
            easyImageForm.resultControlName = "pageSetupWatermarkImage";
            easyImageForm.changeVisibleState(true);
        });
    }
    var watermarkImageControlCell = watermarkTable.addCellInLastRow(watermarkImage);
    watermarkImageControlCell.className = "stiDesignerControlCellsBigIntervals";

    //Image Align
    watermarkTable.addRow();
    var watermarkImageAlignText = watermarkTable.addCellInLastRow();
    watermarkImageAlignText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkImageAlignText.innerHTML = this.loc.PropertyMain.ImageAlignment + ":";

    var imageAlignList = this.ImageList("pageSetupWatermarkImageAlignment", true, false, null, this.GetImageAlignItems());
    imageAlignList.button.caption.style.fontSize = "12px";

    var watermarkImageAlignControlCell = watermarkTable.addCellInLastRow(imageAlignList);
    watermarkImageAlignControlCell.className = "stiDesignerControlCellsBigIntervals";

    //MultipleFactor
    watermarkTable.addRow();
    var watermarkMFactorText = watermarkTable.addCellInLastRow();
    watermarkMFactorText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkMFactorText.innerHTML = this.loc.PropertyMain.ImageMultipleFactor + ":";

    var watermarkMFactorControl = this.TextBoxDoubleValue("pageSetupWatermarkMultipleFactor", 50);
    var watermarkMFactorControlCell = watermarkTable.addCellInLastRow(watermarkMFactorControl);
    watermarkMFactorControlCell.className = "stiDesignerControlCellsBigIntervals";

    //Transparency
    watermarkTable.addRow();
    var watermarkTransparencyText = watermarkTable.addCellInLastRow();
    watermarkTransparencyText.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkTransparencyText.innerHTML = this.loc.PropertyMain.ImageTransparency + ":";

    var watermarkTransparencyControl = this.TextBoxPositiveIntValue("pageSetupWatermarkTransparency", 50);
    var watermarkTransparencyControlCell = watermarkTable.addCellInLastRow(watermarkTransparencyControl);
    watermarkTransparencyControlCell.className = "stiDesignerControlCellsBigIntervals";

    //AspectRatio
    watermarkTable.addRow();
    var watermarkAspectRatioCell = watermarkTable.addCellInLastRow();
    watermarkAspectRatioCell.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkAspectRatioCell.style.paddingTop = "8px";
    watermarkAspectRatioCell.style.paddingBottom = "6px";
    watermarkAspectRatioCell.setAttribute("colspan", "2");

    var watermarkAspectRatioControl = this.CheckBox("pageSetupWatermarkAspectRatio", this.loc.PropertyMain.AspectRatio);
    watermarkAspectRatioCell.appendChild(watermarkAspectRatioControl);

    //Show Image Behind
    watermarkTable.addRow();
    var watermarkShowImgBehindCell = watermarkTable.addCellInLastRow();
    watermarkShowImgBehindCell.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkShowImgBehindCell.style.paddingTop = "6px";
    watermarkShowImgBehindCell.style.paddingBottom = "6px";
    watermarkShowImgBehindCell.setAttribute("colspan", "2");

    var watermarkShowImgBehindControl = this.CheckBox("pageSetupWatermarkShowImageBehind", this.loc.PropertyMain.ShowImageBehind);
    watermarkShowImgBehindCell.appendChild(watermarkShowImgBehindControl);

    //Image Stretch
    watermarkTable.addRow();
    var watermarkStretchCell = watermarkTable.addCellInLastRow();
    watermarkStretchCell.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkStretchCell.style.paddingTop = "6px";
    watermarkStretchCell.style.paddingBottom = "6px";
    watermarkStretchCell.setAttribute("colspan", "2");

    var watermarkStretchControl = this.CheckBox("pageSetupWatermarkImageStretch", this.loc.PropertyMain.ImageStretch);
    watermarkStretchCell.appendChild(watermarkStretchControl);

    //Image Tiling
    watermarkTable.addRow();
    var watermarkTilingCell = watermarkTable.addCellInLastRow();
    watermarkTilingCell.className = "stiDesignerCaptionControlsBigIntervals";
    watermarkTilingCell.style.paddingTop = "6px";
    watermarkTilingCell.style.paddingBottom = "6px";
    watermarkTilingCell.setAttribute("colspan", "2");

    var watermarkTilingControl = this.CheckBox("pageSetupWatermarkImageTiling", this.loc.PropertyMain.ImageTiling);
    watermarkTilingCell.appendChild(watermarkTilingControl);

    return watermarkBlock;
}