﻿
StiMobileDesigner.prototype.InitializeSaveDescriptionForm_ = function () {
    var saveDescriptionForm = this.BaseForm("saveDescriptionForm", this.loc.Services.categoryDesigner, 3);

    saveDescriptionForm.blockHeader = this.FormBlockHeader("Please, type a description of the changes:");
    saveDescriptionForm.container.appendChild(saveDescriptionForm.blockHeader);

    var textArea = this.TextArea("saveDescriptionFormTextArea", 400, 150);
    textArea.style.margin = "8px";
    saveDescriptionForm.container.appendChild(textArea);
    saveDescriptionForm.textArea = textArea;

    textArea.onkeydown = function (e) {
        if (((e.keyCode == 13) || (e.keyCode == 10)) && (e.ctrlKey == false)) {
            saveDescriptionForm.action();
            return false;
        }
        if (((e.keyCode == 13) || (e.keyCode == 10)) && (e.ctrlKey == true)) {
            textArea.value += "\r\n";
            textArea.setSelRange(textArea, textArea.value.length, textArea.value.length);
            return false;
        }
    }

    //This method fixed IExpoler bug
    textArea.setSelRange = function (inputEl, selStart, selEnd) {
        if (inputEl.setSelectionRange) {
            inputEl.focus();
            inputEl.setSelectionRange(selStart, selEnd);
        } else if (inputEl.createTextRange) {
            var range = inputEl.createTextRange();
            range.collapse(true);
            range.moveEnd('character', selEnd);
            range.moveStart('character', selStart);
            range.select();
        }
    }

    saveDescriptionForm.onshow = function () {
        textArea.value = "";
    }

    saveDescriptionForm.actionNo = function () {
        saveDescriptionForm.changeVisibleState(false);
    }

    saveDescriptionForm.buttonClose.action = saveDescriptionForm.actionNo;
    saveDescriptionForm.buttonCancel.action = saveDescriptionForm.actionNo;

    saveDescriptionForm.action = function () {
        saveDescriptionForm.changeVisibleState(false);
        if (this.jsObject.options.cloudParameters) {
            var params = {
                reportTemplateItemKey: this.jsObject.options.cloudParameters.reportTemplateItemKey,
                sessionKey: this.jsObject.options.cloudParameters.sessionKey,
                customMessage: Base64.encode(textArea.value)
            }
            this.jsObject.SendCommandItemResourceSave(params);
        }
    }

    return saveDescriptionForm;
}