﻿
StiMobileDesigner.prototype.InitializeSaveReportForm = function () {

    var saveReportForm = this.BaseForm("saveReport", this.loc.A_WebViewer.SaveReport, 2);
    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "5px";
    saveReportForm.container.appendChild(innerTable);

    var textCell = innerTable.addCell();
    textCell.innerHTML = this.loc.Cloud.labelFileName;
    textCell.className = "stiDesignerCaptionControlsBigIntervals";

    saveReportForm.reportNameTextBox = this.TextBox("saveReportTextBox", 200);
    var textBoxCell = innerTable.addCell(saveReportForm.reportNameTextBox);
    textBoxCell.className = "stiDesignerControlCellsBigIntervals";

    saveReportForm.show = function (saveAs, nextFunc) {
        this.saveAs = saveAs;
        this.nextFunc = nextFunc;
        this.changeVisibleState(true);
        if (this.jsObject.options.report) {
            var fileName = this.jsObject.options.report.properties.reportFile || "Report.mrt";
            if (this.jsObject.options.report.encryptedPassword) {
                if (fileName.toLowerCase().endsWith(".mrt") || fileName.toLowerCase().endsWith(".mrz")) {
                    fileName = fileName.substring(0, fileName.length - 4) + ".mrx";
                }
            }
            this.reportNameTextBox.value = fileName;
        }
    }

    saveReportForm.action = function () {
        if (this.jsObject.options.report)
            this.jsObject.options.report.properties.reportFile = this.reportNameTextBox.value;

        this.changeVisibleState(false);

        if (this.saveAs)
            this.jsObject.SendCommandSaveAsReport();
        else
            this.jsObject.SendCommandSaveReport();

        if (this.nextFunc) this.nextFunc();
    }

    return saveReportForm;
}

StiMobileDesigner.prototype.InitializeSaveInvoiceTemplateForm = function () {

    var form = this.BaseForm("saveInvoiceTemplate", "Save Invoice Template", 2);
    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "5px";
    form.container.appendChild(innerTable);

    var textCell = innerTable.addCell();
    textCell.innerHTML = "Template name:";
    textCell.className = "stiDesignerCaptionControlsBigIntervals";

    form.reportNameTextBox = this.TextBox("saveReportTextBox", 200);
    var textBoxCell = innerTable.addCell(form.reportNameTextBox);
    textBoxCell.className = "stiDesignerControlCellsBigIntervals";

    form.show = function () {        
        this.changeVisibleState(true);
        if (this.jsObject.options.report)
            this.reportNameTextBox.value = this.jsObject.options.report.properties.reportFile || "Template";

    }

    form.action = function () {
        if (this.jsObject.options.report)
            this.jsObject.options.report.properties.reportFile = this.reportNameTextBox.value;

        this.changeVisibleState(false);
        this.jsObject.SendCommandSaveReport();
    }

    return form;
}