﻿
StiMobileDesigner.prototype.InitializeSelectDataForm_ = function () {

    //Select Data Form
    var selectDataForm = this.BaseForm("selectDataForm", "Import Data", 3, this.HelpLinks["data"]);
    selectDataForm.rootItems = ["Tables", "Views", "Queries", "StoredProcedures"];

    var newQuery = this.StandartSmallButton(null, null, this.loc.FormDictionaryDesigner.QueryNew, "DataSourceNew.png");
    newQuery.style.display = "inline-block";
    newQuery.style.margin = "4px";
    selectDataForm.container.appendChild(newQuery);
    selectDataForm.container.appendChild(this.FormSeparator());

    newQuery.action = function () {
        var this_ = this;
        selectDataForm.changeVisibleState(false);
        this.jsObject.InitializeEditDataSourceForm(function (editDataSourceForm) {
            editDataSourceForm.datasource = this_.jsObject.GetDataAdapterTypeFromDatabaseType(selectDataForm.connectionObject.typeConnection);
            editDataSourceForm.nameInSource = selectDataForm.connectionObject.name;
            editDataSourceForm.changeVisibleState(true);
        });
    }

    //Tree
    var tree = this.Tree();
    tree.style.overflow = "auto";
    tree.style.width = "450px";
    tree.style.height = "350px";
    tree.style.padding = "10px";
    selectDataForm.container.appendChild(tree);

    //Progress
    var progress = this.Progress();
    progress.className = "stiDesignerSelectDataProgress";
    progress.style.display = "none";
    selectDataForm.container.appendChild(progress);

    selectDataForm.onshow = function () {
        tree.clear();
        progress.style.display = "";
        this.jsObject.SendCommandGetDatabaseData(this.databaseName);
    }

    selectDataForm.treeItem = function (caption, imageName, itemObject) {
        var item = selectDataForm.jsObject.TreeItem(caption, imageName, itemObject, tree, true);
        item.style.margin = "2px 0 2px 0";

        if (item.checkBox) {
            item.checkBox.action = function () {
                if (this.treeItem.tree.isDisable) return;
                this.treeItem.setChecked(this.isChecked);
                var childs = this.treeItem.getAllChilds();
                for (var i in childs) {
                    childs[i].setChecked(this.isChecked);
                }

                var setCheckedParent = function (treeItem) {
                    if (treeItem.parent) {
                        if (treeItem.isChecked) {
                            treeItem.parent.setChecked(true);
                            setCheckedParent(treeItem.parent);
                        }
                    }
                }

                setCheckedParent(this.treeItem);
            }
        }

        return item;
    }

    selectDataForm.buildTree = function (data) {

        var addRelations = function (parentItem, collection) {
            if (collection) {
                collection.sort(selectDataForm.jsObject.SortByName);
                for (var m = 0; m < collection.length; m++) {
                    var relationObject = collection[m];
                    var relationItem = selectDataForm.treeItem(relationObject.name, relationObject.typeIcon + ".png", relationObject);
                    parentItem.addChild(relationItem);
                }
            }
        }

        var addColumns = function (parentItem, collection) {
            if (collection) {
                collection.sort(selectDataForm.jsObject.SortByName);
                for (var m = 0; m < collection.length; m++) {
                    var columnObject = collection[m];
                    var columnItem = selectDataForm.treeItem(columnObject.name, columnObject.typeIcon + ".png", columnObject);
                    parentItem.addChild(columnItem);
                }
            }
        }

        var addTables = function (parentItem, collection) {
            if (collection) {
                collection.sort(selectDataForm.jsObject.SortByName);

                for (var k = 0; k < collection.length; k++) {
                    var tableItem = selectDataForm.treeItem(collection[k].name, "Data.Data" + collection[k].typeItem + ".png", collection[k]);
                    parentItem.addChild(tableItem);

                    var relations = collection[k].relations;
                    if (relations) addRelations(tableItem, relations);

                    var columns = collection[k].columns;
                    if (columns) addColumns(tableItem, columns);
                }
            }
        }

        progress.style.display = "none";
        for (var i = 0; i < selectDataForm.rootItems.length; i++) {
            var rootItem = selectDataForm.treeItem(selectDataForm.typeConnection == "StiMongoDbDatabase" ? "Collections" : selectDataForm.rootItems[i], "Data.Data" + selectDataForm.rootItems[i] + ".png", null);
            tree["rootItem" + selectDataForm.rootItems[i]] = rootItem;
            tree.appendChild(rootItem);

            if (selectDataForm.typeConnection == "StiMongoDbDatabase" && selectDataForm.rootItems[i] != "Tables") rootItem.style.display = "none";

            if (data && data[selectDataForm.rootItems[i]]) {
                rootItem.setOpening(true);
                addTables(rootItem, data[selectDataForm.rootItems[i]]);
            }
        }
    }

    selectDataForm.action = function () {
        var resultCollection = [];

        for (var i = 0; i < selectDataForm.rootItems.length; i++) {
            var rootItem = tree["rootItem" + selectDataForm.rootItems[i]];

            for (var tableKey in rootItem.childs) {
                var addTable = false;
                var tableItem = rootItem.childs[tableKey];
                if (tableItem.isChecked) addTable = true;

                var columns = [];
                var relations = [];
                var allColumns = [];
                for (var childKey in tableItem.childs) {
                    var childItem = tableItem.childs[childKey];
                    if (childItem.itemObject.typeItem == "Relation") {
                        if (childItem.isChecked) {
                            addTable = true;
                            relations.push(childItem.itemObject);
                        }
                    }
                    else {
                        allColumns.push(childItem.itemObject);
                        if (childItem.isChecked) {
                            addTable = true;
                            columns.push(childItem.itemObject);
                        }
                    }
                }
                columns.sort(selectDataForm.jsObject.SortByName);
                relations.sort(selectDataForm.jsObject.SortByName);

                if (addTable) {
                    var table = tableItem.itemObject;
                    table.countAllColumns = allColumns.length;
                    table.columns = columns;
                    table.relations = relations;
                    table.allColumns = allColumns;
                    resultCollection.push(table);
                }
            }
        }

        selectDataForm.changeVisibleState(false);
        if (resultCollection.length > 0) selectDataForm.jsObject.SendCommandApplySelectedData(resultCollection, selectDataForm.databaseName);
    }

    return selectDataForm;
}