﻿
StiMobileDesigner.prototype.InitializeViewDataForm_ = function () {
    var viewDataForm = this.BaseForm("viewDataForm", this.loc.FormDictionaryDesigner.ViewData, 4);
    viewDataForm.buttonCancel.style.display = "none";
    viewDataForm.container.style.width = "750px";
    viewDataForm.container.style.height = "500px";
    viewDataForm.container.style.overflow = "auto";

    viewDataForm.show = function (data, dataSourceName) {

        viewDataForm.caption.innerHTML = viewDataForm.jsObject.loc.FormDictionaryDesigner.ViewData + " - " + dataSourceName;

        while (this.container.childNodes[0]) this.container.removeChild(this.container.childNodes[0]);
        if (!data) {
            this.changeVisibleState(true);
            return;
        }
                
        var dataTable = this.jsObject.CreateHTMLTable();
        this.container.appendChild(dataTable);
        if (data.length > 1) {
            var imgColumns = {};

            for (var i = 0; i < data[0].length; i++) {
                var captionCell = dataTable.addTextCell(data[0][i]);
                captionCell.style.fontWeight = "bold";
                captionCell.style.textAlign = "center";
                captionCell.className = "stiDesignerViewDataTableCell";
            }
            
            for (var i = 1; i < data.length; i++) {
                dataTable.addRow();
                for (var k = 0; k < data[i].length; k++) {
                    var cell = dataTable.addCellInLastRow();
                    if (data[i][k].type == "Image") {
                        var img = document.createElement("img");
                        img.src = data[i][k].value;
                        cell.appendChild(img);
                    }
                    else {
                        cell.innerHTML = data[i][k].value;
                        cell.className = "stiDesignerViewDataTableCell";
                    }
                }
            }
        }

        try {
            var win = window.open();

            if (win && win.document) {
                win.document.write("<script>document.title = '" + viewDataForm.jsObject.loc.FormDictionaryDesigner.ViewData + " - " + dataSourceName +
                    "';</script><style> .stiDesignerViewDataTableCell { font-family: Arial; font-size: 12px; padding: 4px 15px 4px 4px; color: #444444;" +
                    "border-bottom: 1px dotted #c6c6c6; border-right: 1px dotted #c6c6c6; } </style>");
                win.document.write(this.container.innerHTML);
            }
            else {
                this.changeVisibleState(true);
                return;
            }
        }
        catch (e) {
            this.changeVisibleState(true);
        }
    }

    viewDataForm.action = function () {
        this.changeVisibleState(false);
    }

    return viewDataForm;
}