﻿
StiMobileDesigner.prototype.InitializeAboutPanel = function () {
    var aboutPanel = document.createElement("div");
    this.options.aboutPanel = aboutPanel;
    this.options.mainPanel.appendChild(aboutPanel);
    aboutPanel.jsObject = this;
    aboutPanel.className = "stiDesignerAboutPanel";
    aboutPanel.style.background = "url(" + this.options.images["About.png"] + ")";
    aboutPanel.style.display = "none";

    var version = document.createElement("div");
    version.innerHTML = "Version " + this.options.productVersion;
    aboutPanel.appendChild(version);
    version.style.position = "absolute";
    version.style.fontFamily = "Arial";
    version.style.fontSize = "8pt";
    version.style.color = "#383533";
    version.style.padding = "0px 55px 0px 248px";
    version.style.top = "109px";

    var copyRight = document.createElement("div");
    copyRight.innerHTML = "Copyright 2003-" + new Date().getFullYear() + " by Stimulsoft, All rights reserved.";
    aboutPanel.appendChild(copyRight);
    copyRight.style.position = "absolute";
    copyRight.style.fontFamily = "Arial";
    copyRight.style.fontSize = "8pt";
    copyRight.style.color = "#8a8a8a";
    copyRight.style.textAlign = "center";
    copyRight.style.width = "100%";
    copyRight.style.top = "231px";

    aboutPanel.ontouchstart = function () { this.changeVisibleState(false); }
    aboutPanel.onmousedown = function () { this.changeVisibleState(false); }

    aboutPanel.changeVisibleState = function (state) {
        this.style.display = state ? "" : "none";
        this.jsObject.SetObjectToCenter(this);
        if (!this.jsObject.options.disabledPanels) this.jsObject.InitializeDisabledPanels();
        this.jsObject.options.disabledPanels[2].changeVisibleState(state);
        if (this.jsObject.options.previewMode && this.jsObject.options.viewer) {
            this.jsObject.options.viewer.jsObject.options.disabledPanels[1].style.display = state ? "" : "none";
        }
        if (this.jsObject.options.buttons["About"]) this.jsObject.options.buttons["About"].setSelected(state);
    }

    return aboutPanel;
}