﻿
StiMobileDesigner.prototype.ExecuteAction = function (name) {
    var jsObject = this;
    switch (name) {
        case "newReport":
            {
                var newReportPanel = this.options.newReportPanel || this.InitializeNewReportPanel();
                newReportPanel.changeVisibleState(true);
                break;
            }
        case "infoReport":
            {
                var infoReportPanel = this.options.infoReportPanel || this.InitializeInfoReportPanel();
                infoReportPanel.changeVisibleState(true);
                break;
            }
        case "blankReportButton":
            {
                var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                fileMenu.changeVisibleState(false);
                setTimeout(function () { jsObject.ActionNewReport(); }, 200);
                break;
            }
        case "standartReportButton":
        case "masterDetailReportButton":
            {
                var wizardForm = this.options.forms.wizardForm || this.InitializeWizardForm();
                wizardForm.typeReport = name == "masterDetailReportButton" ? "MasterDetail" : "Standart";
                var dataSources = jsObject.options.report ? jsObject.GetDataSourcesFromDictionary(jsObject.options.report.dictionary) : null;
                wizardForm.dataSourcesFromServer = dataSources;
                wizardForm.changeVisibleState(true);
                break;
            }
        case "openReport":
            {
                var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                fileMenu.changeVisibleState(false);
                setTimeout(function () { jsObject.ActionOpenReport(); }, 200);
                break;
            }
        case "saveReport":
            {
                var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                fileMenu.changeVisibleState(false);
                setTimeout(function () { jsObject.ActionSaveReport(); }, 200);
                break;
            }
        case "saveAsReport":
            {
                var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                fileMenu.changeVisibleState(false);
                setTimeout(function () { jsObject.ActionSaveAsReport(); }, 200);
                break;
            }
        case "closeReport":
            {
                var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                fileMenu.changeVisibleState(false);
                setTimeout(function () { jsObject.ActionCloseReport(); }, 200);
                break;
            }
        case "exitDesigner":
            {
                if (this.options.isJava)
                    window.history.back();
                else {
                    var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                    fileMenu.changeVisibleState(false);
                    setTimeout(function () { jsObject.ActionExitDesigner(); }, 200);
                    break;
                }
            }
        case "closeFileMenu":
            {
                var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                fileMenu.changeVisibleState(false);
                break;
            }
        case "fileButton":
            {
                var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                fileMenu.changeVisibleState(true);
                break;
            }
        case "homeToolButton":
            {
                this.options.workPanel.showPanel(this.options.homePanel);
                this.options.workPanel.changeVisibleState(true);
                break;
            }
        case "insertToolButton":
            {
                if (!this.options.insertPanel) this.InitializeInsertPanel();
                this.options.workPanel.showPanel(this.options.insertPanel);
                this.options.workPanel.changeVisibleState(true);
                break;
            }
        case "layoutToolButton":
            {
                if (!this.options.layoutPanel) this.InitializeLayoutPanel();
                this.options.layoutPanel.updateControls();
                this.options.workPanel.showPanel(this.options.layoutPanel);
                this.options.workPanel.changeVisibleState(true);
                break;
            }
        case "previewToolButton":
            {
                if (!this.options.previewPanel) this.InitializePreviewPanel();

                if (this.options.cloudMode) {
                    if (this.options.buttons.previewToolButton) this.options.buttons.previewToolButton.progress.style.visibility = "visible";
                    this.options.workPanel.showPanel(this.options.previewPanel);
                    this.options.workPanel.changeVisibleState(true);
                    this.ShowReportInTheViewer(this.options.cloudParameters.reportTemplateItemKey);
                }
                else {
                    if (!this.options.viewer && !this.options.mvcMode && !this.options.jsMode) {
                        var jsObject = this;
                        var processImage = this.options.processImage || this.InitializeProcessImage();
                        processImage.show();

                        var viewerParameters = window["js" + jsObject.options.viewerId + "Parameters"];

                        var createViewer = function (viewerParameters) {
                            if (viewerParameters) {
                                var jsViewer = window["js" + jsObject.options.viewerId] = new StiMobileViewer(viewerParameters);
                                jsObject.options.viewer = jsViewer.options.mobileViewer;
                                jsObject.options.viewerContainer.appendChild(jsObject.options.viewer);
                                jsObject.options.viewer.style.display = "";
                            }
                            jsObject.options.workPanel.showPanel(jsObject.options.previewPanel);
                            jsObject.options.workPanel.changeVisibleState(true);
                            jsObject.options.processImage.hide();
                            jsObject.SendCommandLoadReportToViewer();
                        }

                        if (typeof (StiMobileViewer) != 'undefined') {
                            createViewer(viewerParameters);
                        }
                        else {
                            this.LoadStyle(this.options.stylesUrl.replace("MobileDesignerStyleName", "Viewer"));
                            this.LoadScript(this.options.scriptsUrl.replace("MobileDesignerScriptName", "Viewer"), function () {
                                createViewer(viewerParameters);
                            });
                        }
                    }
                    else {
                        this.options.workPanel.showPanel(this.options.previewPanel);
                        this.options.workPanel.changeVisibleState(true);
                        if (this.options.mvcMode)
                            this.SendCommandGetPreviewPages(0, true);
                        else
                            this.SendCommandLoadReportToViewer();
                    }
                }
                break;
            }
        case "zoomIn":
            {
                if (Math.round(this.options.report.zoom * 10) / 10 < 2) {
                    this.options.report.zoom += 0.1;
                    this.PreZoomPage(this.options.currentPage);
                }
                break;
            }
        case "zoomOut":
            {
                if (Math.round(this.options.report.zoom * 10) / 10 > 0.1) {
                    this.options.report.zoom -= 0.1;
                    this.PreZoomPage(this.options.currentPage);
                }
                break;
            }
        case "unitButton":
            {
                this.options.menus.unitMenu.changeVisibleState(!this.options.menus.unitMenu.visible);
                break;
            }
        case "insertBands":
            {
                this.options.menus.bandsMenu.changeVisibleState(!this.options.menus.bandsMenu.visible);
                break;
            }
        case "insertCrossBands":
            {
                this.options.menus.crossBandsMenu.changeVisibleState(!this.options.menus.crossBandsMenu.visible);
                break;
            }
        case "insertComponents":
            {
                this.options.menus.componentsMenu.changeVisibleState(!this.options.menus.componentsMenu.visible);
                break;
            }
        case "insertShapes":
            {
                this.options.menus.shapesMenu.changeVisibleState(!this.options.menus.shapesMenu.visible);
                break;
            }
        case "insertInfographics":
            {
                this.options.menus.infographicsMenu.changeVisibleState(!this.options.menus.infographicsMenu.visible);
                break;
            }
        case "addPage":
            {
                this.SendCommandAddPage(this.options.currentPage.properties.pageIndex);
                break;
            }
        case "removePage":
            {
                this.options.currentPage.remove();
                break;
            }
        case "duplicatePage":
            {
                this.SendCommandDuplicatePage(this.options.currentPage.properties.pageIndex);
                break;
            }
        case "marginsPage":
            {
                this.options.menus.marginsMenu.changeVisibleState(!this.options.menus.marginsMenu.visible);
                break;
            }
        case "orientationPage":
            {
                this.options.menus.orientationMenu.changeVisibleState(!this.options.menus.orientationMenu.visible);
                break;
            }
        case "columnsPage":
            {
                this.options.menus.columnsMenu.changeVisibleState(!this.options.menus.columnsMenu.visible);
                break;
            }
        case "pageSize":
            {
                this.options.menus.pageSizeMenu.changeVisibleState(!this.options.menus.pageSizeMenu.visible);
                break;
            }
        case "groupBlockPageSetupButton":
            {
                this.InitializePageSetupForm(function (pageSetupForm) {
                    pageSetupForm.changeVisibleState(true);
                });
                break;
            }
        case "removeComponent":
            {
                if (this.options.selectedObjects) this.RemoveComponent(this.options.selectedObjects);
                else if (this.options.selectedObject) this.options.selectedObject.remove();
                break;
            }
        case "copyComponent":
            {
                if (this.options.selectedObjects) this.CopyComponent(this.options.selectedObjects);
                else if (this.options.selectedObject) this.options.selectedObject.copy();
                break;
            }
        case "cutComponent":
            {
                if (this.options.selectedObjects) this.CutComponent(this.options.selectedObjects);
                else if (this.options.selectedObject) this.options.selectedObject.cut();
                break;
            }
        case "pasteComponent":
            {
                this.SendCommandGetFromClipboard();
                break;
            }
        case "aboutButton":
            {
                var aboutPanel = this.options.aboutPanel || this.InitializeAboutPanel();
                aboutPanel.changeVisibleState(true);
                break;
            }
        case "showToolBarButton":
            {
                this.options.workPanel.changeVisibleState(true);
                this.options.workPanel.visibleState = true;
                break;
            }
        case "hideToolbarButton":
            {
                this.options.workPanel.changeVisibleState(false);
                this.options.workPanel.visibleState = false;
                break;
            }
        case "zoomInfo":
            {
                this.options.report.zoom = 1;
                this.PreZoomPage(this.options.currentPage);
                break;
            }
        case "undoButton":
            {
                this.SendCommandUndo();
                break;
            }
        case "redoButton":
            {
                this.SendCommandRedo();
                break;
            }
        case "resizeDesigner":
            {
                this.ResizeDesigner();
                break;
            }
        case "groupBlockBordersButton":
            {
                this.InitializeBorderSetupForm(function (borderSetupForm) {
                    borderSetupForm.showFunction = null;
                    borderSetupForm.actionFunction = null;
                    borderSetupForm.changeVisibleState(true);
                });
                break;
            }
        case "reportSetup":
            {
                setTimeout(function () {
                    jsObject.InitializeReportSetupForm(function (reportSetupForm) {
                        reportSetupForm.show();
                    });
                }, 200);
                break;
            }
        case "pageSetup":
            {
                this.InitializePageSetupForm(function (pageSetupForm) {
                    pageSetupForm.changeVisibleState(true);
                });
                break;
            }
        case "pageMoveLeft":
            {
                this.SendCommandPageMove("Left", this.options.currentPage.properties.pageIndex);
                break;
            }
        case "pageMoveRight":
            {
                this.SendCommandPageMove("Right", this.options.currentPage.properties.pageIndex);
                break;
            }
        case "optionsDesigner":
            {
                var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
                fileMenu.changeVisibleState(false);
                setTimeout(function () {
                    jsObject.InitializeOptionsForm(function (optionsForm) {
                        optionsForm.show();
                    });
                }, 200);
                break;
            }
        case "groupBlockReportButton":
            {
                jsObject.InitializeReportSetupForm(function (reportSetupForm) {
                    reportSetupForm.show();
                });
                break;
            }
    }
}