
StiMobileDesigner.prototype.InitializeDesigner = function () {

    this.options.mobileDesigner.pressedDown = function () {
        var options = this.jsObject.options;
                
        //Close Current Menu
        if (options.currentMenu != null) {
            if (options.menuPressed != options.currentMenu && options.currentMenu.parentButton != options.buttonPressed &&
                !options.horMenuPressed && options.horMenuPressed != options.currentMenu.parentMenu &&
                (!(options.imageListMenuPressed || options.dropDownListMenuPressed || options.colorDialogPressed)))
                options.currentMenu.changeVisibleState(false);
        }

        //Close Current HorMenu
        if (options.currentHorMenu != null) {
            if (options.horMenuPressed != options.currentHorMenu && options.currentHorMenu.parentButton != options.buttonPressed &&
                options.currentHorMenu.parentButton != options.menuItemPressed && (!(options.imageListMenuPressed || options.dropDownListMenuPressed || options.colorDialogPressed)))
                options.currentHorMenu.changeVisibleState(false);
        }

        //Close Current ImageList
        if (options.currentImageListMenu != null)
            if (options.imageListMenuPressed != options.currentImageListMenu && options.currentImageListMenu.parentButton != options.buttonPressed)
                options.currentImageListMenu.changeVisibleState(false);

        //Close Current DropDownList
        if (options.currentDropDownListMenu != null)
            if (options.dropDownListMenuPressed != options.currentDropDownListMenu && options.currentDropDownListMenu.parentButton != options.buttonPressed)
                options.currentDropDownListMenu.changeVisibleState(false);

        //Close Current ColorDialog
        if (options.currentColorDialog != null)
            if (options.colorDialogPressed != options.currentColorDialog && options.currentColorDialog.parentButton != options.buttonPressed)
                options.currentColorDialog.changeVisibleState(false);

        //Close Current DatePicker
        if (options.currentDatePicker != null)
            if (options.datePickerPressed != options.currentDatePicker && options.currentDatePicker.parentButton != options.buttonPressed)
                options.currentDatePicker.changeVisibleState(false);

        //Close Draw Component Mode
        if (((!options.buttonPressed && !options.pagePressed) || (options.buttonPressed && options.buttonPressed.groupName != "Components")) && !options.menuPressed && options.insertPanel)
            options.insertPanel.resetChoose();

        //Close Properties Panel       
        if (!options.propertiesPanelPressed && options.propertiesPanel.fixedViewMode && !options.menuPressed && !options.dropDownListMenuPressed &&
            !options.imageListMenuPressed && !options.colorDialogPressed && !options.datePickerPressed && !options.formPressed && !options.disabledPanelPressed)
            options.propertiesPanel.changeVisibleState(false);

        //Hide Check Popup Panel
        if (options.checkPopupPanel) {
            options.checkPopupPanel.hide();
        }

        //Hide Check Preview Panel
        if (options.checkPreviewPanel) {
            options.checkPreviewPanel.hide();
        }

        //Close Report Checker Panel
        if (options.checkPanel && options.checkPanel.isVisible && !options.checkPanelPressed)
            options.checkPanel.changeVisibleState(false);

        options.buttonPressed = false;
        options.menuItemPressed = false;
        options.menuPressed = false;
        options.horMenuPressed = false;
        options.formPressed = false;
        options.dropDownListMenuPressed = false;
        options.imageListMenuPressed = false;
        options.colorDialogPressed = false;
        options.pagePressed = false;
        options.fingerIsMoved = false;
        options.disabledPanelPressed = false;
        options.datePickerPressed = false;
        options.propertiesPanelPressed = false;
        options.checkPanelPressed = false;
    }

    this.options.mobileDesigner.onmousedown = function () {
        if (this.isTouchStartFlag) return;
        this.jsObject.options.isTouchClick = false;
        this.pressedDown();
        this.jsObject.options.designerIsFocused = true;
    }

    this.options.mobileDesigner.ontouchstart = function () {
        var this_ = this;
        this.isTouchStartFlag = true;
        clearTimeout(this.isTouchStartTimer);
        if (this.jsObject.options.buttonsTimer) {
            clearTimeout(this.jsObject.options.buttonsTimer[2]);
            this.jsObject.options.buttonsTimer[0].className = this.jsObject.options.buttonsTimer[1];
            this.jsObject.options.buttonsTimer = null;
        }
        this.jsObject.options.isTouchClick = true;
        this.pressedDown();
        this.isTouchStartTimer = setTimeout(function () {
            this_.isTouchStartFlag = false;
        }, 1000);
    }

    this.options.mobileDesigner.onmouseup = function () {
        if (this.isTouchEndFlag) return;
        this.ontouchend(true);
        clearTimeout(this.jsObject.options.scrollLeftTimer);
        clearTimeout(this.jsObject.options.scrollRightTimer);
    }

    this.options.mobileDesigner.ontouchend = function (mouseProcess) {
        var this_ = this;
        this.isTouchEndFlag = mouseProcess ? false : true;
        clearTimeout(this.isTouchEndTimer);
        this.jsObject.options.fingerIsMoved = false;
        this.isTouchEndTimer = setTimeout(function () {
            this_.isTouchEndFlag = false;
        }, 1000);
    }

    this.options.mobileDesigner.ontouchmove = function () {
        this.jsObject.options.fingerIsMoved = true;
    }
        
    var jsObject = this;

    this.addEvent(window, 'blur', function (event) {
        jsObject.options.designerIsFocused = false;
        jsObject.options.CTRL_pressed = false;
        jsObject.options.SHIFT_pressed = false;
    });

    this.addEvent(window, 'focus', function (event) {
        jsObject.options.designerIsFocused = true;
    });

    this.addEvent(window, 'keyup', function (e) {
        if (e) {
            if (e.keyCode == 17) {
                jsObject.options.CTRL_pressed = false;
            }
            else if (e.keyCode == 16) {
                jsObject.options.SHIFT_pressed = false;
            }
        }
    });

    this.addEvent(window, 'keydown', function (e) {
        if (!jsObject.options.designerIsFocused) return;
        if (e) {
            if (e.keyCode == 17) {
                jsObject.options.CTRL_pressed = true;
            }
            else if (e.keyCode == 16) {
                jsObject.options.SHIFT_pressed = true;
            }
            else if (e.keyCode == 46) {
                if (jsObject.options.buttons.removeComponent.isEnabled && !jsObject.options.controlsIsFocused && !jsObject.options.currentForm) {
                    jsObject.ExecuteAction("removeComponent");
                }
            }
            else if (e.keyCode == 27) {
                if (jsObject.options.currentForm && jsObject.options.currentForm.visible) {
                    jsObject.options.currentForm.changeVisibleState(false);
                    jsObject.options.mobileDesigner.pressedDown();
                }
            }
            else if (e.keyCode == 67 && jsObject.options.CTRL_pressed) {
                if ((!jsObject.options.currentForm || !jsObject.options.currentForm.visible) &&
                    jsObject.options.buttons.copyComponent.isEnabled && !jsObject.options.controlsIsFocused)
                    jsObject.ExecuteAction("copyComponent");
            }
            else if (e.keyCode == 86 && jsObject.options.CTRL_pressed) {
                if ((!jsObject.options.currentForm || !jsObject.options.currentForm.visible) &&
                    jsObject.options.buttons.pasteComponent.isEnabled && !jsObject.options.controlsIsFocused)
                    jsObject.ExecuteAction("pasteComponent");
            }
            else if (e.keyCode == 90 && jsObject.options.CTRL_pressed) {
                if ((!jsObject.options.currentForm || !jsObject.options.currentForm.visible) &&
                    jsObject.options.buttons.undoButton.isEnabled && !jsObject.options.controlsIsFocused)
                    jsObject.ExecuteAction("undoButton");
            }
        }
    });

    this.addEvent(window, 'beforeunload', function (event) {
        if (jsObject.options.reportIsModified && /*!jsObject.options.previewMode &&*/
            !jsObject.options.scrollbiMode && !jsObject.options.ignoreBeforeUnload) {
            var msg = "Are you sure you want to leave this page without saving the report?";
            if (typeof event == "undefined") event = window.event;
            if (event) event.returnValue = msg;

            // For Safari
            return msg;

            var messageForm = jsObject.MessageFormForSave();
            messageForm.changeVisibleState(true);
            messageForm.action = function (state) {
                if (state) {
                    jsObject.ActionSaveReport();
                }
            }
        }
    });
}

