﻿
StiMobileDesigner.prototype.InitializeNewReportPanel = function () {
    var newReportPanel = document.createElement("div");
    newReportPanel.jsObject = this;
    this.options.newReportPanel = newReportPanel;
    this.options.mainPanel.appendChild(newReportPanel);
    newReportPanel.style.display = "none";
    newReportPanel.className = "stiDesignerNewReportPanel";

    var buttonsTable = this.CreateHTMLTable();
    newReportPanel.appendChild(buttonsTable);

    buttonsTable.addCell(this.NewReportPanelButton("blankReportButton", this.loc.Wizards.BlankReport, "BlankReport.png"));
    buttonsTable.addCell(this.NewReportPanelButton("standartReportButton", this.loc.Wizards.StandardReport, "StandartReport.png"));
    buttonsTable.addCell(this.NewReportPanelButton("masterDetailReportButton", this.loc.Wizards.MasterDetailReport, "MasterDetailReport.png"));

    newReportPanel.changeVisibleState = function (state) {
        this.style.display = state ? "" : "none";
        var fileMenu = this.jsObject.options.menus.fileMenu || this.jsObject.InitializeFileMenu();
        if (fileMenu.items.newReport) fileMenu.items.newReport.setSelected(state);
    }

    return newReportPanel;
}

StiMobileDesigner.prototype.NewReportPanelButton = function(name, caption, image) {
    var button = this.BigButton(name, null, caption, image, caption, null, this.GetStyles("NewReportButton"), true);
    button.style.margin = "10px";
    
    return button;    
}