﻿
StiMobileDesigner.prototype.InitializeInsertPanel = function () {
    var insertPanel = this.ChildWorkPanel("insertPanel", "stiDesignerInsertPanel");
    insertPanel.style.display = "none";
    insertPanel.selectedComponent = null;

    insertPanel.resetChoose = function () {
        this.jsObject.options.drawComponent = false;
        this.jsObject.options.paintPanel.changeCursorType(false);
        if (this.selectedComponent) this.selectedComponent.setSelected(false);
        if (!this.jsObject.options.componentsIntoInsertTab) {
            this.jsObject.options.buttons.insertBands.setSelected(false);
            this.jsObject.options.buttons.insertCrossBands.setSelected(false);
            this.jsObject.options.buttons.insertComponents.setSelected(false);
            this.jsObject.options.buttons.insertInfographics.setSelected(false);
        }
    }

    var innerTable = this.CreateHTMLTable();
    insertPanel.appendChild(innerTable);

    if (!this.options.componentsIntoInsertTab) {
        innerTable.addCell(this.GroupBlock("groupBlockGroupsComponents", this.loc.Wizards.Groups, false, null));
        innerTable.addCell(this.GroupBlockSeparator());
    }
    innerTable.addCell(this.GroupBlock("groupBlockMainComponents", this.loc.PropertyCategory.MainCategory, false, null));
    innerTable.addCell(this.GroupBlockSeparator());

    //Groups
    if (!this.options.componentsIntoInsertTab) {
        var groupsTable = this.GroupBlockInnerTable();
        this.options.controls.groupBlockGroupsComponents.container.appendChild(groupsTable);
        groupsTable.addCell(this.BigButton("insertBands", null, this.loc.Report.Bands, "Bands.png",
        [this.loc.Report.Bands, this.HelpLinks["insertcomponent"]], true, this.GetStyles("StandartBigButton")));
        this.BandsMenu();
        groupsTable.addCell(this.BigButton("insertCrossBands", null, this.loc.Report.CrossBands, "CrossBands.png",
        [this.loc.Report.CrossBands, this.HelpLinks["insertcomponent"]], true, this.GetStyles("StandartBigButton")));
        this.CrossBandsMenu();
        groupsTable.addCell(this.BigButton("insertComponents", null, this.loc.Report.Components, "Components.png",
        [this.loc.Report.Components, this.HelpLinks["insertcomponent"]], true, this.GetStyles("StandartBigButton")));
        this.ComponentsMenu();
        groupsTable.addCell(this.BigButton("insertShapes", null, this.loc.Report.Shapes, "StiShape.png",
        [this.loc.Report.Shapes, this.HelpLinks["insertcomponent"]], true, this.GetStyles("StandartBigButton")));
        this.ShapesMenu();
        groupsTable.addCell(this.BigButton("insertInfographics", null, this.loc.Report.Infographics, "Infographics.png",
        [this.loc.Report.Infographics, this.HelpLinks["insertcomponent"]], true, this.GetStyles("StandartBigButton")));
        this.InfographicsMenu();
    }

    //Main
    var mainTable = this.GroupBlockInnerTable();
    this.options.controls.groupBlockMainComponents.container.appendChild(mainTable);
    var componentButtons = this.options.componentsIntoInsertTab || ["StiPageHeaderBand", "StiPageFooterBand", "StiGroupHeaderBand", "StiGroupFooterBand", "StiHeaderBand", "StiFooterBand",
        "StiDataBand", "StiText", "StiImage", "StiChart"];
    for (var i in componentButtons) {
        if (this.options.visibilityComponents[componentButtons[i]] || this.options.visibilityBands[componentButtons[i]]) {
            var button = this.ComponentButton(componentButtons[i] + "_", this.loc.Components[componentButtons[i]], componentButtons[i] + ".png",
                "StandartBigButton", [this.loc.HelpComponents[componentButtons[i]], this.HelpLinks["insertcomponent"]]);
            button.caption.style.maxWidth = "60px";
            button.allwaysEnabled = false;
            mainTable.addCell(button);
        }
    }
}
