﻿
StiMobileDesigner.prototype.InitializeFileMenu = function () {
    var fileMenu = document.createElement("div");
    fileMenu.id = this.options.mobileDesigner.id + "fileMenu";
    fileMenu.className = "stiDesignerFileMenu";
    fileMenu.jsObject = this;
    fileMenu.items = {};
    fileMenu.style.display = "none";
    fileMenu.style.width = "0px";
    this.options.menus["fileMenu"] = fileMenu;
    this.options.mainPanel.appendChild(fileMenu);

    fileMenu.appendChild(this.FileMenuCloseButton());
    if (this.options.showFileMenuInfo) fileMenu.appendChild(this.FileMenuItem("infoReport", this.loc.ReportInfo.Info));
    if (this.options.showFileMenuNew) fileMenu.appendChild(this.FileMenuItem("newReport", this.loc.MainMenu.menuFileNew.replace("&", "")));
    if (this.options.showFileMenuOpen && this.options.canOpenFiles) {
        fileMenu.appendChild(this.FileMenuItem("openReport", this.loc.MainMenu.menuFileOpen.replace("&", "").replace("...", "")));
    }
    if (this.options.showFileMenuSave) fileMenu.appendChild(this.FileMenuItem("saveReport", this.loc.A_WebViewer.SaveReport));
    if (this.options.showFileMenuSaveAs) fileMenu.appendChild(this.FileMenuItem("saveAsReport", this.loc.MainMenu.menuFileSaveAs.replace("...", "")));    
    if (this.options.showFileMenuClose) fileMenu.appendChild(this.FileMenuItem("closeReport", this.loc.MainMenu.menuFileClose.replace("&", "")));
    if (this.options.showFileMenuExit) fileMenu.appendChild(this.FileMenuItem("exitDesigner", this.loc.MainMenu.menuFileExit.replace("&", "")));
    if (this.options.showFileMenuOptions) {
        fileMenu.appendChild(this.FileMenuSeparator());
        fileMenu.appendChild(this.FileMenuItem("optionsDesigner", this.loc.FormOptions.title));
    }

    fileMenu.changeVisibleState = function (state) {
        if (this.jsObject.options.viewerContainer)
            this.jsObject.options.viewerContainer.changeVisibleState(this.jsObject.options.previewMode && !this.jsObject.options.mvcMode ? !state : false);
        this.jsObject.options.toolBar.changeVisibleState(!state);
        this.jsObject.options.workPanel.changeVisibleState(this.jsObject.options.workPanel.visibleState ? !state : false);
        this.jsObject.options.statusPanel.changeVisibleState(!state);
        this.jsObject.options.pagesPanel.changeVisibleState((this.jsObject.options.previewMode && this.jsObject.options.mvcMode) ? false : !state);
        if (this.jsObject.options.showPanelPropertiesAndDictionary) {
            this.jsObject.options.propertiesPanel.changeVisibleState(!this.jsObject.options.propertiesPanel.fixedViewMode
                ? (this.jsObject.options.previewMode && this.jsObject.options.mvcMode ? false : !state) : false);
            this.jsObject.options.propertiesPanel.showButtonsPanel.changeVisibleState(
                (this.jsObject.options.previewMode && this.jsObject.options.mvcMode) || !this.jsObject.options.propertiesPanel.fixedViewMode
                    ? false : (state ? false : true));
        }
        this.jsObject.options.paintPanel.changeVisibleState(!state);                

        if (this.jsObject.options.showFileMenuSave) this.items.saveReport.setEnabled(this.jsObject.options.report);
        if (this.jsObject.options.showFileMenuSaveAs) this.items.saveAsReport.setEnabled(this.jsObject.options.report);
        if (this.jsObject.options.showFileMenuClose) this.items.closeReport.setEnabled(this.jsObject.options.report);
        if (this.jsObject.options.showFileMenuInfo) this.items.infoReport.setEnabled(this.jsObject.options.report);
        if (this.jsObject.options.showFileMenuOptions) this.items.optionsDesigner.setEnabled(this.jsObject.options.report);

        if (state && this.jsObject.options.showFileMenuNew) {
            this.items.newReport.action();
        }
        
        if (state)
            this.style.display = "";
        else {
            this.closeAllPanels();
            if (this.jsObject.options.previewMode) {
                this.jsObject.options.buttons.homeToolButton.action();
            }
        }

        d = new Date();
        endTime = d.getTime() + this.jsObject.options.menuAnimDuration;
        this.jsObject.ShowAnimationFileMenu(this, (state ? 150 : 0), endTime);
    }

    fileMenu.action = function (menuItem) {
        this.closeAllPanels(menuItem.name);
        this.jsObject.ExecuteAction(menuItem.name);
    }

    fileMenu.closeAllPanels = function (openingPanelName) {
        if (this.jsObject.options.newReportPanel && openingPanelName != "newReport") this.jsObject.options.newReportPanel.changeVisibleState(false);
        if (this.jsObject.options.infoReportPanel && openingPanelName != "infoReport") this.jsObject.options.infoReportPanel.changeVisibleState(false);
        if (this.jsObject.options.openPanel && openingPanelName != "openReport") this.jsObject.options.openPanel.changeVisibleState(false);
    }

    return fileMenu;
}

StiMobileDesigner.prototype.FileMenuItem = function (name, caption) {
    var menuItem = document.createElement("div");
    menuItem.jsObject = this;
    menuItem.isEnabled = true;
    menuItem.isSelected = false;
    menuItem.name = name;
    menuItem.id = this.options.mobileDesigner.id + "FileMenuItem" + name;
    menuItem.innerHTML = caption;
    menuItem.className = "stiDesignerFileMenuItem";
    this.options.menus["fileMenu"].items[name] = menuItem;

    menuItem.onmouseover = function () {
        if (!this.jsObject.options.isTouchDevice) this.onmouseenter();
    }

    menuItem.onmouseenter = function () {
        if (!this.isEnabled || this.jsObject.options.isTouchClick) return;
        this.className = "stiDesignerFileMenuItemOver";
    }

    menuItem.onmouseleave = function () {
        if (!this.isEnabled) return;
        this.className = "stiDesignerFileMenuItem";
        this.className = this.isSelected ? "stiDesignerFileMenuItemSelected" : "stiDesignerFileMenuItem";
    }

    menuItem.onclick = function () {
        if (this.isTouchEndFlag || !this.isEnabled || this.jsObject.options.isTouchClick) return;
        this.action();
    }

    menuItem.ontouchend = function () {
        if (!this.isEnabled) return;
        this.className = "stiDesignerFileMenuItemOver";
        var this_ = this;
        this.isTouchEndFlag = true;
        clearTimeout(this.isTouchEndTimer);

        setTimeout(function () {
            this_.className = "stiDesignerFileMenuItem";
            this_.action();
        }, 500);

        this.isTouchEndTimer = setTimeout(function () {
            this_.isTouchEndFlag = false;
        }, 1000);
    }

    menuItem.action = function () {
        this.setSelected(true);
        this.jsObject.options.menus.fileMenu.action(this);
    }

    menuItem.setEnabled = function (state) {
        this.isEnabled = state;
        this.className = state ? "stiDesignerFileMenuItem" : "stiDesignerFileMenuItemDisabled";
    }

    menuItem.setSelected = function (state) {
        if (state) {
            var items = this.jsObject.options.menus.fileMenu.items;
            for (var name in items) {
                if ("setSelected" in items[name]) items[name].setSelected(false);
            }
        }
        this.isSelected = state;
        this.className = state ? "stiDesignerFileMenuItemSelected" : (this.isEnabled ? "stiDesignerFileMenuItem" : "stiDesignerFileMenuItemDisabled");
    }

    return menuItem;
}

StiMobileDesigner.prototype.FileMenuSeparator = function () {
    var menuSeparator = document.createElement("div");
    menuSeparator.style.padding = "5px 25px 5px 25px"
    menuSeparatorInner = document.createElement("div");
    menuSeparatorInner.className = "stiDesignerFileMenuSeparator";
    menuSeparator.appendChild(menuSeparatorInner);
    
    return menuSeparator;
}

StiMobileDesigner.prototype.FileMenuCloseButton = function () {
    var closeButtonParent = document.createElement("div");
    closeButtonParent.style.padding = "15px 0px 15px 25px";

    var closeButton = document.createElement("img");
    closeButton.src = this.options.images["CloseFileMenu.png"];
    closeButton.jsObject = this;
    closeButton.name = "closeFileMenu";
    closeButton.id = this.options.mobileDesigner.id + closeButton.name;
    closeButtonParent.appendChild(closeButton);

    closeButton.onmouseover = function () {
        if (!this.jsObject.options.isTouchDevice) this.onmouseenter();
    }

    closeButton.onmouseenter = function () {
        if (this.jsObject.options.isTouchClick) return;
        this.style.opacity = "0.7";
    }

    closeButton.onmouseleave = function () {
        this.style.opacity = "1";
    }

    closeButton.onclick = function () {
        if (this.isTouchEndFlag) return;
        this.action();
    }

    closeButton.ontouchend = function () {
        this.style.opacity = "0.7";
        var this_ = this;
        this.isTouchEndFlag = true;
        clearTimeout(this.isTouchEndTimer);
        setTimeout(function () {
            this_.style.opacity = "1";
            this_.action();
        }, 150);
        this.isTouchEndTimer = setTimeout(function () {
            this_.isTouchEndFlag = false;
        }, 1000);
    }

    closeButton.action = function () {
        this.jsObject.ExecuteAction(this.name);
    }

    return closeButtonParent;
}